Program CarBlaster;      (* (C) 1997  by  The NAILWOOD Company *)

   (* Purpose: Tuning files of 'Stunts_1.0' - compatible cars *)
   (* First Implementation:  3.11.1993 *)
   (* Latest Modification : 16.03.1997 *)



uses crt,graph,dos,pice,saygete,
     BGIDriv,   { all the BGI drivers }
     BGIFont;   { all the BGI fonts }


const egamode=0;
      c_text_graph=4;
      c_text_key=2;
      c_text_nm=8;
      c_text_active=7;
      c_text_hidden=8;
      gear_up=1;
      gear_down=9;
      gear_ueber=2;
      torque=3;
      gears_no=14;
      power_fact=4;
      brake_power=5;
      max_turn=6;
      empty_run=10;
      curve_power=13;
      height=11;
      read_only=8;
      xebase=15;
      yebase=352;
      yexline=15;
      ymarkline=4;
      ycursline=8;
      ycursline2=260;
      ycompline=19;
      names_ybase=5;
      sv1_ybase=15;
      sv1_yclear=37;
      sv1_ytext=20;
      sv1_textsize=5;
      se_ybase=1;
      se_yplus=14;
      so_ykeys=387;
      so_yplus=15;
      sms_xbase=38;
      sms_ybase=55;
b1='A HQ-product of  The NAILWOOD Company';
ted1= '             Designation :';
ted2= '                          ';
ted3= '                          ';
ted4= '    Propulsion-technique :';
ted5= '           Motor-concept :';
ted6= '     Swept volume, Power :';
ted7= '            Acceleration :';
ted8= '               Top speed :';
ted9= '                   Price :';
ted11='      Scores-grammalogue :';
ted13='      Scores-designation :';
ted15='           Save          :';
 e1='1 byte to the right';
 e3='10 bytes to the r.';
 e5='Choose scroll mode';
 e6='Inc. value by 1';
 e8='Inc. value by 10';
e10='Assimilate value';
e11='Reset value';
e12='Random value';
e13='Left marker';
e14='Right marker';
e15='Cancel markers';
e16='Abort editing    ';
e17='Comp. mode on/off';
e18='Swap cars';
e19='Pos./Values hex.';
e20='Save directly';
e21='Previous car';
e22='Next car';
eb_1='CHANGE DESIGNATIONS :';
eo_1='   SAVE CONFIGURATION :';
edstat11='';
edstat12='';
edstat13='';
expl1='File-status';
expl39='Number of gears';
expl41='Power Amplification (inv.)';
expl44='Brake-Power';
expl46='Idle - no. of revolutions';
expl48='Switch-down-point';
expl50='Switch-up-point';
expl52='Maximum no. of revolutions';
expl56='Gear ratio (inv.)';
expl97='Torque';
expl204='Curve-adhesion';
expl247='Height over street';
f1='    Current directory :  ';
f3='                             Select file :';
h1='   With';
h2='you can save a loaded car into a file of an optional        '+
  '       filename.';
h3='you can load a car from an existing carfile.';
h31='   If you have changed a car and not saved yet, there occurs a warning'+
  '              automatically.';
h4='you activate the editing-mode for the car loaded onto       '+
  '       position 1.';
h5='you activate the editing-mode for the designations of the   '+
  '       car loaded onto position 1.';
h9='you can modify and save the program status.';
h10='you can leave the program.';
i1='   ***  Forbid loading :  Empty input !  ***';
i2='   Car successfully loaded !';
i3='   ***  Press optional key for leaving !  ***  ';
i4='   ***  For saving :  ';
i5='Save';
i6='Cancel';
i7='   Car successfully saved !';
i7a='   Car without additional files successfully saved !';
i7o='   Configuration successfully saved !';
i7z='   Additional files successfully saved !';
i8='   ***  Do you want to overwrite  ';
i9='Overwrite';
i10='   Do you really want to erase the old car  ';
i11='   Do you really want to end the program  ';
l1='   Filename without extension :  ';
m2='LOADING CAR :';
m3='SAVING CAR :';
m4='HELP FOR MAIN MENU :';
mm1= '           Help   ';
mm2= '           Save car   ';
mm3= '           Load car   ';
mm4= '           Edit car   ';
mm5= '           Change car designations   ';
mm9= '           Save configuration   ';
mm10='           End program   ';
mme='not possible';
lm1='       Old 2nd car remains comparative car ';
ld1='  ';
lk1='< 1 >';
lm2='       Old 1st car becomes comparative car ';
ld2='  ';
lk2='< 2 >';
lm3='       Load car twice ';
ld3='  ';
lk3='< 3 >';
lm4='       Load car as comparative car to 1st ';
ld4='  ';
lk4='< 4 >';
lm5='       Load car as comparative car to 2nd ';
ld5='  ';
lk5='< 5 >';
lm6='       Cancel ';
ld6='  ';
lk6='< Esc >';
le5='not possible';
ls40='         File contains no car  ';
ls41='         File contains car';
ls51='         Car has been loaded';
o_cd1='   ***  The indicated directory is not existing yet !  ***';
o_cd2='   ***  Program remains in the current directory  ***';
o_cd3='   Old directory :  ';
o_cd4='   New directory :  ';
o_cd5='   Do you want to change into the new directory  ';
sm1='         Save additional files only ';
sd1='  ';
sk1='< 1 >';
sm2='         Save car without additional files ';
sd2='  ';
sk2='< 2 >';
sm3='         Save car to file ';
sd3='  ';
sk3='< 3 >';
sm4='         Cancel ';
sd4='  ';
sk4='< Esc >';
se5='nicht mglich';
so1='       Car to be changed :';
so2='           Comparing car :';
so3='          Path of Stunts :';
so4='          Start position :';
so5='                 Markers :';
so6='      Show logo on start :';
so7='           Save          :';
so8='               Hex.-Mode :';
so5_1='from : ';
so5_2='to : ';
so8_1='Position : ';
so8_2='Value : ';
ss10='         File does not exist';
ss11='         ***  File exists !  ***';
ss20='         ***  Size of file is 0 bytes !  ***';
ss21='         ***  Size of file is smaller than 815 bytes !  ***';
ss30='         ***  Size of file is larger than 1024 bytes !  ***';
ss31='';
ss40='         ***  The additional files do not exist !  ***';
ss41='         ***  Not all additional files do exist !  ***';
ss50='         ***  The additional files do not all have a valid size ! '+
  ' ***';
ss51='';
w1='   ***  Old car has been changed and not saved yet !  '+
  '***';
w2='   ***  The length of the filename must be exactly 7 characters !  ***  ';
w3='   ***  Unfortunately, this file is not existing yet !  ***  ';
w4='   ***  Unfortunately, the size of this file is 0 bytes !  ***  ';
w5='   ***  ERROR - Saving has not happened !  ***  ';
w5z='   ***  ERROR - Saving of the additional files is not complete !'+
  '  ***';
w7='   ***  You have changed the car and not saved yet !  '+
  '***';
w8='   ***  You have changed the car and not saved yet !  '+
  '***';
w10='   ***  The size of this file is smaller than 815 bytes !  ***';
w11='   ***  The size of this file is larger than 1024 bytes !  ***';
w12='   ***  The file st????.p3s does not exist !  ***';
w13='   ***  The file stda????.pvs does not exist !  ***';
w14='   ***  The file stdb????.pvs does not exist !  ***';
w15='   ***  The file st????.p3s is larger than 7000 bytes!  ***';
w16='   ***  The file stda????.pvs is larger than 20000 bytes!  ***';
w17='   ***  The file stdb????.pvs is larger than 1100 bytes!  ***';
wo1='   ***  The CarBlaster-configuration-file ''CB.cfg'' does not exist'+
  ' !  ***';
wov1='   ***  The directory in the configuration file is invalid !  ***';
wov2='   ***  Program remains in the directory of calling  ***';
yes_char='Y';
no_char='N';
comp_char='C';
swap_char='S';
yes_low_char='y';
no_low_char='n';
comp_low_char='c';
swap_low_char='s';

type pxs_type=record
                st_p3s:array[1..7000] of char;
                stda_pvs:array[1..20000] of char;
                stdb_pvs:array[1..1100] of char;
                st_p3s_s,stda_pvs_s,stdb_pvs_s:integer
              end;

var i,j,grdrvr,grmode,ErrCode,error,begverz,maxchange,kchange,
     minmark,maxmark,oldminmark,oldmaxmark,optminmark,optmaxmark,
     aktpos,fact,oldaktpos,oldfact,optaktpos,optfact: integer;
    markmode,sel,fsel: byte;
    contr,check,ch,progcheck: char;
    eingelesen,goodsave,ok,greeton,menuon,beginsound,screenmove,sm_c,
     carcomp,phexmode,vhexmode: boolean;
    field:array[1..3,1..1024] of char;
    field_orig:array[1..3,1..1024] of char;
    field_s,field_orig_s:array[1..3] of integer;
    pxs:array[1..2] of ^pxs_type;
    oldname,optname:array[1..3] of string[4];
    newname:string[12];
    oldpath:array[1..3] of string[30];
    col:array[1..814] of byte;
    progpath,startpath:string[30];
    datei:text;
    t:longint;
    tsf_pos:array[1..10] of record
                               i,j:byte
                            end;
    tsf:array[1..10,1..6,1..6] of byte;
    P: PathStr;
    D: DirStr;
    N: NameStr;
    E: ExtStr;



procedure writeaktpath;
var s:string;
begin
   getdir(0,s);
   writeln('*',s,'*');
   readkey;
end;


function schdir(dir:DirStr):integer;
var drvstr:string[2];

begin
   {$I-};
   chdir(dir);
   {$I+};
   if ioresult<>0
   then
      schdir:=1
   else
      if length(dir)>1
      then begin
         if (upcase(dir[1])>='A') AND (upcase(dir[1])<='Z') AND (dir[2]=':')
         then begin
            drvstr[1]:=dir[1];
            drvstr[2]:=dir[2];
            drvstr[0]:=chr(2);
            exec('command.com',drvstr);
         end;
         schdir:=0;
      end;
end;


procedure Abort(Msg : string);
begin
  Writeln(Msg, ': ', GraphErrorMsg(GraphResult));
  Halt(1);
end;


function upstring(s:string):string;
var i:integer;

begin
   for i:=1 to length(s)
   do
      s[i]:=upcase(s[i]);
   upstring:=s;
end;


function scroll_file(olddir,oldname,ext:string;dir:integer):string;
type nlp=^namelist;
     namelist=record
        name:string;
        next:nlp;
     end;
var nl,hnl,hhnl:nlp;
    i:integer;
    DirInfo: SearchRec;
    P: PathStr;
    D: DirStr;
    N,preN: NameStr;
    E: ExtStr;
    retval:string;

begin
   nl:=NIL;
   if schdir(olddir)<>0
   then
      retval:=''
   else begin
      FindFirst('*.'+ext, AnyFile, DirInfo);
      while DosError=0
      do begin
         P:=fexpand(DirInfo.Name);
         FSplit(P, D, preN, E);
         preN:=upstring(preN);
         if (nl=NIL) OR (nl^.name>preN)
         then begin
            hnl:=NIL;
            new(hnl);
            hnl^.name:=preN;
            hnl^.next:=nl;
            nl:=hnl;
         end
         else begin
            hnl:=nl;
            while((hnl^.next<>NIL) AND (hnl^.next^.name<preN))
            do
               hnl:=hnl^.next;
            hhnl:=NIL;
            new(hhnl);
            hhnl^.name:=preN;
            hhnl^.next:=hnl^.next;
            hnl^.next:=hhnl;
         end;
         FindNext(DirInfo);
      end;
      if (nl<>NIL)
      then begin
         oldname:=upstring(oldname);
         if dir=1
         then begin
            hnl:=nl;
            while(hnl^.next<>NIL) AND (hnl^.name<=oldname)
            do
               hnl:=hnl^.next;
            if (hnl^.name>oldname)
            then
               retval:=hnl^.name
            else begin
               if (hnl^.next<>NIL)
               then
                  hnl:=hnl^.next;
               retval:=hnl^.name
            end
         end
         else begin
            preN:=nl^.name;
            hnl:=nl;
            while(hnl<>NIL) AND (hnl^.name<oldname)
            do begin
               preN:=hnl^.name;
               hnl:=hnl^.next;
            end;
            retval:=preN;
         end
      end
      else
         retval:='';
   end;
   while (nl<>NIL)
   do begin
      hnl:=nl;
      nl:=nl^.next;
      dispose(hnl);
   end;
   scroll_file:=retval;
end;


procedure SetCursorSpeed(NewSpeed : Word);
begin
  Port[$60] := $F3;
  Delay(200);
  Port[$60] := NewSpeed;
end;


function get_size(name:string):integer;
var cf:file of char;

begin
   assign(cf,name);
   reset(cf);
   get_size:=filesize(cf);
   close(cf)
end;


function not_empty(name:string):boolean;
var cf:file of char;

begin
   assign(cf,name);
   reset(cf);
   if filesize(cf)>0
   then
      not_empty:=true
   else
      not_empty:=false;
   close(cf)
end;


function fchanged(index:integer):boolean;
var changed:boolean;

begin
   changed:=false;
   if field_s[index]<>field_orig_s[index]
   then
      changed:=true
   else begin
      for i:=1 to field_s[index] do begin
         if field[index,i]<>field_orig[index,i]
         then begin
            changed:=true;
            i:=field_s[index]
         end
      end
   end;
   fchanged:=changed
end;


procedure write_mess(t:string;color,newcolor:byte;newline:byte);

begin
   TextColor(color);
   write(t);
   TextColor(newcolor);
   if newline=1
   then
      writeln;
   write(' ');
   gotoxy(wherex-1,wherey)
end;


procedure write_path;
var path:string;

begin
   getdir(0,path);
   TextColor(5);
   write(f1);
   TextColor(2);
   writeln(path)
end;


function getname(defname:string):string;
var name,fractname,origpath,path:string;
    groundline,i:integer;
Label 1,2;

begin
   groundline:=WhereY;
   name:=defname;
   getdir(0,origpath);
1:      getdir(0,path);
      GoToXY(4,groundline);
      write('                                           ',
       '                                     ');
      GoToXY(4,groundline);
      write_path;
      GoToXY(4,groundline+2);
      TextColor(5);
      set_pickwindow_to(29,groundline+2,39,24,2,'');
      getdir(0,path);
      GoToXY(4,groundline);
      write('                                           ',
       '                                     ');
      GoToXY(4,groundline);
      write_path;
      GoToXY(1,groundline+2);
      TextColor(5);
      write(f3);
      set_pickwindow_to(45,groundline+2,55,24,2,'');
      name:=pickfile('car*.res NOEXTENSION');
      if name=''
      then
         GoTo 2;
2:   TextColor(7);
   GoToXY(4,groundline+1);
   writeln('                                                               ');
   writeln('                                                               ');
   GoToXY(1,groundline);
   if name<>'' then begin  (* Erweiterung abschneiden *)
      delete(name,length(name)-3,4);
      fractname:='';
      for i:=4 to length(name)  (* CAR abschneiden *)
      do
         fractname:=fractname+name[i]
   end
   else
      fractname:='';
   getname:=fractname
end;


procedure fieldcopy(index:integer);

begin
   for i:=1 to field_s[index] do begin
      field_orig[index,i]:=field[index,i]
   end
end;


procedure fieldswap;
begin
   field[3]:=field[1];
   field[1]:=field[2];
   field[2]:=field[3];
   field_orig[3]:=field_orig[1];
   field_orig[1]:=field_orig[2];
   field_orig[2]:=field_orig[3];
   oldname[3]:=oldname[1];
   oldname[1]:=oldname[2];
   oldname[2]:=oldname[3];
   oldpath[3]:=oldpath[1];
   oldpath[1]:=oldpath[2];
   oldpath[2]:=oldpath[3];
   field_s[3]:=field_s[1];
   field_s[1]:=field_s[2];
   field_s[2]:=field_s[3];
   field_orig_s[3]:=field_orig_s[1];
   field_orig_s[1]:=field_orig_s[2];
   field_orig_s[2]:=field_orig_s[3];
end;


procedure clearline;
var x,y:integer;

begin
   x:=WhereX;
   y:=WhereY;
   for i:=x to 80 do
      write(' ');
   GoToXY(x,y)
end;


function GetFName(mc:integer;auto:boolean):string;  (** Liest einen mc-
         stelligen String ein **)
var c:char;
    i,anfx,anfy:integer;
    lastpos,firstkey:boolean;
    a,apre:string[40];
Label 1,2,3;

begin
   if auto
   then
      a:=optname[fsel]
   else
      a:=oldname[1];
3:   anfx:=WhereX;
   anfy:=WhereY;
   gotoxy(4,WhereY+1);
   write_path;
   gotoxy(anfx,WhereY-2);
   textcolor(7);
   clearline;
   i:=WhereX;
   write(a);
   GoToXY(i,WhereY);
   i:=1;
   lastpos:=false;
   firstkey:=true;
   if not auto then begin
    repeat  (* Eingabe von Zeichen *)
1:      c:=upcase(readkey);
      if ord(c)=0
      then begin
         c:=upcase(readkey);
         if (ord(c)=80)   (* C_Down *)
         then begin
            GoToXY(anfx,anfy);
            clearline;
            GoToXY(1,WhereY+1);
            apre:=a;
            a:=GetName('');
            GoToXY(anfx,anfy);
            textcolor(7);
            clearline;
            if length(a)>0
            then begin
               write(a);
               GoTo 2
            end
            else begin
               a:=apre;
               GoTo 3
            end
         end
         else
            GoTo 1
      end;
      if (ord(c)<>13) and (ord(c)<>27)
      then begin  (* Kein Return, kein Escape *)
         if firstkey
         then begin  (* Defaultstring lschen *)
            firstkey:=false;
            a:='';
            for i:=1 to mc do
               write(' ');
            GoToXY(WhereX-mc,WhereY);
            i:=1
         end;  (* Defaultstring lschen *)
         if (ord(c)=8) and (i>1)
         then begin  (* Lschen des letzteingegebenen Zeichens *)
            if lastpos=true
            then begin  (* Zeichen auf Cursorposition lschen *)
               write(' ');
               GoToXY(WhereX-1,WhereY);
               lastpos:=false;
               delete(a,mc,1)
            end  (* Zeichen auf Cursorposition lschen *)
            else begin  (* Zeichen links neben Cursor lschen *)
               dec(i);
               GoToXY(WhereX-1,WhereY);
               write(' ');
               GoToXY(WhereX-1,WhereY);
               delete(a,i,1)
            end  (* Zeichen links neben Cursor lschen *)
         end  (* Lschen des letzteingegebenen Zeichens *)
         else begin  (* Verarbeitung des Zeichens *)
            if ord(c)<>8
            then begin  (* Eingabe des Zeichens *)
               write(c);
               inc(i);
               if i=mc+1
               then begin  (* Letztes Zeichen austauschen *)
                  i:=mc;
                  lastpos:=true;
                  delete(a,i,1);
                  insert(c,a,i);
                  GoToXY(WhereX-1,WhereY)
               end  (* Letztes Zeichen austauschen *)
               else begin  (* String um Zeichen verlngern *)
                  insert(c,a,i)
               end  (* String um Zeichen verlngern *)
            end  (* Eingabe des Zeichens *)
         end  (* Verarbeitung des Zeichens *)
      end  (* Kein Return, kein Escape *)
    until (ord(c)=13) or (ord(c)=27); (*Eingabe von Zeichen*)
   end;
   if a<>'' then begin
      if ord(c)=13
      then begin
         if firstkey
         then
            a:=chr(13)
      end
      else begin
         if ord(c)=27
         then
            a:=''
      end
   end;
2:   GetFName:=a
end;


function LoeschProtect:char;  (** Fragt J/N-Entscheidung ab **)
var nachcheck:char;

begin
     GoToXY(WhereX-1,WhereY);
     nachcheck:=' ';
     check:=upcase(readkey);
     if (ord(check)=13)
     then (*Sofortabbruch*)
          check:=no_char
     else (*Eingabewiederholung*)
          begin
               if (check<>yes_char)
               then (*Ja-Nein-Anzeige*)
                    check:=no_char;
                    write(check);
                    repeat (*Lschsicherung, bis [Enter] gedrckt wird*)
                           GoToXY(WhereX-1,WhereY);
                           nachcheck:=upcase(readkey);
                           if ord(nachcheck)<>13
                           then (*Neues Zeichen wird verarbeitet*)
                                begin
                                     if nachcheck<>yes_char
                                     then (*Ja-Nein-Anzeige*)
                                          nachcheck:=no_char;
                                     write(nachcheck);
                                     check:=nachcheck
                                end; (*Neues Zeichen wird verarbeitet*)
                    until ord(nachcheck)=13 (*Lschsicherung, bis [Enter]
                          gedrckt wird*)
          end; (*Eingabewiederholung*)
     LoeschProtect:=check
end;


procedure clear_field(xmin,ymin,xmax,ymax:integer);

begin
   setfillstyle(SOLIDFILL,0);
   bar(xmin,ymin,xmax,ymax);
end;


function hexout(innum:integer;width:integer):string;
var s:string;
    rest,base,i:integer;

begin
   for i:=width downto 1
   do begin
      rest:=innum mod 16;
      if rest<10
      then
         s[i]:=chr(rest+48)
      else
         s[i]:=chr(rest+55);
      innum:=innum div 16;
   end;
   s[0]:=chr(width);
   hexout:=s;
end;


procedure show_values_1(aktpos,fact,v1,v2:integer);
const xbase=20;
var s:string;
    xline,c,oldx,oldy:integer;

begin
   oldx:=GetX;
   oldy:=GetY;
   c:=getcolor;
   if (egamode=1)
   then begin
      clear_field(xbase-12,names_ybase,xbase+83,sv1_ybase+10);
      clear_field(xbase-12,sv1_ybase+10,xbase+28,sv1_ybase+23);
   end
   else
      clear_field(xbase-12,names_ybase,xbase+83,sv1_ybase+sv1_yclear);
   if (phexmode)
   then begin
      s:=hexout(aktpos+fact-1,3);
      s:=s+'h';
   end
   else
      str(aktpos+fact:3,s);
   SetTextStyle(2, HorizDir, sv1_textsize);
   SetTextJustify(RightText, TopText);
   setcolor(7);
   OutTextXY(xbase+24,sv1_ybase+sv1_ytext,s);
   if (vhexmode)
   then begin
      s:=hexout(v1,2);
      s:=s+'h';
   end
   else
      str(v1:3,s);
   SetTextStyle(2, HorizDir, sv1_textsize);
   SetTextJustify(RightText, TopText);
   setcolor(3);
   OutTextXY(xbase+24,sv1_ybase,s);
   SetTextStyle(2, HorizDir, 4);
   outtextxy(xbase+24,names_ybase,oldname[1]);
   SetTextStyle(2, HorizDir, sv1_textsize);
   if (vhexmode)
   then begin
      s:=hexout(v2,2);
      s:=s+'h';
   end
   else
      str(v2:3,s);
   SetTextStyle(2, HorizDir, sv1_textsize);
   SetTextJustify(RightText, TopText);
   setcolor(4);
   OutTextXY(xbase+69,sv1_ybase,s);
   SetTextStyle(2, HorizDir, 4);
   outtextxy(xbase+69,names_ybase,oldname[2]);
   setcolor(c);
   MoveTo(oldx,oldy)
end;


procedure show_explains;
const yfact=6;
      xbase=15;
      xnext=170;
var xline,c,oldx,oldy:integer;

begin
   oldx:=GetX;
   oldy:=GetY;
   c:=getcolor;
   SetTextStyle(2, HorizDir, 4);
   SetTextJustify(LeftText, TopText);
   xline:=120;
   MoveTo(xline,se_ybase);
   setcolor(read_only);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl1);
   setcolor(gears_no);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl39);
   setcolor(power_fact);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl41);
   setcolor(brake_power);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl44);
   xline:=xline+xnext;
   MoveTo(xline,se_ybase);
   setcolor(empty_run);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl46);
   setcolor(gear_down);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl48);
   setcolor(gear_up);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl50);
   setcolor(max_turn);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl52);
   xline:=xline+xnext;
   MoveTo(xline,se_ybase);
   setcolor(gear_ueber);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl56);
   setcolor(torque);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl97);
   setcolor(curve_power);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl204);
   setcolor(height);
   MoveTo(xline,GetY+se_yplus);
   line(GetX,GetY,GetX+3,GetY);
   setcolor(7);
   OutTextXY(xline+xbase,GetY-yfact,expl247);
   setcolor(c);
   MoveTo(oldx,oldy)
end;


procedure show_options;
const x_keys=5;
      x_dots=96;
      x_funct=102;
      x_plus=213;
var xline,c,oldx,oldy,y_pos:integer;

begin
   oldx:=GetX;
   oldy:=GetY;
   c:=getcolor;
   SetTextStyle(2, HorizDir, 4);
   SetTextJustify(LeftText, TopText);
   SetColor(2);
   y_pos:=so_ykeys;
   OutTextXY(x_keys,y_pos,'<C_Right>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys,y_pos,'<Ctrl-C_Right>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys,y_pos,'<Space>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys,y_pos,'<h>/<H>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys,y_pos,'<Esc>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys,y_pos,'<F2>');
   y_pos:=so_ykeys;
   OutTextXY(x_keys+x_plus,y_pos,'<C_Up>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys+x_plus,y_pos,'<Pg_Up>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys+x_plus,y_pos,'<X>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys+x_plus,y_pos,'<Enter>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys+x_plus,y_pos,'<BckSpc.>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys+x_plus,y_pos,'<'+comp_char+'>');
   y_pos:=so_ykeys;
   OutTextXY(x_keys+2*x_plus,y_pos,'<F5>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys+2*x_plus,y_pos,'<F6>');
   y_pos:=y_pos+so_yplus;
   if minmark=0
   then
      setcolor(8);
   OutTextXY(x_keys+2*x_plus,y_pos,'<F8>');
   setcolor(2);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys+2*x_plus,y_pos,'<F9>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys+2*x_plus,y_pos,'<F10>');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_keys+2*x_plus,y_pos,'<'+swap_char+'>');
   SetColor(5);
   y_pos:=so_ykeys;
   OutTextXY(x_funct,y_pos,e1);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct,y_pos,e3);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct,y_pos,e5);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct,y_pos,e19);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct,y_pos,e16);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct,y_pos,e20);
   y_pos:=so_ykeys;
   OutTextXY(x_funct+x_plus,y_pos,e6);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct+x_plus,y_pos,e8);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct+x_plus,y_pos,e12);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct+x_plus,y_pos,e10);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct+x_plus,y_pos,e11);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct+x_plus,y_pos,e17);
   y_pos:=so_ykeys;
   OutTextXY(x_funct+2*x_plus,y_pos,e13);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct+2*x_plus,y_pos,e14);
   y_pos:=y_pos+so_yplus;
   if minmark=0
   then
      setcolor(8);
   OutTextXY(x_funct+2*x_plus,y_pos,e15);
   setcolor(5);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct+2*x_plus,y_pos,e21);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct+2*x_plus,y_pos,e22);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_funct+2*x_plus,y_pos,e18);
   SetTextStyle(2, HorizDir, 2);
   SetTextJustify(RightText, TopText);
   SetColor(7);
   y_pos:=so_ykeys+1;
   OutTextXY(x_dots,y_pos,'     ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots,y_pos,' ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots,y_pos,'       ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots,y_pos,'       ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots,y_pos,'         ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots,y_pos,'          ');
   y_pos:=so_ykeys+1;
   OutTextXY(x_dots+x_plus,y_pos,'        ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots+x_plus,y_pos,'       ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots+x_plus,y_pos,'           ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots+x_plus,y_pos,'       ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots+x_plus,y_pos,'     ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots+x_plus,y_pos,'           ');
   y_pos:=so_ykeys+1;
   OutTextXY(x_dots+2*x_plus,y_pos,'          ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots+2*x_plus,y_pos,'          ');
   y_pos:=y_pos+so_yplus;
   if minmark=0
   then
      setcolor(8);
   OutTextXY(x_dots+2*x_plus,y_pos,'          ');
   setcolor(7);
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots+2*x_plus,y_pos,'          ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots+2*x_plus,y_pos,'         ');
   y_pos:=y_pos+so_yplus;
   OutTextXY(x_dots+2*x_plus,y_pos,'           ');
   setcolor(c);
   MoveTo(oldx,oldy)
end;


procedure ch_marked_lines(value,origvalue:integer);
var vold,vneu,vkorr,vkorrch,lastval,k:integer;

begin
   i:=minmark;
   lastval:=ord(field[1,i]);
   vkorrch:=0;
   vkorr:=random(maxchange*2+1)-maxchange;
   for i:=minmark to maxmark
   do begin
      vold:=ord(field[1,i]);
      case value of
         -1000: begin
            vneu:=ord(field_orig[1,i])
         end;
         0: begin
            vneu:=ord(field[2,i])
         end;
         999: begin
            vkorrch:=vkorrch+random((kchange div 2)*2 +1)-kchange div 2;
            vkorr:=vkorr+vkorrch;
            if vkorr>maxchange div 2
            then begin
               vkorr:=maxchange div 2;
            end
            else if vkorr<-(maxchange div 2)
               then begin
                  vkorr:=-(maxchange div 2);
               end;
            vneu:=lastval+vkorr;
            if (vneu>255)
            then begin
               vneu:=255;
               vkorr:=0;
               vkorrch:=0
            end
            else
               if vneu<1
               then begin
                  vneu:=1;
                  vkorr:=0;
                  vkorrch:=0
               end;
            lastval:=vneu
         end
         else begin
            case markmode of
               1: begin
                  vkorr:=value
               end;
            end;
            vneu:=vold+vkorr;
            if (vneu>255)
            then
               vneu:=255
            else
               if vneu<0
               then
                  vneu:=0
         end
      end;
      if (vneu<>vold) and (col[i]<>read_only)
      then begin
         goodsave:=false;
         field[1,i]:=chr(vneu);
         if (i-fact>0) and (i-fact<101)
         then begin
            setcolor(3);
            line(xebase+(i-fact)*6,yebase,xebase+(i-fact)*6,yebase-vneu);
            setcolor(0);
            line(xebase+(i-fact)*6,yebase-vneu-1,xebase+(i-fact)*6,yebase-256)
         end
      end
   end
end;


procedure show_move_status;
var oldx,oldy,c:integer;

begin
  if (sm_c)
  then begin
   oldx:=GetX;
   oldy:=GetY;
   c:=getcolor;
   clear_field(sms_xbase,sms_ybase+7,sms_xbase+22,sms_ybase+17);
   setcolor(2);
   Line(sms_xbase,sms_ybase+12,sms_xbase+4,sms_ybase+12);
   PutPixel(sms_xbase+1,sms_ybase+11,2);
   PutPixel(sms_xbase+1,sms_ybase+13,2);
   PutPixel(sms_xbase+2,sms_ybase+10,2);
   PutPixel(sms_xbase+2,sms_ybase+14,2);
   Line(sms_xbase+18,sms_ybase+12,sms_xbase+22,sms_ybase+12);
   PutPixel(sms_xbase+21,sms_ybase+11,2);
   PutPixel(sms_xbase+21,sms_ybase+13,2);
   PutPixel(sms_xbase+20,sms_ybase+10,2);
   PutPixel(sms_xbase+20,sms_ybase+14,2);
   if screenmove
   then begin
      setcolor(3);
      Line(sms_xbase+10,sms_ybase+8+egamode,
           sms_xbase+10,sms_ybase+16-egamode);
      setcolor(4);
      Line(sms_xbase+12,sms_ybase+8+egamode,sms_xbase+12,
           sms_ybase+16-egamode)
   end
   else begin
      SetColor(15);
      Line(sms_xbase+11,sms_ybase+7+2*egamode,sms_xbase+11,sms_ybase+10);
      PutPixel(sms_xbase+10,sms_ybase+9,15);
      PutPixel(sms_xbase+12,sms_ybase+9,15);
      Line(sms_xbase+11,sms_ybase+14,sms_xbase+11,sms_ybase+17-2*egamode);
      PutPixel(sms_xbase+10,sms_ybase+15,15);
      PutPixel(sms_xbase+12,sms_ybase+15,15)
   end;
   if (carcomp)
   then begin
      PutPixel(sms_xbase+10,sms_ybase+19-2*egamode,13);
      PutPixel(sms_xbase+11,sms_ybase+19-2*egamode,14);
      PutPixel(sms_xbase+12,sms_ybase+19-2*egamode,13);
   end
   else begin
      PutPixel(sms_xbase+10,sms_ybase+19-2*egamode,0);
      PutPixel(sms_xbase+11,sms_ybase+19-2*egamode,0);
      PutPixel(sms_xbase+12,sms_ybase+19-2*egamode,0);
   end;
   sm_c:=false;
   setcolor(c);
   MoveTo(oldx,oldy)
  end
end;


procedure draw_cursor(color:byte);

begin
   putpixel(xebase+aktpos*6+1,yebase+ycursline,color);
   putpixel(xebase+aktpos*6+1,yebase+ycursline+1,color);
   putpixel(xebase+aktpos*6+1,yebase+ycursline+2-egamode,color);
   putpixel(xebase+aktpos*6+1,yebase+ycursline+3-2*egamode,color);
   putpixel(xebase+aktpos*6,yebase+ycursline+1,color);
   putpixel(xebase+aktpos*6+2,yebase+ycursline+1,color);
   putpixel(xebase+aktpos*6+1,yebase-ycursline2,color);
   putpixel(xebase+aktpos*6+1,yebase-ycursline2-1,color);
   putpixel(xebase+aktpos*6+1,yebase-ycursline2-2+egamode,color);
   putpixel(xebase+aktpos*6+1,yebase-ycursline2-3+2*egamode,color);
   putpixel(xebase+aktpos*6,yebase-ycursline2-1,color);
   putpixel(xebase+aktpos*6+2,yebase-ycursline2-1,color);
end;


procedure edit_field;
const size=814;
      xbase=20;
var i6,maxgr,verschfact,neusize,fp:integer;
    gf:array[1..2,1..size] of char;
    leave,first:boolean;
    megach:boolean;
Label 1;

begin
   first:=true;
   leave:=false;
   screenmove:=false;
   sm_c:=true;
   initgraph(grdrvr,grmode,'');
(*   putpixel(20,300,3);
   putpixel(619,300,4);*)
   show_options;
1:   if fact>714
   then begin
      maxgr:=800-fact+14;
      for i:=maxgr+1 to 100 do begin
         putpixel(xebase+i*6,yebase,0);
         putpixel(xebase+i*6+2,yebase,0)
      end
   end
   else
      maxgr:=100;
  if ((first) or (not sm_c))
  then begin
   setcolor(0);
   line(0,yebase+yexline,639,yebase+yexline);
   line(0,yebase+ymarkline,639,yebase+ymarkline);
   for i:=1 to maxgr do begin
      i6:=xebase+i*6;
      setcolor(3);
      line(i6,yebase,i6,yebase-ord(field[1,i+fact]));
      setcolor(0);
      line(i6,yebase-ord(field[1,i+fact])-1,i6,yebase-256);
      if (i+fact>=minmark) and (i+fact<=maxmark)
      then begin
         setcolor(7);
         line(i6,yebase+ymarkline,i6+2,yebase+ymarkline);
      end;
      setcolor(col[fact+i]);
      line(i6,yebase+yexline,i6+2,yebase+yexline)
   end;
   if maxgr<100
   then for i:=maxgr+1 to 100 do begin
      i6:=xebase+i*6;
      setcolor(0);
      line(i6,yebase,i6,yebase-256)
   end;
   for i:=1 to maxgr do begin
      i6:=xebase+i*6;
      setcolor(4);
      line(i6+2,yebase,i6+2,yebase-ord(field[2,i+fact]));
      setcolor(0);
      line(i6+2,yebase-ord(field[2,i+fact])-1,i6+2,yebase-256)
   end;
   if maxgr=14
   then for i:=maxgr+1 to 100 do begin
      i6:=xebase+i*6;
      setcolor(0);
      line(i6+2,yebase,i6+2,yebase-256)
   end;
   if (fact>714) and (aktpos>800-fact+14)
   then
      aktpos:=800-fact+14;
   draw_cursor(15);
  end;
   repeat
      if (first) or (not sm_c)
      then begin
         show_values_1(aktpos,fact,ord(field[1,aktpos+fact]),
           ord(field[2,aktpos+fact]));
         if (fchanged(1))
         then begin
            SetTextStyle(2, HorizDir, 4);
            SetTextJustify(LeftText,TopText);
            SetColor(7);
            OutTextXY(xbase+29,names_ybase,'#');
         end
         else
            clear_field(xbase+76,names_ybase,xbase+83,sv1_ybase+10);
         if (fchanged(2))
         then begin
            SetTextStyle(2, HorizDir, 4);
            SetTextJustify(LeftText,TopText);
            SetColor(7);
            OutTextXY(xbase+74,names_ybase,'#');
         end
         else
            clear_field(xbase+76,names_ybase,xbase+83,sv1_ybase+10);
         show_explains
      end;
      if (carcomp)
      then begin
         for i:=1 to maxgr do begin
            i6:=xebase+i*6;
            if (field[1,i+fact]<>field[2,i+fact])
            then begin
               putpixel(i6,yebase+ycompline,13);
               putpixel(i6+1,yebase+ycompline,14);
               putpixel(i6+2,yebase+ycompline,13);
            end
            else begin
               putpixel(i6,yebase+ycompline,0);
               putpixel(i6+1,yebase+ycompline,0);
               putpixel(i6+2,yebase+ycompline,0);
            end
         end;
      end
      else begin
         setcolor(0);
         line(0,yebase+ycompline,639,yebase+ycompline);
      end;
      first:=false;
      show_move_status;
      megach:=false;
      contr:=readkey;
      if (contr='+')
      then begin
         megach:=true;
         contr:=chr(68);
      end;
      if (contr='-')
      then begin
         megach:=true;
         contr:=chr(67);
      end;
      if (ord(contr)=0) OR megach
      then begin
         if (not megach)
         then
            contr:=readkey;
         while keypressed
         do
            readkey;
         case ord(contr) of
            75:  begin  (* Left *)
               if not screenmove
               then begin
                  draw_cursor(0);
                  if aktpos>1
                  then
                     dec(aktpos)
                  else begin
                     if fact>0
                     then begin
                        dec(fact);
                        GoTo 1
                     end
                  end;
                  draw_cursor(15)
               end
               else begin
                  if fact<714
                  then begin
                     inc(fact);
                     if aktpos>1
                     then begin
                        draw_cursor(0);
                        dec(aktpos)
                     end;
                     GoTo 1
                  end
               end
            end;
            77:  begin  (* Right *)
               if not screenmove
               then begin
                  if fact+aktpos<814
                  then begin
                     draw_cursor(0);
                     if aktpos<100
                     then
                        inc(aktpos)
                     else begin
                        inc(fact);
                        GoTo 1
                     end;
                     draw_cursor(15);
                  end
               end
               else begin
                  if fact>0
                  then begin
                     dec(fact);
                     if aktpos<100
                     then begin
                        draw_cursor(0);
                        inc(aktpos)
                     end;
                     GoTo 1
                  end
               end
            end;
            115: begin  (* Ctrl-Left *)
               if not screenmove
               then begin
                  draw_cursor(0);
                  if aktpos>10
                  then
                     aktpos:=aktpos-10
                  else begin
                     if fact+aktpos>10
                     then begin
                        fact:=fact+aktpos-11;
                        if fact<0
                        then
                           fact:=0
                     end
                     else
                        fact:=0;
                     aktpos:=1;
                     GoTo 1
                  end;
                  draw_cursor(15);
               end
               else begin
                  if fact<714
                  then begin
                     fact:=fact+10;
                     if fact>714
                     then begin
                        verschfact:=724-fact;
                        fact:=714
                     end
                     else
                        verschfact:=10;
                     draw_cursor(0);
                     aktpos:=aktpos-verschfact;
                     if aktpos<1
                     then
                        aktpos:=1;
                     GoTo 1
                  end
               end
            end;
            116: begin  (* Ctrl-Right *)
               if not screenmove
               then begin
                  draw_cursor(0);
                  if aktpos<91
                  then begin
                     if aktpos<805-fact
                     then
                        aktpos:=aktpos+10
                     else
                        aktpos:=814-fact
                  end
                  else begin
                     if fact>713
                     then
                        aktpos:=814-fact
                     else begin
                        fact:=fact+aktpos-90;
                        if fact>714
                        then begin
                           draw_cursor(0);
                           fact:=714
                        end;
                        aktpos:=100;
                        GoTo 1
                     end
                  end;
                  draw_cursor(15);
               end
               else begin
                  if fact>0
                  then begin
                     fact:=fact-10;
                     if fact<0
                     then begin
                        verschfact:=-fact-10;
                        fact:=0
                     end
                     else
                        verschfact:=-10;
                     draw_cursor(0);
                     aktpos:=aktpos-verschfact;
                     if aktpos>100
                     then
                        aktpos:=100;
                     GoTo 1
                  end
               end
            end;
            72:  begin  (* Up *)
               if aktpos+fact<815
               then begin
                  if (aktpos+fact>=minmark) and (aktpos+fact<=maxmark)
                  then
                     ch_marked_lines(1,ord(field[1,aktpos+fact]))
                  else begin
                     if (ord(field[1,aktpos+fact])<255) and
                       (col[aktpos+fact]<>read_only)
                     then begin
                        goodsave:=false;
                        field[1,aktpos+fact]:=chr(ord(field[1,
                          aktpos+fact])+1);
                        putpixel(xebase+aktpos*6,yebase-ord(field[1,
                          aktpos+fact]),3);
                     end
                  end
               end
            end;
            80:  begin  (* Down *)
               if aktpos+fact<815
               then begin
                  if (aktpos+fact>=minmark) and (aktpos+fact<=maxmark)
                  then
                     ch_marked_lines(-1,ord(field[1,aktpos+fact]))
                  else begin
                     if (ord(field[1,aktpos+fact])>0) and
                       (col[aktpos+fact]<>read_only)
                     then begin
                        goodsave:=false;
                        putpixel(xebase+aktpos*6,yebase-ord(field[1,
                          aktpos+fact]),0);
                        field[1,aktpos+fact]:=chr(ord(field[1,
                          aktpos+fact])-1);
                        putpixel(xebase+aktpos*6,yebase-ord(field[1,
                          aktpos+fact]),3);
                     end
                  end
               end
            end;
            73:  begin  (* PgUp *)
               if aktpos+fact<815
               then begin
                  if (aktpos+fact>=minmark) and (aktpos+fact<=maxmark)
                  then
                     ch_marked_lines(10,ord(field[1,aktpos+fact]))
                  else begin
                     if (ord(field[1,aktpos+fact])<245) and
                       (col[aktpos+fact]<>read_only)
                     then
                        field[1,aktpos+fact]:=chr(ord(field[1,
                          aktpos+fact])+10)
                     else if (col[aktpos+fact]<>read_only)
                        then
                           field[1,aktpos+fact]:=chr(255);
                     goodsave:=false;
                     setcolor(0);
                     line(xebase+aktpos*6,yebase,xebase+aktpos*6,yebase-255);
                     setcolor(3);
                     line(xebase+aktpos*6,yebase,xebase+aktpos*6,
                       yebase-ord(field[1,aktpos+fact]))
                  end
               end
            end;
            81:  begin  (* PgDown *)
               if aktpos+fact<815
               then begin
                  if (aktpos+fact>=minmark) and (aktpos+fact<=maxmark)
                  then
                     ch_marked_lines(-10,ord(field[1,aktpos+fact]))
                  else begin
                     if (ord(field[1,aktpos+fact])>10) and
                       (col[aktpos+fact]<>read_only)
                     then
                        field[1,aktpos+fact]:=chr(ord(field[1,
                          aktpos+fact])-10)
                     else if (col[aktpos+fact]<>read_only)
                        then
                           field[1,aktpos+fact]:=chr(0);
                     goodsave:=false;
                     setcolor(0);
                     line(xebase+aktpos*6,yebase,xebase+aktpos*6,yebase-255);
                     setcolor(3);
                     line(xebase+aktpos*6,yebase,xebase+aktpos*6,
                       yebase-ord(field[1,aktpos+fact]))
                  end
               end
            end;
            60,85,95,105:  begin  (* F2 *)
               schdir(oldpath[1]);
               assign(datei,'car'+oldname[1]+'.RES');
               rewrite(datei);
               if IOResult=0
               then begin
                  for i:=1 to field_s[1] do
                     write(datei,field[1,i]);
                  close(datei);
                  goodsave:=true;
                  fieldcopy(1);
               end
            end;
            63,88,98,108:  begin  (* F5 *)
               minmark:=aktpos+fact;
               if maxmark=0
               then
                  maxmark:=size;
               if maxmark<minmark
               then
                  maxmark:=minmark;
               for i:=1 to maxgr do begin
                  if (i+fact>=minmark) and (i+fact<=maxmark)
                  then
                     setcolor(7)
                  else
                     setcolor(0);
                  line(xebase+i*6,yebase+ymarkline,
                    xebase+i*6+2,yebase+ymarkline)
               end;
               show_options
            end;
            64,89,99,109:  begin  (* F6 *)
               maxmark:=aktpos+fact;
               if minmark=0
               then
                  minmark:=1;
               if minmark>maxmark
               then
                  minmark:=maxmark;
               for i:=1 to maxgr do begin
                  if (i+fact>=minmark) and (i+fact<=maxmark)
                  then
                     setcolor(7)
                  else
                     setcolor(0);
                  line(xebase+i*6,yebase+ymarkline,
                    xebase+i*6+2,yebase+ymarkline)
               end;
               show_options
            end;
            66,91,101,111:  begin  (* F8 *)
               minmark:=0;
               maxmark:=0;
               setcolor(0);
               line(0,yebase+ymarkline,639,yebase+ymarkline);
               show_options
            end;
            67,92,102,112,68,93,103,113: begin
               if (ord(contr)=67) OR (ord(contr)=92) OR
                  (ord(contr)=102) OR (ord(contr)=112)
               then
                  newname:=scroll_file(oldpath[1],'CAR'+oldname[1],'RES',-1)
               else
                  newname:=scroll_file(oldpath[1],'CAR'+oldname[1],'RES', 1);
               if (newname<>'')
               then begin
                  i:=1;
                  while (i<5) AND (i+3<=length(newname))
                  do begin
                     oldname[1,i]:=newname[i+3];
                     inc(i);
                  end;
                  oldname[1,0]:=chr(length(newname)-3);
                  neusize:=get_size('car'+oldname[1]+'.res');
                  Assign(datei, 'car'+oldname[1]+'.res');
                  reset(datei);
                  for fp:=1 to neusize do begin
                     read(datei,ch);
                     field[1,fp]:=ch;
                  end;
                  close(datei);
                  GetDir(0,oldpath[1]);
                  field_s[1]:=neusize;
                  field_orig_s[1]:=neusize;
                  fieldcopy(1);
                  goto 1;
               end;
            end;
         end
      end
      else begin
         case ord(contr) of
            8:  begin  (* BackSpace *)
               while keypressed
               do
                  readkey;
               if aktpos+fact<815
               then begin
                  if (aktpos+fact>=minmark) and (aktpos+fact<=maxmark)
                  then
                     ch_marked_lines(-1000,ord(field[1,aktpos+fact]))
                  else begin
                     field[1,aktpos+fact]:=field_orig[1,aktpos+fact];
                     setcolor(3);
                     line(xebase+aktpos*6,yebase,xebase+aktpos*6,
                       yebase-ord(field[1,aktpos+fact]));
                     setcolor(0);
                     line(xebase+aktpos*6,yebase-ord(field[1,aktpos+fact])-1,
                       xebase+aktpos*6,yebase-256)
                  end
               end
            end;
            13:  begin  (* Enter *)
               while keypressed
               do
                  readkey;
               if aktpos+fact<815
               then begin
                  if (aktpos+fact>=minmark) and (aktpos+fact<=maxmark)
                  then
                     ch_marked_lines(0,ord(field[1,aktpos+fact]))
                  else begin
                     if (col[aktpos+fact]<>read_only)
                     then
                        field[1,aktpos+fact]:=field[2,aktpos+fact];
                     setcolor(3);
                     line(xebase+aktpos*6,yebase,xebase+aktpos*6,
                       yebase-ord(field[1,aktpos+fact]));
                     setcolor(0);
                     line(xebase+aktpos*6,yebase-ord(field[1,aktpos+fact])-1,
                       xebase+aktpos*6,yebase-256)
                  end
               end
            end;
            27:  begin  (* Esc *)
               leave:=true;
               oldaktpos:=aktpos;
               oldfact:=fact;
               oldminmark:=minmark;
               oldmaxmark:=maxmark;
(*               fact:=0;
               aktpos:=1;
*)               (* Exit sequence *)
            end;
            32:  begin  (* Space *)
               screenmove:=not screenmove;
               sm_c:=true;
               while keypressed
               do
                  readkey;
               GoTo 1
            end;
            88,120: begin  (* X *)
               while keypressed
               do
                  readkey;
               if aktpos+fact<815
               then begin
                  if (aktpos+fact>=minmark) and (aktpos+fact<=maxmark)
                  then
                     ch_marked_lines(999,ord(field[1,aktpos+fact]))
                  else begin
                     i:=random(maxchange*2+1)-maxchange;
                     if (col[aktpos+fact]<>read_only)
                     then begin
                        if ord(field[1,aktpos+fact])+i>255
                        then
                           field[1,aktpos+fact]:=chr(255)
                        else if ord(field[1,aktpos+fact])+i<0
                           then
                              field[1,aktpos+fact]:=chr(0)
                           else
                              field[1,aktpos+fact]:=chr(ord(field[1,
                                aktpos+fact])+i)
                     end;
                     setcolor(3);
                     line(xebase+aktpos*6,yebase,xebase+aktpos*6,
                       yebase-ord(field[1,aktpos+fact]));
                     setcolor(0);
                     line(xebase+aktpos*6,yebase-ord(field[1,aktpos+fact])-1,
                       xebase+aktpos*6,yebase-256)
                  end
               end
            end;
            72: begin  (* H *)
               while keypressed
               do
                  readkey;
               vhexmode:=not vhexmode;
            end;
            104: begin  (* h *)
               while keypressed
               do
                  readkey;
               phexmode:=not phexmode;
            end;
            ord(comp_char),ord(comp_low_char): begin  (* V *)
               while keypressed
               do
                  readkey;
               carcomp:=not carcomp;
               sm_c:=true;
               show_move_status;
               goto 1;
            end;
            ord(swap_char),ord(swap_low_char): begin  (* T *)
               while keypressed
               do
                  readkey;
               fieldswap;
               sm_c:=true;
               show_move_status;
               goto 1;
            end
         end
      end
   until leave;
   goodsave:=false;
   closegraph
end;


procedure edit_denotations;
const xbase=37;
      ybase=6;
var s1,s2,s4,s5,s61,s62,s71,s72,s73,s8,s9,s11,s13,
      st61,st62,st7,st81,st82,st9:string;
    z61:longint;
    z62,z71,z72,z8,code,nsl:integer;
    z73:real;
    progmode:char;
    newfield:array[1..1024] of char;

begin
   clrscr;
   progmode:=yes_char;
   repeat
      s1:='';
      s2:='';
      s4:='';
      s5:='';
      s61:='';
      s62:='';
      s71:='';
      s72:='';
      s73:='';
      s8:='';
      s9:='';
      s11:='';
      s13:='';
      st61:='';
      st62:='';
      st7:='';
      st81:='';
      st82:='';
      st9:='';
      z61:=0;
      z62:=0;
      z71:=0;
      z72:=0;
      z73:=0;
      z8:=0;
      i:=815;
      while ord(field[1,i])<>93
      do begin
         s1:=s1+field[1,i];
         inc(i)
      end;
      inc(i);
      while ord(field[1,i])<>93
      do begin
         s2:=s2+field[1,i];
         inc(i)
      end;
      inc(i);
      inc(i);
      while ord(field[1,i])<>93
      do begin
         s4:=s4+field[1,i];
         inc(i)
      end;
      inc(i);
      while ord(field[1,i])<>93
      do begin
         s5:=s5+field[1,i];
         inc(i)
      end;
      inc(i);
      while (ord(field[1,i])>47) and (ord(field[1,i])<58)
      do begin
         s61:=s61+field[1,i];
         inc(i)
      end;
      while (ord(field[1,i])<=47) or (ord(field[1,i])>=58)
      do begin
         st61:=st61+field[1,i];
         inc(i)
      end;
      if st61[length(st61)]=','
      then
         st61:=st61+' ';
      while (ord(field[1,i])>47) and (ord(field[1,i])<58)
      do begin
         s62:=s62+field[1,i];
         inc(i)
      end;
      while ord(field[1,i])<>93
      do begin
         st62:=st62+field[1,i];
         inc(i)
      end;
      inc(i);
      while field[1,i]<>'-'
      do begin
         s71:=s71+field[1,i];
         inc(i)
      end;
      inc(i);
      while (ord(field[1,i])>47) and (ord(field[1,i])<58)
      do begin
         s72:=s72+field[1,i];
         inc(i)
      end;
      inc(i);
      while ((ord(field[1,i])>47) and (ord(field[1,i])<58))
        or (field[1,i]='.')
      do begin
         s73:=s73+field[1,i];
         inc(i)
      end;
      while ord(field[1,i])<>93
      do begin
         st7:=st7+field[1,i];
         inc(i)
      end;
      inc(i);
      while (ord(field[1,i])<=47) or (ord(field[1,i])>=58)
      do begin
         st81:=st81+field[1,i];
         inc(i)
      end;
      while (ord(field[1,i])>47) and (ord(field[1,i])<58)
      do begin
         s8:=s8+field[1,i];
         inc(i)
      end;
      while ord(field[1,i])<>93
      do begin
         st82:=st82+field[1,i];
         inc(i)
      end;
      inc(i);
      while ((ord(field[1,i])<=47) or (ord(field[1,i])>=58))
        and (field[1,i]<>',')
      do begin
         st9:=st9+field[1,i];
         inc(i)
      end;
      while ord(field[1,i])<>93
      do begin
         s9:=s9+field[1,i];
         inc(i)
      end;
      inc(i);
      inc(i);
      while ord(field[1,i])>0
      do begin
         s11:=s11+field[1,i];
         inc(i)
      end;
      inc(i);
      while ord(field[1,i])>0
      do begin
         s13:=s13+field[1,i];
         inc(i)
      end;
      val(s61,z61,code);
      if code=0 then begin
         val(s62,z62,code);
         if code=0 then begin
            val(s71,z71,code);
            if code=0 then begin
               val(s72,z72,code);
               if code=0 then begin
                  val(s73,z73,code);
                  if code=0 then begin
                     val(s8,z8,code);
                  end
                  else begin
                     halt(1)
                  end
               end
               else begin
                  halt(1)
               end
            end
            else begin
               halt(1)
            end
         end
         else begin
            halt(1)
         end
      end
      else begin
         halt(1)
      end;
      textcolor(9);
      GoToXY(30,3);
      write(eb_1);
      Set_Color_To(8,7,0,3);
      box(xbase-2,ybase,xbase+25,ybase+18,0,'');
      userset:=[yes_char,no_char,yes_low_char,no_low_char];
      userchar:='';
      Set_ScoreBoard_On;
      SayGet(xbase,ybase+ 1,'',s1,_S,24,1);
      SayGet(xbase,ybase+ 2,'',s2,_S,24,1);
      SayGet(xbase,ybase+ 4,'',s4,_S,24,1);
      SayGet(xbase,ybase+ 5,'',s5,_S,24,1);
      SayGet(xbase,ybase+ 6,'',z61,_LI,5,0);
      SayGet(xbase+5,ybase+ 6,st61,z62,_I,4,0);
      Range('0','3900');
      SayGet(xbase,ybase+ 7,'',z71,_I,3,0);
      Range('0','255');
      SayGet(xbase+3,ybase+ 7,'-',z72,_I,3,0);
      Range('0','255');
      SayGet(xbase+7,ybase+ 7,' ',z73,_R,4,1);
      SayGet(xbase,ybase+ 8,st81,z8,_I,3,0);
      Range('0','255');
      SayGet(xbase,ybase+ 9,st9,s9,_S,11,1);
      Picture('###########');
      SayGet(xbase,ybase+12,'',s11,_S,4,0);
      SayGet(xbase,ybase+14,'',s13,_S,20,1);
      SayGet(xbase,ybase+17,'',progmode,_C,1,0);
      Picture('');
      textcolor(5);
      textbackground(0);
      GoToXY(6,ybase+1);
      write(ted1);
      GoToXY(6,WhereY+1);
      write(ted2);
      GoToXY(6,WhereY+1);
      write(ted3);
      GoToXY(6,WhereY+1);
      write(ted4);
      GoToXY(6,WhereY+1);
      write(ted5);
      GoToXY(6,WhereY+1);
      write(ted6);
      GoToXY(6,WhereY+1);
      write(ted7);
      GoToXY(6,WhereY+1);
      write(ted8);
      GoToXY(6,WhereY+1);
      write(ted9);
      GoToXY(6,WhereY+3);
      write(ted11);
      GoToXY(6,WhereY+2);
      write(ted13);
      GoToXY(6,WhereY+3);
      write(ted15);
      textcolor(2);
      gotoxy(wherex-9,wherey);
      write('[',yes_char,']/[',no_char,']');
      textcolor(8);
      textbackground(7);
      GoToXY(xbase+13,ybase+6);
      write(st62);
      GoToXY(xbase+12,ybase+7);
      write(st7);
      GoToXY(xbase+13,ybase+8);
      write(st82);
      textcolor(7);
      ReadGets;
      if (editresult<>1)
      then begin
         str(z61,s61);
         str(z62,s62);
         str(z71,s71);
         str(z72,s72);
         str(z73:0:1,s73);
         str(z8,s8);
         progmode:=upcase(progmode);
         case progmode of
            yes_char : begin
               for i:=1 to 814 do
                  newfield[i]:=field[1,i];
               nsl:=814;
               for i:=1 to length(s1)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s1[i]
               end;
               inc(nsl);
               newfield[nsl]:=']';
               for i:=1 to length(s2)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s2[i]
               end;
               inc(nsl);
               newfield[nsl]:=']';
               inc(nsl);
               newfield[nsl]:=']';
               for i:=1 to length(s4)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s4[i]
               end;
               inc(nsl);
               newfield[nsl]:=']';
               for i:=1 to length(s5)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s5[i]
               end;
               inc(nsl);
               newfield[nsl]:=']';
               for i:=1 to length(s61)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s61[i]
               end;
               for i:=1 to length(st61)
               do begin
                  inc(nsl);
                  newfield[nsl]:=st61[i]
               end;
               for i:=1 to length(s62)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s62[i]
               end;
               for i:=1 to length(st62)
               do begin
                  inc(nsl);
                  newfield[nsl]:=st62[i]
               end;
               inc(nsl);
               newfield[nsl]:=']';
               for i:=1 to length(s71)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s71[i]
               end;
               inc(nsl);
               newfield[nsl]:='-';
               for i:=1 to length(s72)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s72[i]
               end;
               inc(nsl);
               newfield[nsl]:=' ';
               for i:=1 to length(s73)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s73[i]
               end;
               for i:=1 to length(st7)
               do begin
                  inc(nsl);
                  newfield[nsl]:=st7[i]
               end;
               inc(nsl);
               newfield[nsl]:=']';
               for i:=1 to length(st81)
               do begin
                  inc(nsl);
                  newfield[nsl]:=st81[i]
               end;
               for i:=1 to length(s8)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s8[i]
               end;
               for i:=1 to length(st82)
               do begin
                  inc(nsl);
                  newfield[nsl]:=st82[i]
               end;
               inc(nsl);
               newfield[nsl]:=']';
               for i:=1 to length(st9)
               do begin
                  inc(nsl);
                  newfield[nsl]:=st9[i]
               end;
               if (length(s9)=0) or
                 (((ord(s9[1])<48) or (ord(s9[1])>57)) and (s9[1]<>','))
               then
                  s9:='0';
               for i:=1 to length(s9)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s9[i]
               end;
               inc(nsl);
               newfield[nsl]:=']';
               inc(nsl);
               newfield[nsl]:=chr(0);
               newfield[31]:=chr(nsl-806);
               for i:=1 to length(s11)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s11[i]
               end;
               inc(nsl);
               newfield[nsl]:=chr(0);
               newfield[27]:=chr(nsl-806);
               for i:=1 to length(s13)
               do begin
                  inc(nsl);
                  newfield[nsl]:=s13[i]
               end;
               inc(nsl);
               newfield[nsl]:=chr(0);
               newfield[1]:=chr(nsl-768);
               for i:=1 to 1024
               do
                  field[1,i]:=newfield[i];
               field_s[1]:=nsl
            end;
            no_char : begin

               (* Non-saving exit sequence *)

            end
         end;
      end;
      textbackground(0)
   until true;
   goodsave:=false
end;


procedure Voreinlesen(auto:boolean);  (** Liest Auto ein **)
var i,j,fp,neusize:integer;
    f:file;
    ok,again,firstauto:boolean;
    s:PathStr;
    lom:array[1..5] of boolean;
    loadstat:array[1..5] of boolean;
    lf_car:array[1..1024] of char;
    loadmode:byte;
    neuname:string[4];
Label 1,2;

begin
   firstauto:=auto;
   repeat
1:      loadmode:=3;
      lom[1]:=false;    (* = Altes 2. Auto bleibt Vergleichsauto *)
      lom[2]:=false;    (* = Altes 1. Auto wird Vergleichsauto *)
      lom[3]:=true;     (* = Auto doppelt laden *)
      lom[4]:=false;    (* = Auto als Vergleichsauto zum 1. laden *)
      lom[5]:=false;    (* = Auto als Vergleichsauto zum 2. laden *)
      loadstat[5]:=eingelesen;
      TextColor(9);
      ok:=false;
      again:=false;
      neuname:='';
      clrscr;
      GoToXY(40-(length(m2)+1) div 2,3);
      writeln(m2);
      writeln;
      if (not goodsave) and (fchanged(1))
      then begin
         writeln;
         write_mess(w1,12,7,1);
         delay(200);
      end;
      GoToXY(WhereX,WhereY+2);
      write_mess(l1,5,7,0);
      write('CAR');
      if not firstauto
      then
         auto:=false;
      neuname:=getfname(4,auto);
      firstauto:=false;
      writeln;
      writeln;
      writeln;
      if neuname=#13
      then
         neuname:=oldname[1];
      if length(neuname)>0
      then begin
         {$I-}
         s := FSearch('car'+neuname+'.res','.');
         if S = '' then begin   (* Nicht vorhandene Datei *)
            writeln;
            write_mess(w3,12,7,0);
            repeat
               check:=readkey;
            until not keypressed;
            again:=true
         end
         else begin  (* Vorhanden *)
            if get_size('car'+neuname+'.res')=0
            then
               again:=true;
            if again then begin
               writeln;
               write_mess(w4,12,7,0);
               repeat
                  check:=readkey
               until not keypressed;
            end;
            if not again then begin
               if get_size('car'+neuname+'.res')<815
               then begin
                  again:=true;
                  writeln;
                  write_mess(w10,12,7,0);
                  repeat
                     check:=readkey
                  until not keypressed;
               end
            end;
            if not again then begin
               if get_size('car'+neuname+'.res')>1024
               then begin
                  again:=true;
                  writeln;
                  write_mess(w11,12,7,0);
                  repeat
                     check:=readkey
                  until not keypressed
               end
            end;
            if not again then begin
               Assign(f, 'st'+neuname+'.p3s');
               Reset(f);
               Close(f);
               if IOResult<>0 then begin
                  again:=true;
                  writeln;
                  write_mess(w12,12,7,0)
               end
               else begin
                  if get_size('st'+neuname+'.p3s')>7000
                  then begin
                     again:=true;
                     writeln;
                     write_mess(w15,12,7,0)
                  end
               end;
               Assign(f, 'stda'+neuname+'.pvs');
               Reset(f);
               Close(f);
               if IOResult<>0 then begin
                  again:=true;
                  writeln;
                  write_mess(w13,12,7,0)
               end
               else begin
                  if get_size('stda'+neuname+'.pvs')>20000
                  then begin
                     again:=true;
                     writeln;
                     write_mess(w16,12,7,0)
                  end
               end;
               Assign(f, 'stdb'+neuname+'.pvs');
               Reset(f);
               Close(f);
               if IOResult<>0 then begin
                  again:=true;
                  writeln;
                  write_mess(w14,12,7,0)
               end
               else begin
                  if get_size('stdb'+neuname+'.pvs')>1100
                  then begin
                     again:=true;
                     writeln;
                     write_mess(w17,12,7,0)
                  end
               end;
               if again
               then repeat
                  check:=readkey
               until not keypressed
            end;
            if not again then begin   (* Gltige Gre *)
               neusize:=get_size('car'+neuname+'.res');
               if (loadstat[5]) and (not auto)
               then begin
                  writeln;
                  write_mess(ls51,12,0,1);
                  lom[1]:=true;
                  lom[2]:=true;
                  lom[4]:=true;
                  lom[5]:=true
               end;
               writeln;
               if (loadstat[5]) and (not auto)
               then begin
                  if lom[1]
                  then begin
                     write_mess(lm1,5,0,0);
                     write_mess(ld1,7,0,0);
                     write_mess(lk1,2,0,1)
                  end
                  else begin
                     write_mess(lm1,8,0,0);
                     write_mess(ld1,8,0,0);
                     write_mess(le5,8,0,1)
                  end;
                  if lom[2]
                  then begin
                     write_mess(lm2,5,0,0);
                     write_mess(ld2,7,0,0);
                     write_mess(lk2,2,0,1)
                  end
                  else begin
                     write_mess(lm2,8,0,0);
                     write_mess(ld2,8,0,0);
                     write_mess(le5,8,0,1)
                  end;
                  write_mess(lm3,5,0,0);
                  write_mess(ld3,7,0,0);
                  write_mess(lk3,2,0,1);
                  if lom[4]
                  then begin
                     write_mess(lm4,5,0,0);
                     write_mess(ld4,7,0,0);
                     write_mess(lk4,2,0,1)
                  end
                  else begin
                     write_mess(lm4,8,0,0);
                     write_mess(ld4,8,0,0);
                     write_mess(le5,8,0,1)
                  end;
                  if lom[5]
                  then begin
                     write_mess(lm5,5,0,0);
                     write_mess(ld5,7,0,0);
                     write_mess(lk5,2,0,1)
                  end
                  else begin
                     write_mess(lm5,8,0,0);
                     write_mess(ld5,8,0,0);
                     write_mess(le5,8,0,1)
                  end;
                  write_mess(lm6,5,0,0);
                  write_mess(ld6,7,0,0);
                  write_mess(lk6,2,0,1);
                  writeln;
                  writeln;
                  write_mess('',0,0,0);
2:                  repeat
                     check:=readkey
                  until not keypressed;
                  if ord(check)<>0
                  then begin
                     case check of
                        '1': begin
                           if lom[1]
                           then
                              loadmode:=1
                           else
                              GoTo 2
                        end;
                        '2': begin
                           if lom[2]
                           then
                              loadmode:=2
                           else
                              GoTo 2
                        end;
                        '3': loadmode:=3;
                        '4': begin
                           if lom[4]
                           then
                              loadmode:=4
                           else
                              GoTo 2
                        end;
                        '5': begin
                           if lom[5]
                           then
                              loadmode:=5
                           else
                              GoTo 2
                        end;
                        chr(27):
                           GoTo 1;
                        else
                           GoTo 2
                     end
                  end
                  else begin
                     check:=readkey;
                     GoTo 2
                  end
               end
               else begin
                  if (loadstat[5]) and (auto)
                  then
                     loadmode:=4
               end;
               Assign(datei, 'car'+neuname+'.res');
               reset(datei);
               case loadmode of
                  2: field[2]:=field[1];
                  5: field[1]:=field[2];
               end;
               for fp:=1 to neusize do begin
                  read(datei,ch);
                  case loadmode of
                     1: field[1,fp]:=ch;
                     2: field[1,fp]:=ch;
                     3: begin
                        field[1,fp]:=ch;
                        field[2,fp]:=ch
                     end;
                     4: field[2,fp]:=ch;
                     5: field[2,fp]:=ch
                  end
               end;
               case loadmode of
                  1: begin
                     oldname[1]:=neuname;
                     GetDir(0,oldpath[1]);
                     field_s[1]:=neusize;
                     field_orig_s[1]:=neusize;
                     fieldcopy(1);
                  end;
                  2: begin
                     oldname[2]:=oldname[1];
                     oldpath[2]:=oldpath[1];
                     oldname[1]:=neuname;
                     GetDir(0,oldpath[1]);
                     field_s[2]:=field_s[1];
                     field_s[1]:=neusize;
                     field_orig_s[2]:=field_orig_s[1];
                     field_orig_s[1]:=neusize;
                     fieldcopy(1);
                  end;
                  3: begin
                     oldname[1]:=neuname;
                     GetDir(0,oldpath[1]);
                     oldname[2]:=neuname;
                     GetDir(0,oldpath[2]);
                     field_s[1]:=neusize;
                     field_s[2]:=neusize;
                     field_orig_s[1]:=neusize;
                     field_orig_s[2]:=neusize;
                     fieldcopy(1);
                     fieldcopy(2);
                  end;
                  4: begin
                     oldname[2]:=neuname;
                     GetDir(0,oldpath[2]);
                     field_s[2]:=neusize;
                     field_orig_s[2]:=neusize;
                     fieldcopy(2);
                  end;
                  5: begin
                     oldname[1]:=oldname[2];
                     oldpath[1]:=oldpath[2];
                     oldname[2]:=neuname;
                     GetDir(0,oldpath[2]);
                     field_s[1]:=field_s[2];
                     field_s[2]:=neusize;
                     field_orig_s[1]:=field_orig_s[2];
                     field_orig_s[2]:=neusize;
                     fieldcopy(2);
                  end
               end;
               close(datei);
               case loadmode of
                  2: begin
                     pxs[2]^.st_p3s:=pxs[1]^.st_p3s;
                     pxs[2]^.stda_pvs:=pxs[1]^.stda_pvs;
                     pxs[2]^.stdb_pvs:=pxs[1]^.stdb_pvs;
                     pxs[2]^.st_p3s_s:=pxs[1]^.st_p3s_s;
                     pxs[2]^.stda_pvs_s:=pxs[1]^.stda_pvs_s;
                     pxs[2]^.stdb_pvs_s:=pxs[1]^.stdb_pvs_s
                  end;
                  5: begin
                     pxs[1]^.st_p3s:=pxs[2]^.st_p3s;
                     pxs[1]^.stda_pvs:=pxs[2]^.stda_pvs;
                     pxs[1]^.stdb_pvs:=pxs[2]^.stdb_pvs;
                     pxs[1]^.st_p3s_s:=pxs[2]^.st_p3s_s;
                     pxs[1]^.stda_pvs_s:=pxs[2]^.stda_pvs_s;
                     pxs[1]^.stdb_pvs_s:=pxs[2]^.stdb_pvs_s
                  end
               end;
               neusize:=get_size('st'+neuname+'.p3s');
               Assign(datei, 'st'+neuname+'.p3s');
               reset(datei);
               case loadmode of
                  1,2: begin
                     for fp:=1 to neusize do
                        read(datei,pxs[1]^.st_p3s[fp]);
                     pxs[1]^.st_p3s_s:=neusize
                  end;
                  3: begin
                     for fp:=1 to neusize do begin
                        read(datei,pxs[1]^.st_p3s[fp]);
                        pxs[2]^.st_p3s[fp]:=pxs[1]^.st_p3s[fp]
                     end;
                     pxs[1]^.st_p3s_s:=neusize;
                     pxs[2]^.st_p3s_s:=neusize
                  end;
                  4,5: begin
                     for fp:=1 to neusize do
                        read(datei,pxs[2]^.st_p3s[fp]);
                     pxs[2]^.st_p3s_s:=neusize
                  end
               end;
               close(datei);
               neusize:=get_size('stda'+neuname+'.pvs');
               Assign(datei, 'stda'+neuname+'.pvs');
               reset(datei);
               case loadmode of
                  1,2: begin
                     for fp:=1 to neusize do
                        read(datei,pxs[1]^.stda_pvs[fp]);
                     pxs[1]^.stda_pvs_s:=neusize
                  end;
                  3: begin
                     for fp:=1 to neusize do begin
                        read(datei,pxs[1]^.stda_pvs[fp]);
                        pxs[2]^.stda_pvs[fp]:=pxs[1]^.stda_pvs[fp]
                     end;
                     pxs[1]^.stda_pvs_s:=neusize;
                     pxs[2]^.stda_pvs_s:=neusize
                  end;
                  4,5: begin
                     for fp:=1 to neusize do
                        read(datei,pxs[2]^.stda_pvs[fp]);
                     pxs[2]^.stda_pvs_s:=neusize
                  end
               end;
               close(datei);
               neusize:=get_size('stdb'+neuname+'.pvs');
               Assign(datei, 'stdb'+neuname+'.pvs');
               reset(datei);
               case loadmode of
                  1,2: begin
                     for fp:=1 to neusize do
                        read(datei,pxs[1]^.stdb_pvs[fp]);
                     pxs[1]^.stdb_pvs_s:=neusize
                  end;
                  3: begin
                     for fp:=1 to neusize do begin
                        read(datei,pxs[1]^.stdb_pvs[fp]);
                        pxs[2]^.stdb_pvs[fp]:=pxs[1]^.stdb_pvs[fp]
                     end;
                     pxs[1]^.stdb_pvs_s:=neusize;
                     pxs[2]^.stdb_pvs_s:=neusize
                  end;
                  4,5: begin
                     for fp:=1 to neusize do
                        read(datei,pxs[2]^.stdb_pvs[fp]);
                     pxs[2]^.stdb_pvs_s:=neusize
                  end
               end;
               close(datei);
(*               write_mess(i2,2,0,0);
               delay(500);
               writeln;
               writeln;
               while keypressed
               do
                  readkey;
               write_mess(i3,5,7,0);
               repeat
                  check:=readkey
               until not keypressed;
*)             menuon:=false;
               ok:=true;
               eingelesen:=true
            end
         end;
         {$I+}
      end
   until (length(neuname)=0) or (ok=true);
   TextColor(7)
end;


procedure Vorspeichern;  (** Speichert Auto **)
var i,j,fp:integer;
    f:file;
    ok,again,stgood,stdagood,stdbgood:boolean;
    s:PathStr;
    som:array[1..3] of boolean;
    savestat:array[1..5] of boolean;
    sf_car:array[1..1024] of char;
    savemode:byte;
    neuname:string[4];
    neupath:DirStr;
    samefile:boolean;
Label 1,2;

begin
   repeat
1:      savemode:=3;
      som[1]:=false;    (* = Nur Zusatzdateien speichern *)
      som[2]:=false;    (* = Auto ohne Zusatzdateien speichern *)
      som[3]:=true;     (* = Auto mit Zusatzdateien auf Datei speichern *)
      stgood:=false;
      stdagood:=false;
      stdbgood:=false;
      savestat[1]:=false;
      savestat[2]:=false;
      savestat[3]:=false;
      savestat[4]:=false;
      savestat[5]:=true;
      TextColor(9);
      ok:=false;
      again:=false;
      neuname:='';
      clrscr;
      GoToXY(40-(length(m3)+1) div 2,3);
      writeln(m3);
      GoToXY(WhereX,7);
      write_mess(l1,5,7,0);
      write('CAR');
      neuname:=getfname(4,false);
      writeln;
      writeln;
      writeln;
      if neuname=#13
      then
         neuname:=oldname[1];
      if (length(neuname)<4) and (length(neuname)>0)
      then begin
            writeln;
            write_mess(w2,12,7,0);
            repeat
               check:=readkey;
            until not keypressed;
      end
      else begin
         if length(neuname)>0
         then begin
            {$I-}
            check:='S';
            getdir(0,neupath);
            if (oldname[1]=neuname) AND (oldpath[1]=neupath)
            then samefile:=true
            else samefile:=false;
            if not (samefile)
            then begin
               s := FSearch('car'+neuname+'.res','.');
               if S <> ''
               then begin   (* Vorhandene Datei *)
                  savestat[1]:=true;
                  if get_size('car'+neuname+'.res')>0
                  then begin  (* Nicht 0 *)
                     if get_size('car'+neuname+'.res')<815
                     then
                        savestat[2]:=true
                     else begin
                        if get_size('car'+neuname+'.res')>1024
                        then
                           savestat[3]:=true
                        else begin
                           savestat[2]:=true;
                           savestat[3]:=true
                        end
                     end
                  end
               end;
            end;
            if not samefile
            then begin
               assign(datei,'st'+neuname+'.p3s');
               reset(datei);
               close(datei);
               if IOResult=0
               then begin
                  savestat[4]:=true;
                  if get_size('st'+neuname+'.p3s')>7000
                  then
                     savestat[5]:=false
                  else
                     stgood:=true
               end
               else
                  savestat[5]:=false;
               assign(datei,'stda'+neuname+'.pvs');
               reset(datei);
               close(datei);
               if IOResult=0
               then begin
                  savestat[4]:=true;
                  if get_size('stda'+neuname+'.pvs')>20000
                  then
                     savestat[5]:=false
                  else
                     stdagood:=true
               end
               else
                  savestat[5]:=false;
               assign(datei,'stdb'+neuname+'.pvs');
               reset(datei);
               close(datei);
               if IOResult=0
               then begin
                  savestat[4]:=true;
                  if get_size('stdb'+neuname+'.pvs')>1100
                  then
                     savestat[5]:=false
                  else
                     stdbgood:=true
               end
               else
                  savestat[5]:=false;
               if (savestat[4]) and (not savestat[5])
                 and ((not stgood) or (not stdagood) or (not stdbgood))
               then begin
                  savestat[4]:=false;
                  savestat[5]:=true
               end;
               if not ((not savestat[1])
                 and (not savestat[4]) and (not savestat[5]))
               then
                  writeln;
               if savestat[1]
               then begin
                  write_mess(ss11,12,0,1);
                  if (not savestat[2]) and (not savestat[3])
                  then
                     write_mess(ss20,12,0,1);
                  if (not savestat[2]) and (savestat[3])
                  then
                     write_mess(ss30,12,0,1);
                  if (savestat[2]) and (not savestat[3])
                  then
                     write_mess(ss21,12,0,1);
                  if (savestat[2]) and (savestat[3])
                  then
                     som[1]:=true;
                  if not savestat[4]
                  then begin
                     if not savestat[5]
                     then
                        write_mess(ss40,12,0,1)
                     else
                        write_mess(ss50,12,0,1)
                  end
                  else begin
                     if not savestat[5]
                     then
                        write_mess(ss41,12,0,1)
                     else
                        som[2]:=true
                  end
               end
               else begin
                  if ((savestat[4]) or (savestat[5]))
                  then begin
                     if ((savestat[4]) and (savestat[5]))
                     then begin
                        write_mess(ss10,2,0,1);
                        som[2]:=true
                     end
                     else begin
                        if savestat[4]
                        then
                           write_mess(ss41,12,0,1)
                        else
                           write_mess(ss50,12,0,1)
                     end
                  end
               end;
               writeln;
               if not ((not savestat[1])
                 and (not savestat[4]) and (not savestat[5]))
               then begin
                  if som[1]
                  then begin
                     write_mess(sm1,5,0,0);
                     write_mess(sd1,7,0,0);
                     write_mess(sk1,2,0,1)
                  end
                  else begin
                     write_mess(sm1,8,0,0);
                     write_mess(sd1,8,0,0);
                     write_mess(se5,8,0,1)
                  end;
                  if som[2]
                  then begin
                     write_mess(sm2,5,0,0);
                     write_mess(sd2,7,0,0);
                     write_mess(sk2,2,0,1)
                  end
                  else begin
                     write_mess(sm2,8,0,0);
                     write_mess(sd2,8,0,0);
                     write_mess(se5,8,0,1)
                  end;
                  write_mess(sm3,5,0,0);
                  write_mess(sd3,7,0,0);
                  write_mess(sk3,2,0,1);
                  write_mess(sm4,5,0,0);
                  write_mess(sd4,7,0,0);
                  write_mess(sk4,2,0,1);
                  writeln;
                  writeln;
                  write_mess('',0,0,0);
      2:            repeat
                     check:=readkey
                  until not keypressed;
                  if ord(check)<>0
                  then begin
                     case check of
                        '1': begin
                           if som[1]
                           then
                              savemode:=1
                           else
                              GoTo 2
                        end;
                        '2': begin
                           if som[2]
                           then
                              savemode:=2
                           else
                              GoTo 2
                        end;
                        '3': savemode:=3;
                        chr(27):
                           GoTo 1;
                        else
                           GoTo 2
                     end
                  end
                  else begin
                     check:=readkey;
                     GoTo 2
                  end
               end;
            end
            else begin
               writeln;
               savemode:=3;
            end;
            case savemode of
               1,3: begin
                  assign(datei,'st'+neuname+'.P3S');
                  rewrite(datei);
                  if IOResult=0
                  then begin
                     for fp:=1 to pxs[1]^.st_p3s_s do
                        write(datei,pxs[1]^.st_p3s[fp]);
                     close(datei);
                     ok:=true
                  end
                  else begin
                     write_mess(w5z,12,7,0);
                     repeat
                        check:=readkey
                     until not keypressed;
                     ok:=false
                  end;
                  if ok then begin
                     assign(datei,'stda'+neuname+'.PVS');
                     rewrite(datei);
                     if IOResult=0
                     then begin
                        for fp:=1 to pxs[1]^.stda_pvs_s do
                           write(datei,pxs[1]^.stda_pvs[fp]);
                        close(datei);
                        ok:=true
                     end
                     else begin
                        write_mess(w5z,12,7,0);
                        repeat
                           check:=readkey
                        until not keypressed;
                        ok:=false
                     end;
                     if ok then begin
                        assign(datei,'stdb'+neuname+'.PVS');
                        rewrite(datei);
                        if IOResult=0
                        then begin
                           for fp:=1 to pxs[1]^.stdb_pvs_s do
                              write(datei,pxs[1]^.stdb_pvs[fp]);
                           close(datei);
                           ok:=true
                        end
                        else begin
                           write_mess(w5z,12,7,0);
                           repeat
                              check:=readkey;
                           until not keypressed;
                           ok:=false
                        end
                     end
                  end
               end
            end;
            case savemode of
               2,3: begin
                  assign(datei,'car'+neuname+'.RES');
                  rewrite(datei);
                  if IOResult=0
                  then begin
                     for fp:=1 to field_s[1] do begin
                        write(datei,field[1,fp]);
                        field_orig[1,fp]:=field[1,fp]
                     end;
                     close(datei);
                     ok:=true;
                     oldname[1]:=neuname;
                     getdir(0,oldpath[1]);
                     field_orig_s[1]:=field_s[1]
                  end
                  else begin
                     write_mess(w5,12,7,0);
                     repeat
                        check:=readkey
                     until not keypressed;
                     ok:=false
                  end
               end
            end;
            if ok then begin
               case savemode of
                  1: write_mess(i7z,2,0,0);
                  2: begin
                     write_mess(i7a,2,0,0);
                     goodsave:=true
                  end;
                  3: begin
                     write_mess(i7,2,0,0);
                     goodsave:=true
                  end;
               end;
               delay(500);
               writeln;
               writeln;
               while keypressed
               do
                  readkey;
               write_mess(i3,5,7,0);
               repeat
                  check:=readkey
               until not keypressed;
               ok:=true;
            end;
            {$I+}
         end
      end
   until (length(neuname)=0) or (ok=true);
   TextColor(7)
end;


procedure mainhelp;

begin
   clrscr;
   TextColor(9);
   writeln;
   GoToXY(40-(length(m4)+1) div 2,2);
   writeln(m4);
   writeln;
   writeln;
   TextColor(7);
   write(h1);
   TextColor(c_text_key);
   write('  < F2 >  ');
   TextColor(7);
   writeln(h2);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F3 >  ');
   TextColor(7);
   writeln(h3);
   writeln(h31);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F4 >  ');
   TextColor(7);
   writeln(h4);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F5 >  ');
   TextColor(7);
   writeln(h5);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F9 >  ');
   TextColor(7);
   writeln(h9);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < Esc >  ');
   TextColor(7);
   writeln(h10);
   writeln(h31);
   writeln;
   writeln;
   TextColor(7);
   while keypressed
   do
      readkey;
   write_mess(i3,5,7,0);
   repeat
      readkey
   until not keypressed;
end;


procedure cb_begin;
var Gd, Gm : Integer;
    i,j,pauswert : Integer;
    contr:char;
Label 1;

begin
   if RegisterBGIdriver(@EGAVGADriverProc) < 0 then
     Abort('EGA/VGA');
   if RegisterBGIfont(@GothicFontProc) < 0 then
     Abort('Gothic');
   if RegisterBGIfont(@SansSerifFontProc) < 0 then
     Abort('SansSerif');
   if RegisterBGIfont(@SmallFontProc) < 0 then
     Abort('Small');
   if RegisterBGIfont(@TriplexFontProc) < 0 then
     Abort('Triplex');
   if greeton
   then
      delay(500);
   if (not keypressed) and (greeton) then begin
      Gd:=grdrvr;
      Gm:=grmode;
      InitGraph(Gd, Gm, '');
      if GraphResult <> grOk
      then begin
         sound(1000);
         delay(1000);
         NoSound;
         halt(1)
      end;
      i:=1;
      j:=2;
1:      repeat
         pauswert:=trunc(100*(exp(begverz*ln(2))-1));
         if beginsound
         then begin
            sound(j*100);
            delay(pauswert div 2);
            sound(i*100);
            delay(pauswert div 2)
         end
         else
            delay(pauswert);
         SetTextStyle(4, HorizDir, 10);
         SetTextJustify(CenterText, CenterText);
         SetColor(j);
         OutTextXY(Succ(GetMaxX) div 2,
           round(getmaxy/480*60-10*egamode),'Car');
         SetColor(i);
         OutTextXY(Succ(GetMaxX) div 2,
           round(getmaxy/480*160+10*egamode),'Blaster');
         SetColor(1);
         SetTextStyle(1, HorizDir, 6);
         OutTextXY(Succ(GetMaxX) div 2,
           round(getmaxy/480*300+10*egamode),'Ver. 3.2');
         SetColor(13);
         SetTextStyle(2, HorizDir, 6);
         OutTextXY(Succ(GetMaxX) div 2,round(getmaxy/480*430+10*egamode),b1);
         inc(i);
         inc(j);
         if i=16 then i:=1;
         if j=16 then j:=1
      until keypressed=true;
      contr:=readkey;
      case contr of
         '+': begin
            if begverz>0
            then
               dec(begverz);
            goto 1
         end;
         '-': begin
            if begverz<5
            then
               inc(begverz);
            goto 1
         end;
         chr(0): begin
            contr:=readkey;
            case ord(contr) of
               88: begin
                  beginsound:=true;
                  goto 1
               end;
               63: begin
                  beginsound:=false;
                  NoSound;
                  goto 1
               end;
            end
         end
      end;
      CloseGraph;
      NoSound
   end;
end;


procedure readopt;
var ok:boolean;
    i,j,zoaktpos,zofact,zominmark,zomaxmark,code:integer;
    cfgname:string[12];
    optpath:string[30];
    oaktpos,ofact,ominmark,omaxmark:string;
    datchar:char;
    optdatei:text;

begin
   optname[1]:='';
   optname[2]:='';
   oaktpos:='';
   ofact:='';
   ominmark:='';
   omaxmark:='';
      while keypressed do
         readkey;
      ok:=false;
      clrscr;
      cfgname:='CB.CFG';
      {$I-}
      schdir(progpath);
      assign(optdatei,cfgname);
      reset(optdatei);
      if IOResult<>0
      then begin
         writeln;
         writeln;
         write_mess(wo1,12,7,1);
         writeln;
         delay(500);
         while keypressed
         do
            readkey;
         write_mess(i3,5,7,0);
         contr:=readkey
      end
      else begin
         ok:=false;
         if eof(optdatei)=false
         then begin
            i:=0;
            repeat
               read(optdatei,datchar);
               datchar:=upcase(datchar);
               inc(i);
               if (ord(datchar)<>13) and (ord(datchar)<>10)
               then
                  optname[1]:=optname[1]+datchar
            until (eof(optdatei)) or (ord(datchar)=13);
            i:=0;
            if not eof(optdatei)
            then begin
               repeat
                  read(optdatei,datchar);
                  datchar:=upcase(datchar);
                  inc(i);
                  if (ord(datchar)<>13) and (ord(datchar)<>10)
                  then
                     optname[2]:=optname[2]+datchar
               until (eof(optdatei)) or (ord(datchar)=13);
               i:=0;
               if not eof(optdatei)
               then begin
                  optpath:='';
                  repeat
                     read(optdatei,datchar);
                     inc(i);
                     if (ord(datchar)<>13) and (ord(datchar)<>10)
                     then
                        optpath:=optpath+datchar
                  until (eof(optdatei)) or (ord(datchar)=13);
                  if (sChDir(optpath) <> 0)
                  then begin
                     write_mess(wov1,12,7,1);
                     write_mess(wov2,12,7,1);
                     writeln;
                     while keypressed
                     do
                        readkey;
                     write_mess(i3,5,7,0);
                     repeat
                        check:=readkey
                     until not keypressed;
                     schdir(startpath)
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           oaktpos:=oaktpos+datchar;
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                     val(oaktpos,zoaktpos,code);
                     if code=0
                     then begin
                        optaktpos:=zoaktpos;
                        aktpos:=optaktpos;
                        oldaktpos:=aktpos
                     end
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           ofact:=ofact+datchar;
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                     val(ofact,zofact,code);
                     if code=0
                     then begin
                        optfact:=zofact;
                        fact:=optfact;
                        oldfact:=fact
                     end
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           ominmark:=ominmark+datchar;
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                     val(ominmark,zominmark,code);
                     if code=0
                     then begin
                        optminmark:=zominmark;
                        minmark:=optminmark;
                        oldminmark:=minmark
                     end
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           omaxmark:=omaxmark+datchar;
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                     val(omaxmark,zomaxmark,code);
                     if code=0
                     then begin
                        optmaxmark:=zomaxmark;
                        maxmark:=optmaxmark;
                        oldmaxmark:=maxmark
                     end
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': phexmode:=false;
                              '1': phexmode:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13)
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': vhexmode:=false;
                              '1': vhexmode:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13)
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': greeton:=false;
                              '1': greeton:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13)
                  end;
                  if (length(optname[1])>0)
                  then begin
                     fsel:=1;
                     voreinlesen(true);
                  end;
                  if (length(optname[2])>0) and (optname[1]<>optname[2])
                  then begin
                     fsel:=2;
                     voreinlesen(true);
                  end;
               end
            end
         end;
         close(optdatei);
         ok:=true
      end;
      clrscr;
      {$I+};
end;


procedure saveopt;
const xbase=37;
      ybase=6;
var ok,gr_on:boolean;
    i,j,zoaktpos,zofact,zominmark,zomaxmark:integer;
    n1,n2:string[4];
    cfgname:string[12];
    optpath,origpath:string[30];
    oaktpos,ofact,ominmark,omaxmark:string[3];
    datchar,progmode,phexmode_c,vhexmode_c,gr_on_c:char;
    optdatei:text;

begin
   while keypressed do
      readkey;
   clrscr;
   cfgname:='CB.CFG';
   n1:=oldname[1];
   n2:=oldname[2];
   getdir(0,origpath);
   optpath:=origpath;
   zoaktpos:=oldaktpos;
   zofact:=oldfact;
   zominmark:=oldminmark;
   zomaxmark:=oldmaxmark;
   if greeton
   then
      gr_on_c:=yes_char
   else
      gr_on_c:=no_char;
   if phexmode
   then
      phexmode_c:=yes_char
   else
      phexmode_c:=no_char;
   if vhexmode
   then
      vhexmode_c:=yes_char
   else
      vhexmode_c:=no_char;
   progmode:=yes_char;
   repeat
      textcolor(9);
      GoToXY(28,3);
      write(eo_1);
      Set_Color_To(8,7,0,3);
      box(xbase-2,ybase,xbase+31,ybase+14,0,'');
      Set_ScoreBoard_On;
      userset:=[yes_char,no_char,yes_low_char,no_low_char];
      userchar:='';
      SayGet(xbase,ybase+ 1,'',n1,_S,4,1);
      Picture('@!');
      SayGet(xbase,ybase+ 2,'',n2,_S,4,1);
      Picture('@!');
      SayGet(xbase,ybase+ 4,'',optpath,_S,30,1);
      Picture('@!');
      SayGet(xbase,ybase+ 6,'',zoaktpos,_I,3,0);
      Picture('999');
      Range('0','100');
      SayGet(xbase+3,ybase+ 6,' + ',zofact,_I,3,0);
      Picture('999');
      Range('0','714');
      SayGet(xbase,ybase+ 7,so5_1,zominmark,_I,3,0);
      Picture('999');
      Range('0','714');
      SayGet(xbase+length(so5_1)+6,ybase+ 7,so5_2,zomaxmark,_I,3,0);
      Picture('999');
      Range('0','714');
      SayGet(xbase,ybase+ 9,so8_1,phexmode_c,_C,1,0);
      Picture('');
      SayGet(xbase+length(so8_1)+4,ybase+ 9,so8_2,vhexmode_c,_C,1,0);
      Picture('');
      SayGet(xbase,ybase+ 11,'',gr_on_c,_C,1,0);
      Picture('');
      SayGet(xbase,ybase+ 13,'',progmode,_C,1,0);
      Picture('');
      textcolor(5);
      textbackground(0);
      GoToXY(6,ybase+1);
      write(so1);
      GoToXY(6,WhereY+1);
      write(so2);
      GoToXY(6,WhereY+2);
      write(so3);
      GoToXY(6,WhereY+2);
      write(so4);
      GoToXY(6,WhereY+1);
      write(so5);
      GoToXY(6,WhereY+2);
      write(so8);
      GoToXY(6,WhereY+2);
      write(so6);
      GoToXY(6,WhereY+2);
      write(so7);
      textcolor(2);
      gotoxy(wherex-9,wherey);
      write('[',yes_char,']/[',no_char,']');
      textcolor(7);
      ReadGets;
      if (editresult<>1)
      then begin
         str(zoaktpos,oaktpos);
         oldaktpos:=zoaktpos;
         aktpos:=zoaktpos;
         str(zofact,ofact);
         oldfact:=zofact;
         fact:=zofact;
         str(zominmark,ominmark);
         oldminmark:=zominmark;
         minmark:=zominmark;
         str(zomaxmark,omaxmark);
         oldmaxmark:=zomaxmark;
         maxmark:=zomaxmark;
         gr_on_c:=upcase(gr_on_c);
         phexmode_c:=upcase(phexmode_c);
         vhexmode_c:=upcase(vhexmode_c);
         case gr_on_c of
            yes_char:
               gr_on:=true;
            no_char:
               gr_on:=false
         end;
         case phexmode_c of
            yes_char:
               phexmode:=true;
            no_char:
               phexmode:=false
         end;
         case vhexmode_c of
            yes_char:
               vhexmode:=true;
            no_char:
               vhexmode:=false
         end;
         {$I-}
         progmode:=upcase(progmode);
         TextBackGround(0);
         GoToXY(1,22);
         case progmode of
            yes_char : begin
               schdir(progpath);
               assign(optdatei,cfgname);
               rewrite(optdatei);
               if IOResult=0
               then begin
                  write(optdatei,n1);
                  write(optdatei,chr(13));
                  write(optdatei,chr(10));
                  write(optdatei,n2);
                  write(optdatei,chr(13));
                  write(optdatei,chr(10));
                  write(optdatei,optpath);
                  write(optdatei,chr(13));
                  write(optdatei,chr(10));
                  write(optdatei,oaktpos);
                  write(optdatei,chr(13));
                  write(optdatei,chr(10));
                  write(optdatei,ofact);
                  write(optdatei,chr(13));
                  write(optdatei,chr(10));
                  write(optdatei,ominmark);
                  write(optdatei,chr(13));
                  write(optdatei,chr(10));
                  write(optdatei,omaxmark);
                  write(optdatei,chr(13));
                  write(optdatei,chr(10));
                  if phexmode
                  then
                     write(optdatei,'1')
                  else
                     write(optdatei,'0');
                  write(optdatei,chr(13));
                  write(optdatei,chr(10));
                  if vhexmode
                  then
                     write(optdatei,'1')
                  else
                     write(optdatei,'0');
                  write(optdatei,chr(13));
                  write(optdatei,chr(10));
                  if gr_on
                  then
                     write(optdatei,'1')
                  else
                     write(optdatei,'0');
                  close(optdatei);
                  write_mess(i7o,2,0,0)
               end
               else
                  write_mess(w5,12,7,0);
               delay(500);
               writeln;
               writeln;
               while keypressed
               do
                  readkey;
               write_mess(i3,5,7,0);
               repeat
                  readkey
               until not keypressed;
            end;
            no_char : begin

               (* Non-saving exit sequence *)

            end
         end;
         clrscr;
         textbackground(0);
         if (schdir(optpath) <> 0)
         then begin
            write_mess(o_cd1,12,7,1);
            write_mess(o_cd2,12,7,2);
            writeln;
            writeln;
            while keypressed
            do
               readkey;
            write_mess(i3,5,7,0);
            repeat
               readkey
            until not keypressed;
            schdir(origpath)
         end
         else begin
            getdir(0,optpath);
            if optpath<>origpath
            then begin
               writeln;
               write_mess(o_cd3,5,7,0);
               write_mess(origpath,2,7,1);
               write_mess(o_cd4,5,7,0);
               write_mess(optpath,2,7,1);
               writeln;
               write_mess(o_cd5,5,7,0);
               TextColor(2);
               write('< ',no_char,' >');
               TextColor(5);
               write('  ?   ');
               TextColor(7);
               write(yes_char);
               gotoxy(wherex-1,wherey);
               check:=upcase(readkey);
               if (check=no_char) or (ord(check)=27)
               then
                  schdir(origpath)
               else
                  check:=' '
            end
         end;
         {$I+};
      end
      else
         textbackground(0);
   until true;
   greeton:=gr_on;
end;


procedure cb_init;

begin
   carcomp:=true;
   greeton:=true;
   menuon:=true;
   begverz:=3;
   beginsound:=false;
   eingelesen:=false;
   goodsave:=true;
   oldname[1]:='';
   oldname[2]:='';
   oldpath[1]:='';
   oldpath[2]:='';
   optaktpos:=1;
   optfact:=0;
   oldaktpos:=1;
   oldfact:=0;
   fact:=0;
   aktpos:=1;
   minmark:=0;
   maxmark:=0;
   optminmark:=0;
   optmaxmark:=0;
   oldminmark:=0;
   oldmaxmark:=0;
   markmode:=1;
   maxchange:=40;
   kchange:=8;
   phexmode:=false;
   vhexmode:=false;
   new(pxs[1]);
   new(pxs[2]);
   pxs[1]^.st_p3s_s:=0;
   pxs[1]^.stda_pvs_s:=0;
   pxs[1]^.stdb_pvs_s:=0;
   pxs[2]^.st_p3s_s:=0;
   pxs[2]^.stda_pvs_s:=0;
   pxs[2]^.stdb_pvs_s:=0;
   for i:=1 to 814 do
      col[i]:=0;
   col[1]:=read_only;
   col[27]:=read_only;
   col[31]:=read_only;
   col[39]:=gears_no;
   col[41]:=power_fact;
   col[44]:=brake_power;
   col[46]:=empty_run;
   col[48]:=gear_down;
   col[50]:=gear_up;
   col[52]:=max_turn;
   col[56]:=gear_ueber;
   col[58]:=gear_ueber;
   col[60]:=gear_ueber;
   col[62]:=gear_ueber;
   col[64]:=gear_ueber;
   col[66]:=gear_ueber;
   for i:=97 to 200 do
      col[i]:=torque;
   col[204]:=curve_power;
   col[247]:=height;
end;



begin
  fsplit(paramstr(0),D,N,E);
  progpath:=D;
  getdir(0,startpath);
  if (egamode=1)
  then begin
     grdrvr:=3;  
     grmode:=1;  
  end
  else begin
     grdrvr:=9;
     grmode:=2;
  end;
  randomize;
  textbackground(0);
  setcursorspeed(0);
  cb_init;
  readopt;
  cb_begin;
  if eingelesen
  then
     menuon:=greeton;
  progcheck:=' ';
  WHILE (ord(progcheck)<>68) AND (ord(progcheck)<>27)
  DO begin (*Programmwiederholung*)
    clrscr;
    if not menuon
    then begin
       edit_field;
       menuon:=true
    end;
    WriteLn;
    TextColor(1);
    WriteLn('                          =============================');
    TextColor(4);
    WriteLn('                           C A R   B L A S T E R   3.2');
    TextColor(1);
    WriteLn('                          =============================');
    WriteLn;
    WriteLn;
    WriteLn;
    TextColor(c_text_active);
    Write(mm1);
    TextColor(c_text_key);
    WriteLn('< F1 >');
    WriteLn;
    WriteLn;
    IF not eingelesen THEN begin
       TextColor(c_text_hidden);
       Write(mm2);
       TextColor(c_text_nm);
       Write(mme)
    end
    ELSE begin
       TextColor(c_text_active);
       Write(mm2);
       TextColor(c_text_key);
       Write('< F2 >')
    end;
    WriteLn;
    WriteLn;
    TextColor(c_text_active);
    Write(mm3);
    TextColor(c_text_key);
    WriteLn('< F3 >');
    WriteLn;
    WriteLn;
    IF not eingelesen THEN begin
       TextColor(c_text_hidden);
       Write(mm4);
       TextColor(c_text_nm);
       Write(mme)
    end
    ELSE begin
       TextColor(c_text_active);
       Write(mm4);
       TextColor(c_text_key);
       Write('< F4 >')
    end;
    WriteLn;
    WriteLn;
    IF not eingelesen THEN begin
       TextColor(c_text_hidden);
       Write(mm5);
       TextColor(c_text_nm);
       Write(mme)
    end
    ELSE begin
       TextColor(c_text_active);
       Write(mm5);
       TextColor(c_text_key);
       Write('< F5 >')
    end;
    TextColor(c_text_active);
    WriteLn;
    WriteLn;
    WriteLn;
    Write(mm9);
    TextColor(c_text_key);
    Write('< F9 >');
    TextColor(c_text_active);
    WriteLn;
    WriteLn;
    Write(mm10);
    write_mess('< Esc >',c_text_key,0,1);
    REPEAT
      progcheck:=readkey;
      if ord(progcheck)=0
      then begin
         if keypressed
         then begin
            progcheck:=readkey;
            while keypressed do begin
               progcheck:=readkey;
               progcheck:=' '
            end
         end
         else
            progcheck:=' '
      end
      else
         if (ord(progcheck)<>27)
         then
            progcheck:=' '
         else
            while keypressed do
               progcheck:=readkey;
      ok:=false;
      CASE ord(progcheck) OF
        59 : begin
           mainhelp;
           ok:=true
        end;
        61 : begin
          voreinlesen(false);
          ok:=true
        end;
        60 : begin
          IF eingelesen THEN begin
            vorspeichern;
            ok:=true
          end
        end;
        62 : begin
          IF eingelesen THEN begin
             edit_field;
             ok:=true
          end;
        end;
        63 : begin
          IF eingelesen THEN begin
             edit_denotations;
             ok:=true
          end;
        end;
        67 : begin
          saveopt;
          ok:=true;
        end;
        27,68 : begin
          ok:=true;
          clrscr;
          if (not goodsave) and (fchanged(1))
          then begin
            GoToXY(1,8);
            TextColor(12);
            writeln(w7)
          end;
(*          if (not goodsave)
          then begin
            GoToXY(1,9);
            TextColor(12);
            writeln(w8)
          end;*)
          if (not goodsave) and (fchanged(1))
          then begin
            writeln;
            TextColor(5);
            write(i11);
            TextColor(2);
            write('< ',yes_char,' >');
            write_mess('  ?',5,7,0);
            write('   ',no_char);
            if LoeschProtect=no_char
            then progcheck:=' '
            else progcheck:=chr(68)
          end
        end
      end
    UNTIL ok=true
   end; (*Programmwiederholung*)
   dispose(pxs[1]);
   dispose(pxs[2]);
   TextColor(7);
   clrscr;
   writeln('     ****  CarBlaster  3.2  by  The NAILWOOD Company  ****');
end.
