Program ScoreBlaster;      (* (C) 1997  by  The NAILWOOD Company *)

   (* Purpose: Editing Highscore-names of 'Stunts_1.0' - compatible *)
   (*           score-tables *)
   (* First Implementation:  1. 4.1993 *)
   (* Latest Modification : 19. 3.1997 *)



uses crt,graph,dos,pice,saygete,
     BGIDriv,   { all the BGI drivers }
     BGIFont;   { all the BGI fonts }


const egamode=0;
      l_border=8;
      c_text_key=2;
      c_text_nm=8;
      c_text_active=7;
      c_text_hidden=8;
      startline=6;
b1='A HQ-product of  The NAILWOOD Company';
f1='    Current directory :  ';
f2='     Change directory :';
f3='                             Select file :';
e1='Cancel Input     ';
e2='   Name              Car                   Opponent   Time       ';
e3='End editing      ';
e4='< Del >   not possible ';
e5='Delete line  ';
e8='Previous table';
e9='Next table';
e10='Save directly';
e11='Re-load table';
eo_1='SAVE CONFIGURATION :';
h1='   With';
h2='you can save a loaded scoretable into a file of an optional '+
  '              filename.';
h3='you can load a scoretable from an existing '+
  'scoresfile.';
h31='   If you have changed a table and not saved yet, there occurs a '+
  'warning            automatically.';
h4='you activate the editing-mode for a loaded '+
  'table.';
h5='you can automatically update scoretables of two directories';

h9='you can modify and save the program status.';
h10='you can leave the program.';
i1='   ***  Forbid loading :  Empty input !  ***';
i2='   Table successfully loaded !';
i3='   ***  Press optional key for leaving !  ***  ';
i4='   ***  For saving :  ';
i5='Save';
i6='Cancel';
i7='   Table successfully saved !';
i7o='   Configuration successfully saved !';
i8='   ***  Do you want to overwrite  ';
i9='Overwrite';
i10='   Do you really want to erase the old scoretable  ';
i11='   Do you really want to end the program  ';
l1='   Filename without extension :  ';
m1='EDITING SCORETABLE :  ';
m2='LOADING SCORETABLE :';
m3='SAVING SCORETABLE :';
m4='HELP FOR MAIN MENU :';
m5='UPDATE SCORETABLES :';
mm1='           Help   ';
mm2='           Save scoretable   ';
mm3='           Load scoretable   ';
mm4='           Edit scoretable   ';
mm9= '           Save configuration   ';
mm10='           End program   ';
mm11='           Update automatically   ';
mme='not possible';
lm2='         Merge scorestables ';
ld2='  ';
lk2='< 2 >';
lm3='         Overwrite loaded tables ';
ld3='  ';
lk3='< 3 > / < Enter >';
lm4='         Cancel ';
ld4='  ';
lk4='< Esc >';
le5='not possible';
ls31='         Lines must be erased at merging process !';
ls40='   ***  File contains no highscores  ***  ';
ls41='         File contains highscores';
ls50='         Loaded table contains no highscores';
ls51='         Loaded table contains highscores';
o_cd1='   ***  The indicated directory is not existing yet !  ***';
o_cd2='   ***  Program remains in the current directory  ***';
o_cd3='   Old directory :  ';
o_cd4='   New directory :  ';
o_cd5='   Do you want to change into the new directory  ';
sm3='         Save scoretable to file ';
sd3='  ';
sk3='< 3 >';
sm4='         Cancel ';
sd4='  ';
sk4='< Esc >';
so1='     Talbe to be changed :';
so3='               Directory :';
so6='      Show logo on start :';
so7='           Save          :';
so8='        Source directory :';
so9='     Comparing directory :';
so10='        Target directory :';
so11='Files in the source dir. :';
so11a=' Update-filemodification :';
so11b='Source-dir.:';
so11c=' Comp.-dir.:';
so12=' Files in the comp.-dir. :';
so13a='   Files --> *.~ig ';
so13b=' / erase ';
so13c=' / - ';
so14='       Record-reportfile :';
so15='          Report records :';
ss10='';
ss11='         ***  File exists !  ***';
ss20='         ***  File has a wrong size  ***';
ss21='';
ss30='         File is empty';
ss31='         ***  File is not empty !  ***';
ss40='         File contains no highscores';
ss41='         ***  File contains highscores  ***';
ss50='         Loaded table is empty';
ss51='         Loaded table contains highscores';
w1='   ***  Old scoretable will be erased by loading a new table !  '+
  '***';
w2='   ***  Unfortunately, this file is not existing yet !  ***  ';
w3='   ***  Unfortunately, this file has a wrong size !  ***  ';
w5='   ***  ERROR - Saving has not happened !  ***  ';
w7='   ***  You have changed the scorestable and not saved yet !  '+
  '***';
wmd1='   ***  The source directory does not exist !  ***  ';
wmd2='   ***  The comparation directory does not exist !  ***  ';
wmd3='   ***  The target directory does not exist !  ***';
wmd3a='   ***  The target directory cannot be created !  ***  ';
wmd4='   ***  The comparation dir. has to be different from the source dir. !  ***  ';
wmd5='   ***  The highscore-reportfile is existing yet !  ***';
wmd5a='   ***  The highscore-reportfile cannot be created !  ***  ';
md_i1='Updating table :  ';
md_i2='New record';
md_i3='Record tied';
md_i4='Updated files :  ';
md_i5='New records :  ';
md_i6='Tied records :  ';
md_cd3='   Do you want to create the target directory ?  ';
md_cd5='   Do you want to overwrite the reportfile ?  ';
wo1='   ***  The ScoreBlaster-configuration-file ''SB.cfg'' does not exist'+
  ' !  ***';
wov1='   ***  The directory in the configuration file is invalid !  ***';
wov2='   ***  Program remains in the directory of calling  ***';
yes_char='Y';
no_char='N';
yes_low_char='y';
no_low_char='n';

type linetype=array[1..52] of char;
     fieldtype=array[1..14] of linetype;

var i,j,error,begverz,mark1,mark2:integer;
    contr,check,ch,progcheck: char;
    eingelesen,goodsave,ok,fertig,merged,menuon,beginsound,greeton,
      manload,highrep: boolean;
    oldname,newname:string[40];
    oldpath:string[30];
    progpath,startpath:string[30];
    mdirs:array[1..3] of string;
    aktline,al,linanz,lf_linanz:byte;
    datei:text;
    optname:string[8];
    logname:string[12];
    field,field_orig:fieldtype;
    emptyline:linetype;
    commstr:string;
    P: PathStr;
    D: DirStr;
    N: NameStr;
    E: ExtStr;



procedure writeaktpath;
var s:string;
begin
   getdir(0,s);
   writeln('*',s,'*');
   readkey;
end;


function schdir(dir:DirStr):integer;
var drvstr:string[2];

begin
   {$I-};
   chdir(dir);
   {$I+};
   if ioresult<>0
   then
      schdir:=1
   else
      if length(dir)>1
      then begin
         if (upcase(dir[1])>='A') AND (upcase(dir[1])<='Z') AND (dir[2]=':')
         then begin
            drvstr[1]:=dir[1];
            drvstr[2]:=dir[2];
            drvstr[0]:=chr(2);
            exec('command.com',drvstr);
         end;
         schdir:=0;
      end;
end;


procedure Abort(Msg : string);
begin
  Writeln(Msg, ': ', GraphErrorMsg(GraphResult));
  Halt(1);
end;


function upstring(s:string):string;
var i:integer;

begin
   for i:=1 to length(s)
   do
      s[i]:=upcase(s[i]);
   upstring:=s;
end;


function scroll_file(olddir,oldname,ext:string;dir:integer):string;
type nlp=^namelist;
     namelist=record
        name:string;
        next:nlp;
     end;
var nl,hnl,hhnl:nlp;
    i:integer;
    DirInfo: SearchRec;
    P: PathStr;
    D: DirStr;
    N,preN: NameStr;
    E: ExtStr;
    retval:string;

begin
   nl:=NIL;
   if schdir(olddir)<>0
   then
      retval:=''
   else begin
      FindFirst('*.'+ext, AnyFile, DirInfo);
      while DosError=0
      do begin
         P:=fexpand(DirInfo.Name);
         FSplit(P, D, preN, E);
         preN:=upstring(preN);
         if (nl=NIL) OR (nl^.name>preN)
         then begin
            hnl:=NIL;
            new(hnl);
            hnl^.name:=preN;
            hnl^.next:=nl;
            nl:=hnl;
         end
         else begin
            hnl:=nl;
            while((hnl^.next<>NIL) AND (hnl^.next^.name<preN))
            do
               hnl:=hnl^.next;
            hhnl:=NIL;
            new(hhnl);
            hhnl^.name:=preN;
            hhnl^.next:=hnl^.next;
            hnl^.next:=hhnl;
         end;
         FindNext(DirInfo);
      end;
      if (nl<>NIL)
      then begin
         oldname:=upstring(oldname);
         if dir=1
         then begin
            hnl:=nl;
            while(hnl^.next<>NIL) AND (hnl^.name<=oldname)
            do
               hnl:=hnl^.next;
            if (hnl^.name>oldname)
            then
               retval:=hnl^.name
            else begin
               if (hnl^.next<>NIL)
               then
                  hnl:=hnl^.next;
               retval:=hnl^.name
            end
         end
         else begin
            preN:=nl^.name;
            hnl:=nl;
            while(hnl<>NIL) AND (hnl^.name<oldname)
            do begin
               preN:=hnl^.name;
               hnl:=hnl^.next;
            end;
            retval:=preN;
         end
      end
      else
         retval:='';
   end;
   while (nl<>NIL)
   do begin
      hnl:=nl;
      nl:=nl^.next;
      dispose(hnl);
   end;
   scroll_file:=retval;
end;


procedure buffer_input;

begin
   while not keypressed do
      delay(1000);
end;


function getlineanz(field:fieldtype):byte;
Label 1;

begin
   for i:=14 downto 0 do begin
      for j:=1 to 40 do
         if field[i,j]<>'.'
         then
            GoTo 1;
      for j:=41 to 42 do
         if ord(field[i,j])<>0
         then
            GoTo 1;
      for j:=43 to 44 do
         if field[i,j]<>'.'
         then
            GoTo 1;
      if field[i,45]<>'/'
      then
         GoTo 1;
      for j:=46 to 49 do
         if field[i,j]<>'.'
         then
            GoTo 1;
      if ord(field[i,50])<>0
      then
         GoTo 1;
      for j:=51 to 52 do
         if ord(field[i,j])<>255
         then
            GoTo 1
   end;
1:   getlineanz:=i
end;


function scoretime(infield:linetype):longint;
var i,j:longint;
begin
   i:=ord(infield[51]);
   j:=ord(infield[52]);
   j:=j*256;
   scoretime:=i+j;
end;


function get_size(name:string):integer;
var cf:file of char;

begin
   assign(cf,name);
   reset(cf);
   get_size:=filesize(cf);
   close(cf)
end;


function fchanged:boolean;
var changed:boolean;

begin
   changed:=false;
   for i:=1 to 7 do begin
      for j:=1 to 52 do begin
         if field[i,j]<>field_orig[i,j]
         then begin
            changed:=true;
            i:=7;
            j:=52
         end
      end
   end;
   fchanged:=changed
end;


procedure write_mess(t:string;color,newcolor:byte;newline:byte);

begin
   TextColor(color);
   write(t);
   TextColor(newcolor);
   if newline=1
   then
      writeln;
   write(' ');
   gotoxy(wherex-1,wherey)
end;


procedure merge_field;
var a,b,c:integer;
    hf:fieldtype;

begin
   merged:=true;      
   a:=1;              
   b:=1;
   c:=1;
   for i:=1 to 14 do
      hf[i]:=field[i];
   for c:=1 to 14 do begin
      if b<=lf_linanz
      then begin
         if a<=linanz
         then begin
            if (field_orig[a]=hf[b])
            then begin
               inc(a);
               dec(c);
            end
            else begin
               if scoretime(hf[b]) < scoretime(field_orig[a])
               then begin
                  field[c]:=hf[b];
                  inc(b)
               end
               else begin
                  field[c]:=field_orig[a];
                  inc(a)
               end
            end
         end
         else begin
            field[c]:=hf[b];
            inc(b)
         end
      end
      else begin
         if a<=linanz
         then begin
            field[c]:=field_orig[a];
            inc(a)
         end
         else
            field[c]:=emptyline
      end
   end
end;


procedure write_path;
var path:string;

begin
   getdir(0,path);
   TextColor(5);
   write(f1);
   TextColor(2);
   writeln(path)
end;


function getname(defname:string;choosefile:boolean):string;
var name,origpath,path:string;
    groundline:integer;
Label 1,2;

begin
   groundline:=WhereY;
   name:=defname;
   getdir(0,origpath);
   repeat
1:      getdir(0,path);
      GoToXY(4,groundline);
      write('                                           ',
       '                                     ');
      GoToXY(4,groundline);
      write_path;
      if not choosefile
      then begin
         GoToXY(4,groundline+2);
         TextColor(5);
         write(f2);
         set_pickwindow_to(29,groundline+2,39,24,2,'');
         path:=pickfile('*.* DIRECTORY');
         if path=''
         then begin
   (*         chdir(origpath);*)
            name:='';
            GoTo 2
         end;
         schdir(path);
      end
      else path:='.';
      if path='.' then begin
         repeat
            getdir(0,path);
            GoToXY(4,groundline);
            write('                                           ',
             '                                     ');
            GoToXY(4,groundline);
            write_path;
            GoToXY(1,groundline+2);
            TextColor(5);
            write(f3);
            set_pickwindow_to(45,groundline+2,55,24,2,'');
            name:=pickfile('*.hig NOEXTENSION');
            if name=''
            then begin
               GoToXY(4,groundline+2);
               write('                                           ',
                '                                     ');
               choosefile:=false;
               GoTo 1
            end;
            GoTo 2
         until false
      end
   until false;
2:   TextColor(7);
   GoToXY(4,groundline+1);
   writeln('                                                               ');
   writeln('                                                               ');
   GoToXY(1,groundline);
   if name<>'' then begin
      delete(name,length(name)-3,4)
   end;
   getname:=name
end;


procedure fieldcopy;

begin
   for i:=1 to 14 do begin
      for j:=1 to 52 do begin
         field_orig[i,j]:=field[i,j]
      end
   end
end;


procedure clearline;
var x,y:integer;

begin
   x:=WhereX;
   y:=WhereY;
   for i:=x to 80 do
      write(' ');
   GoToXY(x,y)
end;


function GetFName(mc:integer;auto:boolean):string;  (** Liest einen
         mc-stelligen String ein **)
var c:char;
    i,anfx,anfy:integer;
    lastpos,firstkey:boolean;
    a,apre:string[40];
Label 1,2,3;

begin
   if auto
   then
      a:=optname
   else
      a:=oldname;
3:   anfx:=WhereX;
   anfy:=WhereY;
   gotoxy(4,WhereY+1);
   write_path;
   gotoxy(anfx,WhereY-2);
   textcolor(7);
   clearline;
   i:=WhereX;
   write(a);
   GoToXY(i,WhereY);
   i:=1;
   lastpos:=false;
   firstkey:=true;
   if not auto then begin
    repeat  (* Eingabe von Zeichen *)
1:      c:=upcase(readkey);
      if ord(c)=0
      then begin
         c:=upcase(readkey);
         if (ord(c)=80) OR (ord(c)=72)
         then begin
            GoToXY(anfx,anfy);
            clearline;
            GoToXY(1,WhereY+1);
            apre:=a;
            a:=GetName('',ord(c)=80);
            GoToXY(anfx,anfy);
            textcolor(7);
            clearline;
            if length(a)>0
            then begin
               write(a);
               GoTo 2
            end
            else begin
               a:=apre;
               GoTo 3
            end
         end
         else
            GoTo 1
      end;
      if (ord(c)<>13) and (ord(c)<>27)
      then begin  (* Kein Return, kein Escape *)
         if firstkey
         then begin  (* Defaultstring lschen *)
            firstkey:=false;
            a:='';
            for i:=1 to mc do
               write(' ');
            GoToXY(WhereX-mc,WhereY);
            i:=1
         end;  (* Defaultstring lschen *)
         if (ord(c)=8) and (i>1)
         then begin  (* Lschen des letzteingegebenen Zeichens *)
            if lastpos=true
            then begin  (* Zeichen auf Cursorposition lschen *)
               write(' ');
               GoToXY(WhereX-1,WhereY);
               lastpos:=false;
               delete(a,mc,1)
            end  (* Zeichen auf Cursorposition lschen *)
            else begin  (* Zeichen links neben Cursor lschen *)
               dec(i);
               GoToXY(WhereX-1,WhereY);
               write(' ');
               GoToXY(WhereX-1,WhereY);
               delete(a,i,1)
            end  (* Zeichen links neben Cursor lschen *)
         end  (* Lschen des letzteingegebenen Zeichens *)
         else begin  (* Verarbeitung des Zeichens *)
            if ord(c)<>8
            then begin  (* Eingabe des Zeichens *)
               write(c);
               inc(i);
               if i=mc+1
               then begin  (* Letztes Zeichen austauschen *)
                  i:=mc;
                  lastpos:=true;
                  delete(a,i,1);
                  insert(c,a,i);
                  GoToXY(WhereX-1,WhereY)
               end  (* Letztes Zeichen austauschen *)
               else begin  (* String um Zeichen verlngern *)
                  insert(c,a,i)
               end  (* String um Zeichen verlngern *)
            end  (* Eingabe des Zeichens *)
         end  (* Verarbeitung des Zeichens *)
      end  (* Kein Return, kein Escape *)
    until (ord(c)=13) or (ord(c)=27); (*Eingabe von Zeichen*)
   end;
   if a<>'' then begin
      if ord(c)=13
      then begin
         if firstkey
         then
            a:=chr(13)
      end
      else begin
         if ord(c)=27
         then
            a:=''
      end
   end;
2:   GetFName:=a
end;


procedure LineAway;

begin
   for i:=al to 14 do begin
      for j:=1 to 52 do begin
         field[i,j]:=field[i+1,j]
      end
   end;
   for j:=1 to 52 do begin
      field[14,j]:=emptyline[j]
   end
end;


procedure ChangeLine(l:byte;name:string);

begin
   i:=0;
   for i:=1 to l do begin
      field[al,i]:=name[i]
   end;
   inc(i);
   field[al,i]:=chr(0);
   for i:=i+1 to 17 do
      field[al,i]:='.'
end;


procedure writefname;
var lastattr:integer;

begin
   lastattr:=textattr;
   GoToXY(40-(length(m1)+1) div 2-4+length(m1)+2,1);
   textcolor(7);
   textbackground(0);
   write(oldname);
   write('        ');
   textattr:=lastattr;
end;


procedure LineEdit; 
var c:char;
    i,x,y:integer;
    lastpos,firstkey:boolean;
    a:string[40];
    mc,anfpos:integer;
Label 1,2,3;

begin
   goodsave:=false;
   al:=aktline;
   mc:=16;
   i:=1;
   a:='';
   lastpos:=false;
   firstkey:=true;
   repeat  (* Eingabe von Zeichen *)
1:      c:=readkey;
      case ord(c) of
         0: begin
            c:=readkey;
            case ord(c) of
               72: begin  (* UP *)
                  if aktline>1
                  then begin
                     dec(aktline);
                     if (firstkey)
                     then
                        GoTo 3
                     else
                        GoTo 2
                  end
                  else
                     GoTo 1
               end;
               80: begin  (* DOWN *)
                  if (aktline<linanz) and (linanz>0)
                  then begin
                     inc(aktline);
                     if (firstkey) or (linanz=0)
                     then
                        GoTo 3
                     else
                        GoTo 2
                  end
                  else
                     GoTo 1
               end;
               83: begin
                  if linanz>0 then begin
                     LineAway;
                     dec(linanz)
                  end;
                  if aktline>linanz
                  then
                     dec(aktline);
                  GoTo 3
               end;
               60,85,95,105: begin
                  schdir(oldpath);
                  assign(datei,oldname+'.HIG');
                  rewrite(datei);
                  if IOResult=0
                  then begin
                     for i:=1 to 7 do begin
                        for j:=1 to 52 do begin
                           write(datei,field[i,j]);
                        end
                     end;
                     close(datei);
                     goodsave:=true;
                     merged:=false;
                     fieldcopy;
                  end;
                  GoTo 3
               end;
               61,86,96,106: begin
                  for i:=1 to 14
                  do
                     field[i]:=emptyline;
                  schdir(oldpath);
                  assign(datei,oldname+'.HIG');
                  reset(datei);
                  if IOResult=0
                  then begin
                     for i:=1 to 7 do begin
                        for j:=1 to 52 do begin
                           read(datei,ch);
                           field[i,j]:=ch
                        end
                     end;
                     close(datei);
                     linanz:=getlineanz(field);
                     if aktline=0
                     then
                        aktline:=1;
                     if (aktline>linanz)
                     then
                        aktline:=linanz;
                     goodsave:=true;
                     merged:=false;
                     fieldcopy;
                  end;
                  GoTo 3
               end;
               67,92,102,112,68,93,103,113: begin
                  if (ord(c)=67) OR (ord(c)=92) OR (ord(c)=102) OR (ord(c)=112)
                  then
                     newname:=scroll_file(oldpath,oldname,'HIG',-1)
                  else
                     newname:=scroll_file(oldpath,oldname,'HIG', 1);
                  if (newname<>'')
                  then begin
                     oldname:=newname;
                     for i:=1 to 14
                     do
                        field[i]:=emptyline;
                     assign(datei,oldname+'.HIG');
                     reset(datei);
                     if IOResult=0
                     then begin
                        for i:=1 to 7 do begin
                           for j:=1 to 52 do begin
                              read(datei,ch);
                              field[i,j]:=ch
                           end
                        end;
                        close(datei);
                        linanz:=getlineanz(field);
                        if aktline=0
                        then
                           aktline:=1;
                        if (aktline>linanz)
                        then
                           aktline:=linanz;
                        goodsave:=true;
                        merged:=false;
                        fieldcopy;
                     end;
                     writefname;
                  end;
                  GoTo 3
               end;
               else begin
                  GoTo 1
               end
            end
         end;
         27: begin
            if (firstkey) or (linanz=0)
            then
               fertig:=true;
            GoTo 3
         end;
         13: begin
            if (firstkey) or (linanz=0)
            then
               GoTo 3
            else
               GoTo 2
         end
      end;
      if linanz=0
      then
         GoTo 3
      else begin
         textcolor(0);
         textbackground(7);
         if firstkey
         then begin  (* Defaultstring lschen *)
            firstkey:=false;
            for i:=1 to mc do
               write(' ');
            GoToXY(WhereX-mc,WhereY);
            i:=1
         end;  (* Defaultstring lschen *)
         if (ord(c)=8) and (i>1)
         then begin  (* Lschen des letzteingegebenen Zeichens *)
            if lastpos=true
            then begin  (* Zeichen auf Cursorposition lschen *)
               write(' ');
               GoToXY(WhereX-1,WhereY);
               lastpos:=false;
               delete(a,mc,1)
            end  (* Zeichen auf Cursorposition lschen *)
            else begin  (* Zeichen links neben Cursor lschen *)
               dec(i);
               GoToXY(WhereX-1,WhereY);
               write(' ');
               GoToXY(WhereX-1,WhereY);
               delete(a,i,1)
            end  (* Zeichen links neben Cursor lschen *)
         end  (* Lschen des letzteingegebenen Zeichens *)
         else begin  (* Verarbeitung des Zeichens *)
            if ord(c)<>8
            then begin  (* Eingabe des Zeichens *)
               write(c);
               inc(i);
               if i=mc+1
               then begin  (* Letztes Zeichen austauschen *)
                  i:=mc;
                  lastpos:=true;
                  delete(a,i,1);
                  insert(c,a,i);
                  GoToXY(WhereX-1,WhereY)
               end  (* Letztes Zeichen austauschen *)
               else begin  (* String um Zeichen verlngern *)
                  insert(c,a,i);
               end  (* String um Zeichen verlngern *)
            end  (* Eingabe des Zeichens *)
         end;  (* Verarbeitung des Zeichens *)
         x:=WhereX;
         y:=WhereY;
         textbackground(0);
         GoToXY(5,24);
         textcolor(2);
         write('< Esc >');
         textcolor(7);
         write('  ');
         textcolor(5);
         write(e1);
         TextColor(0);
         textbackground(7);
         GoToXY(x,y)
      end
   until false;  (*Eingabe von Zeichen*)
2:   TextColor(0);
   textbackground(7);
   if lastpos
   then
      ChangeLine(i,a)
   else
      ChangeLine(i-1,a);
3:   TextColor(0);
   textbackground(7)
end;


function LoeschProtect:char;  (** Fragt J/N-Entscheidung ab **)
var nachcheck:char;

begin
     GoToXY(WhereX-1,WhereY);
     nachcheck:=' ';
     check:=upcase(readkey);
     if (ord(check)=13)
     then (*Sofortabbruch*)
          check:=no_char
     else (*Eingabewiederholung*)
          begin
               if (check<>yes_char)
               then (*Ja-Nein-Anzeige*)
                    check:=no_char;
                    write(check);
                    repeat (*Lschsicherung, bis [Esc] gedrckt wird*)
                           GoToXY(WhereX-1,WhereY);
                           nachcheck:=upcase(readkey);
                           if ord(nachcheck)<>13
                           then (*Neues Zeichen wird verarbeitet*)
                                begin
                                     if nachcheck<>yes_char
                                     then (*Ja-Nein-Anzeige*)
                                          nachcheck:=no_char;
                                     write(nachcheck);
                                     check:=nachcheck
                                end; (*Neues Zeichen wird verarbeitet*)
                    until ord(nachcheck)=13 (*Lschsicherung, bis [Esc]
                          gedrckt wird*)
          end; (*Eingabewiederholung*)
     LoeschProtect:=check
end;


procedure edit_field;
var t1,t2,t3:longint;
    overflow:boolean;

begin
   clrscr;
   textcolor(9);
   GoToXY(40-(length(m1)+1) div 2-4,1);
   write(m1);
   writefname;
   textbackground(7);
   aktline:=1;
   fertig:=false;
   TextColor(15);
   TextBackground(8);
   GoToXY(l_border-3,startline-3);
   write('',
    '');
   GoToXY(l_border-3,startline+15);
   write('',
    '');
   TextBackground(7);
   GoToXY(l_border-3,startline-2);
   write('                                                               ',
    '  ');
   GoToXY(l_border-3,startline-1);
   textcolor(15);
   Write(e2);
   textcolor(0);
   GoToXY(l_border-3,startline);
   TextColor(15);
   write('');
   TextColor(0);
   write('                                                                 ');
   TextColor(15);
   write('');
   TextColor(0);
   repeat
      GoToXY(40-(length(m1)+1) div 2-4+length(m1)+3+length(oldname),1);
      textcolor(7);
      textbackground(0);
      if (fchanged)
      then
         write('#')
      else
         write(' ');
      textbackground(7);
      for i:=1 to 14 do begin
         overflow:=false;
         GoToXY(l_border-3,startline+i-1);
         TextColor(15);
         write('');
         TextColor(0);
         if i>7
         then begin
            textcolor(8);
            write(' ( ');
            textcolor(0)
         end
         else
            write('   ');
         if i>linanz
         then begin
            write('..............    ..........            ../....  ');
            t1:=0;
            t2:=0;
            t3:=0
         end
         else begin
            for j:=1 to 16 do begin
               if ord(field[i,j])=0
               then
                  j:=16
               else
                  write(field[i,j])
            end;
            while WhereX<l_border+21 do
               write(' ');
            for j:=18 to 37 do begin
               if ord(field[i,j])=0
               then
                  j:=37
               else
                  write(field[i,j])
            end;
            while WhereX<l_border+43 do
               write(' ');
            if field[i,42]=chr(1)
            then begin
               write('(');
               for j:=43 to 49 do begin
                  write(field[i,j])
               end;
               write(')')
            end
            else begin
               if field[i,43]=' '
               then
                  write('       ')
               else
                  for j:=43 to 49 do begin
                     write(field[i,j])
                  end;
               write('  ')
            end;
            t1:=scoretime(field[i]);
            overflow:=(t1>32767);
            t3:=(t1-(t1 div 20)*20)*5;
            t1:=t1 div 20;
            t2:=t1-(t1 div 60)*60;
            t1:=t1 div 60
         end;
         write('  ');
         write(t1:2,':');
         if t2<10
         then
            write('0');
         write(t2,'.');
         if t3<10
         then
            write('0');
         write(t3);
         if overflow
         then begin
            textcolor(4);
            write('!');
         end
         else
            write(' ');
         if i>7
         then begin
            textcolor(8);
            write(') ');
            textcolor(0)
         end
         else
            write('  ');
         TextColor(15);
         write('');
         TextColor(0);
      end;
      GoToXY(l_border-3,startline+14);
      TextColor(15);
      write('');
      TextColor(0);
      write('                         ',
       '                                        ');
      TextColor(15);
      write('');
      TextColor(0);
      TextBackground(0);
      GoToXY(5,24);
      textcolor(2);
      write('< Esc >');
      textcolor(7);
      write('  ');
      textcolor(5);
      write(e3);
      GoToXY(5,25);
      textcolor(2);
      write('< F2 >');
      textcolor(7);
      write('  ');
      textcolor(5);
      write(e10);
      GoToXY(5,23);
      if linanz=0
      then begin
         textcolor(8);
         write(e4)
      end
      else begin
         textcolor(2);
         write('< Del >');
         textcolor(7);
         write('  ');
         textcolor(5);
         write(e5)
      end;
      GoToXY(43,23);
      textcolor(2);
      write('< F9 >');
      textcolor(7);
      write('  ');
      textcolor(5);
      write(e8);
      GoToXY(43,24);
      textcolor(2);
      write('< F10 >');
      textcolor(7);
      write('  ');
      textcolor(5);
      write(e9);
      GoToXY(43,25);
      textcolor(2);
      write('< F3 >');
      textcolor(7);
      write('  ');
      textcolor(5);
      write(e11);
      if aktline>linanz
      then
         aktline:=linanz;
      GoToXY(l_border+3,startline+aktline-1);
      if aktline=0
      then begin
         textcolor(7);
         textbackground(7);
         GoToXY(WhereX,startline-2);
         write(' ');
         GoToXY(WhereX-1,WhereY)
      end;
      LineEdit
   until fertig;
   textbackground(0)
end;


procedure sb_begin;
var Gd, Gm : Integer;
    i,j,pauswert : Integer;
    contr:char;
Label 1;

begin
  if (egamode=1)
  then begin
     gd:=3;
     gm:=1;
  end
  else begin
     gd:=9;
     gm:=2;
  end;
   if RegisterBGIdriver(@EGAVGADriverProc) < 0 then
     Abort('EGA/VGA');
   if RegisterBGIfont(@GothicFontProc) < 0 then
     Abort('Gothic');
   if RegisterBGIfont(@SansSerifFontProc) < 0 then
     Abort('SansSerif');
   if RegisterBGIfont(@SmallFontProc) < 0 then
     Abort('Small');
   if RegisterBGIfont(@TriplexFontProc) < 0 then
     Abort('Triplex');
   if greeton
   then
      delay(500);
   if (not keypressed) and (greeton)
   then begin
      Gd:=9;
      Gm:=2;
      InitGraph(Gd, Gm, '');
      if GraphResult <> grOk
      then begin
         sound(1000);
         delay(1000);
         NoSound;
         halt(1)
      end;
      i:=1;
      j:=2;
1:      repeat
         pauswert:=trunc(100*(exp(begverz*ln(2))-1));
         if beginsound
         then begin
            sound(j*100);
            delay(pauswert div 2);
            sound(i*100);
            delay(pauswert div 2)
         end
         else
            delay(pauswert);
(*    NoSound;*)
         SetTextStyle(4, HorizDir, 10);
         SetTextJustify(CenterText, CenterText);
         SetColor(j);
         OutTextXY(Succ(GetMaxX) div 2,
           round(getmaxy/480*60-10*egamode),'Score');
         SetColor(i);
         OutTextXY(Succ(GetMaxX) div 2,
           round(getmaxy/480*160+10*egamode),'Blaster');
         SetColor(1);
         SetTextStyle(1, HorizDir, 6);
         OutTextXY(Succ(GetMaxX) div 2,
           round(getmaxy/480*300+10*egamode),'Ver. 7.2b');
         SetColor(13);
         SetTextStyle(2, HorizDir, 6);
         OutTextXY(Succ(GetMaxX) div 2,round(getmaxy/480*430+10*egamode),b1);
         inc(i);
         inc(j);
         if i=16
         then
            i:=1;
         if j=16
         then
            j:=1
      until keypressed=true;
      contr:=readkey;
      case contr of
         '+': begin
            if begverz>0
            then
               dec(begverz);
            goto 1
         end;
         '-': begin
            if begverz<5
            then
               inc(begverz);
            goto 1
         end;
         chr(0): begin
            contr:=readkey;
            case ord(contr) of
               88: begin
                  beginsound:=true;
                  goto 1
               end;
               63: begin
                  beginsound:=false;
                  NoSound;
                  goto 1
               end;
            end
         end
      end;
      CloseGraph;
      NoSound
   end;
   while keypressed
   do
      check:=readkey
end;


procedure Voreinlesen(auto:boolean);  (** Liest Scoresdatei ein **)
var i,j,fp:integer;
    ok,again,firstauto:boolean;
    s:PathStr;
    lom:array[1..3] of boolean;
    loadstat:array[1..5] of boolean;
    lf_field:fieldtype;
    loadmode:byte;
    neuname:string[8];
Label 1,2;

begin
   repeat
1:      loadmode:=3;
      lom[1]:=false;    (* = nicht definiert *)
      lom[2]:=false;    (* = Tabellen mischen *)
      lom[3]:=false;    (* = Alte Tabelle lschen *)
      loadstat[1]:=false;
      loadstat[2]:=false;
      loadstat[3]:=false;
      loadstat[4]:=false;
      loadstat[5]:=false;
      for i:=1 to 14 do
         lf_field[i]:=emptyline;
      TextColor(9);
      ok:=false;
      again:=false;
      neuname:='';
      clrscr;
      GoToXY(40-(length(m2)+1) div 2,3);
      writeln(m2);
      writeln;
      if (not goodsave) and (fchanged)
      then begin
         writeln;
         writeln;
         TextColor(12);
         writeln(w1);
         TextColor(7);
         clearline;
         delay(200);
(*         writeln;
         TextColor(5);
         writeln(i1);
         TextColor(7);
         clearline;
         delay(200)*)
      end;
      GoToXY(WhereX,WhereY+2);
      TextColor(5);
      write(l1);
      TextColor(7);
      clearline;
      if not firstauto
      then
         auto:=false;
      neuname:=GetFName(8,auto);
      firstauto:=false;
      writeln;
      writeln;
      writeln;
      if neuname=#13
      then
         neuname:=oldname;
      if length(neuname)>0
      then begin
         {$I-}
         s := FSearch(neuname+'.hig','.');
         if S = '' then begin   (* Nicht vorhandene Datei *)
            writeln;
            write_mess(w2,12,7,0);
            repeat
               readkey;
            until not keypressed;
            goto 1
         end
         else begin  (* Vorhanden *)
            loadstat[1]:=true;
            if get_size(neuname+'.hig')=364
            then
               again:=false
            else
               again:=true;
            if not again then begin   (* Gltige Gre *)
               loadstat[2]:=true;
               assign(datei,neuname+'.hig');
               reset(datei);
               for i:=1 to 7 do begin
                  for j:=1 to 52 do begin
                     read(datei,ch);
                     lf_field[i,j]:=ch
                  end
               end;
               close(datei);
               lf_linanz:=getlineanz(lf_field);
               if lf_linanz>0
               then
                  loadstat[4]:=true;
               if linanz>0
               then
                  loadstat[5]:=true;
               if linanz+lf_linanz>14
               then
                  loadstat[3]:=true
            end
         end;
         if loadstat[1]
         then begin
            if loadstat[2]
            then begin
               if not loadstat[4]
               then begin
                  writeln;
                  write_mess(ls40,12,7,0);
                  repeat
                     readkey;
                  until not keypressed;
                  goto 1
               end
               else begin
                  if loadstat[5]
                  then begin
                     lom[2]:=true;
                     lom[3]:=true;
                     writeln;
                     write_mess(ls41,2,0,1);
                     write_mess(ls51,12,0,1);
                     if loadstat[3]
                     then begin
                        write_mess(ls31,12,0,1)
                     end
                  end
               end
            end
            else begin
               writeln;
               write_mess(w3,12,7,0);
               repeat
                  readkey;
               until not keypressed;
               goto 1
            end;
            if not auto
            then begin
               if lom[2]
               then begin
                  writeln;
                  write_mess(lm2,5,0,0);
                  write_mess(ld2,7,0,0);
                  write_mess(lk2,2,0,1)
               end;
               if lom[3]
               then begin
                  write_mess(lm3,5,0,0);
                  write_mess(ld3,7,0,0);
                  write_mess(lk3,2,0,1)
               end;
               if (lom[2]) or (lom[3])
               then begin
                  write_mess(lm4,5,0,0);
                  write_mess(ld4,7,0,0);
                  write_mess(lk4,2,0,1);
                  writeln;
                  write_mess('',0,0,0);
2:                  check:=readkey;
                  case check of
                     '2': loadmode:=2;
                     '3',#13: loadmode:=3;
                     chr(27):
                        GoTo 1;
                     else goto 2
                  end
               end
            end
            else
               loadmode:=3;
            if loadmode=2
            then
               fieldcopy;
            field:=lf_field;
            oldname:=neuname;
            GetDir(0,oldpath);
            writeln;
            if loadmode=2
            then
               merge_field
            else
               fieldcopy;
            linanz:=getlineanz(field);
(*            TextColor(2);
            writeln(i2);
            writeln;
            TextColor(7);
            clearline;
            delay(500);
            TextColor(5);
            write(i3);
            TextColor(7);
            clearline;
         write(' ');
         gotoxy(wherex-1,wherey);
         repeat
            readkey;
         until not keypressed;
*)       menuon:=false;
(*         write('nach');
         sound(1000);
         delay(100);
         nosound;
*)            ok:=true;
            eingelesen:=true
         end;
         {$I+}
      end
   until (length(neuname)=0) or (ok=true);
   TextColor(7)
end;


procedure Vorspeichern;  (** Speichert Scoresdatei **)
var i,j,fp:integer;
    ok,again:boolean;
    s:PathStr;
    som:array[1..3] of boolean;
    savestat:array[1..5] of boolean;
    sf_field:fieldtype;
    savemode:byte;
    neuname:string[8];
    neupath:DirStr;
Label 1,2;

begin
   {$I-};
   schdir(oldpath);
   {$I+};
   repeat
1:      savemode:=3;
      som[1]:=false;     (* = not used *)
      som[2]:=false;    (* = not used *)
      som[3]:=true;    (* = Tabelle auf Datei schreiben *)
      savestat[1]:=false;
      savestat[2]:=false;
      savestat[3]:=false;
      savestat[4]:=false;
      if getlineanz(field)>0
      then
         savestat[5]:=true
      else
         savestat[5]:=false;
      TextColor(9);
      ok:=false;
      again:=false;
      neuname:='';
      clrscr;
      GoToXY(40-(length(m3)+1) div 2,3);
      writeln(m3);
      GoToXY(WhereX,7);
      TextColor(5);
      write(l1);
      TextColor(7);
      clearline;
      i:=WhereX;
      write(oldname);
      GoToXY(i,WhereY);
      neuname:=GetFName(8,false);
      writeln;
      writeln;
      writeln;
      if neuname=#13
      then
         neuname:=oldname;
      if length(neuname)>0
      then begin
         {$I-}
         check:='S';
         getdir(0,neupath);
         if not ((oldname=neuname) AND (oldpath=neupath))
         then begin
            s := FSearch(neuname+'.hig','.');
            if S <> ''
            then begin   (* Vorhandene Datei *)
               savestat[1]:=true;
               if get_size(neuname+'.hig')=364
               then begin   (* Gltige Gre *)
                  savestat[2]:=true;
                  savestat[3]:=true;
                  assign(datei,neuname+'.hig');
                  reset(datei);
                  for i:=1 to 7 do begin
                     for j:=1 to 52 do begin
                        read(datei,ch);
                        sf_field[i,j]:=ch
                     end
                  end;
                  if getlineanz(sf_field)>0
                  then
                     savestat[4]:=true;
                  close(datei)
               end
               else begin
                  if get_size(neuname+'.hig')>0   (* Grer als 0 *)
                  then
                     savestat[3]:=true
               end
            end;
         end;
         if savestat[1]
         then begin
            writeln;
            write_mess(ss11,12,0,1);
            if not savestat[2]
            then begin
               write_mess(ss20,12,0,1);
               if not savestat[3]
               then
                  write_mess(ss30,2,0,1)
               else
                  write_mess(ss31,12,1,1)
            end
            else begin
               if savestat[4]
               then begin
                  write_mess(ss41,12,1,1)
               end
               else
                  write_mess(ss40,2,1,1)
            end;
            if savestat[5]
            then begin
               write_mess(ss51,2,1,1)
            end
            else
               write_mess(ss50,2,1,1)
         end;
         writeln;
         if savestat[1]
         then begin
            if som[3]
            then begin
               write_mess(sm3,5,0,0);
               write_mess(sd3,7,0,0);
               write_mess(sk3,2,0,1)
            end;
            write_mess(sm4,5,0,0);
            write_mess(sd4,7,0,0);
            write_mess(sk4,2,0,1);
            writeln;
            writeln;
            write_mess('',0,0,0);
2:            check:=readkey;
            if ord(check)<>0
            then begin
               case check of
                  '3': begin
                     if som[3]
                     then
                        savemode:=3
                     else
                        GoTo 2
                  end;
                  chr(27):
                     GoTo 1;
                  else
                     GoTo 2
               end
            end
            else begin
               readkey;
               GoTo 2
            end
         end;
         assign(datei,neuname+'.HIG');
         rewrite(datei);
         if IOResult=0
         then begin
            for i:=1 to 7 do begin
               for j:=1 to 52 do begin
                  write(datei,field[i,j]);
               end
            end;
            oldname:=neuname;
            GetDir(0,oldpath);
            close(datei);
            fieldcopy;
            write_mess(i7,2,0,0);
            delay(500);
            writeln;
            writeln;
            write_mess(i3,5,7,0);
            readkey;
            ok:=true;
            goodsave:=true;
            merged:=false
         end
         else begin
            TextColor(12);
            write(w5);
            TextColor(7);
            clearline;
            readkey;
            ok:=false
         end
         {$I+}
      end
   until (length(neuname)=0) or (ok=true);
   TextColor(7)
end;


procedure merge_directories;
const xbase=37;
      ybase=6;
var highrep_c:char;
    aktdir:string;
    ok:boolean;
    DirInfo: SearchRec;
    a,b,c:integer;
    f1,f2,f3,hf:fieldtype;
    n1,n2,n3:PathStr;
    datei1,datei2,datei3,logdatei:text;
    f1_linanz,f2_linanz:integer;
    rectime1,rectime2:longint;
    aktcount,newrecs,equalrecs:integer;
    eingestellt,linefound:boolean;
    P: PathStr;
    D: DirStr;
    N: NameStr;
    E: ExtStr;
Label 1;

begin
   for i:=1 to 14 do begin
      f1[i]:=emptyline;
      f2[i]:=emptyline;
      f3[i]:=emptyline;
      hf[i]:=emptyline;
   end;
   if highrep
   then
      highrep_c:=yes_char
   else
      highrep_c:=no_char;
   repeat
      clrscr;
      aktcount:=0;
      newrecs:=0;
      equalrecs:=0;
      getdir(0,aktdir);
      textcolor(9);
      GoToXY(28,3);
      write(m5);
      Set_Color_To(8,7,0,3);
      box(xbase-2,ybase,xbase+31,ybase+11,0,'');
      Set_ScoreBoard_On;
      userset:=[yes_char,no_char,yes_low_char,no_low_char];
      userchar:='';
      SayGet(xbase,ybase+ 1,'',mdirs[1],_S,30,1);
      Picture('@!');
      SayGet(xbase,ybase+ 2,'',mdirs[2],_S,30,1);
      Picture('@!');
      SayGet(xbase,ybase+ 4,'',mdirs[3],_S,30,1);
      Picture('@!');
      SayGet(xbase,ybase+ 6,'',mark1,_I,1,0);
      Picture('9');
      Range('0','2');
      SayGet(xbase,ybase+ 7,'',mark2,_I,1,0);
      Picture('9');
      Range('0','2');
      SayGet(xbase,ybase+ 9,'',logname,_S,12,1);
      Picture('@!');
      SayGet(xbase,ybase+ 10,'',highrep_c,_C,1,0);
      Picture('');
      textcolor(5);
      textbackground(0);
      GoToXY(6,ybase+1);
      write(so8);
      GoToXY(6,WhereY+1);
      write(so9);
      GoToXY(6,WhereY+2);
      write(so10);
      GoToXY(6,WhereY+2);
      write(so11);
      GoToXY(6,WhereY+1);
      write(so12);
      GoToXY(6,WhereY+2);
      write(so14);
      GoToXY(6,WhereY+1);
      write(so15);
      GoToXY(6,WhereY+3);
      textcolor(5);
      write(so13a);
      textcolor(2);
      write('[1]');
      textcolor(5);
      write(so13b);
      textcolor(2);
      write('[2]');
      textcolor(5);
      write(so13c);
      textcolor(2);
      write('[0]');
      textcolor(5);
      ReadGets;
      highrep_c:=upcase(highrep_c);
      case highrep_c of
         yes_char:
            highrep:=true;
         no_char:
            highrep:=false
      end;
1:    ok:=true;
      textcolor(7);
      textbackground(0);
      if (editResult<>1)
      then begin
         gotoxy(1,21);
         mdirs[1]:=fexpand(mdirs[1]);
         mdirs[2]:=fexpand(mdirs[2]);
         mdirs[3]:=fexpand(mdirs[3]);
         if (mdirs[1][length(mdirs[1])]='\')
         then
            delete(mdirs[1],length(mdirs[1]),1);
         if (mdirs[2][length(mdirs[2])]='\')
         then
            delete(mdirs[2],length(mdirs[2]),1);
         if (mdirs[3][length(mdirs[3])]='\')
         then
            delete(mdirs[3],length(mdirs[3]),1);
         if (mdirs[1]=mdirs[2])
         then begin
            write_mess(wmd4,12,7,0);
            repeat
               check:=readkey
            until not keypressed;
            ok:=false;
         end
         else begin
            {$I-};
            if (schdir(mdirs[1]) <> 0)
            then begin
               write_mess(wmd1,12,7,0);
               repeat
                  check:=readkey
               until not keypressed;
               schdir(aktdir);
               ok:=false;
            end
            else begin
               if (schdir(mdirs[2]) <> 0)
               then begin
                  write_mess(wmd2,12,7,0);
                  repeat
                     check:=readkey
                  until not keypressed;
                  schdir(aktdir);
                  ok:=false;
               end
               else begin
                  if (schdir(mdirs[3]) <> 0)
                  then begin
                     write_mess(wmd3,12,7,1);
                     writeln;
                     write_mess(md_cd3,5,7,0);
                     TextColor(2);
                     write('< ',no_char,' >');
                     TextColor(5);
                     write('  ?   ');
                     TextColor(7);
                     write(yes_char);
                     gotoxy(wherex-1,wherey);
                     repeat
                        check:=upcase(readkey)
                     until not keypressed;
                     if (ord(check)<>27)
                     then begin
                        if check=no_char
                        then begin
                           check:=' ';
                           ok:=false;
                        end
                        else begin
                           mkdir(mdirs[3]);
                           if (ioresult<>0)
                           then begin
                              writeln;
                              write_mess(wmd3a,12,7,0);
                              repeat
                                 check:=readkey
                              until not keypressed;
                              ok:=false;
                           end
                           else
                              GOTO 1;
                        end;
                     end;
                     schdir(aktdir)
                  end;
                  if ((ok) AND (ord(check)<>27))
                  then begin
                     if length(logname)>0
                     then begin
                        check:=' ';
                        assign(logdatei,logname);
                        reset (logdatei);
                        if (ioresult=0)
                        then begin
                           write_mess(wmd5,12,7,1);
                           writeln;
                           write_mess(md_cd5,5,7,0);
                           TextColor(2);
                           write('< ',yes_char,' >');
                           TextColor(5);
                           write('  ?   ');
                           TextColor(7);
                           write(no_char);
                           gotoxy(wherex-1,wherey);
                           repeat
                             check:=upcase(readkey)
                           until not keypressed;
                           if check=yes_char
                           then
                              check:=' '
                           else
                              ok:=false;
                        end;
                        if (ok AND (check=' '))
                        then begin
                           rewrite(logdatei);
                           if (ioresult<>0)
                           then begin
                              write_mess(wmd5a,12,7,0);
                              repeat
                                 check:=readkey
                              until not keypressed;
                              ok:=false;
                           end
                        end
                     end
                  end;
               end;
            end;
            {$I+};
         end
      end
      else
         check:=chr(27);
      if (ok) and (ord(check)<>27)
      then begin
         schdir(mdirs[1]);
         FindFirst('*.hig', AnyFile, DirInfo);
         while DosError = 0 do
         begin
            n1:=DirInfo.Name;
            textcolor(7);
            gotoxy(1,21);
            clearline;
            gotoxy(1,22);
            clearline;
            gotoxy(1,23);
            clearline;
            gotoxy(1,21);
            textcolor(2);
            write(md_i1);
            textcolor(7);
            P:=fexpand(n1);
            FSplit(P, D, N, E);
            write(N);
            assign(datei1,n1);
            reset(datei1);
            for i:=1 to 7 do begin
               for j:=1 to 52 do begin
                  read(datei1,ch);
                  f1[i,j]:=ch
               end
            end;
            close(datei1);
            schdir(mdirs[2]);
            n2:=n1;
            assign(datei2,n2);
            {$I-}
            reset(datei2);
            {$I+}
            if (IOResult=0)
            then begin
               for i:=1 to 7 do begin
                  for j:=1 to 52 do begin
                     read(datei2,ch);
                     f2[i,j]:=ch
                  end
               end;
               close(datei2);
               f1_linanz:=getlineanz(f1);
               f2_linanz:=getlineanz(f2);
               a:=1;
               b:=1;
               c:=1;
               for c:=1 to 14 do begin
                  if b<=f2_linanz
                  then begin
                     if a<=f1_linanz
                     then begin
                        if (f1[a]=f2[b])
                        then begin
                           inc(a);
                           dec(c);
                        end
                        else begin
                           if scoretime(f2[b]) < scoretime(f1[a])
                           then begin
                              f3[c]:=f2[b];
                              inc(b)
                           end
                           else begin
                              f3[c]:=f1[a];
                              inc(a)
                           end
                        end
                     end
                     else begin
                        f3[c]:=f2[b];
                        inc(b)
                     end
                  end
                  else begin
                     if a<=f1_linanz
                     then begin
                        f3[c]:=f1[a];
                        inc(a)
                     end
                     else
                        f3[c]:=emptyline
                  end
               end;
               schdir(mdirs[3]);
               n3:=n1;
               assign(datei3,n1);
               rewrite(datei3);
               for i:=1 to 7 do begin
                  for j:=1 to 52 do begin
                     write(datei3,f3[i,j]);
                  end
               end;
               close(datei3);
               if (mdirs[3]<>mdirs[1])
               then begin
                  schdir(mdirs[1]);
                  P:=fexpand(n1);
                  FSplit(P, D, N, E);
                  case mark1 of
                     1: begin
                        assign(datei1,n1);
                        rename(datei1,N+'.~ig');
                     end;
                     2: begin
                        assign(datei1,n1);
                        erase(datei1);
                     end;
                  end;
               end;
               if (mdirs[2]<>mdirs[1])
               then begin
                  schdir(mdirs[2]);
                  P:=fexpand(n2);
                  FSplit(P, D, N, E);
                  case mark2 of
                     1: begin
                        assign(datei2,n2);
                        rename(datei2,N+'.~ig');
                     end;
                     2: begin
                        assign(datei2,n2);
                        erase(datei2);
                     end;
                  end;
               end;
               rectime1:=scoretime(f1[1]);
               rectime2:=scoretime(f2[1]);
               if ((rectime2<rectime1) OR (f1[1]=emptyline))
               then begin
                  if length(logname)>0
                  then begin
                     schdir(mdirs[1]);
                     P:=fexpand(n1);
                     FSplit(P, D, N, E);
                     write(logdatei,N);
                     for i:=length(N) to 12 do
                        write(logdatei,' ');
                     write(logdatei,md_i2+chr(13)+chr(10));
                  end;
                  if (highrep)
                  then begin
                     gotoxy(40,wherey);
                     write_mess('--- '+md_i2+' --- !  ',12,7,0);
                     repeat
                        readkey
                     until not keypressed;
                  end;
                  inc(newrecs);
               end
               else begin
                  if (rectime2=rectime1)
                  then begin
                     eingestellt:=false;
                     b:=1;
                     while (b<=7) AND (scoretime(f2[b])=rectime1) AND
                           (not eingestellt)
                     do begin
                        a:=1;
                        linefound:=true;
                        while (a<=7) AND (scoretime(f1[a])=rectime1) AND
                           (not eingestellt)
                        do begin
                           if (f2[b]=f1[a])
                           then
                              a:=7
                           else
                              linefound:=false;
                           inc(a);
                        end;
                        if not linefound
                        then
                           eingestellt:=true
                        else
                           inc(b);
                     end;
                     if (eingestellt)
                     then begin
                        if length(logname)>0
                        then begin
                           schdir(mdirs[1]);
                           P:=fexpand(n1);
                           FSplit(P, D, N, E);
                           write(logdatei,N);
                           for i:=length(N) to 12 do
                              write(logdatei,' ');
                           write(logdatei,md_i3+chr(13)+chr(10));
                        end;
                        if (highrep)
                        then begin
                           gotoxy(40,wherey);
                           write_mess('--- '+md_i3+' --- !  ',12,7,0);
                           repeat
                              readkey
                           until not keypressed;
                        end;
                        inc(equalrecs);
                     end
                  end;
               end;
               inc(aktcount);
            end;
            schdir(mdirs[1]);
            FindNext(DirInfo);
         end;
         if length(logname)>0
         then begin
            close(logdatei);
            schdir(mdirs[3]);
            if get_size(fexpand(logname))=0
            then
               erase(logdatei);
         end;
         schdir(aktdir);
         gotoxy(1,21);
         clearline;
         textcolor(5);
         write(md_i4);
         textcolor(7);
         write(aktcount);
         gotoxy(1,22);
         textcolor(5);
         write(md_i5);
         textcolor(7);
         write(newrecs);
         gotoxy(24,22);
         textcolor(5);
         write(md_i6);
         textcolor(7);
         write(equalrecs);
         gotoxy(1,24);
         while keypressed
         do
            readkey;
         write_mess(i3,5,7,0);
         repeat
            readkey
         until not keypressed;
      end;
   until (ok=true) OR (ord(check)=27);
   check:=' ';
   schdir(aktdir);
end;


procedure readopt;
var ok:boolean;
    i,j,code:integer;
    cfgname:string[12];
    optpath:string[30];
    optlog:string[12];
    datchar:char;
    optdatei:text;

begin
   optname:='';
   optlog:='';
      while keypressed do
         readkey;
      ok:=false;
      clrscr;
      cfgname:='SB.CFG';
      {$I-}
      schdir(progpath);
      assign(optdatei,cfgname);
      reset(optdatei);
      if IOResult<>0
      then begin
         writeln;
         writeln;
         write_mess(wo1,12,7,1);
         writeln;
         delay(500);
         while keypressed
         do
            readkey;
         write_mess(i3,5,7,0);
         readkey
      end
      else begin
         ok:=false;
         if eof(optdatei)=false
         then begin
            i:=0;
            repeat
               read(optdatei,datchar);
               datchar:=upcase(datchar);
               inc(i);
               if (ord(datchar)<>13) and (ord(datchar)<>10)
               then
                  optname:=optname+datchar
            until (eof(optdatei)) or (ord(datchar)=13);
            i:=0;
               if not eof(optdatei)
               then begin
                  optpath:='';
                  repeat
                     read(optdatei,datchar);
                     inc(i);
                     if (ord(datchar)<>13) and (ord(datchar)<>10)
                     then
                        optpath:=optpath+datchar
                  until (eof(optdatei)) or (ord(datchar)=13);
                  if (sChDir(optpath) <> 0)
                  then begin
                     write_mess(wov1,12,7,1);
                     write_mess(wov2,12,7,1);
                     writeln;
                     while keypressed
                     do
                        readkey;
                     write_mess(i3,5,7,0);
                     repeat
                        readkey
                     until not keypressed;
                     schdir(startpath)
                  end;
                  if not eof(optdatei)
                  then begin
                     mdirs[1]:='';
                     repeat
                        read(optdatei,datchar);
                        inc(i);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then
                           mdirs[1]:=mdirs[1]+datchar;
                     until (eof(optdatei)) or (ord(datchar)=13);
                  end;
                  if not eof(optdatei)
                  then begin
                     mdirs[2]:='';
                     repeat
                        read(optdatei,datchar);
                        inc(i);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then
                           mdirs[2]:=mdirs[2]+datchar;
                     until (eof(optdatei)) or (ord(datchar)=13);
                  end;
                  if not eof(optdatei)
                  then begin
                     mdirs[3]:='';
                     repeat
                        read(optdatei,datchar);
                        inc(i);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then
                           mdirs[3]:=mdirs[3]+datchar;
                     until (eof(optdatei)) or (ord(datchar)=13);
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': mark1:=0;
                              '1': mark1:=1;
                              '2': mark1:=2;
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': mark2:=0;
                              '1': mark2:=1;
                              '2': mark2:=2;
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                  end;
                  repeat
                     read(optdatei,datchar);
                     datchar:=upcase(datchar);
                     if (ord(datchar)<>13) and (ord(datchar)<>10)
                     then
                        optlog:=optlog+datchar
                  until (eof(optdatei)) or (ord(datchar)=13);
                  logname:=optlog;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': highrep:=false;
                              '1': highrep:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13)
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': greeton:=false;
                              '1': greeton:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13)
                       or (datchar='0') or (datchar='1');
                     if (length(optname)>0)
                     then
                        voreinlesen(true);
                  end
               end
         end;
         close(optdatei);
         ok:=true
      end;
      clrscr;
      {$I+};
end;


procedure saveopt;
const xbase=37;
      ybase=4;
var ok,gr_on:boolean;
    i,j:integer;
    n:string[8];
    cfgname:string[12];
    optpath,origpath:string[30];
    datchar,progmode,gr_on_c,highrep_c:char;
    optdatei:text;

begin
   while keypressed do
      readkey;
   clrscr;
   cfgname:='SB.CFG';
   n:=oldname;
   getdir(0,origpath);
   optpath:=origpath;
   if greeton
   then
      gr_on_c:=yes_char
   else
      gr_on_c:=no_char;
   if highrep
   then
      highrep_c:=yes_char
   else
      highrep_c:=no_char;
   progmode:=yes_char;
   repeat
      textcolor(9);
      GoToXY(28,2);
      write(eo_1);
      Set_Color_To(8,7,0,3);
      box(xbase-2,ybase,xbase+31,ybase+16,0,'');
      Set_ScoreBoard_On;
      userset:=[yes_char,no_char,yes_low_char,no_low_char];
      userchar:='';
      SayGet(xbase,ybase+ 1,'',n,_S,8,1);
      Picture('@!');
      SayGet(xbase,ybase+ 2,'',optpath,_S,30,1);
      Picture('@!');
      SayGet(xbase,ybase+ 4,'',mdirs[1],_S,30,1);
      Picture('@!');
      SayGet(xbase,ybase+ 5,'',mdirs[2],_S,30,1);
      Picture('@!');
      SayGet(xbase,ybase+ 6,'',mdirs[3],_S,30,1);
      Picture('@!');
      SayGet(xbase+13,ybase+ 8,'',mark1,_I,1,0);
      Picture('9');
      Range('0','2');
      SayGet(xbase+29,ybase+ 8,'',mark2,_I,1,0);
      Picture('9');
      Range('0','2');
      SayGet(xbase,ybase+ 10,'',logname,_S,12,1);
      Picture('@!');
      SayGet(xbase,ybase+ 11,'',highrep_c,_C,1,1);
      Picture('');
      SayGet(xbase,ybase+ 13,'',gr_on_c,_C,1,0);
      Picture('');
      SayGet(xbase,ybase+ 15,'',progmode,_C,1,0);
      Picture('');
      textcolor(5);
      textbackground(0);
      GoToXY(6,ybase+1);
      write(so1);
      GoToXY(6,WhereY+1);
      write(so3);
      GoToXY(6,WhereY+2);
      write(so8);
      GoToXY(6,WhereY+1);
      write(so9);
      GoToXY(6,WhereY+1);
      write(so10);
      GoToXY(6,WhereY+2);
      write(so11a);
      textbackground(7);
      textcolor(8);
      GoToXY(xbase,WhereY);
      write(so11b);
      GoToXY(xbase+16,WhereY);
      write(so11c);
      textcolor(5);
      textbackground(0);
      GoToXY(6,WhereY+2);
      write(so14);
      GoToXY(6,WhereY+1);
      write(so15);
      GoToXY(6,WhereY+2);
      write(so6);
      GoToXY(6,WhereY+2);
      write(so7);
      textcolor(2);
      gotoxy(wherex-9,wherey);
      write('[',yes_char,']/[',no_char,']');
      textcolor(7);
      ReadGets;
      if editresult<>1
      then begin
         gr_on_c:=upcase(gr_on_c);
         case gr_on_c of
            yes_char:
               gr_on:=true;
            no_char:
               gr_on:=false
         end;
         highrep_c:=upcase(highrep_c);
         case highrep_c of
            yes_char:
               highrep:=true;
            no_char:
               highrep:=false
         end;
         {$I-}
         progmode:=upcase(progmode);
         TextBackGround(0);
         GoToXY(1,22);
         case progmode of
            yes_char : begin
               schdir(progpath);
               assign(optdatei,cfgname);
               rewrite(optdatei);
               if IOResult=0
               then begin
                  write(optdatei,n+chr(13)+chr(10));
                  write(optdatei,optpath+chr(13)+chr(10));
                  write(optdatei,mdirs[1]+chr(13)+chr(10));
                  write(optdatei,mdirs[2]+chr(13)+chr(10));
                  write(optdatei,mdirs[3]+chr(13)+chr(10));
                  write(optdatei,mark1,chr(13)+chr(10));
                  write(optdatei,mark2,chr(13)+chr(10));
                  write(optdatei,logname+chr(13)+chr(10));
                  if highrep
                  then
                     write(optdatei,'1',chr(13)+chr(10))
                  else
                     write(optdatei,'0',chr(13)+chr(10));
                  if gr_on
                  then
                     write(optdatei,'1')
                  else
                     write(optdatei,'0');
                  close(optdatei);
                  write_mess(i7o,2,0,0)
               end
               else
                  write_mess(w5,12,7,0);
               delay(500);
               writeln;
               writeln;
               while keypressed
               do
                  readkey;
               write_mess(i3,5,7,0);
               repeat
                  readkey
               until not keypressed;
            end;
            no_char : begin

               (* Non-saving exit sequence *)

            end;
         end;
         clrscr;
         textbackground(0);
         if (schdir(optpath) <> 0)
         then begin
            write_mess(o_cd1,12,7,1);
            write_mess(o_cd2,12,7,2);
            writeln;
            writeln;
            while keypressed
            do
               readkey;
            write_mess(i3,5,7,0);
            repeat
               readkey
            until not keypressed;
            schdir(origpath)
         end
         else begin
            getdir(0,optpath);
            if optpath<>origpath
            then begin
               writeln;
               write_mess(o_cd3,5,7,0);
               write_mess(origpath,2,7,1);
               write_mess(o_cd4,5,7,0);
               write_mess(optpath,2,7,1);
               writeln;
               write_mess(o_cd5,5,7,0);
               TextColor(2);
               write('< ',no_char,' >');
               TextColor(5);
               write('  ?   ');
               TextColor(7);
               write(yes_char);
               gotoxy(wherex-1,wherey);
               check:=upcase(readkey);
               if (check=no_char) or (ord(check)=27)
               then
                  schdir(origpath)
               else
                  check:=' '
            end
         end;
         {$I+};
      end
      else
         TextBackGround(0);
   until true;
   greeton:=gr_on;
end;


procedure mainhelp;

begin
   clrscr;
   TextColor(9);
   GoToXY(40-(length(m4)+1) div 2,2);
   writeln(m4);
   writeln;
   writeln;
   TextColor(7);
   write(h1);
   TextColor(c_text_key);
   write('  < F2 >  ');
   TextColor(7);
   writeln(h2);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F3 >  ');
   TextColor(7);
   writeln(h3);
   writeln(h31);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F4 >  ');
   TextColor(7);
   writeln(h4);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F5 >  ');
   TextColor(7);
   writeln(h5);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F9 >  ');
   TextColor(7);
   writeln(h9);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < Esc >  ');
   TextColor(7);
   writeln(h10);
   writeln(h31);
   writeln;
   TextColor(7);
   while keypressed
   do
      readkey;
   write_mess(i3,5,7,0);
   repeat
      readkey
   until not keypressed;
end;


procedure sb_init;

begin
  for i:=1 to 40 do
     emptyline[i]:='.';
  emptyline[41]:=chr(0);
  emptyline[42]:=chr(0);
  emptyline[43]:='.';
  emptyline[44]:='.';
  emptyline[45]:='/';
  emptyline[46]:='.';
  emptyline[47]:='.';
  emptyline[48]:='.';
  emptyline[49]:='.';
  emptyline[50]:=chr(0);
  emptyline[51]:=chr(255);
  emptyline[52]:=chr(255);
  greeton:=true;
  menuon:=true;
  begverz:=3;
  beginsound:=false;
  linanz:=0;
  oldname:='';
  oldpath:='';
  eingelesen:=false;
  goodsave:=true;
  merged:=false;
  manload:=false;
  mdirs[1]:=startpath;
  mdirs[2]:=startpath;
  mdirs[3]:=startpath;
  mark1:=1;
  mark2:=1;
  highrep:=true;
  logname:='';
end;



begin
  getdir(0,startpath);
  fsplit(paramstr(0),D,N,E);
if D[length(D)]='\'
then
   D[0]:=chr(ord(D[0])-1);
{$I-};
schdir(D);
{$I-};
  getdir(0,progpath);
  textbackground(0);
  sb_init;
  readopt;
  if (paramcount>0)
  then
     schdir(startpath);
  sb_begin;
  if paramcount>0
  then begin
      commstr:=paramstr(1);
      if commstr[1]='"'
      then begin
         for i:=1 to length(commstr)
         do
            commstr[i]:=commstr[i+1];
         commstr[0]:=chr(ord(commstr[0])-1);
      end;
      commstr:=fexpand(commstr);
      fsplit(commstr,D,N,E);
      commstr:=N;
      i:=1;
      optname:='';
      while (i<=length(commstr)) and (commstr[i]<>'.')
      do begin
         optname[0]:=chr(ord(optname[0])+1);
         optname[i]:=upcase(commstr[i]);
         inc(i);
      end;
      greeton:=false;
      manload:=true;
      voreinlesen(true);
  end;
  if eingelesen
  then
     menuon:=greeton;
  progcheck:=' ';
  textbackground(0);
  WHILE (ord(progcheck)<>68) AND (ord(progcheck)<>27)
  DO begin (*Programmwiederholung*)
    clrscr;
    if not menuon
    then begin
       edit_field;
       menuon:=true
    end;
    clrscr;
    if (ord(progcheck)<>27)
    then begin
       WriteLn;
       TextColor(1);
       WriteLn('                        ==================================');
       TextColor(4);
       WriteLn('                         S C O R E   B L A S T E R   7.2b');
       TextColor(1);
       WriteLn('                        ==================================');
       WriteLn;
       WriteLn;
       WriteLn;
       TextColor(c_text_active);
       Write(mm1);
       TextColor(c_text_key);
       WriteLn('< F1 >');
       WriteLn;
       WriteLn;
       IF not eingelesen THEN begin
          TextColor(c_text_hidden);
          Write(mm2);
          TextColor(c_text_nm);
          Write(mme)
       end
       ELSE begin
          TextColor(c_text_active);
          Write(mm2);
          TextColor(c_text_key);
          Write('< F2 >')
       end;
       WriteLn;
       WriteLn;
       TextColor(c_text_active);
       Write(mm3);
       TextColor(c_text_key);
       WriteLn('< F3 >');
       WriteLn;
       WriteLn;
       IF not eingelesen THEN begin
          TextColor(c_text_hidden);
          Write(mm4);
          TextColor(c_text_nm);
          Write(mme)
       end
       ELSE begin
          TextColor(c_text_active);
          Write(mm4);
          TextColor(c_text_key);
          Write('< F4 >')
       end;
       TextColor(c_text_active);
       WriteLn;
       WriteLn;
       Write(mm11);
       TextColor(c_text_key);
       Write('< F5 >');
       TextColor(c_text_active);
       WriteLn;
       WriteLn;
       WriteLn;
       Write(mm9);
       TextColor(c_text_key);
       Write('< F9 >');
       TextColor(c_text_active);
       WriteLn;
       WriteLn;
       Write(mm10);
       write_mess('< Esc >',c_text_key,0,1);
       REPEAT
         progcheck:=readkey;
         if ord(progcheck)=0
         then begin
            if keypressed
            then begin
               progcheck:=readkey;
               while keypressed do begin
                  progcheck:=readkey;
                  progcheck:=' '
               end
            end
            else
               progcheck:=' ';
         end
         else
            if (ord(progcheck)<>27)
            then
               progcheck:=' '
            else
               while keypressed do
                  progcheck:=readkey;
         ok:=false;
         CASE ord(progcheck) OF
           59 : begin
              mainhelp;
              ok:=true
           end;
           61 : begin
             voreinlesen(false);
             ok:=true
           end;
           60 : begin
             IF eingelesen THEN begin
               vorspeichern;
               ok:=true
             end
           end;
           62 : begin
             IF eingelesen THEN begin
                edit_field;
                ok:=true
             end;
           end;
           63 : begin
                merge_directories;
                ok:=true
           end;
           67 : begin
             saveopt;
             ok:=true;
           end;
           27,68 : begin
             ok:=true;
             clrscr;
             if (not goodsave) and (fchanged) or (merged)
             then begin
               GoToXY(1,8);
               TextColor(12);
               writeln(w7);
               writeln;
               TextColor(5);
               write(i11);
               TextColor(2);
               write('< ',yes_char,' >');
               write_mess('  ?',5,7,0);
               write('   ',no_char);
               if LoeschProtect=no_char
               then
                  progcheck:=' '
               else
                  progcheck:=chr(68)
             end
           end
         end
       UNTIL ok=true
    end;
  end; (*Programmwiederholung*)
  TextColor(7);
  clrscr;
  writeln('     ****  ScoreBlaster  7.2b  by  The NAILWOOD Company  ****');
end.
