Program ScoreViewer;      (* (C) 1995  by  Nailwood Industries *)

   (* Purpose: Viewing Highscores of 'Stunts_1.0' - compatible      *)
   (*           score-tables with QuickView of the Norton-Commander *)
   (* First Implementation: 17. 5.1995 *)
   (* Latest Modification :  4. 3.1997 *)



uses crt,dos;


const l_border=8;
      c_text_key=2;
      c_text_nm=8;
      c_text_active=7;
      c_text_hidden=8;
      startline=11;
days : array [0..6] of String[9] = ('Sunday','Monday','Tuesday','Wednesday',
  'Thursday','Friday','Saturday');
b1='A HQ-product of  The NAILWOOD Company';
f1='    Current directory :  ';
f2='     Change directory :';
f3='                             Select file :';
e1='Cancel Input     ';
e2='Name              Car                   Opponent   Time       ';
e2n1='Name              Car                 ';
e2n2='        Opponent   Time               ';
e3='End editing      ';
e4='< Del >   not possible ';
e5='Delete line  ';
e6='< C_Up >   not possible     ';
e7='1 Line up     ';
e8='< C_Down >   not possible     ';
e9='1 Line down     ';
e10='< Esc >   not possible     ';
eo_1='SAVE CONFIGURATION :';
h1='   With';
h2='you can save a loaded scoretable into a file of an optional '+
  '              filename.';
h3='you can load a scoretable from an existing '+
  'scoresfile.';
h31='   If you have changed a table and not saved yet, there occurs a '+
  'warning            automatically.';
h4='you activate the editing-mode for a loaded '+
  'table.';
h9='you can modify and save the program status.';
h10='you can leave the program.';
i1='   ***  Forbid loading :  Empty input !  ***';
i2='   Table successfully loaded !';
i3='   ***  Press optional key for leaving !  ***  ';
i4='   ***  For saving :  ';
i5='Save';
i6='Cancel';
i7='   Table successfully saved !';
i7o='   Configuration successfully saved !';
i8='   ***  Do you want to overwrite  ';
i9='Overwrite';
i10='   Do you really want to erase the old scoretable  ';
i11='   Do you really want to end the program  ';
iprint='   ***  Press [p] for a printout.  ***';
l1='   Filename without extension :  ';
m1='Highscore-file : ';
m2='LOADING SCORETABLE :';
m3='SAVING SCORETABLE :';
m4='HELP FOR MAIN MENU :';
mm1='           Help   ';
mm2='           Save scoretable   ';
mm3='           Load scoretable   ';
mm4='           Edit scoretable   ';
mm9= '           Save configuration   ';
mm10='           End program   ';
mme='not possible';
lm2='         Merge scorestables ';
ld2='  ';
lk2='< 2 >';
lm3='         Overwrite loaded tables ';
ld3='  ';
lk3='< 3 >';
lm4='         Cancel ';
ld4='  ';
lk4='< Esc >';
le5='not possible';
ls31='         Lines must be erased at merging process !';
ls40='   ***  File contains empty table  ***  ';
ls41='         File contains no empty table';
ls50='         Only empty table loaded';
ls51='         Table with information has been loaded';
o_cd1='   ***  The indicated directory is not existing yet !  ***';
o_cd2='   ***  Program remains in the current directory  ***';
o_cd3='   Old directory :  ';
o_cd4='   New directory :  ';
o_cd5='   Do you want to change into the new directory  ';
ps1='              Highscore-file : ';
ps2='          Last actualisation : ';
ps3='                               ';
ps4='       Printing date : ';
ps5='       Printing time : ';
pleft='          ';
printerr1='   ***  Unfortunately, printing is not possible !  ***';
sm3='         Save scoretable to file ';
sd3='  ';
sk3='< 3 >';
sm4='         Cancel ';
sd4='  ';
sk4='< Esc >';
so1='     Talbe to be changed :';
so3='               Directory :';
so6='               Greetings :';
so7='           Save          :';
ss10='';
ss11='         ***  File exists !  ***';
ss20='         ***  File has a wrong size  ***';
ss21='';
ss30='         File is empty';
ss31='         ***  File is not empty !  ***';
ss40='         File contains empty table';
ss41='         ***  File contains no empty table  ***';
ss50='         Only empty table loaded';
ss51='         Table with information has been loaded';
w_nc='    ScoreViewer - Error message :     ';
w1='   ***  Old scoretable will be erased by loading a new table !  '+
  '***';
w2='   ***  Unfortunately, this file is not existing yet !  ***  ';
w3='   ***  Unfortunately, this file has a wrong size !  ***  ';
w3n1='  ***  Unfortunately this file   ***  ';
w3n2='  ***  has a wrong size !        ***  ';
w3n3='   View this file with an other       ';
w3n4='   editor.                            ';
w3n3a='   View this file with an other editor.';
w5='   ***  ERROR - Saving has not happened !  ***  ';
w7='   ***  You have changed the scorestable and not saved yet !  '+
  '***';
wo1='   ***  The ScoreBlaster-configuration-file ''SB.cfg'' does not exist'+
  ' !  ***';
wov1='   ***  The directory in the configuration file is invalid !  ***';
wov2='   ***  Program remains in the directory of calling  ***';
parerr1='   ***  Syntax :  SV <filename>[.hig] ,  SV <filename> -p  ***';
yes_char='Y';
no_char='N';
yes_low_char='y';
no_low_char='n';

type linetype=string[52];
     fieldtype=array[1..14] of linetype;

var i,j,error,begverz,clm,startx,starty:integer;
    y, mo, d, dow, h, m, s, hund : Word;
    contr,check,ch: char;
    eingelesen,goodsave,ok,fertig,merged,menuon,beginsound,greeton,
      printon,printout: boolean;
    oldname:string[40];
    stpath,startpath:string[30];
    commstr,switchstring:string[255];
    aktline,al,linanz,lf_linanz:byte;
    datei,lst:text;
    optname:string[8];
    optstring:string;
    field,field_orig:fieldtype;
    emptyline:linetype;
    ftime : Longint;
    dt : DateTime;
    outstring,prestring:string;
    memnum:longint;
    parb,paro:word;



function getlineanz(field:fieldtype):byte;
Label 1;

begin
   for i:=7 downto 0 do begin
(*
      for j:=1 to 40 do
         if field[i,j]<>'.'
         then
            GoTo 1;
      for j:=41 to 42 do
         if ord(field[i,j])<>0
         then
            GoTo 1;
      for j:=43 to 44 do
         if field[i,j]<>'.'
         then
            GoTo 1;
      if field[i,45]<>'/'
      then
         GoTo 1;
      for j:=46 to 49 do
         if field[i,j]<>'.'
         then
            GoTo 1;
      if ord(field[i,50])<>0
      then
         GoTo 1;
      for j:=51 to 52 do
         if ord(field[i,j])<>255
         then
            GoTo 1
*)
      if field[i]<>emptyline
      then goto 1
   end;
1:   getlineanz:=i
end;


function get_size(name:string):integer;
var cf:file of char;

begin
   assign(cf,name);
   reset(cf);
   get_size:=filesize(cf);
   close(cf)
end;


function LZ(w : Word) : String;
var
  s : String;
begin
  Str(w:0,s);
  if Length(s) = 1 then
    s := '0' + s;
  LZ := s;
end;


procedure write_mess(t:string;color,newcolor:byte;newline:byte);

begin
   TextColor(color);
   write(t);
   TextColor(newcolor);
   if newline=1
   then
      writeln;
   write(' ');
   gotoxy(wherex-1,wherey)
end;


function scoretime(infield:linetype):longint;
var i,j:longint;
begin
   i:=ord(infield[51]);
   j:=ord(infield[52]);
   j:=j*256;
   scoretime:=i+j;
end;


procedure print_score;
var t1,t2,t3:longint;
    overflow:boolean;
    lst:text;

begin
   GetDate(y,mo,d,dow);
   GetTime(h,m,s,hund);
   {$I-};
      assign(lst, 'PRN');
      rewrite(lst);
      writeln(lst);
      writeln(lst);
      if (ioresult=160)
      then begin
         case clm of
            2: begin
               writeln;
               write_mess(printerr1,12,7,0);
               writeln;
               halt(1);
            end;
            3: begin
               gotoxy(1,18);
               write_mess(printerr1,12,7,0);
               check:=readkey;
               halt(1);
            end;
         end;
      end;
   {$I-};
   outstring:=ps1+optname;
   writeln(lst,outstring);
   outstring:=ps2;
   str(dt.Day:0, prestring);
   outstring:=outstring+prestring+'.';
   str(dt.Month:0, prestring);
   outstring:=outstring+prestring+'.';
   str(dt.Year:0, prestring);
   outstring:=outstring+prestring;
   while Length(outstring)<40 do
      outstring:=outstring+' ';
   outstring:=outstring+ps4;
   str(d:0, prestring);
   outstring:=outstring+prestring+'.';
   str(mo:0, prestring);
   outstring:=outstring+prestring+'.';
   str(y:0, prestring);
   outstring:=outstring+prestring;
   WriteLn(lst,outstring);
   outstring:=ps3;
   str(dt.Hour:0, prestring);
   outstring:=outstring+prestring+':'+lz(dt.Min);
   while Length(outstring)<40 do
      outstring:=outstring+' ';
   outstring:=outstring+ps5;
   str(h:0, prestring);
   outstring:=outstring+prestring+':'+lz(m);
   WriteLn(lst,outstring);
   writeln(lst);
   writeln(lst);
   writeln(lst,pleft+e2);
   writeln(lst);
   for i:=1 to 7 do begin
      overflow:=false;
      if i>linanz
      then begin
         outstring:=pleft+'..............    ..........            ../....'+
           '  ';
         t1:=0;
         t2:=0;
         t3:=0
      end
      else begin
         outstring:=pleft;
         for j:=1 to 16 do begin
            if ord(field[i,j])=0
            then
               j:=16
            else
               outstring:=outstring+field[i,j]
         end;
         while length(outstring)<28 do
            outstring:=outstring+' ';
         for j:=18 to 37 do begin
            if ord(field[i,j])=0
            then
               j:=37
            else
               outstring:=outstring+field[i,j]
         end;
         while length(outstring)<50 do
            outstring:=outstring+' ';
         if field[i,42]=chr(1)
         then begin
            outstring:=outstring+'(';
            for j:=43 to 49 do begin
               outstring:=outstring+field[i,j]
            end;
            outstring:=outstring+')'
         end
         else begin
            if field[i,43]=' '
            then
               outstring:=outstring+'       '
            else
               for j:=43 to 49 do begin
                  outstring:=outstring+field[i,j]
               end;
            outstring:=outstring+'  '
         end;
         t1:=scoretime(field[i]);
         overflow:=(t1>32767);
         t3:=(t1-(t1 div 20)*20)*5;
         t1:=t1 div 20;
         t2:=t1-(t1 div 60)*60;
         t1:=t1 div 60
      end;
      outstring:=outstring+'  ';
      str(t1:2,prestring);
      outstring:=outstring+prestring+':'+lz(t2)+'.'+lz(t3);
      if overflow
      then
         outstring:=outstring+'!';
      writeln(lst,outstring)
   end;
   writeln(lst);
   writeln(lst);
   close(lst);
end;


procedure show_normal;
var t1,t2,t3,startline:longint;
    overflow:boolean;

begin
   if (clm=2)
   then
      startline:=11
   else
      startline:=7;
   aktline:=1;
   fertig:=false;
   TextColor(15);
   TextBackground(8);
   GoToXY(l_border-3,startline-3);
   write('',
    '');
   GoToXY(l_border-3,startline+8);
   write('',
    '');
   TextBackground(7);
   GoToXY(l_border-3,startline-2);
   write('                                                               ',
    '  ');
   GoToXY(l_border-3,startline-1);
   textcolor(15);
   Write('   '+e2+'');
   textcolor(0);
   GoToXY(l_border-3,startline);
   TextColor(15);
   write('');
   TextColor(0);
   write('                                                                 ');
   TextColor(15);
   write('');
   TextColor(0);
   for i:=1 to 7 do begin
      overflow:=false;
      GoToXY(l_border-3,startline+i-1);
      TextColor(15);
      write('');
      TextColor(0);
      if i>7
      then begin
         textcolor(8);
         write(' ( ');
         textcolor(0)
      end
      else
         write('   ');
      if i>linanz
      then begin
         write('..............    ..........            ../....  ');
         t1:=0;
         t2:=0;
         t3:=0
      end
      else begin
         for j:=1 to 16 do begin
            if ord(field[i,j])=0
            then
               j:=16
            else
               write(field[i,j])
         end;
         while WhereX<l_border+21 do
            write(' ');
         for j:=18 to 37 do begin
            if ord(field[i,j])=0
            then
               j:=37
            else
               write(field[i,j])
         end;
         while WhereX<l_border+43 do
            write(' ');
         if field[i,42]=chr(1)
         then begin
            write('(');
            for j:=43 to 49 do begin
               write(field[i,j])
            end;
            write(')')
         end
         else begin
            if field[i,43]=' '
            then
               write('       ')
            else
               for j:=43 to 49 do begin
                  write(field[i,j])
               end;
            write('  ')
         end;
         t1:=scoretime(field[i]);
         overflow:=(t1>32767);
         t3:=(t1-(t1 div 20)*20)*5;
         t1:=t1 div 20;
         t2:=t1-(t1 div 60)*60;
         t1:=t1 div 60
      end;
      write('  ');
      write(t1:2,':');
      if t2<10
      then
         write('0');
      write(t2,'.');
      if t3<10
      then
         write('0');
      write(t3);
      if overflow
      then begin
         textcolor(4);
         write('!');
      end
      else
         write(' ');
      write('  ');
      TextColor(15);
      write('');
      TextColor(0);
   end;
   GoToXY(l_border-3,startline+7);
   TextColor(15);
   write('');
   TextColor(0);
   write('                         ',
    '                                        ');
   TextColor(15);
   write('');
   TextColor(7);
   TextBackground(0);
   writeln;
   writeln;
   if (clm=3)
   then begin
      if (printon)
      then begin
         writeln;
         writeln;
         write_mess(iprint,2,7,0);
      end;
      writeln;
      writeln;
      write_mess(i3,5,7,0);
      check:=upcase(readkey);
      if (printon)
      then begin
         if check='P'
         then
            print_score;
      end;
   end
end;


procedure show_full;
const l_border1=-1;
      l2_border1=8;
      startline1=3;
      tcol=0;
      bcol=7;
var t1,t2,t3:longint;
    overflow:boolean;
    l_border,l2_border,startline,preval,spaceval,firstspace:integer;

begin
   l_border:=l_border1-1+startx;
   l2_border:=l2_border1-1+startx;
   firstspace:=0;
   textbackground(bcol);
   case starty of
      15: begin
         startline:=startline1-1;
         preval:=2;
         spaceval:=0;
         textcolor(tcol);
      end;
      23: begin
         startline:=startline1;
         preval:=3;
         spaceval:=0;
         textcolor(tcol);
         GoToXY(l_border+3,startline-1);
         write('--------------------------------------');
      end;
      30: begin
         startline:=startline1+3;
         preval:=3;
         spaceval:=0;
         textcolor(15);
         gotoxy(l_border+3,startline-4);
         write('                                      ');
         gotoxy(l_border+3,startline-3);
         write(e2n1);
         gotoxy(l_border+3,startline-2);
         write(e2n2);
         textcolor(tcol);
         GoToXY(l_border+3,startline-1);
         write('--------------------------------------');
      end;
      48: begin
         startline:=startline1+6;
         preval:=5;
         spaceval:=1;
         firstspace:=1;
         textcolor(15);
         gotoxy(l_border+3,startline-6);
         write('                                      ');
         gotoxy(l_border+3,startline-5);
         write('                                      ');
         gotoxy(l_border+3,startline-4);
         write(e2n1);
         gotoxy(l_border+3,startline-3);
         write('                                      ');
         gotoxy(l_border+3,startline-2);
         write(e2n2);
         textcolor(tcol);
         GoToXY(l_border+3,startline-1);
         write('--------------------------------------');
      end
   end;
   for i:=1 to 7 do begin
      overflow:=false;
      if firstspace=1
      then begin
         GoToXY(l_border+3,startline+i*preval-preval);
         write('                                      ');
      end;
      if spaceval>0
      then begin
         GoToXY(l_border+3,startline+i*preval-preval+firstspace+1);
         write('                                      ');
      end;
      GoToXY(l_border+3,startline+i*preval-preval+firstspace);
      if i>linanz
      then begin
         write('..............    ..........');
         while (wherex<startx+39)
         do
            write(' ');
         GoToXY(l_border+3,startline+i*preval-preval+firstspace+1+spaceval);
         while (wherex<l2_border+2)
         do
            write(' ');
         write('../....  ');
         t1:=0;
         t2:=0;
         t3:=0
      end
      else begin
         for j:=1 to 16 do begin
            if ord(field[i,j])=0
            then
               j:=16
            else
               write(field[i,j])
         end;
         while WhereX<l_border+21 do
            write(' ');
         for j:=18 to 37 do begin
            if ord(field[i,j])=0
            then
               j:=37
            else
               write(field[i,j])
         end;
         while (wherex<startx+39)
         do
            write(' ');
         GoToXY(l_border+3,startline+i*preval-preval+firstspace+1+spaceval);
         while (wherex<l2_border+2)
         do
            write(' ');
         if field[i,42]=chr(1)
         then begin
            write('(');
            for j:=43 to 49 do begin
               write(field[i,j])
            end;
            write(')')
         end
         else begin
            if field[i,43]=' '
            then
               write('       ')
            else
               for j:=43 to 49 do begin
                  write(field[i,j])
               end;
            write('  ')
         end;
         t1:=scoretime(field[i]);
         overflow:=(t1>32767);
         t3:=(t1-(t1 div 20)*20)*5;
         t1:=t1 div 20;
         t2:=t1-(t1 div 60)*60;
         t1:=t1 div 60
      end;
      write('  ');
      write(t1:2,':');
      if t2<10
      then
         write('0');
      write(t2,'.');
      if t3<10
      then
         write('0');
      write(t3);
      if overflow
      then begin
         textcolor(4);
         write('!');
      end
      else
         write(' ');
      textcolor(0);
      while (wherex<startx+39)
      do
         write(' ');
      if (starty=23) or (starty=30) or (starty=48)
      then begin
         GoToXY(l_border+3,startline+i*preval-1);
         write('--------------------------------------');
      end
   end;
   case starty of
      30: begin
         gotoxy(l_border+3,wherey+1);
         write('                                      ');
      end;
      48: begin
         gotoxy(l_border+3,wherey+1);
         write('                                      ');
         gotoxy(l_border+3,wherey+1);
         write('                                      ');
      end;
   end;
   textcolor(7);
   textbackground(0);
end;


procedure Voreinlesen(auto:boolean);  (** Liest Scoresdatei ein **)
const l_border1=-1;
var i,j,fp,l_border:integer;
    ok,again,firstauto:boolean;
    s:PathStr;
    lom:array[1..3] of boolean;
    loadstat:array[1..5] of boolean;
    lf_field:fieldtype;
    loadmode:byte;
    neuname:string[8];
Label 1,2;

begin
   l_border:=l_border1-1+startx;
1:   for i:=1 to 7 do
      lf_field[i]:=emptyline;
      loadmode:=3;
      lom[1]:=false;    (* = nicht definiert *)
      lom[2]:=false;    (* = Tabellen mischen *)
      lom[3]:=false;    (* = Alte Tabelle lschen *)
      loadstat[1]:=false;
      loadstat[2]:=false;
      loadstat[3]:=false;
      loadstat[4]:=false;
      loadstat[5]:=false;
      ok:=false;
      again:=false;
      neuname:=optname;
      if length(neuname)>0
      then begin
         {$I-}
         s := FSearch(neuname+'.hig','.');
         if S = '' then begin   (* Nicht vorhandene Datei *)
            if (clm=1)
            then begin
               writeln;
               halt(1)
            end;
            writeln;
            write_mess(w2,12,7,0);
            writeln;
            halt(1);
         end
         else begin  (* Vorhanden *)
            loadstat[1]:=true;
            if get_size(neuname+'.hig')=364
            then
               again:=false
            else
               again:=true;
            if not again then begin   (* Gltige Gre *)
               loadstat[2]:=true;
               assign(datei,neuname+'.hig');
               reset(datei);
               for i:=1 to 7 do begin
                  for j:=1 to 52 do begin
                     read(datei,ch);
                     lf_field[i,j]:=ch
                  end
               end;
               GetFTime(datei,ftime);
               UnpackTime(ftime,dt);
               close(datei);
               lf_linanz:=getlineanz(lf_field);
               if lf_linanz>0
               then
                  loadstat[4]:=true;
               if linanz>0
               then
                  loadstat[5]:=true;
               if linanz+lf_linanz>14
               then
                  loadstat[3]:=true
            end
         end;
         if loadstat[1]
         then begin
            if loadstat[2]
            then begin
               if not loadstat[4]
               then begin
                  if (clm=2)
                  then begin
                     writeln;
                     write_mess(ls40,12,7,0);
                     writeln;
                     halt(1)
                  end;
               end
               else begin
                  if loadstat[5]
                  then begin
                     lom[2]:=true;
                     lom[3]:=true;
                     if (clm<>1)
                     then begin
                        writeln;
                        write_mess(ls41,2,0,1);
                        write_mess(ls51,12,0,1);
                     end;
                     if loadstat[3]
                     then
                        write_mess(ls31,12,0,1)
                  end
               end
            end
            else begin
               if (clm=1)
               then begin
                  textcolor(7);
                  gotoxy(l_border+3,4);
                  write(w_nc);
                  textcolor(12);
                  gotoxy(l_border+3,7);
                  write(w3n1);
                  gotoxy(l_border+3,wherey+1);
                  write(w3n2);
                  textcolor(2);
                  gotoxy(l_border+3,wherey+2);
                  write(w3n3);
                  gotoxy(l_border+3,wherey+1);
                  write(w3n4);
                  halt(1)
               end
               else begin
                  if (clm=3)
                  then begin
                     clrscr;
                     TextColor(7);
                     writeln;
                     writeln('     '+m1+optname+'.hig');
                     writeln;
                     writeln;
                     write_mess(w3,12,7,0);
                     writeln;
                     writeln;
                     write_mess(w3n3a,2,7,0);
                     writeln;
                     writeln;
                     writeln;
                     write_mess(i3,5,7,0);
                     readkey;
                  end
                  else begin
                     writeln;
                     write_mess(w3,12,7,0);
                     writeln;
                  end
               end;
               halt(1);
            end;
            if not auto
            then begin
               if lom[2]
               then begin
                  writeln;
                  write_mess(lm2,5,0,0);
                  write_mess(ld2,7,0,0);
                  write_mess(lk2,2,0,1)
               end;
               if lom[3]
               then begin
                  write_mess(lm3,5,0,0);
                  write_mess(ld3,7,0,0);
                  write_mess(lk3,2,0,1)
               end;
               if (lom[2]) or (lom[3])
               then begin
                  write_mess(lm4,5,0,0);
                  write_mess(ld4,7,0,0);
                  write_mess(lk4,2,0,1);
                  writeln;
                  write_mess('',0,0,0);
2:                  check:=readkey;
                  case check of
                     '2': loadmode:=2;
                     '3': loadmode:=3;
                     chr(27):
                        GoTo 1;
                     else goto 2
                  end
               end
            end
            else
               loadmode:=3;
            field:=lf_field;
            oldname:=neuname;
            writeln;
            linanz:=getlineanz(field);
            ok:=true;
            eingelesen:=true
         end;
         {$I+}
      end;
   if (clm<>1)
   then
      TextColor(7)
end;


procedure sb_init;
var ta:array[1..2] of char;
    ls1,ls2:string[2];

begin
   emptyline:='........................................'+
     +chr(0)+chr(0)+'../....'+chr(0)+chr(255)+chr(255);
   greeton:=true;
   menuon:=true;
   begverz:=3;
   beginsound:=false;
   linanz:=0;
   oldname:='';
   eingelesen:=false;
   goodsave:=true;
   merged:=false;
   clm:=0;
   printon:=true;
   printout:=false;
(*
   {$I-};
      assign(lst, 'PRN');
      rewrite(lst);
      writeln(lst);
      if (ioresult=160)
      then 
         printon:=false;
      close(lst);
   {$I-};
*)
end;



begin
   textbackground(0);
   startx:=wherex;
   starty:=wherey;
   getdir(0,stpath);
   startpath:=stpath;
   sb_init;
   if paramcount>0
   then begin
      commstr:=paramstr(1);
      if commstr[1]='/'
      then begin
         parb:=0;
         paro:=0;
         memnum:=0;
         for i:=5 to length(commstr)
         do
            memnum:=memnum*10+(ord(commstr[i])-48);
         parb:=memnum div 65536;
         paro:=memnum-parb*65536;
         i:=1;
         repeat
            if paro=65535
            then begin
               paro:=0;
               parb:=parb+1;
            end
            else
               paro:=paro+1;
            commstr[i]:=chr(mem[parb:paro]);
            inc(i);
         until (chr(mem[parb:paro])='.');
         commstr[i+0]:='h';
         commstr[i+1]:='i';
         commstr[i+2]:='g';
         commstr[0]:=chr(i+2);
      end;
      i:=1;
      optname:='';
      while (i<=length(commstr)) and (commstr[i]<>'.')
      do begin
         optname[0]:=chr(ord(optname[0])+1);
         optname[i]:=upcase(commstr[i]);
         inc(i);
      end;
      if i<=length(commstr)
      then begin
         if ((starty=11) OR (starty=12))
         then
            clm:=3
         else
            clm:=1
      end
      else begin
         clm:=2;
         if (paramcount>1)
         then begin
            optstring:=paramstr(2);
            if (optstring='-p')
            then begin
               printout:=true;
            end
            else begin
               writeln;
               write_mess(parerr1,12,7,0);
               writeln;
               halt(1);
            end
         end
      end;
      greeton:=false;
   end
   else begin
      writeln;
      write_mess(parerr1,12,7,0);
      writeln;
      halt(1);
   end;
   voreinlesen(true);
   case clm of
      1: begin
         show_full;
         halt(0);
      end;
      2: begin
         clrscr;
         TextColor(7);
         writeln;
         writeln('     ScoreViewer  1.2  by  The NAILWOOD Company');
         writeln;
         writeln('     '+m1+optname);
         writeln;
         show_normal;
         if printout
         then
            print_score;
      end;
      3: begin
         clrscr;
         TextColor(7);
         writeln;
         writeln('     '+m1+optname);
         writeln;
         show_normal;
      end;
   end;
end.
