Program TrackBlaster_Pro;      (* (C) 1997  by  The NAILWOOD Company *)

   (* Purpose: Editing Terrain of 'Stunts_1.0' - compatible tracks *)
   (* First Implementation: 28. 3.1993 *)
   (* Latest Modification : 27. 3.1997 *)



uses crt,graph,dos,pice,saygete,tb_graph,tb_defs,
     BGIDriv,   { all the BGI drivers }
     BGIFont;   { all the BGI fonts }


procedure writeaktpath;
var s:string;
begin
   getdir(0,s);
   writeln('*',s,'*');
   readkey;
end;


function GetFName(mc:integer;auto:boolean):string;  (** Liest einen
         mc-stelligen String ein **)
var c:char;
    i,anfx,anfy:integer;
    lastpos,firstkey:boolean;
    a,apre:string[40];
Label 1,2,3;

begin
   if auto
   then
      a:=optname
   else
      a:=oldname[1];
3:   anfx:=WhereX;
   anfy:=WhereY;
   gotoxy(4,WhereY+1);
   write_path;
   gotoxy(anfx,WhereY-2);
   textcolor(7);
   clearline;
   i:=WhereX;
   write(a);
   GoToXY(i,WhereY);
   i:=1;
   lastpos:=false;
   firstkey:=true;
   if not auto then begin
    repeat  (* Eingabe von Zeichen *)
1:      c:=upcase(readkey);
      if ord(c)=0
      then begin
         c:=upcase(readkey);
         if (ord(c)=80) OR (ord(c)=72)
         then begin
            GoToXY(anfx,anfy);
            clearline;
            GoToXY(1,WhereY+1);
            apre:=a;
            a:=GetName('',ord(c)=80);
            GoToXY(anfx,anfy);
            textcolor(7);
            clearline;
            if length(a)>0
            then begin
               write(a);
               GoTo 2
            end
            else begin
               a:=apre;
               GoTo 3
            end
         end
         else
            GoTo 1
      end;
      if (ord(c)<>13) and (ord(c)<>27)
      then begin  (* Kein Return, kein Escape *)
         if firstkey
         then begin  (* Defaultstring lschen *)
            firstkey:=false;
            a:='';
            for i:=1 to mc do
               write(' ');
            GoToXY(WhereX-mc,WhereY);
            i:=1
         end;  (* Defaultstring lschen *)
         if (ord(c)=8) and (i>1)
         then begin  (* Lschen des letzteingegebenen Zeichens *)
            if lastpos=true
            then begin  (* Zeichen auf Cursorposition lschen *)
               write(' ');
               GoToXY(WhereX-1,WhereY);
               lastpos:=false;
               delete(a,mc,1)
            end  (* Zeichen auf Cursorposition lschen *)
            else begin  (* Zeichen links neben Cursor lschen *)
               dec(i);
               GoToXY(WhereX-1,WhereY);
               write(' ');
               GoToXY(WhereX-1,WhereY);
               delete(a,i,1)
            end  (* Zeichen links neben Cursor lschen *)
         end  (* Lschen des letzteingegebenen Zeichens *)
         else begin  (* Verarbeitung des Zeichens *)
            if ord(c)<>8
            then begin  (* Eingabe des Zeichens *)
               write(c);
               inc(i);
               if i=mc+1
               then begin  (* Letztes Zeichen austauschen *)
                  i:=mc;
                  lastpos:=true;
                  delete(a,i,1);
                  insert(c,a,i);
                  GoToXY(WhereX-1,WhereY)
               end  (* Letztes Zeichen austauschen *)
               else begin  (* String um Zeichen verlngern *)
                  insert(c,a,i)
               end  (* String um Zeichen verlngern *)
            end  (* Eingabe des Zeichens *)
         end  (* Verarbeitung des Zeichens *)
      end  (* Kein Return, kein Escape *)
    until (ord(c)=13) or (ord(c)=27); (*Eingabe von Zeichen*)
   end;
   if a<>'' then begin
      if ord(c)=13
      then begin
         if firstkey
         then
            a:=chr(13)
      end
      else begin
         if ord(c)=27
         then
            a:=''
      end
   end;
2:   GetFName:=a
end;


function LoeschProtect:char;  (** Fragt J/N-Entscheidung ab **)
var nachcheck:char;

begin
     GoToXY(WhereX-1,WhereY);
     nachcheck:=' ';
     check:=upcase(readkey);
     if (ord(check)=13)
     then (*Sofortabbruch*)
          check:=no_char
     else (*Eingabewiederholung*)
          begin
               if (check<>yes_char)
               then (*Ja-Nein-Anzeige*)
                    check:=no_char;
                    write(check);
                    repeat (*Lschsicherung, bis [Enter] gedrckt wird*)
                           GoToXY(WhereX-1,WhereY);
                           nachcheck:=upcase(readkey);
                           if ord(nachcheck)<>13
                           then (*Neues Zeichen wird verarbeitet*)
                                begin
                                     if nachcheck<>yes_char
                                     then (*Ja-Nein-Anzeige*)
                                          nachcheck:=no_char;
                                     write(nachcheck);
                                     check:=nachcheck
                                end; (*Neues Zeichen wird verarbeitet*)
                    until ord(nachcheck)=13 (*Lschsicherung, bis [Enter]
                          gedrckt wird*)
          end; (*Eingabewiederholung*)
     LoeschProtect:=check
end;


procedure draw_comp;
var xp,yp:integer;

begin
   if (trackcomp)
   then begin
      for i:=1 to 30 do
         for j:=30 downto 1 do begin
            if ((trackfield[1,900+i-j*30]<>trackfield[2,900+i-j*30]) OR
                (field[1,i,j]<>field[2,i,j]))
            then begin
               xp:=l_border+(i-1)*(xwidth+1)+xwidth div 2-2;
               yp:=u_border+(j-1)*(ywidth+1);
               putpixel(xp-3,yp,14);
               putpixel(xp-2,yp,13);
               putpixel(xp-1,yp,14);
               putpixel(xp  ,yp,13);
               putpixel(xp+1,yp,14);
               putpixel(xp+2,yp,13);
               putpixel(xp+3,yp,14);
               xp:=l_border+(i-1)*(xwidth+1);
               yp:=u_border+(j-1)*(ywidth+1)+ywidth div 2-2;
               putpixel(xp,yp-3,14);
               putpixel(xp,yp-2,13);
               putpixel(xp,yp-1,14);
               putpixel(xp,yp  ,13);
               putpixel(xp,yp+1,14);
               putpixel(xp,yp+2,13);
               putpixel(xp,yp+3,14);
            end;
         end
   end
end;


procedure clear_comp;

begin
   setcolor(0);
   setlinestyle(SOLIDLN,0,1);
   for j:=1 to 30 do
      line(l_border,u_border+(j-1)*(ywidth+1),
           l_border+(30)*(xwidth+1),u_border+(j-1)*(ywidth+1));
   for i:=1 to 30 do
      line(l_border+(i-1)*(xwidth+1),u_border,
           l_border+(i-1)*(xwidth+1),u_border+(30)*(ywidth+1));
end;


procedure debug(inint:integer);
var s:string;

begin
   setcolor(15);
   str(inint,s);
   setfillstyle(SOLIDFILL,0);
   bar(0,0,60,30);
   settextstyle(1,HORIZDIR,1);
   settextjustify(LEFTTEXT,TOPTEXT);
   outtextxy(10,10,s);
   sound(1000);
   readkey;
   nosound;
end;


function fchanged(index:integer):boolean;
var changed:boolean;

begin
   changed:=false;
   for i:=1 to 30 do begin
      for j:=1 to 30 do begin
         if field[index,i,j]<>field_orig[index,i,j]
         then begin
            changed:=true;
            i:=30;
            j:=30
         end
      end
   end;
   fchanged:=changed
end;


function tchanged(index:integer):boolean;
var changed:boolean;

begin
   changed:=false;
   for i:=1 to 900 do begin
      if trackfield[index,i]<>o_tf[index,i]
      then begin
         changed:=true;
         i:=900;
      end
   end;
   tchanged:=changed
end;


function hchanged(index:integer):boolean;

begin
   hchanged:=(horizchar[index]<>o_horizchar[index]) OR
             (postchar[index]<>o_postchar[index])
end;


procedure set_rand(cii,cjj,randmax:integer;overwrite:boolean);
var wert:byte;
    waterarray:integer;
    grassarray:array[1..10] of integer;
    rmx,rval,newel:integer;
    nowater,noships:boolean;

begin
   newel:=0;
   if ((objhill) OR ((field[1,cii,cjj]<7) OR (field[1,cii,cjj]>18)))
       AND ((verz_props[0]>random(100)) OR (markfunct=0))
   then begin
      nowater:=false;
      noships:=false;
      rmx:=randmax;
      if ((field[1,cii,cjj]>0) AND (field[1,cii,cjj]<6))
      then begin
         if not housewater
         then begin
            rmx:=verz_props[10];
            nowater:=true;
         end;
      end;
      if ((field[1,cii,cjj]=0) OR (field[1,cii,cjj]>5))
      then begin
         if not shipgrass
         then begin
            rmx:=rmx-verz_props[10];
            noships:=true;
         end;
      end;
      if (rmx>0)
      then begin
         rval:=random(rmx)+1;
         i:=0;
         while (rval>0)
         do begin
            if (not (noships AND (i=9))) AND (not (nowater AND (i<>9)))
            then
               rval:=rval-verz_props[i+1];
            inc(i);
         end;
         if (i>0)
         then begin
            if i>5
            then
               rval:=random(4)
            else
               rval:=0;
            newel:=sbase[i]+rval
         end;
      end;
   end;
   wert:=ord(trackfield[1,900+cii-cjj*30]);
   if ((wert=0) OR ((((wert>150) AND (wert<179)) OR (wert=2)) AND overwrite))
   then begin
      MoveTo(l_border+((cii-1)*(xwidth+1)),u_border+((cjj-1)*(ywidth+1)));
      draw_field_elem(field[1,cii,cjj]);
      trackfield[1,900+cii-cjj*30]:=chr(newel);
      draw_track_elem(0,cii,cjj);
      draw_field_elem(257);
   end;
end;


procedure random_scenery(overwrite:boolean);
var randmax:integer;

begin
   if (markfunct<1)
   then begin
      randmax:=0;
      for i:=1 to 11
      do
         randmax:=randmax+verz_props[i];
      if (markfunct=-1)
      then begin
         for cii:=ci to ci+(markxmax-markxmin)
         do begin
            for cjj:=cj to cj+(markymax-markymin)
            do
               set_rand(cii,cjj,randmax,overwrite);
         end;
         MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
         draw_field_elem(258);
      end
      else begin
         set_rand(ci,cj,randmax,overwrite);
         MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
         draw_field_elem(260);
      end
   end
end;


procedure set_track_elem(oldmulti:boolean;aci,acj:integer);
var altx,alty:integer;

begin
   if (multiel[ord(trackfield[1,900+aci-acj*30])]>0)
   then
      oldmulti:=true;
   gofield(aci,acj);
   draw_field_elem(field[1,aci,acj]);
   draw_track_elem(0,aci,acj);
(*   case t_elem_nr of
        10..13,20..23,30..33,52..55,60..65,85..94,105..108,
          117..124 : oldmulti:=true
   end;*)
   if oldmulti
   then begin
      altx:=getx;
      alty:=gety;
      if aci<30
      then begin
         inc(aci);
         MoveTo(l_border+((aci-1)*(xwidth+1)),u_border+((acj-1)*(ywidth+1)));
         draw_field_elem(field[1,aci,acj]);
         draw_track_elem(0,aci,acj);
         dec(aci)
      end;
      if acj<30
         then begin
         inc(acj);
         MoveTo(l_border+((aci-1)*(xwidth+1)),u_border+((acj-1)*(ywidth+1)));
         draw_field_elem(field[1,aci,acj]);
         draw_track_elem(0,aci,acj);
         dec(acj)
      end;
      if (aci<30) and (acj<30)
      then begin
         inc(aci);
         inc(acj);
         MoveTo(l_border+((aci-1)*(xwidth+1)),u_border+((acj-1)*(ywidth+1)));
         draw_field_elem(field[1,aci,acj]);
         draw_track_elem(0,aci,acj);
         dec(aci);
         dec(acj)
      end;
      moveto(altx,alty)
   end
end;


procedure transform_field;

begin
   for i:=1 to 30
   do
      for j:=1 to 30
      do begin
         sclipfield[i,j]:=0;
         lclipfield[i,j]:=0
      end;
   if not ((xmirr) or (ymirr))
   then
      for i:=markxmin to markxmax
      do
         for j:=markymin to markymax
         do begin
            sclipfield[i,j]:=sfromclipfield[i,j];
            lclipfield[i,j]:=lfromclipfield[i,j]
         end
   else begin
      if trackmark
      then begin
         if (xmirr) and (not ymirr)
         then begin
            for i:=markxmin to markxmax
            do
               for j:=markymin to markymax
               do begin
                  case sfromclipfield[i,j]
                  of
                     255: begin
                        case sfromclipfield[i-1,j]
                        of
                           65,86: begin
                              sclipfield[i,markymax+markymin-j]:=255
                           end;
                           10..13,20..23,30..33,52..55,60..63,87..94,105..108,
                             117..124 : begin
                              if j<markymax
                              then begin
                                 sclipfield[i,markymax+markymin-j-1]:=255
                              end
                           end
                           else begin
                              if sclipfield[i,markymax+markymin-j]=0
                              then
                                 sclipfield[i,markymax+markymin-j]:=255
                           end
                        end
                     end;
                     254: begin
                        case sfromclipfield[i,j-1]
                        of
                          10..13,20..23,30..33,52..55,60..64,85,87..94,
                            105..108,117..124 : begin
                              if j>markymin
                              then begin
                                 sclipfield[i,markymax+markymin-j+1]:=254
                              end
                           end
                           else begin
                              if sclipfield[i,markymax+markymin-j]=0
                              then
                                 sclipfield[i,markymax+markymin-j]:=254
                           end
                        end
                     end;
                     253: begin
                        case sfromclipfield[i-1,j-1]
                        of
                           10..13,20..23,30..33,52..55,60..65,85..94,105..108,
                            117..124 : begin
                              if j>markymin
                              then begin
                                 sclipfield[i,markymax+markymin-j+1]:=253
                              end
                           end
                           else begin
                              if sclipfield[i,markymax+markymin-j]=0
                              then
                                 sclipfield[i,markymax+markymin-j]:=253
                           end
                        end
                     end;
                     10..13,20..23,30..33,52..55,60..64,85,87..94,105..108,
                       117..124 : begin
                        if j<markymax
                        then begin
                           sclipfield[i,markymax+markymin-j-1]:=
                             strafo[sfromclipfield[i,j]].x;
                        end
                     end
                     else begin
                        if not ((sclipfield[i,markymax+markymin-j]<>0)
                          and (sfromclipfield[i,j]=0))
                        then
                           sclipfield[i,markymax+markymin-j]:=
                             strafo[sfromclipfield[i,j]].x;
                     end
                  end;
               end
         end;
         if (not xmirr) and (ymirr)
         then begin
            for i:=markxmin to markxmax
            do
               for j:=markymin to markymax
               do begin
                  case sfromclipfield[i,j]
                  of
                     255: begin
                        case sfromclipfield[i-1,j]
                        of
                          10..13,20..23,30..33,52..55,60..63,65,86..94,
                            105..108,117..124 : begin
                              if i>markxmin
                              then begin
                                 sclipfield[markxmax+markxmin-i+1,j]:=255
                              end
                           end
                           else begin
                              if sclipfield[markxmax+markxmin-i,j]=0
                              then
                                 sclipfield[markxmax+markxmin-i,j]:=255
                           end
                        end
                     end;
                     254: begin
                        case sfromclipfield[i,j-1]
                        of
                           64,85: begin
                              sclipfield[markxmax+markxmin-i,j]:=254
                           end;
                           10..13,20..23,30..33,52..55,60..63,87..94,105..108,
                             117..124 : begin
                              if i<markxmax
                              then begin
                                 sclipfield[markxmax+markxmin-i-1,j]:=254
                              end
                           end
                           else begin
                              if sclipfield[markxmax+markxmin-i,j]=0
                              then
                                 sclipfield[markxmax+markxmin-i,j]:=254
                           end
                        end
                     end;
                     253: begin
                        case sfromclipfield[i-1,j-1]
                        of
                           10..13,20..23,30..33,52..55,60..63,87..94,105..108,
                             117..124 : begin
                              if i>markxmin
                              then begin
                                 sclipfield[markxmax+markxmin-i+1,j]:=253
                              end
                           end
                           else begin
                              if sclipfield[markxmax+markxmin-i,j]=0
                              then
                                 sclipfield[markxmax+markxmin-i,j]:=253
                           end
                        end
                     end;
                     10..13,20..23,30..33,52..55,60..63,65,86..94,105..108,
                       117..124 : begin
                        if i<markxmax
                        then begin
                           sclipfield[markxmax+markxmin-i-1,j]:=
                             strafo[sfromclipfield[i,j]].y;
                        end
                     end
                     else begin
                        if not ((sclipfield[markxmax+markxmin-i,j]<>0)
                          and (sfromclipfield[i,j]=0))
                        then
                           sclipfield[markxmax+markxmin-i,j]:=
                             strafo[sfromclipfield[i,j]].y;
                     end
                  end;
               end
         end;
         if (xmirr) and (ymirr)
         then begin
            for i:=markxmin to markxmax
            do
               for j:=markymin to markymax
               do begin
                  case sfromclipfield[i,j]
                  of
                     255: begin
                        case sfromclipfield[i-1,j]
                        of
                           65,86: begin
                              if i>markxmin
                              then begin
                                 sclipfield[markxmax+markxmin-i+1,
                                   markymax+markymin-j]:=255
                              end
                           end;
                           10..13,20..23,30..33,52..55,60..63,87..94,105..108,
                             117..124 : begin
                              if (i>markxmin) and (j<markymax)
                              then begin
                                 sclipfield[markxmax+markxmin-i+1,
                                   markymax+markymin-j-1]:=255
                              end
                           end
                           else begin
                              if sclipfield[markxmax+markxmin-i,
                                markymax+markymin-j]=0
                              then
                                 sclipfield[markxmax+markxmin-i,
                                   markymax+markymin-j]:=255
                           end
                        end
                     end;
                     254: begin
                        case sfromclipfield[i,j-1]
                        of
                           64,85: begin
                              if j>markymin
                              then begin
                                 sclipfield[markxmax+markxmin-i,
                                   markymax+markymin-j+1]:=254
                              end
                           end;
                           10..13,20..23,30..33,52..55,60..63,87..94,105..108,
                            117..124 : begin
                              if (i<markxmax) and (j>markymin)
                              then begin
                                 sclipfield[markxmax+markxmin-i-1,
                                   markymax+markymin-j+1]:=254
                              end
                           end
                           else begin
                              if sclipfield[markxmax+markxmin-i,
                                markymax+markymin-j]=0
                              then
                                 sclipfield[markxmax+markxmin-i,
                                   markymax+markymin-j]:=254
                           end
                        end
                     end;
                     253: begin
                        case sfromclipfield[i-1,j-1]
                        of
                          10..13,20..23,30..33,52..55,60..63,87..94,105..108,
                            117..124 : begin
                              if (i>markxmin) and (j>markymin)
                              then begin
                                 sclipfield[markxmax+markxmin-i+1,
                                   markymax+markymin-j+1]:=253
                              end
                           end
                           else begin
                              if sclipfield[markxmax+markxmin-i,
                                markymax+markymin-j]=0
                              then
                                 sclipfield[markxmax+markxmin-i,
                                   markymax+markymin-j]:=253
                           end
                        end
                     end;
                     64,85: begin
                        if j<markymax
                        then begin
                           sclipfield[markxmax+markxmin-i,
                             markymax+markymin-j-1]:=
                             strafo[sfromclipfield[i,j]].xy;
                        end
                     end;
                     65,86: begin
                        if i<markxmax
                        then begin
                           sclipfield[markxmax+markxmin-i-1,
                             markymax+markymin-j]:=
                             strafo[sfromclipfield[i,j]].xy;
                        end
                     end;
                     10..13,20..23,30..33,52..55,60..63,87..94,105..108,
                       117..124 : begin
                        if (i<markxmax) and (j<markymax)
                        then begin
                           sclipfield[markxmax+markxmin-i-1,
                             markymax+markymin-j-1]:=
                             strafo[sfromclipfield[i,j]].xy;
                        end
                     end
                     else begin
                        if not ((sclipfield[markxmax+markxmin-i,
                          markymax+markymin-j]<>0)
                          and (sfromclipfield[i,j]=0))
                        then
                           sclipfield[markxmax+markxmin-i,markymax+markymin
                             -j]:=strafo[sfromclipfield[i,j]].xy;
                     end
                  end;
               end
         end;
      end;
      if terrmark
      then begin
         if (xmirr) and (not ymirr)
         then
            for i:=markxmin to markxmax
            do
               for j:=markymin to markymax
               do
                  lclipfield[i,j]:=ltrafo[lfromclipfield[i,
                    markymax+markymin-j]].x;
         if (not xmirr) and (ymirr)
         then
            for i:=markxmin to markxmax
            do
               for j:=markymin to markymax
               do
                  lclipfield[i,j]:=ltrafo[lfromclipfield[markxmax+markxmin-i,
                    j]].y;
         if (xmirr) and (ymirr)
         then
            for i:=markxmin to markxmax
            do
               for j:=markymin to markymax
               do
                  lclipfield[i,j]:=ltrafo[lfromclipfield[markxmax+markxmin-i,
                    markymax+markymin-j]].xy
      end
   end
end;


procedure redraw_field;

begin
    for j:=1 to 30 do begin
       for i:=1 to 30 do begin
          xpos:=l_border+((i-1)*(xwidth+1));
          ypos:=u_border+((j-1)*(ywidth+1));
          MoveTo(xpos,ypos);
          draw_field_elem(field[1,i,j]);
          draw_track_elem(0,i,j);
       end
    end;
    setfillstyle(SOLIDFILL,0);
    bar(0,0,30*(xwidth+1)+1,u_border-2);
    setcolor(5);
    SetTextStyle(2, HorizDir, 4);
    SetTextJustify(RightText, TopText);
    outtextxy(name1_l,name1_u,name1);
    outtextxy(name2_l,name2_u,name2);
    setcolor(2);
    SetTextJustify(LeftText, TopText);
    outtextxy(name1_l+10,name1_u,oldpath[1]+'\'+oldname[1]);
    outtextxy(name2_l+10,name2_u,oldpath[2]+'\'+oldname[2]);
    MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
end;


procedure draw_changed;
var xbase:integer;

begin
   SetTextStyle(2, HorizDir, 4);
   SetTextJustify(LeftText, TopText);
   xbase:=name1_l+20+textwidth(oldpath[1]+'\'+oldname[1]);
   if (fchanged(1) OR tchanged(1) OR hchanged(1))
   then begin
      setcolor(7);
      outtextxy(xbase,name1_u,'#');
   end
   else begin
      setfillstyle(SOLIDFILL,0);
      bar(xbase,name1_u,xbase+10,name1_u+10);
   end;
   xbase:=name2_l+20+textwidth(oldpath[2]+'\'+oldname[2]);
   if (fchanged(2) OR tchanged(2) OR hchanged(2))
   then begin
      setcolor(7);
      outtextxy(xbase,name2_u,'#');
   end
   else begin
      setfillstyle(SOLIDFILL,0);
      bar(xbase,name2_u,xbase+10,name2_u+10);
   end;
end;


function scroll_field_pos(sx,sy:integer):boolean;
var nx,ny:integer;

begin
   nx:=ci+sx;
   ny:=cj+sy;
   if ((nx>0) AND (nx<31) AND NOT
       ((nx>30-markxmax+markxmin) AND (markfunct<>0)) AND
       (ny>0) AND (ny<31) AND NOT
       ((ny>30-markymax+markymin) AND (markfunct<>0)))
   then begin
      if markfunct<>0
      then begin
         MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
         draw_field_elem(259);
         ci:=nx;
         cj:=ny;
         MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
         draw_field_elem(258);
         if (sneumarkpos) or (lneumarkpos)
         then begin
            sneumarkpos:=false;
            lneumarkpos:=false;
            draw_short_key_menu
         end
      end
      else begin
         if (prefetched)
         then begin
            prefetched:=false;
            draw_short_key_menu;
         end;
         MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
         draw_field_elem(257);
         ci:=nx;
         cj:=ny;
         MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
         if autoset
         then begin
            contr:=chr(13);
            scroll_field_pos:=true;
            exit;
         end;
         draw_field_elem(256);
         if marked
         then begin
            draw_field_elem(258);
         end;
      end;
   end;
   scroll_field_pos:=false;
end;


procedure scroll_tsf_pos(sx,sy:integer);
var nx,ny:integer;

begin
   MoveTo(ssf_l_border+tsf_pos[tsf_nr].i*(xwidth+1),
     tu_border+(tsf_pos[tsf_nr].j-1)*(ywidth+1));
   draw_field_elem(257);
   nx:=tsf_pos[tsf_nr].i+sx;
   ny:=tsf_pos[tsf_nr].j+sy;
   if ((nx>0) AND (nx<7) AND (ny>0) AND (ny<7))
   then begin
      tsf_pos[tsf_nr].i:=nx;
      tsf_pos[tsf_nr].j:=ny;
   end;
   MoveTo(ssf_l_border+tsf_pos[tsf_nr].i*(xwidth+1),
     tu_border+(tsf_pos[tsf_nr].j-1)*(ywidth+1));
   draw_field_elem(256);
   MoveTo(l_border+((ci-1)*(xwidth+1)),
     u_border+((cj-1)*(ywidth+1)));
   draw_sel_el
end;


procedure edit_field;
var altx,alty,me:integer;
    pf_t_found,megach:boolean;
    newname:string[12];
Label 1,2;

begin
   InitGraph(grdrvr,grmode,'');
   ErrCode := GraphResult;
   IF ErrCode = grOk then begin
2 :    setbkcolor(0);
    while keypressed do contr:=readkey;
    contr:='';
    t:=timeconvert;
    redraw_field;
    t:=timeconvert-t;
    clear_comp;
    prefetched:=false;
    autoset:=false;
    sneumarkpos:=false;
    lneumarkpos:=false;
    t_elem_nr:=tsf[tsf_nr,tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j];
   draw_select_field;
   draw_short_key_menu;
   write_status;
   draw_edit_menu;
   draw_sel_el;
   if ci>30-markxmax+markxmin
   then
      ci:=30-markxmax+markxmin;
   if cj>30-markymax+markymin
   then
      cj:=30-markymax+markymin;
   MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
   if markfunct=0
   then
      draw_field_elem(256)
   else
      draw_field_elem(258);
   repeat
      draw_comp;
      draw_changed;
      megach:=false;
      contr:=readkey;
      if (contr='+')
      then begin
         megach:=true;
         contr:=chr(93);
      end;
      if (contr='-')
      then begin
         megach:=true;
         contr:=chr(92);
      end;
1 :
      if (ord(contr)=0) OR megach
      then begin
         if (not megach)
         then
            contr:=readkey;
         case ord(contr) of
            72:   (* UP *)
               if scroll_field_pos(0,-1)
               then
                  goto 1;
            75:   (* LEFT *)
               if scroll_field_pos(-1,0)
               then
                  goto 1;
            80:   (* DOWN *)
               if scroll_field_pos(0,1)
               then
                  goto 1;
            77:   (* RIGHT *)
               if scroll_field_pos(1,0)
               then
                  goto 1;
            73:   (* RIGHT-UP *)
               if scroll_field_pos(1,-1)
               then
                  goto 1;
            81: begin  (* RIGHT-DOWN *)
               contr:='?';
               if scroll_field_pos(1,1)
               then
                  goto 1;
            end;
            79:   (* LEFT-DOWN *)
               if scroll_field_pos(-1,1)
               then
                  goto 1;
            71:   (* LEFT-UP *)
               if scroll_field_pos(-1,-1)
               then
                  goto 1;
            82: begin   (* Insert *)
              case markfunct
              of 0: begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
               imp_nr:=false;
               case ord(trackfield[1,900+ci-cj*30]) of
                  10..13,20..23,30..33,52..55,60..65,85..94,105..108,
                    117..124 : imp_nr:=true
               end;
               trackfield[1,900+ci-cj*30]:=o_tf[1,900+ci-cj*30];
               set_track_elem(imp_nr,ci,cj);
               draw_field_elem(256);
               if marked
               then begin
                  draw_field_elem(258);
               end;
               goodsave:=false
              end;
                -1: begin
                 if markfunct=-1
                 then begin
                     cii:=ci;
                     cjj:=cj;
                     for j:=markymin to markymax
                     do begin
                        for i:=markxmin to markxmax
                        do begin
                           imp_nr:=false;
                           case ord(trackfield[1,900+cii-cjj*30]) of
                              10..13,20..23,30..33,52..55,60..65,85..94,
                                105..108,117..124 : imp_nr:=true
                           end;
                           trackfield[1,900+cii-cjj*30]:=o_tf[1,900+cii-cjj*30];
                           MoveTo(l_border+((cii-1)*(xwidth+1)),
                             u_border+((cjj-1)*(ywidth+1)));
                           set_track_elem(imp_nr,cii,cjj);
                           draw_field_elem(257);
                           inc(cii);
                        end;
                        cii:=ci;
                        inc(cjj)
                     end;
                     draw_field_elem(258);
                     goodsave:=false
                 end;
                end;
                1,2: begin
                     if (sneumarkpos)
                     then begin
                        cii:=ci;
                        cjj:=cj;
                        for j:=markymin to markymax
                        do begin
                           for i:=markxmin to markxmax
                           do begin
                              imp_nr:=false;
                              case ord(trackfield[1,900+cii-cjj*30]) of
                                 10..13,20..23,30..33,52..55,60..65,85..94,
                                   105..108,117..124 : imp_nr:=true
                              end;
                              trackfield[1,900+cii-cjj*30]:=
                                pre_tf[900+cii-cjj*30];
                              MoveTo(l_border+((cii-1)*(xwidth+1)),
                                u_border+((cjj-1)*(ywidth+1)));
                              set_track_elem(imp_nr,cii,cjj);
                              draw_field_elem(257);
                              inc(cii);
                           end;
                           cii:=ci;
                           inc(cjj)
                        end;
                        draw_field_elem(258);
                        sneumarkpos:=false;
                        draw_short_key_menu;
                        goodsave:=false;
                     end
                end
              end
            end;
            83: begin   (* Delete *)
              if markfunct=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
               imp_nr:=false;
               case ord(trackfield[1,900+ci-cj*30]) of
                  10..13,20..23,30..33,52..55,60..65,85..94,105..108,
                    117..124 : imp_nr:=true
               end;
               trackfield[1,900+ci-cj*30]:=chr(0);
               set_track_elem(imp_nr,ci,cj);
               draw_field_elem(256);
               if marked
               then begin
                  draw_field_elem(258);
               end;
               goodsave:=false
              end
              else begin
                 if markfunct=-1
                 then begin
                     cii:=ci;
                     cjj:=cj;
                     for j:=markymin to markymax
                     do begin
                        for i:=markxmin to markxmax
                        do begin
                           imp_nr:=false;
                           case ord(trackfield[1,900+cii-cjj*30]) of
                              10..13,20..23,30..33,52..55,60..65,85..94,
                                105..108,117..124 : imp_nr:=true
                           end;
                           trackfield[1,900+cii-cjj*30]:=chr(0);
                           MoveTo(l_border+((cii-1)*(xwidth+1)),
                             u_border+((cjj-1)*(ywidth+1)));
                           set_track_elem(imp_nr,cii,cjj);
                           draw_field_elem(257);
                           inc(cii);
                        end;
                        cii:=ci;
                        inc(cjj)
                     end;
                     draw_field_elem(258);
                     goodsave:=false
                  end;
               end
            end;
            59..68 : begin   (* F1..F10 *)
              if markfunct<=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
               dedm:=false;
               dsf:=false;
               if not trackmode
               then begin
                  dedm:=true;
                  dsf:=true
               end;
               if tsf_nr<>ord(contr)-58
               then
                  dsf:=true;
               tsf_nr:=ord(contr)-58;
               t_elem_nr:=tsf[tsf_nr,tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j];
               trackmode:=true;
               if dsf
               then
                  draw_select_field;
               if dedm
               then
                  draw_edit_menu;
               MoveTo(ssf_l_border+tsf_pos[tsf_nr].i*(xwidth+1),
                      tu_border+(tsf_pos[tsf_nr].j-1)*(ywidth+1));
               draw_field_elem(256);
               MoveTo(l_border+((ci-1)*(xwidth+1)),
                 u_border+((cj-1)*(ywidth+1)));
               if marked
               then
                  draw_field_elem(258)
               else
                  draw_field_elem(256);
               if dedm
               then
                  draw_sel_el
              end
              else begin
                 if terrmark
                 then begin
                    if not trackmark
                    then
                       trackmark:=true
                    else
                       terrmark:=false;
                    draw_short_key_menu;
                    draw_edit_menu;
                    draw_sel_el;
                 end;
              end
            end;
            88,98,108 : begin   (* Alt-F5 *)
              if markfunct=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     if marked
                     then
                        draw_short_key_menu;
                  end;
               draw_field_elem(257);
               if marked
               then
                  draw_field_elem(259)
               else begin
                  marked:=true;
                  draw_short_key_menu
               end;
               markxmin:=ci;
               markymin:=cj;
               if (markxmax=0)
               then begin
                  markxmax:=30;
                  markymax:=30;
               end;
               if markxmax<markxmin
               then
                  markxmax:=markxmin;
               if markymax<markymin
               then
                  markymax:=markymin;
               draw_field_elem(258)
              end
            end;
            89,99,109 : begin   (* Alt-F6 *)
              if markfunct=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     if marked
                     then
                        draw_short_key_menu;
                  end;
               draw_field_elem(257);
               if marked
               then
                  draw_field_elem(259)
               else begin
                  marked:=true;
                  draw_short_key_menu
               end;
               markxmax:=ci;
               markymax:=cj;
               if (markxmin=0)
               then begin
                  markxmin:=1;
                  markymin:=1;
               end;
               if markxmin>markxmax
               then
                  markxmin:=markxmax;
               if markymin>markymax
               then
                  markymin:=markymax;
               draw_field_elem(258)
              end
            end;
            91,101,111 : begin   (* Alt-F8 *)
              if marked
              then begin
               markfunct:=99;
               draw_field_elem(259);
               markfunct:=0;
               marked:=false;
               sneumarkpos:=false;
               lneumarkpos:=false;
               trackmark:=false;
               terrmark:=false;
               markxmin:=0;
               markymin:=0;
               markxmax:=0;
               markymax:=0;
               xmirr:=false;
               ymirr:=false;
               draw_select_field;
               draw_edit_menu;
               draw_sel_el;
               draw_short_key_menu;
               MoveTo(l_border+((ci-1)*(xwidth+1)),
                 u_border+((cj-1)*(ywidth+1)));
               draw_field_elem(256);
              end
            end;
            90,100,110 : begin   (* Alt-F7 *)
              if markfunct<>0
              then begin
               markfunct:=99;
               draw_field_elem(259);
               markfunct:=0;
               marked:=true;
               sneumarkpos:=false;
               lneumarkpos:=false;
               trackmark:=false;
               terrmark:=false;
               markxmax:=markxmax-markxmin+ci;
               markymax:=markymax-markymin+cj;
               markxmin:=ci;
               markymin:=cj;
               xmirr:=false;
               ymirr:=false;
               draw_select_field;
               draw_edit_menu;
               draw_sel_el;
               draw_short_key_menu;
               MoveTo(l_border+((ci-1)*(xwidth+1)),
                 u_border+((cj-1)*(ywidth+1)));
               draw_field_elem(258);
              end
            end;
            84,94,104 : begin   (* Alt-F1 *)
               GetMem(p1,ImageSize(0,  0,639,199));
               GetImage(0,  0,639,199,p1^);
               GetMem(p2,ImageSize(0,200,639,399));
               GetImage(0,200,639,399,p2^);
               GetMem(p3,ImageSize(0,400,639,479));
               GetImage(0,400,639,479,p3^);
               ClearDevice;
               draw_full_key_menu;
               PutImage(0,  0,p1^,NormalPut);
               PutImage(0,200,p2^,NormalPut);
               PutImage(0,400,p3^,NormalPut);
               FreeMem(p1,ImageSize(0,  0,639,199));
               FreeMem(p2,ImageSize(0,200,639,399));
               FreeMem(p3,ImageSize(0,400,639,479));
               MoveTo(l_border+((ci-1)*(xwidth+1)),
                 u_border+((cj-1)*(ywidth+1)))
            end;
            85,95,105: begin   (* Alt-F2 *)
               schdir(oldpath[1]);
               assign(datei,oldname[1]+'.TRK');
               rewrite(datei);
               if IOResult=0
               then begin
                  for i:=1 to 900 do
                     write(datei,trackfield[1,i]);
                  write(datei,horizchar[1]);
                  for j:=1 to 30 do begin
                     for i:=1 to 30 do
                        write(datei,chr(field[1,i,j]));
                  end;
                  write(datei,postchar[1]);
                  fieldcopy;
                  trackcopy;
                  o_horizchar[1]:=horizchar[1];
                  o_postchar[1]:=postchar[1];
                  close(datei);
                  ok:=true;
                  goodsave:=true
               end
               else begin
                  sound(1000);
                  delay(10000);
                  nosound;
               end
            end;
            92,102,112,93,103,113: begin
               if (ord(contr)=92) OR (ord(contr)=102) OR (ord(contr)=112)
               then
                  newname:=scroll_file(oldpath[1],oldname[1],'TRK',-1)
               else
                  newname:=scroll_file(oldpath[1],oldname[1],'TRK', 1);
               if (newname<>'')
               then begin
                  oldname[1]:=newname;
                  assign(datei,oldname[1]+'.TRK');
                  reset(datei);
                  for i:=1 to 900 do begin
                     read(datei,ch);
                     if ord(ch)>0
                     then
                        trackloaded:=true;
                     trackfield[1,i]:=ch;
                     o_tf[1,i]:=ch
                  end;
                  read(datei,horizchar[1]);
                  for j:=1 to 30 do begin
                     for i:=1 to 30 do begin
                        read(datei,ch);
                        field[1,i,j]:=ord(ch);
                     end
                  end;
                  read(datei,postchar[1]);
                  close(datei);
                  o_horizchar[1]:=horizchar[1];
                  o_postchar[1]:=postchar[1];
                  fieldcopy;
                  goodsave:=true;
                  getdir(0,oldpath[1]);
               end;
               goto 2;
            end;
            45: begin   (* Alt-X *)
               if (markfunct=0)
               then begin
                  prefetched:=false;
                  if (not marked)
                  then begin
                     markxmin:=ci;
                     markymin:=cj;
                     markxmax:=ci;
                     markymax:=cj;
                     marked:=true;
                  end;
                  MoveTo(l_border+((ci-1)*(xwidth+1)),
                    u_border+((cj-1)*(ywidth+1)));
                  draw_field_elem(257);
                  ci:=markxmin;
                  cj:=markymin;
                  markfunct:=2;
                  terrmark:=true;
                  trackmark:=true;
                  SetColor(16);
                  setfillstyle(1,0);
                  bar(lsf_l_border-1,tu_border-1,
                      639,tu_border+6*(ywidth+1)+1);
                  for j:=1 to 30
                  do begin
                     for i:=1 to 30
                     do begin
                        sfromclipfield[i,j]:=ord(trackfield[1,900+i-j*30]);
                        lfromclipfield[i,j]:=field[1,i,j];
                           if (i>markxmin-1) and (i<markxmax+1) and
                             (j>markymin-1) and (j<markymax+1)
                           then begin
                              imp_nr:=false;
                              case ord(trackfield[1,900+i-j*30]) of
                                 10..13,20..23,30..33,52..55,60..65,85..94,
                                   105..108,117..124 : imp_nr:=true
                              end;
                              trackfield[1,900+i-j*30]:=chr(0);
                              MoveTo(l_border+((i-1)*(xwidth+1)),
                                u_border+((j-1)*(ywidth+1)));
                              set_track_elem(imp_nr,i,j);
                              draw_field_elem(257)
                           end;
                           if (i>markxmin-1) and (i<markxmax+1) and
                             (j>markymin-1) and (j<markymax+1)
                           then begin
                              field[1,i,j]:=0;
                              MoveTo(l_border+((i-1)*(xwidth+1)),
                                u_border+((j-1)*(ywidth+1)));
                              draw_field_elem(0);
                              draw_track_elem(0,i,j);
                              draw_field_elem(257)
                           end
                     end
                  end;
                  draw_edit_menu;
                  draw_sel_el;
                  MoveTo(l_border+((ci-1)*(xwidth+1)),
                    u_border+((cj-1)*(ywidth+1)));
                  draw_field_elem(258);
                  sneumarkpos:=false;
                  lneumarkpos:=false;
                  draw_short_key_menu
               end
            end;
            else begin
               if markfunct<=0
               then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
                  case hill_mode of
                     true: begin
                        case ord(contr) of
                           119: begin   (* Left-up *)
                              elem_nr:=17;
                              draw_sel_el
                           end;
                           117: begin   (* Left-down *)
                              elem_nr:=18;
                              draw_sel_el
                           end;
                           118: begin   (* Right-down *)
                              elem_nr:=15;
                              draw_sel_el
                            end;
                           132: begin   (* Right-up *)
                              elem_nr:=16;
                              draw_sel_el
                           end
                        end
                     end
                  end
               end
            end
         end
      end
      else begin
         case contr of
            chr(13): begin    (* ENTER *)
               if markfunct=0
               then begin
                  if trackmode
                  then begin
                     if (not autoset)
                     then begin
                        if (prefetched)
                        then begin
                           case pretrack[1,1] of
                              chr(0): begin
                                 MoveTo(ssf_l_border+tsf_pos[tsf_nr].i*(xwidth+1),
                                   tu_border+(tsf_pos[tsf_nr].j-1)*(ywidth+1));
                                 draw_field_elem(257);
                                 tsf_pos[tsf_nr].i:=1;
                                 tsf_pos[tsf_nr].j:=1;
                                 draw_select_field;
                                 draw_edit_menu;
                                 MoveTo(ssf_l_border+tsf_pos[tsf_nr].i*(xwidth+1),
                                   tu_border+(tsf_pos[tsf_nr].j-1)*(ywidth+1));
                                 draw_field_elem(256);
                                 MoveTo(l_border+((ci-1)*(xwidth+1)),
                                   u_border+((cj-1)*(ywidth+1)));
                                 draw_sel_el
                              end;
                              else begin
                                 MoveTo(ssf_l_border+tsf_pos[tsf_nr].i*(xwidth+1),
                                   tu_border+(tsf_pos[tsf_nr].j-1)*(ywidth+1));
                                 draw_field_elem(257);
                                 pf_t_found:=false;
                                 k:=0;
                                 h_pretrack:=chr(0);
                                 h_pretrack:=pretrack[1,1];
                                 case ord(h_pretrack) of
                                    253: begin
                                       if (ci>1) AND (cj>1)
                                       then
                                          if multiel[ord(trackfield[1,900+(ci-1)-(cj-1)*30])]=3
                                          then
                                             pretrack[1,1]:=trackfield[1,900+(ci-1)-(cj-1)*30]
                                    end;
                                    254: begin
                                       if (cj>1)
                                       then
                                          if multiel[ord(trackfield[1,900+ci-(cj-1)*30])]>1
                                          then
                                             pretrack[1,1]:=trackfield[1,900+ci-(cj-1)*30];
                                    end;
                                    255: begin
                                       if (ci>1)
                                       then
                                          if (multiel[ord(trackfield[1,900+(ci-1)-cj*30])]=1) OR
                                             (multiel[ord(trackfield[1,900+(ci-1)-cj*30])]=3)
                                          then
                                             pretrack[1,1]:=trackfield[1,900+(ci-1)-cj*30];
                                    end;
                                 end;
                                 while (not pf_t_found) AND (k<10)
                                 do begin
                                    j:=0;
                                    while (not pf_t_found) AND (j<6)
                                    do begin
                                       i:=0;
                                       while (not pf_t_found) AND (i<6)
                                       do begin
                                          if tsf[k+1,i+1,j+1]=ord(pretrack[1,1])
                                          then begin
                                             tsf_pos[k+1].i:=i+1;
                                             tsf_pos[k+1].j:=j+1;
                                             tsf_nr:=k+1;
                                             pf_t_found:=true;
                                          end;
                                          inc(i);
                                       end;
                                       inc(j);
                                    end;
                                    inc(k);
                                 end;
                                 if (ord(pretrack[1,1])<253)
                                 then
                                    case ord(h_pretrack) of
                                       253: begin
                                          inc(tsf_pos[tsf_nr].i);
                                          inc(tsf_pos[tsf_nr].j);
                                       end;
                                       254:
                                          inc(tsf_pos[tsf_nr].j);
                                       255:
                                          inc(tsf_pos[tsf_nr].i);
                                    end;
                                 draw_select_field;
                                 draw_edit_menu;
                                 MoveTo(ssf_l_border+tsf_pos[tsf_nr].i*(xwidth+1),
                                   tu_border+(tsf_pos[tsf_nr].j-1)*(ywidth+1));
                                 draw_field_elem(256);
                                 MoveTo(l_border+((ci-1)*(xwidth+1)),
                                   u_border+((cj-1)*(ywidth+1)));
                                 draw_sel_el
                              end;
                           end;
                        end
                        else
                           pretrack[1,1]:=trackfield[1,900+ci-cj*30];
                        prefetched:=not prefetched;
                        draw_short_key_menu;
                     end;
                     imp_nr:=false;
                     case ord(trackfield[1,900+ci-cj*30]) of
                        10..13,20..23,30..33,52..55,60..65,85..94,105..108,
                          117..124 : imp_nr:=true
                     end;
                     trackfield[1,900+ci-cj*30]:=chr(tsf[tsf_nr,
                       tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j]);
                     set_track_elem(imp_nr,ci,cj);
                     draw_field_elem(256);
                     if marked
                     then begin
                        draw_field_elem(258)
                     end;
                     goodsave:=false
                  end
                  else begin
                     if (not autoset)
                     then begin
                        if (prefetched)
                        then begin
                           case prefield of
                              0: begin
                                 elem_nr:=prefield;
                                 draw_sel_el
                              end;
                              1..5: begin
                                 if hill_mode then begin
                                    hill_mode:=false;
                                    draw_select_field;
                                 end;
                                 elem_nr:=prefield;
                                 draw_sel_el
                              end;
                              6..18: begin
                                 if (not hill_mode) then begin
                                    hill_mode:=true;
                                    draw_select_field;
                                 end;
                                 elem_nr:=prefield;
                                 draw_sel_el
                              end;
                           end;
                        end
                        else
                           prefield:=field[1,ci,cj];
                        prefetched:=not prefetched;
                        draw_short_key_menu;
                     end;
                     field[1,ci,cj]:=elem_nr;
                     draw_field_elem(elem_nr);
                     draw_track_elem(0,ci,cj);
                     draw_field_elem(256);
                     if marked
                     then begin
                        draw_field_elem(258)
                     end;
                     goodsave:=false
                  end;
               end
               else begin
                  cii:=ci;
                  cjj:=cj;
                  if markfunct=-1
                  then begin
                   if trackmode
                   then begin
                     for j:=markymin to markymax
                     do begin
                        for i:=markxmin to markxmax
                        do begin
                           imp_nr:=false;
                           case ord(trackfield[1,900+cii-cjj*30]) of
                              10..13,20..23,30..33,52..55,60..65,85..94,
                                105..108,117..124 : imp_nr:=true
                           end;
                           trackfield[1,900+cii-cjj*30]:=chr(tsf[tsf_nr,
                             tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j]);;
                           MoveTo(l_border+((cii-1)*(xwidth+1)),
                             u_border+((cjj-1)*(ywidth+1)));
                           set_track_elem(imp_nr,cii,cjj);
                           draw_field_elem(257);
                           inc(cii);
                        end;
                        cii:=ci;
                        inc(cjj)
                     end
                   end
                   else begin
                     for j:=markymin to markymax
                     do begin
                        for i:=markxmin to markxmax
                        do begin
                           field[1,cii,cjj]:=elem_nr;
                           MoveTo(l_border+((cii-1)*(xwidth+1)),
                             u_border+((cjj-1)*(ywidth+1)));
                           draw_field_elem(elem_nr);
                           draw_track_elem(0,cii,cjj);
                           draw_field_elem(257);
                           inc(cii);
                        end;
                        cii:=ci;
                        inc(cjj)
                     end
                   end
                  end
                  else begin
                   transform_field;
                   if trackmark
                   then begin
                     for j:=markymin to markymax
                     do begin
                        for i:=markxmin to markxmax
                        do begin
                           imp_nr:=false;
                           pre_tf[900+cii-cjj*30]:=trackfield[1,900+cii-cjj*30];
                           case ord(trackfield[1,900+cii-cjj*30]) of
                              10..13,20..23,30..33,52..55,60..65,85..94,
                                105..108,117..124 : imp_nr:=true
                           end;
                           trackfield[1,900+cii-cjj*30]:=chr(sclipfield[i,j]);
                           MoveTo(l_border+((cii-1)*(xwidth+1)),
                             u_border+((cjj-1)*(ywidth+1)));
                           set_track_elem(imp_nr,cii,cjj);
                           draw_field_elem(257);
                           inc(cii);
                        end;
                        cii:=ci;
                        inc(cjj)
                     end;
                     sneumarkpos:=true;
                     draw_short_key_menu
                   end;
                   cii:=ci;
                   cjj:=cj;
                   if terrmark
                   then begin
                     for j:=markymin to markymax
                     do begin
                        for i:=markxmin to markxmax
                        do begin
                           field_pre[cii,cjj]:=field[1,cii,cjj];
                           field[1,cii,cjj]:=lclipfield[i,j];
                           MoveTo(l_border+((cii-1)*(xwidth+1)),
                             u_border+((cjj-1)*(ywidth+1)));
                           draw_field_elem(field[1,cii,cjj]);
                           draw_track_elem(0,cii,cjj);
                           draw_field_elem(257);
                           inc(cii);
                        end;
                        cii:=ci;
                        inc(cjj)
                     end;
                     lneumarkpos:=true;
                     draw_short_key_menu
                   end
                  end;
                  goodsave:=false;
                  MoveTo(l_border+((ci-1)*(xwidth+1)),
                    u_border+((cj-1)*(ywidth+1)));
                  draw_field_elem(258);
               end
            end;
            chr(10): begin   (* Ctrl-Enter *);
               if (markfunct=0) AND (trackmode)
               then begin
                  me:=multiel[ord(tsf[tsf_nr,tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j])];
                  imp_nr:=(multiel[ord(trackfield[1,900+ci-cj*30])]>0);
                  trackfield[1,900+ci-cj*30]:=chr(tsf[tsf_nr,
                    tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j]);
                  set_track_elem(imp_nr,ci,cj);
                  if ((me=1) OR (me=3)) AND (ci<30)
                  then begin
                     imp_nr:=(multiel[ord(trackfield[1,900+ci+1-cj*30])]>0);
                     trackfield[1,900+ci+1-cj*30]:=chr(tsf[tsf_nr,
                       tsf_pos[tsf_nr].i+1,tsf_pos[tsf_nr].j]);
                     set_track_elem(imp_nr,ci+1,cj);
                  end;
                  if ((me=2) OR (me=3)) AND (cj<30)
                  then begin
                     imp_nr:=(multiel[ord(trackfield[1,900+ci-(cj+1)*30])]>0);
                     trackfield[1,900+ci-(cj+1)*30]:=chr(tsf[tsf_nr,
                       tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j+1]);
                     set_track_elem(imp_nr,ci,cj+1);
                  end;
                  if (me=3) AND (ci<30) AND (cj<30)
                  then begin
                     imp_nr:=(multiel[ord(trackfield[1,900+ci+1-(cj+1)*30])]>0);
                     trackfield[1,900+ci+1-(cj+1)*30]:=chr(tsf[tsf_nr,
                       tsf_pos[tsf_nr].i+1,tsf_pos[tsf_nr].j+1]);
                     set_track_elem(imp_nr,ci+1,cj+1);
                  end;
                  gofield(ci,cj);
                  draw_field_elem(256);
                  if marked
                  then
                     draw_field_elem(258);
               end
               else begin
                  imp_nr:=false;
                  case ord(trackfield[1,900+ci-cj*30]) of
                     10..13,20..23,30..33,52..55,60..65,85..94,105..108,
                       117..124 : imp_nr:=true
                  end;
                  trackfield[1,900+ci-cj*30]:=chr(tsf[tsf_nr,
                    tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j]);
                  set_track_elem(imp_nr,ci,cj);
                  draw_field_elem(256);
                  if marked
                  then
                     draw_field_elem(258)
               end;
               goodsave:=false
            end;
            chr(8): begin   (* BackSpace *)
              if markfunct=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
               field[1,ci,cj]:=field_orig[1,ci,cj];
               draw_field_elem(field_orig[1,ci,cj]);
               draw_track_elem(0,ci,cj);
               draw_field_elem(256);
               if marked
               then begin
                  draw_field_elem(258);
               end;
               goodsave:=false
              end
              else begin
                  if markfunct=-1
                  then begin
                     cii:=ci;
                     cjj:=cj;
                     for j:=markymin to markymax
                     do begin
                        for i:=markxmin to markxmax
                        do begin
                           field[1,cii,cjj]:=field_orig[1,cii,cjj];
                           MoveTo(l_border+((cii-1)*(xwidth+1)),
                             u_border+((cjj-1)*(ywidth+1)));
                           draw_field_elem(field[1,cii,cjj]);
                           draw_track_elem(0,cii,cjj);
                           draw_field_elem(257);
                           inc(cii);
                        end;
                        cii:=ci;
                        inc(cjj)
                     end;
                     draw_field_elem(258);
                     goodsave:=false
                  end
                  else begin
                     if (lneumarkpos)
                     then begin
                        cii:=ci;
                        cjj:=cj;
                        for j:=markymin to markymax
                        do begin
                           for i:=markxmin to markxmax
                           do begin
                              field[1,cii,cjj]:=field_pre[cii,cjj];
                              MoveTo(l_border+((cii-1)*(xwidth+1)),
                                u_border+((cjj-1)*(ywidth+1)));
                                draw_field_elem(field[1,cii,cjj]);
                                draw_track_elem(0,cii,cjj);
                                draw_field_elem(257);
                                inc(cii);
                           end;
                           cii:=ci;
                           inc(cjj)
                        end;
                        draw_field_elem(258);
                        lneumarkpos:=false;
                        draw_short_key_menu;
                        goodsave:=false
                     end;
                  end
              end
            end;
            ' ': begin    (* SPACE *)
              if markfunct<=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
               if trackmode
               then begin
                  trackmode:=false;
                  draw_select_field;
                  draw_edit_menu;
                  elem_nr:=0;
                  draw_sel_el
               end
               else begin
                  if hill_mode then begin
                     hill_mode:=false;
                     draw_select_field;
                     elem_nr:=0;
                     draw_sel_el
                  end
                  else begin
                     hill_mode:=true;
                     draw_select_field;
                     elem_nr:=0;
                     draw_sel_el
                  end
               end;
               if marked
               then
                  draw_field_elem(258)
              end
              else begin
                 if trackmark
                 then begin
                    if not terrmark
                    then
                       terrmark:=true
                    else
                       trackmark:=false;
                    draw_short_key_menu;
                    draw_edit_menu;
                    draw_sel_el;
                 end;
              end
            end;
            chr(9): begin   (* Tab *)
              if markfunct=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
               autoset:=not autoset;
               write_status
              end
            end;
            comp_low_char,comp_char:
            begin
               trackcomp:=not trackcomp;
               if (not trackcomp)
               then
                  draw_field_elem(260);
               write_status;
            end;
            swap_low_char,swap_char: begin
               prefetched:=false;
               trackswap;
               redraw_field;
            end;
            'd','D': begin
               prefetched:=false;
               trackdup;
               goto 2;
            end;
            'x','X': begin
              if markfunct<=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
               random_scenery(contr='X');
               MoveTo(l_border+((ci-1)*(xwidth+1)),
                      u_border+((cj-1)*(ywidth+1)));
               goodsave:=false
              end
            end;
            'm','M': begin
(*              if markfunct<=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
               multifield:=not multifield;
               draw_sel_el;
               MoveTo(l_border+((ci-1)*(xwidth+1)),
                      u_border+((cj-1)*(ywidth+1)));
               goodsave:=false
              end
*)            end;
            '<': begin
               if markfunct>0
               then begin
                  ymirr:=not ymirr;
                  xmirr:=((xmirr) and (ymirr)) or (not (xmirr or ymirr));
                  draw_sel_el;
                  draw_field_elem(258);
               end
            end;
            '>': begin
               if markfunct>0
               then begin
                  xmirr:=not xmirr;
                  ymirr:=((ymirr) and (xmirr)) or (not (ymirr or xmirr));
                  draw_sel_el;
                  draw_field_elem(258);
               end
            end;
            chr(3): begin   (* Ctrl-C *)
               if (markfunct=0)
               then begin
                  prefetched:=false;
                  if (not marked)
                  then begin
                     markxmin:=ci;
                     markymin:=cj;
                     markxmax:=ci;
                     markymax:=cj;
                     marked:=true;
                  end;
                  MoveTo(l_border+((ci-1)*(xwidth+1)),
                    u_border+((cj-1)*(ywidth+1)));
                  draw_field_elem(257);
                  ci:=markxmin;
                  cj:=markymin;
                  markfunct:=1;
                  if trackmode
                  then begin
                     terrmark:=false;
                     trackmark:=true
                  end
                  else begin
                     terrmark:=true;
                     trackmark:=false
                  end;
                  SetColor(16);
                  setfillstyle(1,0);
                  bar(lsf_l_border-1,tu_border-1,
                      639,tu_border+6*(ywidth+1)+1);
                  for j:=1 to 30
                  do begin
                     for i:=1 to 30
                     do begin
                        sfromclipfield[i,j]:=ord(trackfield[1,900+i-j*30]);
                        lfromclipfield[i,j]:=field[1,i,j];
                     end
                  end;
                  draw_edit_menu;
                  draw_sel_el;
                  MoveTo(l_border+((ci-1)*(xwidth+1)),
                    u_border+((cj-1)*(ywidth+1)));
                  draw_field_elem(258);
                  sneumarkpos:=false;
                  lneumarkpos:=false;
                  draw_short_key_menu
               end
            end;
            chr(24): begin   (* Ctrl-X *)
               if (markfunct=0)
               then begin
                  prefetched:=false;
                  if (not marked)
                  then begin
                     markxmin:=ci;
                     markymin:=cj;
                     markxmax:=ci;
                     markymax:=cj;
                     marked:=true;
                  end;
                  MoveTo(l_border+((ci-1)*(xwidth+1)),
                    u_border+((cj-1)*(ywidth+1)));
                  draw_field_elem(257);
                  ci:=markxmin;
                  cj:=markymin;
                  markfunct:=2;
                  if trackmode
                  then begin
                     terrmark:=false;
                     trackmark:=true
                  end
                  else begin
                     terrmark:=true;
                     trackmark:=false
                  end;
                  SetColor(16);
                  setfillstyle(1,0);
                  bar(lsf_l_border-1,tu_border-1,
                      639,tu_border+6*(ywidth+1)+1);
                  for j:=1 to 30
                  do begin
                     for i:=1 to 30
                     do begin
                        sfromclipfield[i,j]:=ord(trackfield[1,900+i-j*30]);
                        lfromclipfield[i,j]:=field[1,i,j];
                     end
                  end;
                  for j:=1 to 30
                  do begin
                     for i:=1 to 30
                     do begin
                        if trackmark
                        then begin
                           if (i>markxmin-1) and (i<markxmax+1) and
                             (j>markymin-1) and (j<markymax+1)
                           then begin
                              imp_nr:=false;
                              case ord(trackfield[1,900+i-j*30]) of
                                 10..13,20..23,30..33,52..55,60..65,85..94,
                                   105..108,117..124 : imp_nr:=true
                              end;
                              trackfield[1,900+i-j*30]:=chr(0);
                              MoveTo(l_border+((i-1)*(xwidth+1)),
                                u_border+((j-1)*(ywidth+1)));
                              set_track_elem(imp_nr,i,j);
                              draw_field_elem(257)
                           end
                        end;
                        if terrmark
                        then begin
                           if (i>markxmin-1) and (i<markxmax+1) and
                             (j>markymin-1) and (j<markymax+1)
                           then begin
                              field[1,i,j]:=0;
                              MoveTo(l_border+((i-1)*(xwidth+1)),
                                u_border+((j-1)*(ywidth+1)));
                              draw_field_elem(0);
                              draw_track_elem(0,i,j);
                              draw_field_elem(257)
                           end
                        end
                     end
                  end;
                  draw_edit_menu;
                  draw_sel_el;
                  MoveTo(l_border+((ci-1)*(xwidth+1)),
                    u_border+((cj-1)*(ywidth+1)));
                  draw_field_elem(258);
                  sneumarkpos:=false;
                  lneumarkpos:=false;
                  draw_short_key_menu
               end
            end;
            chr(19): begin   (* Ctrl-S *)
               if (marked) and (markfunct=0)
               then begin
                  prefetched:=false;
                  ci:=markxmin;
                  cj:=markymin;
                  markfunct:=-1;
                  draw_field_elem(257);
                  MoveTo(l_border+((ci-1)*(xwidth+1)),
                    u_border+((cj-1)*(ywidth+1)));
                  draw_field_elem(258);
                  sneumarkpos:=false;
                  lneumarkpos:=false;
                  draw_short_key_menu
               end
            end;
            'l','L': begin
               if (megadrive) and (not trackmode) and (markfunct=0)
               then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
                  i:=0;
                  megac:=readkey;
                  if (ord(megac)>47) and (ord(megac)<58)
                  then begin
                     i:=ord(megac)-48;
                     megac:=readkey;
                     if (ord(megac)>47) and (ord(megac)<58)
                     then begin
                        i:=i*10+ord(megac)-48;
                        megac:=readkey;
                        if (ord(megac)>47) and (ord(megac)<58)
                        then
                           i:=i*10+ord(megac)-48
                        else begin
                           if ord(megac)=0
                           then begin
                              readkey;
                              i:=0
                           end
                           else begin
                              if ord(megac)<>13
                              then
                                 i:=0
                           end
                        end;
                     end
                     else begin
                        if ord(megac)=0
                           then begin
                           readkey;
                           i:=0
                        end
                        else begin
                           if ord(megac)<>13
                           then
                              i:=0
                        end
                     end
                  end
                  else begin
                     if ord(megac)=0
                        then begin
                        readkey;
                        i:=0
                     end
                     else begin
                        if ord(megac)<>13
                        then
                           i:=0
                     end
                  end;
                  while i>255
                  do
                     i:=i-256;
                  elem_nr:=i;
                  draw_sel_el;
                  goodsave:=false;
               end
            end;
            '0': begin   (* Grass *)
              if markfunct<=0
              then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
               elem_nr:=0;
               draw_sel_el
              end
            end;
            else begin
               if markfunct<=0
               then begin
                  if (prefetched)
                  then begin
                     prefetched:=false;
                     draw_short_key_menu;
                  end;
                  case trackmode of
                     true: begin
                        case contr of
                           '1':
                              scroll_tsf_pos(-1,1);
                           '5','2':
                              scroll_tsf_pos(0,1);
                           '3':
                              scroll_tsf_pos(1,1);
                           '4':
                              scroll_tsf_pos(-1,0);
                           '6':
                              scroll_tsf_pos(1,0);
                           '7':
                              scroll_tsf_pos(-1,-1);
                           '8':
                              scroll_tsf_pos(0,-1);
                           '9':
                              scroll_tsf_pos(1,-1);
                        end;
                        t_elem_nr:=tsf[tsf_nr,tsf_pos[tsf_nr].i,
                                           tsf_pos[tsf_nr].j]
                     end;
                     false: begin
                        case hill_mode of
                           true: begin
                              case contr of
                                 '1': begin
                                    elem_nr:=14;
                                    draw_sel_el
                                 end;
                                 '2': begin
                                    elem_nr:=7;
                                    draw_sel_el
                                 end;
                                 '3': begin
                                    elem_nr:=11;
                                    draw_sel_el
                                 end;
                                 '4': begin
                                    elem_nr:=10;
                                    draw_sel_el
                                 end;
                                 '5': begin
                                    elem_nr:=6;
                                    draw_sel_el
                                 end;
                                 '6': begin
                                    elem_nr:=8;
                                    draw_sel_el
                                 end;
                                 '7': begin
                                    elem_nr:=13;
                                    draw_sel_el
                                 end;
                                 '8': begin
                                    elem_nr:=9;
                                    draw_sel_el
                                 end;
                                 '9': begin
                                    elem_nr:=12;
                                    draw_sel_el
                                 end
                              end
                           end;
                           false: begin
                              case contr of
                                 '1': begin
                                    elem_nr:=4;
                                    draw_sel_el
                                 end;
                                 '3': begin
                                    elem_nr:=5;
                                    draw_sel_el
                                 end;
                                 '5': begin
                                    elem_nr:=1;
                                    draw_sel_el
                                 end;
                                 '7': begin
                                    elem_nr:=3;
                                    draw_sel_el
                                 end;
                                 '9': begin
                                    elem_nr:=2;
                                    draw_sel_el
                                 end
                              end
                           end
                        end
                     end
                  end
               end
            end
         end
      end;
      while keypressed do
         contr:=readkey
    until (contr=#27) OR (upcase(contr)='Q');
    if (upcase(contr)='Q')
    then
       progcheck:=chr(27);
    oldi:=ci;
    oldj:=cj;
    CloseGraph
   end
   else begin
     sound(1000);
     delay(1000);
     nosound;
     WriteLn('Graphics error:',GraphErrorMsg(ErrCode));
     delay(5000);
   end
end;


procedure edit_denotations;
const xbase=37;
      ybase=6;
var hc,pc:integer;
    progmode:char;

begin
   clrscr;
   progmode:=yes_char;
   repeat
      hc:=ord(horizchar[1]);
      pc:=ord(postchar[1]);
      textcolor(9);
      GoToXY(40-(length(eb_1)+1) div 2,3);
      write(eb_1);
      Set_Color_To(8,7,0,3);
      if megadrive
      then
         box(xbase-2,ybase,xbase+4,ybase+5,0,'')
      else begin
         box(xbase-2,ybase,xbase+2,ybase+5,0,'');
         if (hc>4) AND (hc<10)
         then
            hc:=hc+300;
         if hc=255
         then
            hc:=5;
      end;
      Set_ScoreBoard_On;
      if megadrive
      then begin
         SayGet(xbase,ybase+ 1,'',hc,_I,3,0);
         Range('0','255');
         SayGet(xbase,ybase+ 2,'',pc,_I,3,0);
         Range('0','255')
      end
      else begin
         SayGet(xbase,ybase+ 1,'',hc,_I,1,0);
         Range('0','5')
      end;
      SayGet(xbase,ybase+4,'',progmode,_C,1,0);
      userset:=[yes_char,no_char,yes_low_char,no_low_char];
      userchar:='';
      Picture('');
      textcolor(5);
      textbackground(0);
      GoToXY(6,ybase+1);
      if megadrive
      then begin
         write('               Byte  901 :');
         GoToXY(6,WhereY+1);
         write('               Byte 1802 :')
      end
      else
         write(hed1);
      if (megadrive)
      then
         GoToXY(6,WhereY+2)
      else
         GoToXY(6,WhereY+3);
      write(hed15);
      textcolor(2);
      gotoxy(wherex-9,wherey);
      write('[',yes_char,']/[',no_char,']');
      GoToXY(1,14);
      write_mess(hexpl1,5,7,1);
      writeln;
      write_mess(hexpl2,2,7,0);
      if (megadrive)
      then
         write_mess('255',2,7,0)
      else
         write_mess(' 5',2,7,0);
      ReadGets;
      if (editresult<>1)
      then begin
         progmode:=upcase(progmode);
         case progmode of
            yes_char : begin
               if not megadrive
               then begin
                  if hc=5
                  then
                     hc:=255;
                  if hc>300
                  then
                     hc:=hc-300;
               end;
               horizchar[1]:=chr(hc);
               postchar[1]:=chr(pc)
            end;
            no_char : begin

               (* Non-saving exit sequence *)

            end
         end;
      end;
      textbackground(0)
   until true;
   goodsave:=false
end;


procedure random_props;
const xbase=48;
      ybase=5;
var progmode:char;
    vp:array[0..11] of integer;
    housewater_c,shipgrass_c,objhill_c:char;

begin
   clrscr;
   for i:=0 to 11
   do
      vp[i]:=verz_props[i];
   if housewater
   then
      housewater_c:=yes_char
   else
      housewater_c:=no_char;
   if shipgrass
   then
      shipgrass_c:=yes_char
   else
      shipgrass_c:=no_char;
   if objhill
   then
      objhill_c:=yes_char
   else
      objhill_c:=no_char;
   repeat
      textcolor(9);
      GoToXY(40-(length(eb_2)+1) div 2,2);
      write(eb_2);
      Set_Color_To(8,7,0,3);
      box(xbase-2,ybase,xbase+5,ybase+18,0,'');
      Set_ScoreBoard_On;
      SayGet(xbase,ybase+ 1,'',vp[0],_I,3,0);
      Picture('999');
      Range('0','100');
      for i:=1 to 11
      do begin
         SayGet(xbase,ybase+i+2,'',vp[i],_I,3,0);
         Picture('999');
         Range('0','100');
      end;
      userset:=[yes_char,no_char,yes_low_char,no_low_char];
      userchar:='';
      SayGet(xbase,ybase+15,'',housewater_c,_C,1,0);
      Picture('');
      SayGet(xbase,ybase+16,'',shipgrass_c,_C,1,0);
      Picture('');
      SayGet(xbase,ybase+17,'',objhill_c,_C,1,0);
      Picture('');
      textcolor(8);
      textbackground(7);
      gotoxy(xbase+4,ybase+1);
      write('%');
      textcolor(5);
      textbackground(0);
      GoToXY(1,ybase+1);
      write(vz0);
      GoToXY(1,ybase+3);
      write(vz1);
      GoToXY(1,ybase+4);
      write(vz2);
      GoToXY(1,ybase+5);
      write(vz3);
      GoToXY(1,ybase+6);
      write(vz4);
      GoToXY(1,ybase+7);
      write(vz5);
      GoToXY(1,ybase+8);
      write(vz6);
      GoToXY(1,ybase+9);
      write(vz7);
      GoToXY(1,ybase+10);
      write(vz8);
      GoToXY(1,ybase+11);
      write(vz9);
      GoToXY(1,ybase+12);
      write(vz10);
      GoToXY(1,ybase+13);
      write(vz11);
      GoToXY(1,ybase+15);
      write(vz12);
      GoToXY(1,ybase+16);
      write(vz13);
      GoToXY(1,ybase+17);
      write(vz14);
      ReadGets;
      if (editresult<>1)
      then begin
         for i:=0 to 11
         do
            verz_props[i]:=vp[i];
         housewater_c:=upcase(housewater_c);
         shipgrass_c:=upcase(shipgrass_c);
         objhill_c:=upcase(objhill_c);
         if housewater_c=yes_char
         then
            housewater:=true
         else
            housewater:=false;
         if shipgrass_c=yes_char
         then
            shipgrass:=true
         else
            shipgrass:=false;
         if objhill_c=yes_char
         then
            objhill:=true
         else
            objhill:=false;
      end;
      textbackground(0)
   until true;
end;


procedure Voreinlesen(auto:boolean);  (** Liest Streckendatei ein **)
var i,j,fp,oldx,oldy:integer;
    ok,again,firstauto,firstload:boolean;
    s:PathStr;
    lom:array[1..3] of boolean;
    loadstat:array[1..5] of boolean;
    lf_track:array[1..900] of char;
    lf_horizchar,lf_postchar:char;
    loadmode:byte;
    neuname:string[8];
    defset:byte;
    testdir:dirstr;
Label 1,2;

begin
   firstload:=not eingelesen;
   firstauto:=auto;
   repeat
1:      defset:=0;
      loadmode:=3;
      lom[1]:=true;     (* = Leerstrecke einlesen *)
      lom[2]:=false;    (* = Alte Strecke erhalten *)
      lom[3]:=false;    (* = Strecke einlesen *)
      loadstat[1]:=false;
      loadstat[2]:=false;
      loadstat[3]:=false;
      loadstat[4]:=false;
      loadstat[5]:=trackloaded;
      TextColor(9);
      ok:=false;
      again:=false;
      neuname:='';
      clrscr;
      GoToXY(40-(length(m2)+1) div 2,3);
      writeln(m2);
      writeln;
      if (not goodsave) and (fchanged(1) or tchanged(1) or hchanged(1))
      then begin
         writeln
      end;
      if (not goodsave) and (hchanged(1))
      then begin
         write_mess(w0,12,7,1);
         delay(200)
      end;
      if (not goodsave) and (fchanged(1))
      then begin
         write_mess(w1,12,7,1);
         delay(200);
      end;
      if (not goodsave) and (tchanged(1))
      then begin
         write_mess(w2,12,7,1);
         delay(200)
      end;
      if (not goodsave) and (fchanged(1) or tchanged(1) or hchanged(1))
      then begin
(*         writeln;
         write_mess(i1,5,7,1);
         delay(200)*)
      end;
      GoToXY(WhereX,WhereY+2);
      write_mess(l1,5,7,0);
      if not firstauto
      then
         auto:=false;
      neuname:=getfname(8,auto);
      firstauto:=false;
      writeln;
      writeln;
      writeln;
      if neuname=#13
      then
         neuname:=oldname[1];
      if length(neuname)>0
      then begin
         {$I-}
         s := FSearch(neuname+'.trk','.');
         if S = '' then begin   (* Nicht vorhandene Datei *)
            writeln;
            write_mess(w3,12,7,0);
            repeat
               check:=readkey;
            until not keypressed;
            again:=true
         end
         else begin  (* Vorhanden *)
            if get_size(neuname+'.trk')<>1802
            then
               again:=true;
            if not again then begin   (* Gltige Gre *)
               assign(datei,neuname+'.trk');
               reset(datei);
               for i:=1 to 900 do begin
                  read(datei,ch);
                  if ord(ch)>0
                  then
                     loadstat[4]:=true;
                  lf_track[i]:=ch
               end;
               read(datei,lf_horizchar);
               for i:=1 to 900 do
                  read(datei,ch);
               read(datei,lf_postchar);
               close(datei);
               if (loadstat[4]) and (not auto)
               then begin
                  writeln;
                  write_mess(ls41,2,0,1);
                  if loadstat[5]
                  then begin
                     write_mess(ls51,12,0,1);
                     lom[2]:=true
                  end
                  else begin
                     write_mess(ls50,2,0,1)
                  end;
                  lom[3]:=true
               end
               else begin
                  if (loadstat[5]) and (not auto)
                  then begin
                     writeln;
                     write_mess(ls40,2,0,1);
                     write_mess(ls51,12,0,1);
                     lom[2]:=true
                  end
               end;
               writeln;
               if ((loadstat[4]) or (loadstat[5])) and (not auto)
               then begin
                  write_mess(lm1,5,0,0);
                  write_mess(ld1,7,0,0);
                  write_mess(lk1,2,0,1);
                  defset:=1;
                  if lom[2]
                  then begin
                     write_mess(lm2,5,0,0);
                     write_mess(ld2,7,0,0);
                     write_mess(lk2,2,0,1)
                  end
                  else begin
                     write_mess(lm2,8,0,0);
                     write_mess(ld2,8,0,0);
                     write_mess(le5,8,0,1)
                  end;
                  if lom[3]
                  then begin
                     write_mess(lm3,5,0,0);
                     write_mess(ld3,7,0,0);
                     write_mess(lk3,2,0,1);
                     defset:=3;
                  end
                  else begin
                     write_mess(lm3,8,0,0);
                     write_mess(ld3,8,0,0);
                     write_mess(le5,8,0,1)
                  end;
                  write_mess(lm4,5,0,0);
                  write_mess(ld4,7,0,0);
                  write_mess(lk4,2,0,1);
                  oldx:=wherex;
                  oldy:=wherey;
                  case defset of
                     1: begin
                        gotoxy(59,wherey-4);
                        write_mess(' / < Enter >',2,0,0);
                     end;
                     3: begin
                        gotoxy(59,wherey-2);
                        write_mess(' / < Enter >',2,0,0);
                     end;
                  end;
                  gotoxy(oldx,oldy);
                  writeln;
                  writeln;
                  write_mess('',0,0,0);
2:                  repeat
                     check:=readkey
                  until not keypressed;
                  if ord(check)<>0
                  then begin
                     case check of
                        '1',#13: if ((check<>#13) OR (defset=1))
                           then
                              loadmode:=1;
                        '2': begin
                           if lom[2]
                           then
                              loadmode:=2
                           else
                              GoTo 2
                        end;
                        '3',#13: begin
                           if ((check<>#13) OR (defset=3)) AND (lom[3])
                           then
                              loadmode:=3
                           else
                              GoTo 2
                        end;
                        chr(27):
                           GoTo 1;
                        else
                           GoTo 2
                     end
                  end
                  else begin
                     check:=readkey;
                     GoTo 2
                  end
               end
               else begin
                  if ((loadstat[4]) or (loadstat[5])) and (auto)
                  then
                     loadmode:=3
               end;
(*               if (loadmode=3)
               then
                  trackswap
               else
                  trackdup;
*)               Assign(datei, neuname+'.trk');
               reset(datei);
               for fp:=1 to 900 do begin
                  read(datei,ch);
                  if loadmode=1
                  then begin
                     trackfield[1,fp]:=chr(0);
                     o_tf[1,fp]:=chr(0);
                     trackloaded:=false
                  end;
                  if loadmode=3
                  then begin
                     if ord(ch)>0
                     then
                        trackloaded:=true;
                     trackfield[1,fp]:=ch;
                     o_tf[1,fp]:=ch
                  end
               end;
               read(datei,horizchar[1]);
               for j:=1 to 30 do begin
                  for i:=1 to 30 do begin
                     read(datei,ch);
                     field[1,i,j]:=ord(ch);
                     inc(fp)
                  end
               end;
               oldname[1]:=neuname;
               read(datei,postchar[1]);
               close(datei);
               o_horizchar[1]:=horizchar[1];
               o_postchar[1]:=postchar[1];
               fieldcopy;
               goodsave:=true;
               getdir(0,oldpath[1]);
(*               write_mess(i2,2,0,0);
               delay(500);
               writeln;
               writeln;
               write_mess(i3,5,7,0);
               TextColor(7);
               clearline;
               readkey;
*)             menuon:=false;
               ok:=true;
               eingelesen:=true;
               if firstload
               then
                  trackdup;
            end
            else begin
               writeln;
               write_mess(w4,12,7,0);
               repeat
                  check:=readkey
               until not keypressed;
            end
         end;
         {$I+}
      end
   until (length(neuname)=0) or (ok=true);
   TextColor(7)
end;


procedure Vorspeichern;  (** Speichert Streckendatei **)
var i,j,fp,oldx,oldy:integer;
    ok,again:boolean;
    s:PathStr;
    som:array[1..3] of boolean;
    savestat:array[1..5] of boolean;
    sf_track:array[1..900] of char;
    sf_horizchar,sf_postchar:char;
    savemode:byte;
    neuname:string[8];
    neupath:DirStr;
    defset:byte;
Label 1,2;

begin
   {$I-};
   schdir(oldpath[1]);
   {$I+};
   repeat
1:      defset:=0;
      savemode:=3;
      som[1]:=true;     (* = Leerstreckenfeld auf Datei schreiben *)
      som[2]:=false;    (* = Altes Streckenfeld auf Datei erhalten *)
      som[3]:=false;    (* = Streckenfeld auf Datei schreiben *)
      savestat[1]:=false;
      savestat[2]:=false;
      savestat[3]:=false;
      savestat[4]:=false;
      trackloaded:=false;
      for i:=1 to 900 do begin
         if ord(trackfield[1,i])>0
         then begin
            trackloaded:=true;
            i:=900
         end
      end;
      savestat[5]:=trackloaded;
      TextColor(9);
      ok:=false;
      again:=false;
      neuname:='';
      clrscr;
      GoToXY(40-(length(m3)+1) div 2,3);
      writeln(m3);
      GoToXY(WhereX,7);
      write_mess(l1,5,7,0);
      neuname:=getfname(8,false);
      writeln;
      writeln;
      writeln;
      if neuname=#13
      then
         neuname:=oldname[1];
      if length(neuname)>0
      then begin
         {$I-}
         check:='S';
         getdir(0,neupath);
         if not ((oldname[1]=neuname) AND (oldpath[1]=neupath))
         then begin
            s := FSearch(neuname+'.trk','.');
            if S <> ''
            then begin   (* Vorhandene Datei *)
               savestat[1]:=true;
               if get_size(neuname+'.trk')=1802
               then begin   (* Gltige Gre *)
                  defset:=3;
                  savestat[2]:=true;
                  savestat[3]:=true;
                  assign(datei,neuname+'.trk');
                  reset(datei);
                  for i:=1 to 900 do begin
                     read(datei,ch);
                     if ord(ch)>0
                     then
                        savestat[4]:=true;
                     sf_track[i]:=ch
                  end;
                  read(datei,sf_horizchar);
                  for i:=1 to 900 do
                     read(datei,ch);
                  read(datei,sf_postchar);
                  close(datei)
               end
               else begin
                  if get_size(neuname+'.trk')>0   (* Grer als 0 *)
                  then
                     savestat[3]:=true
               end;
               if not savestat[5]
               then
                  defset:=1;
            end
            else begin
               defset:=3;
               if not savestat[5]
               then
                  defset:=1
            end;
         end;
         if savestat[1]
         then begin
            writeln;
            write_mess(ss11,12,0,1);
            if not savestat[2]
            then begin
               write_mess(ss20,12,0,1);
               if not savestat[3]
               then
                  write_mess(ss30,2,0,1)
               else
                  write_mess(ss31,12,1,1)
            end
            else begin
               if savestat[4]
               then begin
                  write_mess(ss41,12,1,1);
                  som[2]:=true
               end
               else
                  write_mess(ss40,2,1,1)
            end
         end;
         if not ((oldname[1]=neuname) AND (oldpath[1]=neupath))
         then begin
            if savestat[5]
            then begin
               if not savestat[1]
               then
                  writeln;
               write_mess(ss51,2,1,1);
               som[3]:=true
            end
            else
               if savestat[1]
               then
                  write_mess(ss50,2,1,1);
            writeln;
            if (savestat[1]) or (savestat[5])
            then begin
               write_mess(sm1,5,0,0);
               write_mess(sd1,7,0,0);
               write_mess(sk1,2,0,1);
               if som[2]
               then begin
                  write_mess(sm2,5,0,0);
                  write_mess(sd2,7,0,0);
                  write_mess(sk2,2,0,1)
               end
               else begin
                  write_mess(sm2,8,0,0);
                  write_mess(sd2,8,0,0);
                  write_mess(se5,8,0,1)
               end;
               if som[3]
               then begin
                  write_mess(sm3,5,0,0);
                  write_mess(sd3,7,0,0);
                  write_mess(sk3,2,0,1)
               end
               else begin
                  write_mess(sm3,8,0,0);
                  write_mess(sd3,8,0,0);
                  write_mess(se5,8,0,1)
               end;
               write_mess(sm4,5,0,0);
               write_mess(sd4,7,0,0);
               write_mess(sk4,2,0,1);
               oldx:=wherex;
               oldy:=wherey;
               case defset of
                  1: begin
                     gotoxy(59,wherey-4);
                     write_mess(' / < Enter >',2,0,0);
                  end;
                  3: begin
                     gotoxy(59,wherey-2);
                     write_mess(' / < Enter >',2,0,0);
                  end;
               end;
               gotoxy(oldx,oldy);
               writeln;
               writeln;
               write_mess('',0,0,0);
   2:            repeat
                  check:=readkey
               until not keypressed;
               if ord(check)<>0
               then begin
                  case check of
                     '1',#13: if ((check<>#13) OR (defset=1))
                        then
                           savemode:=1;
                     '2': begin
                        if som[2]
                        then
                           savemode:=2
                        else
                           GoTo 2
                     end;
                     '3',#13: begin
                        if ((check<>#13) OR (defset=3)) AND (som[3])
                        then
                           savemode:=3
                        else
                           GoTo 2
                     end;
                     chr(27):
                        GoTo 1;
                     else
                        GoTo 2
                  end
               end
               else begin
                  repeat
                     check:=readkey
                  until not keypressed;
                  GoTo 2
               end
            end;
         end
         else
            writeln;
         assign(datei,neuname+'.TRK');
         rewrite(datei);
         if IOResult=0
         then begin
            case savemode of
               1: begin
                  for fp:=1 to 900 do
                     write(datei,chr(0));
               end;
               2: begin
                  for fp:=1 to 900
                  do
                     write(datei,sf_track[fp]);
               end;
               3: begin
                  for fp:=1 to 900 do begin
                     write(datei,trackfield[1,fp]);
                     o_tf[1,fp]:=trackfield[1,fp]
                  end;
               end
            end;
            write(datei,horizchar[1]);
            for j:=1 to 30 do begin
               for i:=1 to 30 do begin
                  write(datei,chr(field[1,i,j]));
                  field_orig[1,i,j]:=field[1,i,j];
               end
            end;
            write(datei,postchar[1]);
            o_horizchar[1]:=horizchar[1];
            o_postchar[1]:=postchar[1];
            oldname[1]:=neuname;
            getdir(0,oldpath[1]);
            close(datei);
            write_mess(i7,2,0,0);
            delay(500);
            writeln;
            writeln;
            write_mess(i3,5,7,0);
            repeat
               readkey
            until not keypressed;
            ok:=true;
            goodsave:=true
         end
         else begin
            write_mess(w5,12,7,0);
            ok:=false
         end
         {$I+}
      end
   until (length(neuname)=0) or (ok=true);
   TextColor(7)
end;


procedure readopt;
var ok:boolean;
    i,j,zoi,zoj,code:integer;
    cfgname:string[12];
    optpath:string[30];
    oi,oj:string[2];
    props:string[3];
    datchar:char;
    optdatei:text;

begin
   optname:='';
   oi:='';
   oj:='';
      while keypressed do
         readkey;
      ok:=false;
      clrscr;
      cfgname:='TB.CFG';
      {$I-}
      schdir(progpath);
      assign(optdatei,cfgname);
      reset(optdatei);
      if IOResult<>0
      then begin
         writeln;
         writeln;
         write_mess(wo1,12,7,1);
         writeln;
         delay(500);
         while keypressed
         do
            readkey;
         write_mess(i3,5,7,0);
         contr:=readkey
      end
      else begin
         ok:=false;
         if eof(optdatei)=false
         then begin
            i:=0;
            repeat
               read(optdatei,datchar);
               datchar:=upcase(datchar);
               inc(i);
               if (ord(datchar)<>13) and (ord(datchar)<>10)
               then
                  optname:=optname+datchar
            until (eof(optdatei)) or (ord(datchar)=13);
            i:=0;
               if not eof(optdatei)
               then begin
                  optpath:='';
                  repeat
                     read(optdatei,datchar);
                     inc(i);
                     if (ord(datchar)<>13) and (ord(datchar)<>10)
                     then
                        optpath:=optpath+datchar
                  until (eof(optdatei)) or (ord(datchar)=13);
                  if (sChDir(optpath) <> 0)
                  then begin
                     write_mess(wov1,12,7,1);
                     write_mess(wov2,12,7,1);
                     optpath:='-';
                     writeln;
                     while keypressed
                     do
                        readkey;
                     write_mess(i3,5,7,0);
                     repeat
                        readkey
                     until not keypressed;
                     schdir(startpath)
                  end
                  else
                     oldpath[1]:=optpath;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           oi:=oi+datchar;
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                     val(oi,zoi,code);
                     if code=0
                     then begin
                        opti:=zoi;
                        ci:=opti;
                        oldi:=ci
                     end
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           oj:=oj+datchar;
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                     val(oj,zoj,code);
                     if code=0
                     then begin
                        optj:=zoj;
                        cj:=optj;
                        oldj:=cj
                     end
                  end;
                  i:=0;
                  while (not eof(optdatei)) AND (i<12)
                  do begin
                     props:='';
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           props:=props+datchar;
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                     val(props,zoj,code);
                     if code=0
                     then
                        verz_props[i]:=zoj;
                     inc(i);
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': housewater:=false;
                              '1': housewater:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': shipgrass:=false;
                              '1': shipgrass:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': objhill:=false;
                              '1': objhill:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': greeton:=false;
                              '1': greeton:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13);
                  end;
                  if not eof(optdatei)
                  then begin
                     repeat
                        read(optdatei,datchar);
                        if (ord(datchar)<>13) and (ord(datchar)<>10)
                        then begin
                           case datchar of
                              '0': megadrive:=false;
                              '1': megadrive:=true
                           end
                        end
                     until (eof(optdatei)) or (ord(datchar)=13)
                       or (datchar='0') or (datchar='1');
                     if ((length(optname)>0) AND (optpath<>'-'))
                     then
                        voreinlesen(true)
                  end
               end
         end;
         close(optdatei);
         ok:=true
      end;
      clrscr;
      {$I+};
end;


procedure saveopt;
const xbase=37;
      ybase=6;
var ok,gr_on:boolean;
    i,j,zoi,zoj:integer;
    n:string[8];
    cfgname:string[12];
    optpath,origpath:string[30];
    oi,oj:string[2];
    props:string[3];
    datchar,progmode,gr_on_c:char;
    optdatei:text;

begin
   while keypressed do
      readkey;
   clrscr;
   cfgname:='TB.CFG';
   n:=oldname[1];
   zoi:=oldi;
   zoj:=oldj;
   getdir(0,origpath);
   optpath:=origpath;
   if greeton
   then
      gr_on_c:=yes_char
   else
      gr_on_c:=no_char;
   progmode:=yes_char;
   repeat
      textcolor(9);
      GoToXY(40-(length(eo_1)+1) div 2,3);
      write(eo_1);
      Set_Color_To(8,7,0,3);
      box(xbase-2,ybase,xbase+31,ybase+11,0,'');
      Set_ScoreBoard_On;
      userset:=[yes_char,no_char,yes_low_char,no_low_char];
      userchar:='';
      SayGet(xbase,ybase+ 1,'',n,_S,8,1);
      Picture('@!');
      SayGet(xbase,ybase+ 3,'',optpath,_S,30,1);
      Picture('@!');
      SayGet(xbase,ybase+ 5,so4_1,zoj,_I,2,0);
      Picture('99');
      Range('1','30');
      SayGet(xbase+5+length(so4_1),ybase+ 5,so4_2,zoi,_I,2,0);
      Picture('99');
      Range('1','30');
      SayGet(xbase,ybase+ 7,'',gr_on_c,_C,1,0);
      Picture('');
      SayGet(xbase,ybase+ 10,'',progmode,_C,1,0);
      Picture('');
      textcolor(5);
      textbackground(0);
      GoToXY(6,ybase+1);
      write(so1);
      GoToXY(6,WhereY+2);
      write(so3);
      GoToXY(6,WhereY+2);
      write(so4);
      GoToXY(6,WhereY+2);
      write(so6);
      GoToXY(6,WhereY+3);
      write(so7);
      textcolor(2);
      gotoxy(wherex-9,wherey);
      write('[',yes_char,']/[',no_char,']');
      textcolor(7);
      ReadGets;
      if (editresult<>1)
      then begin
         str(zoi,oi);
         oldi:=zoi;
         ci:=zoi;
         str(zoj,oj);
         oldj:=zoj;
         cj:=zoj;
         gr_on_c:=upcase(gr_on_c);
         case gr_on_c of
            yes_char:
               gr_on:=true;
            no_char:
               gr_on:=false
         end;
         {$I-}
         progmode:=upcase(progmode);
         TextBackGround(0);
         GoToXY(1,22);
         case progmode of
            yes_char : begin
               schdir(progpath);
               assign(optdatei,cfgname);
               rewrite(optdatei);
               if IOResult=0
               then begin
                  write(optdatei,n,chr(13),chr(10));
                  write(optdatei,optpath,chr(13),chr(10));
                  write(optdatei,oi,chr(13),chr(10));
                  write(optdatei,oj,chr(13),chr(10));
                  for i:=0 to 11
                  do begin
                     str(verz_props[i],props);
                     write(optdatei,props,chr(13),chr(10));
                  end;
                  if housewater
                  then
                     write(optdatei,'1',chr(13),chr(10))
                  else
                     write(optdatei,'0',chr(13),chr(10));
                  if shipgrass
                  then
                     write(optdatei,'1',chr(13),chr(10))
                  else
                     write(optdatei,'0',chr(13),chr(10));
                  if objhill
                  then
                     write(optdatei,'1',chr(13),chr(10))
                  else
                     write(optdatei,'0',chr(13),chr(10));
                  if gr_on
                  then
                     write(optdatei,'1',chr(13),chr(10))
                  else
                     write(optdatei,'0',chr(13),chr(10));
                  if megadrive
                  then
                     write(optdatei,'1',chr(13),chr(10))
                  else
                     write(optdatei,'0');
                  close(optdatei);
                  write_mess(i7o,2,0,0)
               end
               else
                  write_mess(w5,12,7,0);
               delay(500);
               writeln;
               writeln;
               while keypressed
               do
                  readkey;
               write_mess(i3,5,7,0);
               repeat
                  readkey
               until not keypressed;
            end;
            no_char : begin

               (* Non-saving exit sequence *)

            end
         end;
         clrscr;
         textbackground(0);
         if (schdir(optpath) <> 0)
         then begin
            write_mess(o_cd1,12,7,1);
            write_mess(o_cd2,12,7,2);
            writeln;
            writeln;
            while keypressed
            do
               readkey;
            write_mess(i3,5,7,0);
            repeat
               readkey
            until not keypressed;
            schdir(origpath)
         end
         else begin
            getdir(0,optpath);
            if optpath<>origpath
            then begin
               writeln;
               write_mess(o_cd3,5,7,0);
               write_mess(origpath,2,7,1);
               write_mess(o_cd4,5,7,0);
               write_mess(optpath,2,7,1);
               writeln;
               write_mess(o_cd5,5,7,0);
               TextColor(2);
               write('< ',no_char,' >');
               TextColor(5);
               write('  ?   ');
               TextColor(7);
               write(yes_char);
               gotoxy(wherex-1,wherey);
               check:=upcase(readkey);
               if (check=no_char) or (ord(check)=27)
               then
                  schdir(origpath)
               else
                  check:=' ';
            end
         end;
         {$I+};
      end
      else
         textbackground(0);
   until true;
   greeton:=gr_on;
end;


procedure tb_begin;
var gd,gm:integer;
    i,j,pauswert : Integer;
    contr:char;
Label 1;

begin
   if greeton
   then
      delay(500);
   if (not keypressed) and (greeton)
   then begin
      Gd:=grdrvr;
      Gm:=grmode;
      InitGraph(Gd, Gm, '');
      if GraphResult <> grOk
      then begin
         sound(1000);
         delay(1000);
         NoSound;
         halt(1)
      end;
      i:=1;
      j:=2;
1:      repeat
         pauswert:=trunc(100*(exp(begverz*ln(2))-1));
         if beginsound
         then begin
            sound(j*100);
            delay(pauswert div 2);
            sound(i*100);
            delay(pauswert div 2)
         end
         else
            delay(pauswert);
(*    NoSound;*)
         SetTextStyle(4, HorizDir, 10);
         SetTextJustify(CenterText, CenterText);
         SetColor(j);
         OutTextXY(Succ(GetMaxX) div 2,
           round(getmaxy/480*60-10*egamode),'Track');
         SetColor(i);
         OutTextXY(Succ(GetMaxX) div 2,
           round(getmaxy/480*160+10*egamode),'Blaster');
         setcolor(3);
         SetTextStyle(1, HorizDir, 4);
         outtextxy(540,round(getmaxy/480*200+23*egamode),'P');
         outtextxy(570,round(getmaxy/480*187+23*egamode),'R');
         outtextxy(600,round(getmaxy/480*180+23*egamode),'O');
         if (egamode=1)
         then begin
            arc(650,round(350/480*425)+13,96,125,200);
            arc(650,round(350/480*421)+13,97,126,195);
            arc(650,round(350/480*420)+13,102,126,195);
            arc(650,round(350/480*415)+13,100,127,190);
            arc(650,round(350/480*410)+13,100,128,185);
            arc(650,round(350/480*405)+13,100,129,180);
            putpixel(543,194,3);
            putpixel(534,198,3);
            putpixel(534,197,3);
         end
         else begin
            arc(650,400,95,125,200);
            arc(650,395,100,126,195);
            arc(650,390,100,127,190);
            arc(650,385,100,128,185);
            arc(650,380,100,129,180);
         end;
         SetColor(1);
         SetTextStyle(1, HorizDir, 6);
         OutTextXY(Succ(GetMaxX) div 2,
           round(getmaxy/480*300+10*egamode),'Ver. 5.3');
         SetColor(13);
         SetTextStyle(2, HorizDir, 6);
         OutTextXY(Succ(GetMaxX) div 2,round(getmaxy/480*430+10*egamode),b1);
         inc(i);
         inc(j);
         if i=16
         then
            i:=1;
         if j=16
         then
            j:=1
      until keypressed=true;
      contr:=readkey;
      case contr of
         '+': begin
            if begverz>0
            then
               dec(begverz);
            goto 1
         end;
         '-': begin
            if begverz<5
            then
               inc(begverz);
            goto 1
         end;
         chr(0): begin
            contr:=readkey;
            case ord(contr) of
               88: begin
                  beginsound:=true;
                  goto 1
               end;
               63: begin
                  beginsound:=false;
                  NoSound;
                  goto 1
               end;
            end
         end
      end;
      CloseGraph;
      NoSound
   end;
   while keypressed
   do
      check:=readkey
end;


procedure mainhelp;

begin
   clrscr;
   TextColor(9);
   GoToXY(40-(length(m4)+1) div 2,1);
   writeln(m4);
   writeln;
   TextColor(7);
   write(h1);
   TextColor(c_text_key);
   write('  < F2 >  ');
   TextColor(7);
   writeln(h2);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F3 >  ');
   TextColor(7);
   writeln(h3);
   writeln(h31);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F4 >  ');
   TextColor(7);
   writeln(h4);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F5 >  ');
   TextColor(7);
   writeln(h5);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F6 >  ');
   TextColor(7);
   writeln(h6);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < F9 >  ');
   TextColor(7);
   writeln(h9);
   writeln;
   write(h1);
   TextColor(c_text_key);
   write('  < Esc >  ');
   TextColor(7);
   writeln(h10);
   writeln(h31);
   writeln;
   TextColor(7);
   while keypressed
   do
      readkey;
   write_mess(i3,5,7,0);
   repeat
      readkey
   until not keypressed;
end;


procedure tb_init;

begin
   if RegisterBGIdriver(@EGAVGADriverProc) < 0 then
     Abort('EGA/VGA');
   if RegisterBGIfont(@GothicFontProc) < 0 then
     Abort('Gothic');
   if RegisterBGIfont(@SansSerifFontProc) < 0 then
     Abort('SansSerif');
   if RegisterBGIfont(@SmallFontProc) < 0 then
     Abort('Small');
   if RegisterBGIfont(@TriplexFontProc) < 0 then
     Abort('Triplex');
   for i:=1 to 30
   do
      for j:=1 to 30
      do begin
         field[1,i,j]:=0;
         field[2,i,j]:=0;
         field_orig[1,i,j]:=0;
         field_orig[2,i,j]:=0;
         trackfield[1,i+(j-1)*30]:=chr(0);
         trackfield[2,i+(j-1)*30]:=chr(0);
         o_tf[1,i+(j-1)*30]:=chr(0);
         o_tf[2,i+(j-1)*30]:=chr(0);
         horizchar[1]:=chr(0);
         horizchar[2]:=chr(0);
         postchar[1]:=chr(0);
         postchar[2]:=chr(0);
      end;
   for i:=0 to 255 do
      multiel[i]:=0;
   for i:=0 to 2 do
      for j:=0 to 2 do
         pretrack_set[i,j]:=false;
   multiel[10]:=3;
   multiel[11]:=3;
   multiel[12]:=3;
   multiel[13]:=3;
   multiel[20]:=3;
   multiel[21]:=3;
   multiel[22]:=3;
   multiel[23]:=3;
   multiel[30]:=3;
   multiel[31]:=3;
   multiel[32]:=3;
   multiel[33]:=3;
   multiel[52]:=3;
   multiel[53]:=3;
   multiel[54]:=3;
   multiel[55]:=3;
   multiel[60]:=3;
   multiel[61]:=3;
   multiel[62]:=3;
   multiel[63]:=3;
   multiel[64]:=2;
   multiel[65]:=1;
   multiel[85]:=2;
   multiel[86]:=1;
   multiel[87]:=3;
   multiel[88]:=3;
   multiel[89]:=3;
   multiel[90]:=3;
   multiel[91]:=3;
   multiel[92]:=3;
   multiel[93]:=3;
   multiel[94]:=3;
   multiel[105]:=3;
   multiel[106]:=3;
   multiel[107]:=3;
   multiel[108]:=3;
   multiel[117]:=3;
   multiel[118]:=3;
   multiel[119]:=3;
   multiel[120]:=3;
   multiel[121]:=3;
   multiel[122]:=3;
   multiel[123]:=3;
   multiel[124]:=3;
   tsf[ 1,1,1]:=  0;
   tsf[ 1,2,1]:=  6;
   tsf[ 1,3,1]:=  5;
   tsf[ 1,4,1]:=  7;
   tsf[ 1,5,1]:=  1;
   tsf[ 1,6,1]:=180;
   tsf[ 1,1,2]:= 74;
   tsf[ 1,2,2]:=  4;
   tsf[ 1,3,2]:=  8;
   tsf[ 1,4,2]:=  9;
   tsf[ 1,5,2]:=179;
   tsf[ 1,6,2]:=181;
   tsf[ 1,1,3]:= 10;
   tsf[ 1,2,3]:=255;
   tsf[ 1,3,3]:= 11;
   tsf[ 1,4,3]:=255;
   tsf[ 1,5,3]:= 76;
   tsf[ 1,6,3]:= 82;
   tsf[ 1,1,4]:=254;
   tsf[ 1,2,4]:=253;
   tsf[ 1,3,4]:=254;
   tsf[ 1,4,4]:=253;
   tsf[ 1,5,4]:= 80;
   tsf[ 1,6,4]:= 78;
   tsf[ 1,1,5]:= 12;
   tsf[ 1,2,5]:=255;
   tsf[ 1,3,5]:= 13;
   tsf[ 1,4,5]:=255;
   tsf[ 1,5,5]:= 79;
   tsf[ 1,6,5]:= 75;
   tsf[ 1,1,6]:=254;
   tsf[ 1,2,6]:=253;
   tsf[ 1,3,6]:=254;
   tsf[ 1,4,6]:=253;
   tsf[ 1,5,6]:= 77;
   tsf[ 1,6,6]:= 81;
   tsf[ 2,1,1]:=  0;
   tsf[ 2,2,1]:= 16;
   tsf[ 2,3,1]:= 15;
   tsf[ 2,4,1]:= 17;
   tsf[ 2,5,1]:=134;
   tsf[ 2,6,1]:=136;
   tsf[ 2,1,2]:=125;
   tsf[ 2,2,2]:= 14;
   tsf[ 2,3,2]:= 18;
   tsf[ 2,4,2]:= 19;
   tsf[ 2,5,2]:=135;
   tsf[ 2,6,2]:=137;
   tsf[ 2,1,3]:= 20;
   tsf[ 2,2,3]:=255;
   tsf[ 2,3,3]:= 21;
   tsf[ 2,4,3]:=255;
   tsf[ 2,5,3]:=127;
   tsf[ 2,6,3]:=133;
   tsf[ 2,1,4]:=254;
   tsf[ 2,2,4]:=253;
   tsf[ 2,3,4]:=254;
   tsf[ 2,4,4]:=253;
   tsf[ 2,5,4]:=131;
   tsf[ 2,6,4]:=129;
   tsf[ 2,1,5]:= 22;
   tsf[ 2,2,5]:=255;
   tsf[ 2,3,5]:= 23;
   tsf[ 2,4,5]:=255;
   tsf[ 2,5,5]:=130;
   tsf[ 2,6,5]:=126;
   tsf[ 2,1,6]:=254;
   tsf[ 2,2,6]:=253;
   tsf[ 2,3,6]:=254;
   tsf[ 2,4,6]:=253;
   tsf[ 2,5,6]:=128;
   tsf[ 2,6,6]:=132;
   tsf[ 3,1,1]:=  0;
   tsf[ 3,2,1]:= 26;
   tsf[ 3,3,1]:= 25;
   tsf[ 3,4,1]:= 27;
   tsf[ 3,5,1]:=147;
   tsf[ 3,6,1]:=149;
   tsf[ 3,1,2]:=138;
   tsf[ 3,2,2]:= 24;
   tsf[ 3,3,2]:= 28;
   tsf[ 3,4,2]:= 29;
   tsf[ 3,5,2]:=148;
   tsf[ 3,6,2]:=150;
   tsf[ 3,1,3]:= 30;
   tsf[ 3,2,3]:=255;
   tsf[ 3,3,3]:= 31;
   tsf[ 3,4,3]:=255;
   tsf[ 3,5,3]:=140;
   tsf[ 3,6,3]:=146;
   tsf[ 3,1,4]:=254;
   tsf[ 3,2,4]:=253;
   tsf[ 3,3,4]:=254;
   tsf[ 3,4,4]:=253;
   tsf[ 3,5,4]:=144;
   tsf[ 3,6,4]:=142;
   tsf[ 3,1,5]:= 32;
   tsf[ 3,2,5]:=255;
   tsf[ 3,3,5]:= 33;
   tsf[ 3,4,5]:=255;
   tsf[ 3,5,5]:=143;
   tsf[ 3,6,5]:=139;
   tsf[ 3,1,6]:=254;
   tsf[ 3,2,6]:=253;
   tsf[ 3,3,6]:=254;
   tsf[ 3,4,6]:=253;
   tsf[ 3,5,6]:=141;
   tsf[ 3,6,6]:=145;
   tsf[ 4,1,1]:=  0;
   tsf[ 4,2,1]:=  0;
   tsf[ 4,3,1]:=115;
   tsf[ 4,4,1]:= 59;
   tsf[ 4,5,1]:= 71;
   tsf[ 4,6,1]:= 64;
   tsf[ 4,1,2]:= 56;
   tsf[ 4,2,2]:= 57;
   tsf[ 4,3,2]:=116;
   tsf[ 4,4,2]:= 58;
   tsf[ 4,5,2]:= 68;
   tsf[ 4,6,2]:=254;
   tsf[ 4,1,3]:= 73;
   tsf[ 4,2,3]:= 69;
   tsf[ 4,3,3]:= 84;
   tsf[ 4,4,3]:= 72;
   tsf[ 4,5,3]:= 83;
   tsf[ 4,6,3]:= 85;
   tsf[ 4,1,4]:= 65;
   tsf[ 4,2,4]:=255;
   tsf[ 4,3,4]:= 86;
   tsf[ 4,4,4]:=255;
   tsf[ 4,5,4]:= 70;
   tsf[ 4,6,4]:=254;
   tsf[ 4,1,5]:= 66;
   tsf[ 4,2,5]:=  0;
   tsf[ 4,3,5]:=  0;
   tsf[ 4,4,5]:=  0;
   tsf[ 4,5,5]:=  0;
   tsf[ 4,6,5]:=  0;
   tsf[ 4,1,6]:= 67;
   tsf[ 4,2,6]:=  0;
   tsf[ 4,3,6]:=  0;
   tsf[ 4,4,6]:=  0;
   tsf[ 4,5,6]:=  0;
   tsf[ 4,6,6]:=  0;
   tsf[ 5,1,1]:=  0;
   tsf[ 5,2,1]:= 41;
   tsf[ 5,3,1]:= 50;
   tsf[ 5,4,1]:= 47;
   tsf[ 5,5,1]:= 46;
   tsf[ 5,6,1]:= 42;
   tsf[ 5,1,2]:=  0;
   tsf[ 5,2,2]:= 45;
   tsf[ 5,3,2]:= 51;
   tsf[ 5,4,2]:= 43;
   tsf[ 5,5,2]:= 48;
   tsf[ 5,6,2]:= 49;
   tsf[ 5,1,3]:= 52;
   tsf[ 5,2,3]:=255;
   tsf[ 5,3,3]:= 53;
   tsf[ 5,4,3]:=255;
   tsf[ 5,5,3]:= 40;
   tsf[ 5,6,3]:= 44;
   tsf[ 5,1,4]:=254;
   tsf[ 5,2,4]:=253;
   tsf[ 5,3,4]:=254;
   tsf[ 5,4,4]:=253;
   tsf[ 5,5,4]:=  0;
   tsf[ 5,6,4]:=  0;
   tsf[ 5,1,5]:= 54;
   tsf[ 5,2,5]:=255;
   tsf[ 5,3,5]:= 55;
   tsf[ 5,4,5]:=255;
   tsf[ 5,5,5]:=  0;
   tsf[ 5,6,5]:=  0;
   tsf[ 5,1,6]:=254;
   tsf[ 5,2,6]:=253;
   tsf[ 5,3,6]:=254;
   tsf[ 5,4,6]:=253;
   tsf[ 5,5,6]:=  0;
   tsf[ 5,6,6]:=  0;
   tsf[ 6,1,1]:=  0;
   tsf[ 6,2,1]:=  0;
   tsf[ 6,3,1]:= 91;
   tsf[ 6,4,1]:=255;
   tsf[ 6,5,1]:= 87;
   tsf[ 6,6,1]:=255;
   tsf[ 6,1,2]:=  0;
   tsf[ 6,2,2]:=  0;
   tsf[ 6,3,2]:=254;
   tsf[ 6,4,2]:=253;
   tsf[ 6,5,2]:=254;
   tsf[ 6,6,2]:=253;
   tsf[ 6,1,3]:= 92;
   tsf[ 6,2,3]:=255;
   tsf[ 6,3,3]:= 89;
   tsf[ 6,4,3]:=255;
   tsf[ 6,5,3]:= 93;
   tsf[ 6,6,3]:=255;
   tsf[ 6,1,4]:=254;
   tsf[ 6,2,4]:=253;
   tsf[ 6,3,4]:=254;
   tsf[ 6,4,4]:=253;
   tsf[ 6,5,4]:=254;
   tsf[ 6,6,4]:=253;
   tsf[ 6,1,5]:= 90;
   tsf[ 6,2,5]:=255;
   tsf[ 6,3,5]:= 88;
   tsf[ 6,4,5]:=255;
   tsf[ 6,5,5]:= 94;
   tsf[ 6,6,5]:=255;
   tsf[ 6,1,6]:=254;
   tsf[ 6,2,6]:=253;
   tsf[ 6,3,6]:=254;
   tsf[ 6,4,6]:=253;
   tsf[ 6,5,6]:=254;
   tsf[ 6,6,6]:=253;
   tsf[ 7,1,1]:=  0;
   tsf[ 7,2,1]:=  0;
   tsf[ 7,3,1]:=112;
   tsf[ 7,4,1]:=110;
   tsf[ 7,5,1]:=114;
   tsf[ 7,6,1]:=113;
   tsf[ 7,1,2]:=  0;
   tsf[ 7,2,2]:=  0;
   tsf[ 7,3,2]:=  0;
   tsf[ 7,4,2]:=  0;
   tsf[ 7,5,2]:=  0;
   tsf[ 7,6,2]:=109;
   tsf[ 7,1,3]:= 60;
   tsf[ 7,2,3]:=255;
   tsf[ 7,3,3]:= 61;
   tsf[ 7,4,3]:=255;
   tsf[ 7,5,3]:=  0;
   tsf[ 7,6,3]:=111;
   tsf[ 7,1,4]:=254;
   tsf[ 7,2,4]:=253;
   tsf[ 7,3,4]:=254;
   tsf[ 7,4,4]:=253;
   tsf[ 7,5,4]:=  0;
   tsf[ 7,6,4]:=  0;
   tsf[ 7,1,5]:= 62;
   tsf[ 7,2,5]:=255;
   tsf[ 7,3,5]:= 63;
   tsf[ 7,4,5]:=255;
   tsf[ 7,5,5]:=  0;
   tsf[ 7,6,5]:=  0;
   tsf[ 7,1,6]:=254;
   tsf[ 7,2,6]:=253;
   tsf[ 7,3,6]:=254;
   tsf[ 7,4,6]:=253;
   tsf[ 7,5,6]:=  0;
   tsf[ 7,6,6]:=  0;
   tsf[ 8,1,1]:=  0;
   tsf[ 8,2,1]:=  0;
   tsf[ 8,3,1]:= 36;
   tsf[ 8,4,1]:= 35;
   tsf[ 8,5,1]:=104;
   tsf[ 8,6,1]:= 37;
   tsf[ 8,1,2]:=  0;
   tsf[ 8,2,2]:=  0;
   tsf[ 8,3,2]:= 95;
   tsf[ 8,4,2]:=102;
   tsf[ 8,5,2]:=100;
   tsf[ 8,6,2]:= 96;
   tsf[ 8,1,3]:=105;
   tsf[ 8,2,3]:=255;
   tsf[ 8,3,3]:=106;
   tsf[ 8,4,3]:=255;
   tsf[ 8,5,3]:= 39;
   tsf[ 8,6,3]:= 98;
   tsf[ 8,1,4]:=254;
   tsf[ 8,2,4]:=253;
   tsf[ 8,3,4]:=254;
   tsf[ 8,4,4]:=253;
   tsf[ 8,5,4]:= 34;
   tsf[ 8,6,4]:=101;
   tsf[ 8,1,5]:=107;
   tsf[ 8,2,5]:=255;
   tsf[ 8,3,5]:=108;
   tsf[ 8,4,5]:=255;
   tsf[ 8,5,5]:=103;
   tsf[ 8,6,5]:= 99;
   tsf[ 8,1,6]:=254;
   tsf[ 8,2,6]:=253;
   tsf[ 8,3,6]:=254;
   tsf[ 8,4,6]:=253;
   tsf[ 8,5,6]:= 38;
   tsf[ 8,6,6]:= 97;
   tsf[ 9,1,1]:=  0;
   tsf[ 9,2,1]:=  0;
   tsf[ 9,3,1]:=119;
   tsf[ 9,4,1]:=255;
   tsf[ 9,5,1]:=123;
   tsf[ 9,6,1]:=255;
   tsf[ 9,1,2]:=  0;
   tsf[ 9,2,2]:=  0;
   tsf[ 9,3,2]:=254;
   tsf[ 9,4,2]:=253;
   tsf[ 9,5,2]:=254;
   tsf[ 9,6,2]:=253;
   tsf[ 9,1,3]:=120;
   tsf[ 9,2,3]:=255;
   tsf[ 9,3,3]:=121;
   tsf[ 9,4,3]:=255;
   tsf[ 9,5,3]:=117;
   tsf[ 9,6,3]:=255;
   tsf[ 9,1,4]:=254;
   tsf[ 9,2,4]:=253;
   tsf[ 9,3,4]:=254;
   tsf[ 9,4,4]:=253;
   tsf[ 9,5,4]:=254;
   tsf[ 9,6,4]:=253;
   tsf[ 9,1,5]:=122;
   tsf[ 9,2,5]:=255;
   tsf[ 9,3,5]:=124;
   tsf[ 9,4,5]:=255;
   tsf[ 9,5,5]:=118;
   tsf[ 9,6,5]:=255;
   tsf[ 9,1,6]:=254;
   tsf[ 9,2,6]:=253;
   tsf[ 9,3,6]:=254;
   tsf[ 9,4,6]:=253;
   tsf[ 9,5,6]:=254;
   tsf[ 9,6,6]:=253;
   tsf[10,1,1]:=  0;
   tsf[10,2,1]:=  0;
   tsf[10,3,1]:=163;
   tsf[10,4,1]:=164;
   tsf[10,5,1]:=165;
   tsf[10,6,1]:=166;
   tsf[10,1,2]:=153;
   tsf[10,2,2]:=  0;
   tsf[10,3,2]:=159;
   tsf[10,4,2]:=160;
   tsf[10,5,2]:=161;
   tsf[10,6,2]:=162;
   tsf[10,1,3]:=152;
   tsf[10,2,3]:=  0;
   tsf[10,3,3]:=155;
   tsf[10,4,3]:=156;
   tsf[10,5,3]:=157;
   tsf[10,6,3]:=158;
   tsf[10,1,4]:=151;
   tsf[10,2,4]:=  0;
   tsf[10,3,4]:=167;
   tsf[10,4,4]:=168;
   tsf[10,5,4]:=169;
   tsf[10,6,4]:=170;
   tsf[10,1,5]:=154;
   tsf[10,2,5]:=  0;
   tsf[10,3,5]:=171;
   tsf[10,4,5]:=172;
   tsf[10,5,5]:=173;
   tsf[10,6,5]:=174;
   tsf[10,1,6]:=  2;
   tsf[10,2,6]:=  0;
   tsf[10,3,6]:=175;
   tsf[10,4,6]:=176;
   tsf[10,5,6]:=177;
   tsf[10,6,6]:=178;
   strafo[  6].x :=  8;
   strafo[  6].y :=  7;
   strafo[  6].xy:=  9;
   strafo[  5].x :=  5;
   strafo[  5].y :=  5;
   strafo[  5].xy:=  5;
   strafo[  7].x :=  9;
   strafo[  7].y :=  6;
   strafo[  7].xy:=  8;
   strafo[  1].x :=179;
   strafo[  1].y :=  1;
   strafo[  1].xy:=179;
   strafo[180].x :=180;
   strafo[180].y :=181;
   strafo[180].xy:=181;
   strafo[ 74].x := 74;
   strafo[ 74].y := 74;
   strafo[ 74].xy:= 74;
   strafo[  4].x :=  4;
   strafo[  4].y :=  4;
   strafo[  4].xy:=  4;
   strafo[  8].x :=  6;
   strafo[  8].y :=  9;
   strafo[  8].xy:=  7;
   strafo[  9].x :=  7;
   strafo[  9].y :=  8;
   strafo[  9].xy:=  6;
   strafo[179].x :=  1;
   strafo[179].y :=179;
   strafo[179].xy:=  1;
   strafo[181].x :=181;
   strafo[181].y :=180;
   strafo[181].xy:=180;
   strafo[ 10].x := 12;
   strafo[ 10].y := 11;
   strafo[ 10].xy:= 13;
   strafo[ 11].x := 13;
   strafo[ 11].y := 10;
   strafo[ 11].xy:= 12;
   strafo[ 76].x := 80;
   strafo[ 76].y := 82;
   strafo[ 76].xy:= 78;
   strafo[ 82].x := 78;
   strafo[ 82].y := 76;
   strafo[ 82].xy:= 78;
   strafo[ 80].x := 76;
   strafo[ 80].y := 78;
   strafo[ 80].xy:= 82;
   strafo[ 78].x := 82;
   strafo[ 78].y := 80;
   strafo[ 78].xy:= 76;
   strafo[ 12].x := 10;
   strafo[ 12].y := 13;
   strafo[ 12].xy:= 11;
   strafo[ 13].x := 11;
   strafo[ 13].y := 12;
   strafo[ 13].xy:= 10;
   strafo[ 79].x := 77;
   strafo[ 79].y := 75;
   strafo[ 79].xy:= 81;
   strafo[ 75].x := 81;
   strafo[ 75].y := 79;
   strafo[ 75].xy:= 77;
   strafo[ 77].x := 79;
   strafo[ 77].y := 81;
   strafo[ 77].xy:= 75;
   strafo[ 81].x := 75;
   strafo[ 81].y := 77;
   strafo[ 81].xy:= 79;
   strafo[ 16].x := 18;
   strafo[ 16].y := 17;
   strafo[ 16].xy:= 19;
   strafo[ 15].x := 15;
   strafo[ 15].y := 15;
   strafo[ 15].xy:= 15;
   strafo[ 17].x := 19;
   strafo[ 17].y := 16;
   strafo[ 17].xy:= 18;
   strafo[134].x :=135;
   strafo[134].y :=134;
   strafo[134].xy:=135;
   strafo[136].x :=136;
   strafo[136].y :=137;
   strafo[136].xy:=137;
   strafo[125].x :=125;
   strafo[125].y :=125;
   strafo[125].xy:=125;
   strafo[ 14].x := 14;
   strafo[ 14].y := 14;
   strafo[ 14].xy:= 14;
   strafo[ 18].x := 16;
   strafo[ 18].y := 19;
   strafo[ 18].xy:= 17;
   strafo[ 19].x := 17;
   strafo[ 19].y := 18;
   strafo[ 19].xy:= 16;
   strafo[135].x :=134;
   strafo[135].y :=135;
   strafo[135].xy:=134;
   strafo[137].x :=137;
   strafo[137].y :=136;
   strafo[137].xy:=136;
   strafo[ 20].x := 22;
   strafo[ 20].y := 21;
   strafo[ 20].xy:= 23;
   strafo[ 21].x := 23;
   strafo[ 21].y := 20;
   strafo[ 21].xy:= 22;
   strafo[127].x :=131;
   strafo[127].y :=133;
   strafo[127].xy:=129;
   strafo[133].x :=129;
   strafo[133].y :=127;
   strafo[133].xy:=131;
   strafo[131].x :=127;
   strafo[131].y :=129;
   strafo[131].xy:=133;
   strafo[129].x :=133;
   strafo[129].y :=131;
   strafo[129].xy:=127;
   strafo[ 22].x := 20;
   strafo[ 22].y := 23;
   strafo[ 22].xy:= 21;
   strafo[ 23].x := 21;
   strafo[ 23].y := 22;
   strafo[ 23].xy:= 20;
   strafo[130].x :=128;
   strafo[130].y :=126;
   strafo[130].xy:=132;
   strafo[126].x :=132;
   strafo[126].y :=130;
   strafo[126].xy:=128;
   strafo[128].x :=130;
   strafo[128].y :=132;
   strafo[128].xy:=126;
   strafo[132].x :=126;
   strafo[132].y :=128;
   strafo[132].xy:=130;
   strafo[ 26].x := 28;
   strafo[ 26].y := 27;
   strafo[ 26].xy:= 29;
   strafo[ 25].x := 25;
   strafo[ 25].y := 25;
   strafo[ 25].xy:= 25;
   strafo[ 27].x := 29;
   strafo[ 27].y := 26;
   strafo[ 27].xy:= 28;
   strafo[147].x :=148;
   strafo[147].y :=147;
   strafo[147].xy:=148;
   strafo[149].x :=149;
   strafo[149].y :=150;
   strafo[149].xy:=150;
   strafo[138].x :=138;
   strafo[138].y :=138;
   strafo[138].xy:=138;
   strafo[ 24].x := 24;
   strafo[ 24].y := 24;
   strafo[ 24].xy:= 24;
   strafo[ 28].x := 26;
   strafo[ 28].y := 29;
   strafo[ 28].xy:= 27;
   strafo[ 29].x := 27;
   strafo[ 29].y := 28;
   strafo[ 29].xy:= 26;
   strafo[148].x :=147;
   strafo[148].y :=148;
   strafo[148].xy:=147;
   strafo[150].x :=150;
   strafo[150].y :=149;
   strafo[150].xy:=149;
   strafo[ 30].x := 32;
   strafo[ 30].y := 31;
   strafo[ 30].xy:= 33;
   strafo[ 31].x := 33;
   strafo[ 31].y := 30;
   strafo[ 31].xy:= 32;
   strafo[140].x :=144;
   strafo[140].y :=146;
   strafo[140].xy:=142;
   strafo[146].x :=142;
   strafo[146].y :=140;
   strafo[146].xy:=144;
   strafo[144].x :=140;
   strafo[144].y :=142;
   strafo[144].xy:=146;
   strafo[142].x :=146;
   strafo[142].y :=144;
   strafo[142].xy:=140;
   strafo[ 32].x := 30;
   strafo[ 32].y := 33;
   strafo[ 32].xy:= 31;
   strafo[ 33].x := 31;
   strafo[ 33].y := 32;
   strafo[ 33].xy:= 30;
   strafo[143].x :=141;
   strafo[143].y :=139;
   strafo[143].xy:=145;
   strafo[139].x :=145;
   strafo[139].y :=143;
   strafo[139].xy:=141;
   strafo[141].x :=143;
   strafo[141].y :=145;
   strafo[141].xy:=139;
   strafo[145].x :=139;
   strafo[145].y :=141;
   strafo[145].xy:=143;
   strafo[115].x :=115;
   strafo[115].y :=115;
   strafo[115].xy:=115;
   strafo[ 59].x := 58;
   strafo[ 59].y := 59;
   strafo[ 59].xy:= 58;
   strafo[ 71].x := 70;
   strafo[ 71].y := 71;
   strafo[ 71].xy:= 70;
   strafo[ 64].x := 64;
   strafo[ 64].y := 64;
   strafo[ 64].xy:= 64;
   strafo[ 56].x := 56;
   strafo[ 56].y := 57;
   strafo[ 56].xy:= 57;
   strafo[ 57].x := 57;
   strafo[ 57].y := 56;
   strafo[ 57].xy:= 56;
   strafo[116].x :=116;
   strafo[116].y :=116;
   strafo[116].xy:=116;
   strafo[ 58].x := 59;
   strafo[ 58].y := 58;
   strafo[ 58].xy:= 59;
   strafo[ 68].x := 68;
   strafo[ 68].y := 68;
   strafo[ 68].xy:= 68;
   strafo[ 73].x := 73;
   strafo[ 73].y := 72;
   strafo[ 73].xy:= 72;
   strafo[ 69].x := 69;
   strafo[ 69].y := 69;
   strafo[ 69].xy:= 69;
   strafo[ 84].x := 84;
   strafo[ 84].y := 84;
   strafo[ 84].xy:= 84;
   strafo[ 72].x := 72;
   strafo[ 72].y := 73;
   strafo[ 72].xy:= 73;
   strafo[ 83].x := 83;
   strafo[ 83].y := 83;
   strafo[ 83].xy:= 83;
   strafo[ 85].x := 85;
   strafo[ 85].y := 85;
   strafo[ 85].xy:= 85;
   strafo[ 65].x := 65;
   strafo[ 65].y := 65;
   strafo[ 65].xy:= 65;
   strafo[ 86].x := 86;
   strafo[ 86].y := 86;
   strafo[ 86].xy:= 86;
   strafo[ 70].x := 71;
   strafo[ 70].y := 70;
   strafo[ 70].xy:= 71;
   strafo[ 66].x := 66;
   strafo[ 66].y := 66;
   strafo[ 66].xy:= 66;
   strafo[ 67].x := 67;
   strafo[ 67].y := 67;
   strafo[ 67].xy:= 67;
   strafo[ 41].x := 45;
   strafo[ 41].y := 47;
   strafo[ 41].xy:= 43;
   strafo[ 50].x := 51;
   strafo[ 50].y := 50;
   strafo[ 50].xy:= 51;
   strafo[ 47].x := 43;
   strafo[ 47].y := 41;
   strafo[ 47].xy:= 45;
   strafo[ 46].x := 40;
   strafo[ 46].y := 42;
   strafo[ 46].xy:= 44;
   strafo[ 42].x := 44;
   strafo[ 42].y := 46;
   strafo[ 42].xy:= 40;
   strafo[ 45].x := 41;
   strafo[ 45].y := 43;
   strafo[ 45].xy:= 47;
   strafo[ 51].x := 50;
   strafo[ 51].y := 51;
   strafo[ 51].xy:= 50;
   strafo[ 43].x := 47;
   strafo[ 43].y := 45;
   strafo[ 43].xy:= 41;
   strafo[ 48].x := 48;
   strafo[ 48].y := 49;
   strafo[ 48].xy:= 49;
   strafo[ 49].x := 49;
   strafo[ 49].y := 48;
   strafo[ 49].xy:= 48;
   strafo[ 52].x := 54;
   strafo[ 52].y := 53;
   strafo[ 52].xy:= 55;
   strafo[ 53].x := 55;
   strafo[ 53].y := 52;
   strafo[ 53].xy:= 54;
   strafo[ 40].x := 46;
   strafo[ 40].y := 44;
   strafo[ 40].xy:= 42;
   strafo[ 44].x := 42;
   strafo[ 44].y := 40;
   strafo[ 44].xy:= 46;
   strafo[ 54].x := 52;
   strafo[ 54].y := 55;
   strafo[ 54].xy:= 53;
   strafo[ 55].x := 53;
   strafo[ 55].y := 54;
   strafo[ 55].xy:= 52;
   strafo[ 91].x := 89;
   strafo[ 91].y := 87;
   strafo[ 91].xy:= 93;
   strafo[ 87].x := 93;
   strafo[ 87].y := 91;
   strafo[ 87].xy:= 89;
   strafo[ 92].x := 88;
   strafo[ 92].y := 90;
   strafo[ 92].xy:= 94;
   strafo[ 89].x := 91;
   strafo[ 89].y := 93;
   strafo[ 89].xy:= 87;
   strafo[ 93].x := 87;
   strafo[ 93].y := 89;
   strafo[ 93].xy:= 91;
   strafo[ 90].x := 94;
   strafo[ 90].y := 92;
   strafo[ 90].xy:= 88;
   strafo[ 88].x := 92;
   strafo[ 88].y := 94;
   strafo[ 88].xy:= 90;
   strafo[ 94].x := 90;
   strafo[ 94].y := 88;
   strafo[ 94].xy:= 92;
   strafo[112].x :=112;
   strafo[112].y :=114;
   strafo[112].xy:=114;
   strafo[110].x :=110;
   strafo[110].y :=110;
   strafo[110].xy:=110;
   strafo[114].x :=114;
   strafo[114].y :=112;
   strafo[114].xy:=112;
   strafo[113].x :=111;
   strafo[113].y :=113;
   strafo[113].xy:=111;
   strafo[109].x :=109;
   strafo[109].y :=109;
   strafo[109].xy:=109;
   strafo[ 60].x := 62;
   strafo[ 60].y := 62;
   strafo[ 60].xy:= 60;
   strafo[ 61].x := 63;
   strafo[ 61].y := 63;
   strafo[ 61].xy:= 61;
   strafo[111].x :=113;
   strafo[111].y :=111;
   strafo[111].xy:=113;
   strafo[ 62].x := 60;
   strafo[ 62].y := 60;
   strafo[ 62].xy:= 62;
   strafo[ 63].x := 61;
   strafo[ 63].y := 61;
   strafo[ 63].xy:= 63;
   strafo[ 36].x := 36;
   strafo[ 36].y := 37;
   strafo[ 36].xy:= 37;
   strafo[ 35].x := 35;
   strafo[ 35].y := 35;
   strafo[ 35].xy:= 35;
   strafo[104].x :=104;
   strafo[104].y :=104;
   strafo[104].xy:=104;
   strafo[ 37].x := 37;
   strafo[ 37].y := 36;
   strafo[ 37].xy:= 36;
   strafo[ 95].x := 95;
   strafo[ 95].y := 96;
   strafo[ 95].xy:= 96;
   strafo[102].x :=102;
   strafo[102].y :=102;
   strafo[102].xy:=102;
   strafo[100].x :=100;
   strafo[100].y :=100;
   strafo[100].xy:=100;
   strafo[ 96].x := 96;
   strafo[ 96].y := 95;
   strafo[ 96].xy:= 95;
   strafo[105].x :=107;
   strafo[105].y :=106;
   strafo[105].xy:=108;
   strafo[106].x :=108;
   strafo[106].y :=105;
   strafo[106].xy:=107;
   strafo[ 39].x := 38;
   strafo[ 39].y := 39;
   strafo[ 39].xy:= 38;
   strafo[ 98].x := 97;
   strafo[ 98].y := 98;
   strafo[ 98].xy:= 97;
   strafo[ 34].x := 34;
   strafo[ 34].y := 34;
   strafo[ 34].xy:= 34;
   strafo[101].x :=101;
   strafo[101].y :=101;
   strafo[101].xy:=101;
   strafo[107].x :=105;
   strafo[107].y :=108;
   strafo[107].xy:=106;
   strafo[108].x :=106;
   strafo[108].y :=107;
   strafo[108].xy:=105;
   strafo[103].x :=103;
   strafo[103].y :=103;
   strafo[103].xy:=103;
   strafo[ 99].x := 99;
   strafo[ 99].y := 99;
   strafo[ 99].xy:= 99;
   strafo[ 38].x := 39;
   strafo[ 38].y := 38;
   strafo[ 38].xy:= 39;
   strafo[ 97].x := 98;
   strafo[ 97].y := 97;
   strafo[ 97].xy:= 98;
   strafo[119].x :=121;
   strafo[119].y :=123;
   strafo[119].xy:=117;
   strafo[123].x :=117;
   strafo[123].y :=119;
   strafo[123].xy:=121;
   strafo[120].x :=124;
   strafo[120].y :=122;
   strafo[120].xy:=118;
   strafo[121].x :=119;
   strafo[121].y :=117;
   strafo[121].xy:=123;
   strafo[117].x :=123;
   strafo[117].y :=121;
   strafo[117].xy:=119;
   strafo[122].x :=118;
   strafo[122].y :=120;
   strafo[122].xy:=124;
   strafo[124].x :=120;
   strafo[124].y :=118;
   strafo[124].xy:=122;
   strafo[118].x :=122;
   strafo[118].y :=124;
   strafo[118].xy:=120;
   strafo[163].x :=164;
   strafo[163].y :=163;
   strafo[163].xy:=164;
   strafo[164].x :=163;
   strafo[164].y :=164;
   strafo[164].xy:=163;
   strafo[165].x :=165;
   strafo[165].y :=166;
   strafo[165].xy:=166;
   strafo[166].x :=166;
   strafo[166].y :=165;
   strafo[166].xy:=165;
   strafo[153].x :=153;
   strafo[153].y :=153;
   strafo[153].xy:=153;
   strafo[159].x :=160;
   strafo[159].y :=159;
   strafo[159].xy:=160;
   strafo[160].x :=159;
   strafo[160].y :=160;
   strafo[160].xy:=159;
   strafo[161].x :=161;
   strafo[161].y :=162;
   strafo[161].xy:=162;
   strafo[162].x :=162;
   strafo[162].y :=161;
   strafo[162].xy:=161;
   strafo[152].x :=152;
   strafo[152].y :=152;
   strafo[152].xy:=152;
   strafo[155].x :=156;
   strafo[155].y :=155;
   strafo[155].xy:=156;
   strafo[156].x :=155;
   strafo[156].y :=156;
   strafo[156].xy:=155;
   strafo[157].x :=157;
   strafo[157].y :=158;
   strafo[157].xy:=158;
   strafo[158].x :=158;
   strafo[158].y :=157;
   strafo[158].xy:=157;
   strafo[151].x :=151;
   strafo[151].y :=151;
   strafo[151].xy:=151;
   strafo[167].x :=168;
   strafo[167].y :=167;
   strafo[167].xy:=168;
   strafo[168].x :=167;
   strafo[168].y :=168;
   strafo[168].xy:=167;
   strafo[169].x :=169;
   strafo[169].y :=170;
   strafo[169].xy:=170;
   strafo[170].x :=170;
   strafo[170].y :=169;
   strafo[170].xy:=169;
   strafo[154].x :=154;
   strafo[154].y :=154;
   strafo[154].xy:=154;
   strafo[171].x :=171;
   strafo[171].y :=172;
   strafo[171].xy:=172;
   strafo[172].x :=172;
   strafo[172].y :=171;
   strafo[172].xy:=171;
   strafo[173].x :=174;
   strafo[173].y :=173;
   strafo[173].xy:=174;
   strafo[174].x :=173;
   strafo[174].y :=174;
   strafo[174].xy:=173;
   strafo[  2].x :=  2;
   strafo[  2].y :=  2;
   strafo[  2].xy:=  2;
   strafo[175].x :=176;
   strafo[175].y :=175;
   strafo[175].xy:=176;
   strafo[176].x :=175;
   strafo[176].y :=176;
   strafo[176].xy:=175;
   strafo[177].x :=177;
   strafo[177].y :=178;
   strafo[177].xy:=178;
   strafo[178].x :=178;
   strafo[178].y :=177;
   strafo[178].xy:=177;
   strafo[  0].x :=0;
   strafo[  0].y :=0;
   strafo[  0].xy:=0;
   strafo[  3].x :=3;
   strafo[  3].y :=3;
   strafo[  3].xy:=3;
   for i:=182 to 252
   do begin
      strafo[  i].x :=i;
      strafo[  i].y :=i;
      strafo[  i].xy:=i
   end;
   ltrafo[  0].x :=  0;
   ltrafo[  0].y :=  0;
   ltrafo[  0].xy:=  0;
   ltrafo[ 13].x := 14;
   ltrafo[ 13].y := 12;
   ltrafo[ 13].xy:= 11;
   ltrafo[  9].x :=  7;
   ltrafo[  9].y :=  9;
   ltrafo[  9].xy:=  7;
   ltrafo[ 12].x := 11;
   ltrafo[ 12].y := 13;
   ltrafo[ 12].xy:= 14;
   ltrafo[ 10].x := 10;
   ltrafo[ 10].y :=  8;
   ltrafo[ 10].xy:=  8;
   ltrafo[  6].x :=  6;
   ltrafo[  6].y :=  6;
   ltrafo[  6].xy:=  6;
   ltrafo[  8].x :=  8;
   ltrafo[  8].y := 10;
   ltrafo[  8].xy:= 10;
   ltrafo[ 14].x := 13;
   ltrafo[ 14].y := 11;
   ltrafo[ 14].xy:= 12;
   ltrafo[  7].x :=  9;
   ltrafo[  7].y :=  7;
   ltrafo[  7].xy:=  9;
   ltrafo[ 11].x := 12;
   ltrafo[ 11].y := 14;
   ltrafo[ 11].xy:= 13;
   ltrafo[ 17].x := 18;
   ltrafo[ 17].y := 16;
   ltrafo[ 17].xy:= 15;
   ltrafo[ 16].x := 15;
   ltrafo[ 16].y := 17;
   ltrafo[ 16].xy:= 18;
   ltrafo[ 18].x := 17;
   ltrafo[ 18].y := 15;
   ltrafo[ 18].xy:= 16;
   ltrafo[ 15].x := 16;
   ltrafo[ 15].y := 18;
   ltrafo[ 15].xy:= 17;
   ltrafo[  3].x :=  4;
   ltrafo[  3].y :=  2;
   ltrafo[  3].xy:=  5;
   ltrafo[  2].x :=  5;
   ltrafo[  2].y :=  3;
   ltrafo[  2].xy:=  4;
   ltrafo[  1].x :=  1;
   ltrafo[  1].y :=  1;
   ltrafo[  1].xy:=  1;
   ltrafo[  4].x :=  3;
   ltrafo[  4].y :=  5;
   ltrafo[  4].xy:=  2;
   ltrafo[  5].x :=  2;
   ltrafo[  5].y :=  4;
   ltrafo[  5].xy:=  3;
   for i:=19 to 255
   do begin
      ltrafo[  i].x :=i;
      ltrafo[  i].y :=i;
      ltrafo[  i].xy:=i
   end;
   for i:=0 to 31 do
      for j:=0 to 31 do begin
         sfromclipfield[i,j]:=0;
         lfromclipfield[i,j]:=0
      end;
   tsf_pos[1].i:=1;
   tsf_pos[1].j:=1;
   tsf_pos[2].i:=1;
   tsf_pos[2].j:=1;
   tsf_pos[3].i:=1;
   tsf_pos[3].j:=1;
   tsf_pos[4].i:=1;
   tsf_pos[4].j:=1;
   tsf_pos[5].i:=1;
   tsf_pos[5].j:=1;
   tsf_pos[6].i:=1;
   tsf_pos[6].j:=1;
   tsf_pos[7].i:=1;
   tsf_pos[7].j:=1;
   tsf_pos[8].i:=1;
   tsf_pos[8].j:=1;
   tsf_pos[9].i:=1;
   tsf_pos[9].j:=1;
   tsf_pos[10].i:=1;
   tsf_pos[10].j:=1;
   tsf_nr:=1;
   lsf_pos[13].x:=lsf_l_border+(xwidth+1)*2;
   lsf_pos[13].y:=tu_border;
   lsf_pos[ 9].x:=lsf_l_border+(xwidth+1)*6;
   lsf_pos[ 9].y:=tu_border;
   lsf_pos[12].x:=lsf_l_border+(xwidth+1)*10;
   lsf_pos[12].y:=tu_border;
   lsf_pos[10].x:=lsf_l_border+(xwidth+1)*2;
   lsf_pos[10].y:=tu_border+(ywidth+1)*2;
   lsf_pos[ 6].x:=lsf_l_border+(xwidth+1)*6;
   lsf_pos[ 6].y:=tu_border+(ywidth+1)*2;
   lsf_pos[ 8].x:=lsf_l_border+(xwidth+1)*10;
   lsf_pos[ 8].y:=tu_border+(ywidth+1)*2;
   lsf_pos[14].x:=lsf_l_border+(xwidth+1)*2;
   lsf_pos[14].y:=tu_border+(ywidth+1)*4;
   lsf_pos[ 7].x:=lsf_l_border+(xwidth+1)*6;
   lsf_pos[ 7].y:=tu_border+(ywidth+1)*4;
   lsf_pos[11].x:=lsf_l_border+(xwidth+1)*10;
   lsf_pos[11].y:=tu_border+(ywidth+1)*4;
   lsf_pos[17].x:=lsf_l_border+(xwidth+1)*4;
   lsf_pos[17].y:=tu_border+(ywidth+1)*1;
   lsf_pos[16].x:=lsf_l_border+(xwidth+1)*8;
   lsf_pos[16].y:=tu_border+(ywidth+1)*1;
   lsf_pos[18].x:=lsf_l_border+(xwidth+1)*4;
   lsf_pos[18].y:=tu_border+(ywidth+1)*3;
   lsf_pos[15].x:=lsf_l_border+(xwidth+1)*8;
   lsf_pos[15].y:=tu_border+(ywidth+1)*3;
   lsf_pos[ 3].x:=lsf_l_border+(xwidth+1)*2;
   lsf_pos[ 3].y:=tu_border;
   lsf_pos[ 2].x:=lsf_l_border+(xwidth+1)*6;
   lsf_pos[ 2].y:=tu_border;
   lsf_pos[ 1].x:=lsf_l_border+(xwidth+1)*4;
   lsf_pos[ 1].y:=tu_border+(ywidth+1)*2;
   lsf_pos[ 4].x:=lsf_l_border+(xwidth+1)*2;
   lsf_pos[ 4].y:=tu_border+(ywidth+1)*4;
   lsf_pos[ 5].x:=lsf_l_border+(xwidth+1)*6;
   lsf_pos[ 5].y:=tu_border+(ywidth+1)*4;
   lsf_pos[ 0].x:=lsf_l_border;
   lsf_pos[ 0].y:=tu_border+(ywidth+1)*4;
   sbase[1]:=153;
   sbase[2]:=152;
   sbase[3]:=151;
   sbase[4]:=154;
   sbase[5]:=  2;
   sbase[6]:=163;
   sbase[7]:=159;
   sbase[8]:=155;
   sbase[9]:=167;
   sbase[10]:=171;
   sbase[11]:=175;
   marked:=false;
   markfunct:=0;
   markxmin:=0;
   markxmax:=0;
   markymin:=0;
   markymax:=0;
   xmirr:=false;
   ymirr:=false;
   trackmark:=false;
   terrmark:=false;
   trackmode:=false;
   multifield:=false;
   hill_mode:=true;
   autoset:=false;
   trackcomp:=false;
   verz_props[0]:=10;
   for i:=1 to 11
   do
      verz_props[i]:=100;
   housewater:=false;
   shipgrass:=false;
   objhill:=false;
   elem_nr:=0;
   selx:=lsf_pos[0].x;
   sely:=lsf_pos[0].y;
   t_elem_nr:=tsf[tsf_nr,tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j];
   greeton:=true;
   menuon:=true;
   begverz:=3;
   beginsound:=false;
   megadrive:=false;
   eingelesen:=false;
   trackloaded:=false;
   goodsave:=true;
   commstr:='';
   oldname[1]:='';
   oldname[2]:='';
   oldpath[1]:='';
   oldpath[2]:='';
   opti:=1;
   optj:=1;
   oldi:=1;
   oldj:=1;
   ci:=1;
   cj:=1;
   quickleave:=false;
end;



begin
  initnumstat:=GSS(1);
  SSS(1,true);
  getdir(0,startpath);
  fsplit(paramstr(0),D,N,E);
if D[length(D)]='\'
then
   D[0]:=chr(ord(D[0])-1);
{$I-};
schdir(D);
{$I-};
  getdir(0,progpath);
  if (egamode=1)
  then begin
     grdrvr:=3;  
     grmode:=1;  
  end
  else begin
     grdrvr:=9;
     grmode:=2;
  end;
  randomize;
  textbackground(0);
  setcursorspeed(0);
  tb_init;
  readopt;
  if (paramcount>0)
  then
     schdir(startpath);
  tb_begin;
  if ParamCount>0
  then begin
     commstr:=paramstr(1);
     if commstr='megadrive'
     then begin
        megadrive:=true;
        if ParamCount>1
        then
           commstr:=ParamStr(2);
     end;
     if commstr[1]='"'
     then begin
        for i:=1 to length(commstr)
        do
           commstr[i]:=commstr[i+1];
        commstr[0]:=chr(ord(commstr[0])-1);
     end;
     commstr:=fexpand(commstr);
     fsplit(commstr,D,N,E);
     commstr:=N;
     if (ParamCount>1) or (megadrive=false)
     then begin
        i:=1;
        optname:='';
        while (i<=length(commstr)) and (commstr[i]<>'.')
        do begin
           optname[0]:=chr(ord(optname[0])+1);
           optname[i]:=upcase(commstr[i]);
           inc(i);
        end;
        greeton:=false;
        voreinlesen(true);
     end
  end;
  if eingelesen
  then
     menuon:=greeton;
  progcheck:=' ';
  WHILE (ord(progcheck)<>68) AND (ord(progcheck)<>27)
  DO begin (*Programmwiederholung*)
    clrscr;
    if not menuon
    then begin
       edit_field;
       menuon:=true
    end;
    if (ord(progcheck)<>68) AND (ord(progcheck)<>27)
    then begin
       WriteLn;
       TextColor(1);
       s:='=======================================';
       GoToXY(40-(length(s)+1) div 2,WhereY);
       writeln(s);
       TextColor(4);
       s:= 'T R A C K   B L A S T E R   PRO   5.3';
       GoToXY(40-(length(s)+1) div 2,WhereY);
       writeln(s);
       TextColor(1);
       s:='=======================================';
       GoToXY(40-(length(s)+1) div 2,WhereY);
       writeln(s);
       WriteLn;
       if megadrive
       then begin
          GoToXY(40-(length(mega1)+1) div 2, WhereY);
          write_mess(mega1,139,7,1)
       end;
       if (megadrive)
       then
          writeln;
       WriteLn;
       write_mess(mm1,c_text_active,7,0);
       write_mess('< F1 >',c_text_key,7,1);
       if not megadrive
       then
          WriteLn;
       WriteLn;
       IF not eingelesen THEN begin
          TextColor(c_text_hidden);
          Write(mm2);
          TextColor(c_text_nm);
          Write(mme)
       end
       ELSE begin
          TextColor(c_text_active);
          Write(mm2);
          TextColor(c_text_key);
          Write('< F2 >')
       end;
       WriteLn;
       if not megadrive
       then
          WriteLn;
       TextColor(c_text_active);
       Write(mm3);
       TextColor(c_text_key);
       WriteLn('< F3 >');
       if not megadrive
       then
          WriteLn;
       WriteLn;
       IF not eingelesen THEN begin
          TextColor(c_text_hidden);
          Write(mm4);
          TextColor(c_text_nm);
          Write(mme)
       end
       ELSE begin
          TextColor(c_text_active);
          Write(mm4);
          TextColor(c_text_key);
          Write('< F4 >')
       end;
       if not megadrive
       then
          WriteLn;
       WriteLn;
       IF not eingelesen THEN begin
          TextColor(c_text_hidden);
          Write(mm5);
          TextColor(c_text_nm);
          Write(mme)
       end
       ELSE begin
          TextColor(c_text_active);
          Write(mm5);
          TextColor(c_text_key);
          Write('< F5 >')
       end;
       if not megadrive
       then
          WriteLn;
       writeln;
       TextColor(c_text_active);
       Write(mm6);
       TextColor(c_text_key);
       WriteLn('< F6 >');
       TextColor(c_text_active);
       if not megadrive
       then
          WriteLn;
       WriteLn;
       Write(mm9);
       TextColor(c_text_key);
       Write('< F9 >');
       TextColor(c_text_active);
       if not megadrive
       then
          WriteLn;
       WriteLn;
       Write(mm10);
       write_mess('< Esc >',c_text_key,0,1);
       if megadrive
       then begin
          writeln;
          writeln;
          write_mess(mega2,12,0,1);
          write_mess(mega3,12,0,0);
       end;
       REPEAT
         progcheck:=readkey;
         if ord(progcheck)=0
         then begin
            if keypressed
            then begin
               progcheck:=readkey;
               while keypressed do begin
                  progcheck:=readkey;
                  progcheck:=' '
               end
            end
            else
               progcheck:=' '
         end
         else
            if (ord(progcheck)<>27)
            then
               progcheck:=' '
            else
               while keypressed do
                  progcheck:=readkey;
         ok:=false;
         CASE ord(progcheck) OF
           59 : begin
              mainhelp;
              ok:=true
           end;
           61 : begin
             voreinlesen(false);
             ok:=true
           end;
           60 : begin
             IF eingelesen THEN begin
               vorspeichern;
               ok:=true
             end
           end;
           62 : begin
             IF eingelesen THEN begin
                edit_field;
                ok:=true
             end;
           end;
           63 : begin
             IF eingelesen THEN begin
                edit_denotations;
                ok:=true
             end;
           end;
           64 : begin
             random_props;
             ok:=true
           end;
           67 : begin
             saveopt;
             ok:=true;
           end;
           27,68 : begin
             ok:=true;
             clrscr;
             if (not goodsave) and (hchanged(1))
             then begin
               GoToXY(1,7);
               TextColor(12);
               writeln(w6)
             end;
             if (not goodsave) and (fchanged(1))
             then begin
               GoToXY(1,8);
               TextColor(12);
               writeln(w7)
             end;
             if (not goodsave) and (tchanged(1))
             then begin
               GoToXY(1,9);
               TextColor(12);
               writeln(w8)
             end;
             if (not goodsave) and
                (fchanged(1) or tchanged(1) or hchanged(1))
             then begin
               writeln;
               TextColor(5);
               write(i11);
               TextColor(2);
               write('< ',yes_char,' >');
               write_mess('  ?',5,7,0);
               write('   ',no_char);
               if LoeschProtect=no_char
               then
                  progcheck:=' '
               else
                  progcheck:=chr(68)
             end
           end
         end
       UNTIL ok=true
    end;
  end; (*Programmwiederholung*)
  TextColor(7);
  clrscr;
  writeln('     ****  TrackBlaster Pro  5.3  by  The NAILWOOD Company  ****');
  SSS(1,initnumstat);
end.
