unit tb_defs;      (* (C) 1997  by  The NAILWOOD Company *)

   (* Purpose: Providing graphic routines for TrackBlaster_Pro *)
   (* First Implementation:  5.2.1997 *)
   (* Latest Modification : 25.3.1997 *)



INTERFACE

uses dos,crt,pice,graph;


const egamode=0;
      xwidth=14;
      ywidth=14;
      l_border=0;
      r_border=15;
      u_border=27;
      tu_border=5;
      ssf_l_border=500;
      lsf_l_border=470;
      sel_l=545;
      sel_u=452;
      multi_l=sel_l+26;
      multi_u=sel_u;
      takt_l=480;
      takt_yplus=10;
      takt_u1=sel_u-8;
      takt_u2=takt_u1-takt_yplus div 2;
      vmstat_l=sel_l+xwidth div 2;
      vmstat_u=sel_u-takt_yplus*3+6;
      name1_l=130;
      name2_l=130;
      name1_u=2;
      name2_u=12;
      autoset_l=598;
      autoset_u=takt_u1;
      fh_u=460;
      sx=5;
      sy=5;
      mj=3;
      laby=20;
      fkm_ybase=64;
      fkm_yplus=13;
      skm_xbase=468;
      skm_ybase=100;
      skm_yplus=13;
      c_grass=2;
      c_hill=10;
      c_water=1;
      c_edge=7;
      c_text_graph=4;
      c_text_key=2;
      c_text_nm=8;
      c_text_active=7;
      c_text_hidden=8;
      Green50 : FillPatternType = ($Aa, $55, $Aa, $55, $Aa, $55, $Aa, $55);
b1='A HQ-product of  The NAILWOOD Company';
ed1='Active';
ed2='terrain-';
ed3='element :';
ted1='Active';
ted2='track-';
ted3='element :';
hed1 ='                 Horizon :';
hed15='           Save          :';
hexpl1='     Desert     Tropical     Alpine       City       Country      Chaos';
hexpl2='        0           1           2           3           4          ';
vz0= '                 General scenery element :';
vz1= '  Specific priorities :             Tree :';
vz2= '                                  Cactus :';
vz3= '                                Palmtree :';
vz4= '                            Tennis court :';
vz5= '                                     Car :';
vz6= '                              Gray house :';
vz7= '                               Red house :';
vz8= '                         Filling station :';
vz9= '                                Windmill :';
vz10='                                    Ship :';
vz11='                              Restaurant :';
vz12='       Other objects than ships in water :';
vz13='                           Ships on land :';
vz14='                    Objects on hillsides :';
eb_1='CHANGE HORIZON :';
eb_2='DEFINE AUTOMATIC SCENERY :';
eo_1='SAVE CONFIGURATION :';
edstat11='Auto-';
edstat12='set-';
edstat13='mode';
edstat2='Comparing mode';
e1='Field-cursor to left';
e2='Field-cursor to right';
e3='Field-cursor to up';
e4='Field-cursor to down';
e5='Field-cursor to right up';
e6='Field-cursor to right down';
e7='Field-cursor to left down';
e8='Field-cursor to left up';
e9='Select water-/hill-mode';
e10='Select track-selection-field';
e11='Auto-set-mode on/off';
e12a='Set element';
e12b='Pick up previous element';
e13='Reset terrain-element';
e14='Reset track-element';
e15='Erase track-element';
e16='Set scenery element on free place';
e16b='Set scenery element';
e17='Set marking left/up';
e18='Set marking right/down';
e19='De-activate marking';
e19b='Marking to pre-marking';
e20='Activate marking-auto-set-mode';
e21='Copy marking into clipboard';
e22='Move marking into clipboard';
e22sh='Move mark. (tr. & terr.) into clipb.';
e23a='Mirror clipboard (x,y,xy,-)';
e23b='Mirror clipboard (y,x,xy,-)';
e24='Comparing mode on/off';
e25='Swap current track with comp.-tr.';
e26='Save current track directly';
e27='Load curr. track also as comp. tr.';
e30='Load previous trackfield';
e31='Load next trackfield';
e91='End editing';
e92='Quit the program';
em1='Mark.-cursor to left';
em2='Mark.-cursor to right';
em3='Mark.-cursor to up';
em4='Mark.-cursor to down';
em5='Mark.-cursor to right up';
em6='Mark.-cursor to right down';
em7='Mark.-cursor to left down';
em8='Mark.-cursor to left up';
em9='Activate terr.- clipb. [excl.]';
em10='Activate track- clipb. [excl.]';
em12='Insert clipboard';
em13='Set terr.-el. before inserting';
em14='Set track.-el. before inserting';
en4='Selection-cursor to left';
en6='Selection-cursor to right';
en8='Selection-cursor to up';
en2='Selection-cursor to down';
en9='Selection-cursor to right up';
en3='Selection-cursor to right down';
en1='Selection-cursor to left up';
en7='Selection-cursor to left down';
en0='Set selection-cursor';
es9='Water-/hill-mode';
es10='Track-select.-field';
es11='Auto-set-mode on/off';
es12a='Set element';
es12b='Pick up prev. elem.';
es13='Reset terrain-elem.';
es14='Reset track-elem.';
es15='Erase track-elem.';
es16='Set random element';
es17='Set marking l./up';
es18='Set marking r./dwn.';
es19='De-activ. marking';
es19b='Mark. = pre-mark.';
es20='Mark.-AutoSet-mode';
es21='Mark. -> clipboard';
es22='Mark. >> clipboard';
es22sh='M. tr.&terr. >> cb.';
es23='Mirror clipb. (x,y,xy,-)';
es24='Comparing mode on/off';
es25='Current tr. <-> Comp.-tr.';
es26='Save directly';
es90='Full help';
es91='End editing';
es92='Quit the program';
esm9='Activ. terr.-clipb.';
esm10='Activ. track-clipb.';
esm12='Insert clipboard';
esm13='Terr.-el. bef. ins.';
esm14='Track.-el. bef. ins.';
name1='Current track :';
name2='Comparative-track :';
f1='    Current directory :  ';
f2='     Change directory :';
f3='                             Select file :';
h1='   With';
h2='you can save a loaded trackfield into a file of an optional        '+
  'filename.';
h3='you can load a trackfield of a track from an existing              '+
  'trackfile.';
h31='   If you have changed a trackfield and not saved yet, there occurs a '+
  'warning       automatically.';
h4='you activate the editing-mode for a loaded '+
  'trackfield.';
h5='you can change the horizon of the loaded trackfield';
h6='you can define the attributes for the automatic scenery      '+
  '       generation.';
h9='you can modify and save the program status.';
h10='you can leave the program.';
i1='   ***  Forbid loading :  Empty input !  ***';
i2='   Trackfield successfully loaded !';
i3='   ***  Press optional key for leaving !  ***  ';
i4='   ***  For saving :  ';
i5='Save';
i6='Cancel';
i7='   Trackfield successfully saved !';
i7o='   Configuration successfully saved !';
i8='   ***  Do you want to overwrite  ';
i9='Overwrite';
i10='   Do you really want to erase the old trackfield  ';
i11='   Do you really want to end the program  ';
l1='   Filename without extension :  ';
m2='LOADING TRACKFIELD :';
m3='SAVING TRACKFIELD :';
m4='HELP FOR MAIN MENU :';
me='HELP FOR EDITOR :';
mm1='           Help   ';
mm2='           Save trackfield   ';
mm3='           Load trackfield   ';
mm4='           Edit trackfield   ';
mm5='           Change horizon   ';
mm6='           Define scenery   ';
mm9= '           Save configuration   ';
mm10='           End program   ';
mme='not possible';
lm1='      Load terrain with empty track ';
ld1='  ';
lk1='< 1 >';
lm2='      Load terrain under loaded track ';
ld2='  ';
lk2='< 2 >';
lm3='      Load terrain and track ';
ld3='  ';
lk3='< 3 >';
lm4='      Cancel ';
ld4='  ';
lk4='< Esc >';
le5='not possible';
ls40='         File contains no track';
ls41='         File contains track';
ls50='         Loaded file contains no track';
ls51='         Loaded file contains track';
o_cd1='   ***  The indicated directory is not existing yet !  ***';
o_cd2='   ***  Program remains in the current directory  ***';
o_cd3='   Old directory :  ';
o_cd4='   New directory :  ';
o_cd5='   Do you want to change into the new directory  ';
sm1='      Save terrain with empty track ';
sd1='  ';
sk1='< 1 >';
sm2='      Save terrain under track of file ';
sd2='  ';
sk2='< 2 >';
sm3='      Save terrain and track ';
sd3='  ';
sk3='< 3 >';
sm4='      Cancel ';
sd4='  ';
sk4='< Esc >';
se5='not possible';
so1='     Track to be changed :';
so3='               Directory :';
so4='         Cursor-Position :';
so6='      Show logo on start :';
so7='           Save          :';
so4_1='Line : ';
so4_2='Column : ';
ss10='';
ss11='         ***  File exists !  ***';
ss20='         ***  File has a wrong size  ***';
ss21='';
ss30='         File is empty';
ss31='         ***  File is not empty !  ***';
ss40='         File contains no track';
ss41='         ***  File contains track  ***';
ss50='         No track loaded';
ss51='         Track has been loaded';
w0='   ***  Old horizon will be erased by loading a new field '+
  '!  ***';
w1='   ***  Old terrain will be erased by loading a new field !  '+
  '***';
w2='   ***  Old track will be erased by loading a new field !  '+
  '***';
w3='   ***  Unfortunately, this file is not existing yet !  ***  ';
w4='   ***  Unfortunately, this file has a wrong size !  ***  ';
w5='   ***  SYSTEM-ERROR - Saving has not happened !  ***  ';
w6='   ***  You have changed the horizon and not saved yet !  '+
  '***';
w7='   ***  You have changed the terrain and not saved yet !  '+
  '***';
w8='   ***  You have changed the track and not saved yet !  '+
  '***';
wo1='   ***  The TrackBlaster-configuration-file ''TB.cfg'' does not exist'+
  ' !  ***';
wov1='   ***  The directory in the configuration file is invalid !  ***';
wov2='   ***  Program remains in the directory of calling  ***';
mega1='***  Extended mode  ***';
mega2='This mode may only be used by specially instructed TrackBlaste'+
 'r operating       '+
      'personal.  Serious ''Stunts''-failures could occour as a result '+
 'of misoperating.  '+
 'HardDisk-damages not excluded.';
mega3='At open points please consult  The NAILWOOD Company.';
yes_char='Y';
no_char='N';
comp_char='C';
swap_char='S';
yes_low_char='y';
no_low_char='n';
comp_low_char='c';
swap_low_char='s';
mirr_char='\';
mirr_shift_char='|';


type point= record
               x,y: integer
            end;
     triangle= array[0..3] of point;
     quadrangle= array[0..4] of point;

var triangle_v: triangle;
    quadrangle_v: quadrangle;
    i,j,k,ii,jj,ti,tj,xpos,ypos,selx,sely,elem_nr,t_elem_nr,
     grdrvr,grmode,ErrCode,error,begverz,markfunct,prefield:integer;
    tsf_nr,ci,cj,cii,cjj,oldi,oldj,opti,optj,
     markxmin,markxmax,markymin,markymax:byte;
    pretrack:array[0..2,0..2] of char;
    h_pretrack:char;
    pretrack_set:array[0..2,0..2] of boolean;
    paranz:word;
    contr,check,ch,megac,progcheck: char;
    hill_mode,autoset,eingelesen,goodsave,ok,trackloaded,multifield,trackmode,
     imp_nr,menuon,beginsound,greeton,megadrive,marked,xmirr,ymirr,trackcomp,
     sneumarkpos,lneumarkpos,trackmark,terrmark,dskm,dedm,dsf,
     prefetched,quickleave,initnumstat : boolean;
    trackfield,o_tf: array[1..3,1..900] of char;
    pre_tf: array[1..900] of char;
    field,field_orig : array[1..3,1..30,1..30] of byte;
    sclipfield,lclipfield,field_pre : array[1..30,1..30] of byte;
    sfromclipfield,lfromclipfield: array[0..31,0..31] of byte;
    horizchar,postchar:array[1..3] of char;
    o_horizchar,o_postchar:array[1..3] of char;
    oldname:array[1..3] of String;
    oldpath:array[1..3] of String;
    sbase:array[1..11] of byte;
    startpath,progpath:String;
    datei:text;
    optname:string[8];
    t:longint;
    tsf_pos:array[1..10] of record
                               i,j:byte
                            end;
    lsf_pos:array[0..18] of record
                               x,y:integer
                            end;
    tsf:array[1..10,1..6,1..6] of byte;
    multiel:array[0..255] of byte;
    strafo,ltrafo:array[0..255] of
       record
          x,y,xy:byte
       end;
    p1,p2,p3:pointer;
    commstr,s:string;
    verz_props:array[0..11] of integer;
    housewater:boolean;
    shipgrass:boolean;
    objhill:boolean;
    P: PathStr;
    D: DirStr;
    N: NameStr;
    E: ExtStr;


   function GSS(led:byte):boolean;
   function SSS(led:byte;on:boolean):byte; 
   function schdir(dir:DirStr):integer;
   procedure write_mess(t:string;color,newcolor:byte;newline:byte);
   procedure Abort(Msg : string);
   procedure write_path;
   function getname(defname:string;choosefile:boolean):string;
   function scroll_file(olddir,oldname,ext:string;dir:integer):string;
   procedure SetCursorSpeed(NewSpeed : Word);
   function timeconvert:longint;
   function get_size(name:string):integer;
   procedure clearline;
   procedure trackswap;
   procedure trackdup;
   procedure fieldcopy;
   procedure trackcopy;




IMPLEMENTATION


function GetShiftState(Mask:byte):byte; assembler;

asm
  MOV AH,$02  {Select shift state function}
  INT $16
  AND AL,Mask
end;


function GSS(led:byte):boolean;   (* 1: NumLock    *)
var mask:byte;                    (* 2: CapsLock   *)
                                  (* 3: ScrollLock *)
begin
   case led of
      1: mask:=32;
      2: mask:=64;
      3: mask:=16;
      else exit;
   end;
   GSS:=(GetShiftState(mask)=mask);
end;


function SSS(led:byte;on:boolean):byte;   (* 1: NumLock    *)
var mask:byte;                            (* 2: CapsLock   *)
                                          (* 3: ScrollLock *)
begin
   case led of
      1: mask:=32;
      2: mask:=64;
      3: mask:=16;
      else exit;
   end;
   if on
   then
      mem[$0040:$0017]:=mem[$0040:$0017] OR mask
   else
      mem[$0040:$0017]:=mem[$0040:$0017] AND (255-mask);
   GetShiftState(led);
end;


function schdir(dir:DirStr):integer;
var drvstr:string[2];

begin
   {$I-};
   chdir(dir);
   {$I+};
   if ioresult<>0
   then
      schdir:=1
   else
      if length(dir)>1
      then begin
         if (upcase(dir[1])>='A') AND (upcase(dir[1])<='Z') AND (dir[2]=':')
         then begin
            drvstr[1]:=dir[1];
            drvstr[2]:=dir[2];
            drvstr[0]:=chr(2);
            exec('command.com',drvstr);
         end;
         schdir:=0;
      end;
end;


procedure write_mess(t:string;color,newcolor:byte;newline:byte);

begin
   TextColor(color);
   write(t);
   TextColor(newcolor);
   if newline=1
   then
      writeln;
   write(' ');
   gotoxy(wherex-1,wherey)
end;


procedure Abort(Msg : string);
begin
  Writeln(Msg, ': ', GraphErrorMsg(GraphResult));
  Halt(1);
end;


function upstring(s:string):string;
var i:integer;

begin
   for i:=1 to length(s)
   do
      s[i]:=upcase(s[i]);
   upstring:=s;
end;


procedure write_path;
var path:string;

begin
   getdir(0,path);
   TextColor(5);
   write(f1);
   TextColor(2);
   writeln(path)
end;


function getname(defname:string;choosefile:boolean):string;
var name,origpath,path:string;
    groundline:integer;
Label 1,2;

begin
   groundline:=WhereY;
   name:=defname;
   getdir(0,origpath);
   repeat
1:      getdir(0,path);
      GoToXY(4,groundline);
      write('                                           ',
       '                                     ');
      GoToXY(4,groundline);
      write_path;
      if not choosefile
      then begin
         GoToXY(4,groundline+2);
         TextColor(5);
         write(f2);
         set_pickwindow_to(29,groundline+2,39,24,2,'');
         path:=pickfile('*.* DIRECTORY');
         if path=''
         then begin
   (*         chdir(origpath);*)
            name:='';
            GoTo 2
         end;
         schdir(path);
      end
      else path:='.';
      if path='.' then begin
         repeat
            getdir(0,path);
            GoToXY(4,groundline);
            write('                                           ',
             '                                     ');
            GoToXY(4,groundline);
            write_path;
            GoToXY(1,groundline+2);
            TextColor(5);
            write(f3);
            set_pickwindow_to(45,groundline+2,55,24,2,'');
            name:=pickfile('*.trk NOEXTENSION');
            if name=''
            then begin
               GoToXY(4,groundline+2);
               write('                                           ',
                '                                     ');
               choosefile:=false;
               GoTo 1
            end;
            GoTo 2
         until false
      end
   until false;
2:   TextColor(7);
   GoToXY(4,groundline+1);
   writeln('                                                               ');
   writeln('                                                               ');
   GoToXY(1,groundline);
   if name<>'' then begin
      delete(name,length(name)-3,4)
   end;
   getname:=name
end;


function scroll_file(olddir,oldname,ext:string;dir:integer):string;
type nlp=^namelist;
     namelist=record
        name:string;
        next:nlp;
     end;
var nl,hnl,hhnl:nlp;
    i:integer;
    DirInfo: SearchRec;
    P: PathStr;
    D: DirStr;
    N,preN: NameStr;
    E: ExtStr;
    retval:string;

begin
   nl:=NIL;
   if schdir(olddir)<>0
   then
      retval:=''
   else begin
      FindFirst('*.'+ext, AnyFile, DirInfo);
      while DosError=0
      do begin
         P:=fexpand(DirInfo.Name);
         FSplit(P, D, preN, E);
         preN:=upstring(preN);
         if (nl=NIL) OR (nl^.name>preN)
         then begin
            hnl:=NIL;
            new(hnl);
            hnl^.name:=preN;
            hnl^.next:=nl;
            nl:=hnl;
         end
         else begin
            hnl:=nl;
            while((hnl^.next<>NIL) AND (hnl^.next^.name<preN))
            do
               hnl:=hnl^.next;
            hhnl:=NIL;
            new(hhnl);
            hhnl^.name:=preN;
            hhnl^.next:=hnl^.next;
            hnl^.next:=hhnl;
         end;
         FindNext(DirInfo);
      end;
      if (nl<>NIL)
      then begin
         oldname:=upstring(oldname);
         if dir=1
         then begin
            hnl:=nl;
            while(hnl^.next<>NIL) AND (hnl^.name<=oldname)
            do
               hnl:=hnl^.next;
            if (hnl^.name>oldname)
            then
               retval:=hnl^.name
            else begin
               if (hnl^.next<>NIL)
               then
                  hnl:=hnl^.next;
               retval:=hnl^.name
            end
         end
         else begin
            preN:=nl^.name;
            hnl:=nl;
            while(hnl<>NIL) AND (hnl^.name<oldname)
            do begin
               preN:=hnl^.name;
               hnl:=hnl^.next;
            end;
            retval:=preN;
         end
      end
      else
         retval:='';
   end;
   while (nl<>NIL)
   do begin
      hnl:=nl;
      nl:=nl^.next;
      dispose(hnl);
   end;
   scroll_file:=retval;
end;


procedure SetCursorSpeed(NewSpeed : Word);
begin
  Port[$60] := $F3;
  Delay(200);
  Port[$60] := NewSpeed;
end;


function timeconvert:longint;
var wert:longint;
    h,m,s,c:word;
    hi,mi,si,ci:longint;

begin
   gettime(h,m,s,c);
   hi:=h;
   mi:=m;
   si:=s;
   ci:=c;
   wert:=hi*360000+mi*6000+si*100+ci;
   timeconvert:=wert
end;


function get_size(name:string):integer;
var cf:file of char;

begin
   assign(cf,name);
   reset(cf);
   get_size:=filesize(cf);
   close(cf)
end;


procedure clearline;
var i,x,y:integer;

begin
   x:=WhereX;
   y:=WhereY;
   for i:=x to 80 do
      write(' ');
   GoToXY(x,y)
end;


procedure trackswap;
begin
    trackfield[3]:=trackfield[1];
    trackfield[1]:=trackfield[2];
    trackfield[2]:=trackfield[3];
    o_tf[3]:=o_tf[1];
    o_tf[1]:=o_tf[2];
    o_tf[2]:=o_tf[3];
    field[3]:=field[1];
    field[1]:=field[2];
    field[2]:=field[3];
    field_orig[3]:=field_orig[1];
    field_orig[1]:=field_orig[2];
    field_orig[2]:=field_orig[3];
    oldname[3]:=oldname[1];
    oldname[1]:=oldname[2];
    oldname[2]:=oldname[3];
    oldpath[3]:=oldpath[1];
    oldpath[1]:=oldpath[2];
    oldpath[2]:=oldpath[3];
    horizchar[3]:=horizchar[1];
    horizchar[1]:=horizchar[2];
    horizchar[2]:=horizchar[3];
    o_horizchar[3]:=o_horizchar[1];
    o_horizchar[1]:=o_horizchar[2];
    o_horizchar[2]:=o_horizchar[3];
    postchar[3]:=postchar[1];
    postchar[1]:=postchar[2];
    postchar[2]:=postchar[3];
    o_postchar[3]:=o_postchar[1];
    o_postchar[1]:=o_postchar[2];
    o_postchar[2]:=o_postchar[3];
end;


procedure trackdup;
begin
    trackfield[2]:=trackfield[1];
    o_tf[2]:=o_tf[1];
    field[2]:=field[1];
    field_orig[2]:=field_orig[1];
    oldname[2]:=oldname[1];
    oldpath[2]:=oldpath[1];
    horizchar[2]:=horizchar[1];
    o_horizchar[2]:=o_horizchar[1];
    postchar[2]:=postchar[1];
    o_postchar[2]:=o_postchar[1];
end;


procedure fieldcopy;

begin
   for i:=1 to 30 do begin
      for j:=1 to 30 do begin
         field_orig[1,i,j]:=field[1,i,j]
      end
   end
end;


procedure trackcopy;

begin
   for i:=1 to 900 do begin
       o_tf[1,i]:=trackfield[1,i]
   end
end;




begin
end.
