unit tb_graph;      (* (C) 1997  by  The NAILWOOD Company *)

   (* Purpose: Providing graphic routines for TrackBlaster_Pro *)
   (* First Implementation: 28.3.1993 *)
   (* Latest Modification : 25.3.1997 *)



INTERFACE

uses graph,crt,tb_defs,dos;


   procedure gofield(ci:integer;cj:integer);
   procedure clear_field(xmin,ymin,xmax,ymax:integer);
   procedure landscape(kind:byte;xpos,ypos:integer);
   procedure straight(direction,color:word);
   procedure away_street(kind:byte);
   procedure tunnel(kind:byte);
   procedure ramp(kind:byte);
   procedure inclined(kind:byte);
   procedure small_curve(quadrant,color:word);
   procedure big_curve(combquadrant,color,rand:word);
   procedure s_big_curve(kind:word);
   procedure chick(kind:byte);
   procedure split(kind:byte);
   procedure screw(combquadrant,height:byte;right_sense:boolean);
   procedure loops(kind:byte);
   procedure scenery(kind:byte);
   procedure finish(kind,color:byte);
   procedure draw_track_elem(mode,i,j:byte);   (* i-te Spalte, j-te Zeile *)
   procedure draw_field_elem(nr:integer);
   procedure draw_select_field;
   procedure draw_sel_el;
   procedure write_status;
   procedure draw_edit_menu;
   procedure draw_menu_line(xpos,ypos:integer;keytext,dots,functtext:string;
     active:boolean);
   procedure draw_smenu_line(xpos,ypos,x_dots:integer;keytext,dots,functtext:
     string;active:boolean);
   procedure draw_full_key_menu;
   procedure draw_short_key_menu;
   procedure Make_Label(s:string);
   procedure Write_Ctrl(z:char);




IMPLEMENTATION

uses BGIDriv,   { all the BGI drivers }
     BGIFont;   { all the BGI fonts }


procedure gofield(ci:integer;cj:integer);

begin
   Moveto(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
end;


procedure triangle_1(xpos,ypos:integer);

begin
   triangle_v[0].x:=xpos+1;
   triangle_v[0].y:=ypos+ywidth;
   triangle_v[1].x:=xpos+xwidth;
   triangle_v[1].y:=ypos+ywidth;
   triangle_v[2].x:=xpos+1;
   triangle_v[2].y:=ypos+1;
   triangle_v[3].x:=xpos+1;
   triangle_v[3].y:=ypos+ywidth
end;


procedure triangle_2(xpos,ypos:integer);

begin
   triangle_v[0].x:=xpos+xwidth;
   triangle_v[0].y:=ypos+ywidth;
   triangle_v[1].x:=xpos+xwidth;
   triangle_v[1].y:=ypos+1;
   triangle_v[2].x:=xpos+1;
   triangle_v[2].y:=ypos+ywidth;
   triangle_v[3].x:=xpos+xwidth;
   triangle_v[3].y:=ypos+ywidth
end;


procedure triangle_3(xpos,ypos:integer);

begin
   triangle_v[0].x:=xpos+xwidth;
   triangle_v[0].y:=ypos+1;
   triangle_v[1].x:=xpos+1;
   triangle_v[1].y:=ypos+1;
   triangle_v[2].x:=xpos+xwidth;
   triangle_v[2].y:=ypos+ywidth;
   triangle_v[3].x:=xpos+xwidth;
   triangle_v[3].y:=ypos+1
end;


procedure triangle_4(xpos,ypos:integer);

begin
   triangle_v[0].x:=xpos+1;
   triangle_v[0].y:=ypos+1;
   triangle_v[1].x:=xpos+1;
   triangle_v[1].y:=ypos+ywidth;
   triangle_v[2].x:=xpos+xwidth;
   triangle_v[2].y:=ypos+1;
   triangle_v[3].x:=xpos+1;
   triangle_v[3].y:=ypos+1
end;


procedure triangle_5(xpos,ypos:integer);

begin
   triangle_v[0].x:=xpos+1;
   triangle_v[0].y:=ypos+1+ywidth div 2;
   triangle_v[1].x:=xpos+1;
   triangle_v[1].y:=ypos+ywidth;
   triangle_v[2].x:=xpos+xwidth div 2;
   triangle_v[2].y:=ypos+ywidth;
   triangle_v[3].x:=xpos+1;
   triangle_v[3].y:=ypos+1+ywidth div 2;
   quadrangle_v[0].x:=xpos+1;
   quadrangle_v[0].y:=ypos+1;
   quadrangle_v[1].x:=xpos+1;
   quadrangle_v[1].y:=ypos+ywidth div 2;
   quadrangle_v[2].x:=xpos+1+xwidth div 2;
   quadrangle_v[2].y:=ypos+ywidth;
   quadrangle_v[3].x:=xpos+xwidth;
   quadrangle_v[3].y:=ypos+ywidth;
   quadrangle_v[4].x:=xpos+1;
   quadrangle_v[4].y:=ypos+1
end;


procedure triangle_6(xpos,ypos:integer);

begin
   triangle_v[0].x:=xpos+1+xwidth div 2;
   triangle_v[0].y:=ypos+ywidth;
   triangle_v[1].x:=xpos+xwidth;
   triangle_v[1].y:=ypos+ywidth;
   triangle_v[2].x:=xpos+xwidth;
   triangle_v[2].y:=ypos+1+ywidth div 2;
   triangle_v[3].x:=xpos+1+xwidth div 2;
   triangle_v[3].y:=ypos+ywidth;
   quadrangle_v[0].x:=xpos+1;
   quadrangle_v[0].y:=ypos+ywidth;
   quadrangle_v[1].x:=xpos+xwidth div 2;
   quadrangle_v[1].y:=ypos+ywidth;
   quadrangle_v[2].x:=xpos+xwidth;
   quadrangle_v[2].y:=ypos+ywidth div 2;
   quadrangle_v[3].x:=xpos+xwidth;
   quadrangle_v[3].y:=ypos+1;
   quadrangle_v[4].x:=xpos+1;
   quadrangle_v[4].y:=ypos+ywidth
end;


procedure triangle_7(xpos,ypos:integer);

begin
   triangle_v[0].x:=xpos+1+xwidth div 2;
   triangle_v[0].y:=ypos+1;
   triangle_v[1].x:=xpos+xwidth;
   triangle_v[1].y:=ypos+ywidth div 2;
   triangle_v[2].x:=xpos+xwidth;
   triangle_v[2].y:=ypos+1;
   triangle_v[3].x:=xpos+1+xwidth div 2;
   triangle_v[3].y:=ypos+1;
   quadrangle_v[0].x:=xpos+1;
   quadrangle_v[0].y:=ypos+1;
   quadrangle_v[1].x:=xpos+xwidth;
   quadrangle_v[1].y:=ypos+ywidth;
   quadrangle_v[2].x:=xpos+xwidth;
   quadrangle_v[2].y:=ypos+1+ywidth div 2;
   quadrangle_v[3].x:=xpos+xwidth div 2;
   quadrangle_v[3].y:=ypos+1;
   quadrangle_v[4].x:=xpos+1;
   quadrangle_v[4].y:=ypos+1
end;


procedure triangle_8(xpos,ypos:integer);

begin
   triangle_v[0].x:=xpos+1;
   triangle_v[0].y:=ypos+1;
   triangle_v[1].x:=xpos+1;
   triangle_v[1].y:=ypos+ywidth div 2;
   triangle_v[2].x:=xpos+xwidth div 2;
   triangle_v[2].y:=ypos+1;
   triangle_v[3].x:=xpos+1;
   triangle_v[3].y:=ypos+1;
   quadrangle_v[0].x:=xpos+1;
   quadrangle_v[0].y:=ypos+ywidth;
   quadrangle_v[1].x:=xpos+xwidth;
   quadrangle_v[1].y:=ypos+1;
   quadrangle_v[2].x:=xpos+1+xwidth div 2;
   quadrangle_v[2].y:=ypos+1;
   quadrangle_v[3].x:=xpos+1;
   quadrangle_v[3].y:=ypos+1+ywidth div 2;
   quadrangle_v[4].x:=xpos+1;
   quadrangle_v[4].y:=ypos+1
end;


procedure squadrangle_1(xpos,ypos:integer);

begin
   bar(xpos+1,ypos+1,xpos+xwidth,ypos+ywidth)
end;


procedure squadrangle_2_v(xpos,ypos:integer);    (* waagrecht *)

begin
   rectangle(xpos+1,ypos+1,xpos+xwidth,ypos+ywidth div 2);
   bar(xpos+2,ypos+2,xpos-1+xwidth,ypos-1+ywidth div 2);
end;


procedure squadrangle_2_w(xpos,ypos:integer);    (* waagrecht *)

begin
   rectangle(xpos+1,ypos+1+ywidth div 2,xpos+xwidth,ypos+ywidth);
   bar(xpos+2,ypos+2+ywidth div 2,xpos+xwidth-1,ypos+ywidth-1);
end;


procedure squadrangle_3_v(xpos,ypos:integer);    (* senkrecht *)

begin
   rectangle(xpos+1,ypos+1,xpos+xwidth div 2,ypos+ywidth);
   bar(xpos+2,ypos+2,xpos-1+xwidth div 2,ypos+ywidth-1);
end;


procedure squadrangle_3_w(xpos,ypos:integer);    (* senkrecht *)

begin
   rectangle(xpos+1+xwidth div 2,ypos+1,xpos+xwidth,ypos+ywidth);
   bar(xpos+2+xwidth div 2,ypos+2,xpos+xwidth-1,ypos+ywidth-1);
end;


procedure clear_field(xmin,ymin,xmax,ymax:integer);
var c,oldx,oldy:integer;

begin
   c:=getcolor;
   oldx:=GetX;
   oldy:=GetY;
   setcolor(16);
   setfillstyle(1,0);
   bar(xmin,ymin,xmax,ymax);
   setcolor(c);
   MoveTo(oldx,oldy)
end;


procedure landscape(kind:byte;xpos,ypos:integer);

begin
   case kind of
      0:begin   (* Grass *)
         setcolor(c_grass);
         setfillstyle(1,c_grass);
         squadrangle_1(xpos,ypos)
      end;
      1:begin   (* Water *)
         setcolor(c_water);
         setfillstyle(1,c_water);
         squadrangle_1(xpos,ypos)
      end;
      2:begin   (* Water-Edge into left down *)
         triangle_1(xpos,ypos);
         setcolor(c_water);
         setfillstyle(1,c_water);
         fillpoly(4,triangle_v);
         triangle_3(xpos,ypos);
         setcolor(c_grass);
         setfillstyle(1,c_grass);
         fillpoly(4,triangle_v)
      end;
      3:begin   (* Water-Edge into right down *)
         triangle_2(xpos,ypos);
         setcolor(c_water);
         setfillstyle(1,c_water);
         fillpoly(4,triangle_v);
         triangle_4(xpos,ypos);
         setcolor(c_grass);
         setfillstyle(1,c_grass);
         fillpoly(4,triangle_v)
      end;
      4:begin   (* Water-Edge into right up *)
         triangle_3(xpos,ypos);
         setcolor(c_water);
         setfillstyle(1,c_water);
         fillpoly(4,triangle_v);
         triangle_1(xpos,ypos);
         setcolor(c_grass);
         setfillstyle(1,c_grass);
         fillpoly(4,triangle_v)
      end;
      5:begin   (* Water-Edge into left up *)
         triangle_4(xpos,ypos);
         setcolor(c_water);
         setfillstyle(1,c_water);
         fillpoly(4,triangle_v);
         triangle_2(xpos,ypos);
         setcolor(c_grass);
         setfillstyle(1,c_grass);
         fillpoly(4,triangle_v)
      end;
      6:begin   (* Hill *)
         setcolor(c_hill);
         setfillstyle(1,c_hill);
         squadrangle_1(xpos,ypos)
      end;
      7:begin   (* Edge downto down *)
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         squadrangle_2_v(xpos,ypos);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         squadrangle_2_w(xpos,ypos)
      end;
      8:begin   (* Edge downto right *)
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         squadrangle_3_v(xpos,ypos);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         squadrangle_3_w(xpos,ypos)
      end;
      9:begin   (* Edge downto up *)
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         squadrangle_2_v(xpos,ypos);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         squadrangle_2_w(xpos,ypos)
      end;
      10:begin   (* Edge downto left *)
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         squadrangle_3_v(xpos,ypos);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         squadrangle_3_w(xpos,ypos)
      end;
      11:begin   (* Grass-Edge downto right down *)
         triangle_2(xpos,ypos);
         setcolor(c_grass);
         setfillstyle(1,c_grass);
         fillpoly(4,triangle_v);
         triangle_8(xpos,ypos);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         fillpoly(4,triangle_v);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         fillpoly(4,quadrangle_v)
      end;
      12:begin   (* Grass-Edge downto right up *)
         triangle_3(xpos,ypos);
         setcolor(c_grass);
         setfillstyle(1,c_grass);
         fillpoly(4,triangle_v);
         triangle_5(xpos,ypos);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         fillpoly(4,triangle_v);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         fillpoly(4,quadrangle_v)
      end;
      13:begin   (* Grass-Edge downto left up *)
         triangle_4(xpos,ypos);
         setcolor(c_grass);
         setfillstyle(1,c_grass);
         fillpoly(4,triangle_v);
         triangle_6(xpos,ypos);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         fillpoly(4,triangle_v);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         fillpoly(4,quadrangle_v)
      end;
      14:begin   (* Grass-Edge downto left down *)
         triangle_1(xpos,ypos);
         setcolor(c_grass);
         setfillstyle(1,c_grass);
         fillpoly(4,triangle_v);
         triangle_7(xpos,ypos);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         fillpoly(4,triangle_v);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         fillpoly(4,quadrangle_v)
      end;
      15:begin   (* Hill-Edge downto right down *)
         triangle_4(xpos,ypos);
         setcolor(c_hill);
         setfillstyle(1,c_hill);
         fillpoly(4,triangle_v);
         triangle_6(xpos,ypos);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         fillpoly(4,triangle_v);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         fillpoly(4,quadrangle_v)
      end;
      16:begin   (* Hill-Edge downto right up *)
         triangle_1(xpos,ypos);
         setcolor(c_hill);
         setfillstyle(1,c_hill);
         fillpoly(4,triangle_v);
         triangle_7(xpos,ypos);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         fillpoly(4,triangle_v);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         fillpoly(4,quadrangle_v)
      end;
      17:begin   (* Hill-Edge downto left up *)
         triangle_2(xpos,ypos);
         setcolor(c_hill);
         setfillstyle(1,c_hill);
         fillpoly(4,triangle_v);
         triangle_8(xpos,ypos);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         fillpoly(4,triangle_v);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         fillpoly(4,quadrangle_v)
      end;
      18:begin   (* Hill-Edge downto left down *)
         triangle_3(xpos,ypos);
         setcolor(c_hill);
         setfillstyle(1,c_hill);
         fillpoly(4,triangle_v);
         triangle_5(xpos,ypos);
         setcolor(c_grass);
         setfillpattern(green50,c_grass);
         fillpoly(4,triangle_v);
         setcolor(c_hill);
         setfillpattern(green50,c_hill);
         fillpoly(4,quadrangle_v)
      end;
   end;
end;


procedure straight(direction,color:word);
var a,b:word;

begin
   a:=getx;
   b:=gety;
   setcolor(color);
   setfillstyle(1,color);
   case direction of
      1: begin
         b:=b+ywidth div 2;
         bar(a+1,b-1,a+xwidth,b+2)
      end;
      2: begin
         a:=a+xwidth div 2;
         bar(a-1,b+1,a+2,b+ywidth)
      end
  end
end;


procedure away_street(kind:byte);
var a,b:integer;

begin
   a:=getx;
   b:=gety;
   case kind of
      1: begin
         setcolor(8);
         line(a+1,b+6,a+xwidth,b+2);
         line(a+1,b+7,a+xwidth,b+3);
         line(a+1,b+8,a+xwidth,b+4);
         line(a+1,b+9,a+xwidth,b+5)
      end;
      2: begin
         setcolor(8);
         line(a+1,b+2,a+xwidth,b+6);
         line(a+1,b+3,a+xwidth,b+7);
         line(a+1,b+4,a+xwidth,b+8);
         line(a+1,b+5,a+xwidth,b+9)
      end;
      3: begin
         setcolor(8);
         line(a+1,b+6,a+xwidth,b+ywidth-4);
         line(a+1,b+7,a+xwidth,b+ywidth-3);
         line(a+1,b+8,a+xwidth,b+ywidth-2);
         line(a+1,b+9,a+xwidth,b+ywidth-1)
      end;
      4: begin
         setcolor(8);
         line(a+1,b+ywidth-4,a+xwidth,b+6);
         line(a+1,b+ywidth-3,a+xwidth,b+7);
         line(a+1,b+ywidth-2,a+xwidth,b+8);
         line(a+1,b+ywidth-1,a+xwidth,b+9)
      end;
      5: begin
         setcolor(8);
         line(a+2,b+1,a+6,b+ywidth);
         line(a+3,b+1,a+7,b+ywidth);
         line(a+4,b+1,a+8,b+ywidth);
         line(a+5,b+1,a+9,b+ywidth)
      end;
      6: begin
         setcolor(8);
         line(a+6,b+1,a+2,b+ywidth);
         line(a+7,b+1,a+3,b+ywidth);
         line(a+8,b+1,a+4,b+ywidth);
         line(a+9,b+1,a+5,b+ywidth)
      end;
      7: begin
         setcolor(8);
         line(a+xwidth-4,b+1,a+6,b+ywidth);
         line(a+xwidth-3,b+1,a+7,b+ywidth);
         line(a+xwidth-2,b+1,a+8,b+ywidth);
         line(a+xwidth-1,b+1,a+9,b+ywidth)
      end;
      8: begin
         setcolor(8);
         line(a+6,b+1,a+xwidth-4,b+ywidth);
         line(a+7,b+1,a+xwidth-3,b+ywidth);
         line(a+8,b+1,a+xwidth-2,b+ywidth);
         line(a+9,b+1,a+xwidth-1,b+ywidth)
      end;
      9: begin
         setcolor(8);
         line(a+1,b+ywidth-4,a+xwidth,b+ywidth-4);
         line(a+1,b+ywidth-3,a+xwidth,b+ywidth-3);
         line(a+1,b+ywidth-2,a+xwidth,b+ywidth-2);
         line(a+1,b+ywidth-1,a+xwidth,b+ywidth-1)
      end;
      10: begin
         setcolor(8);
         line(a+1,b+2,a+xwidth,b+2);
         line(a+1,b+3,a+xwidth,b+3);
         line(a+1,b+4,a+xwidth,b+4);
         line(a+1,b+5,a+xwidth,b+5)
      end;
      11: begin
         setcolor(8);
         line(a+2,b+1,a+2,b+ywidth);
         line(a+3,b+1,a+3,b+ywidth);
         line(a+4,b+1,a+4,b+ywidth);
         line(a+5,b+1,a+5,b+ywidth)
      end;
      12: begin
         setcolor(8);
         line(a+xwidth-1,b+1,a+xwidth-1,b+ywidth);
         line(a+xwidth-2,b+1,a+xwidth-2,b+ywidth);
         line(a+xwidth-3,b+1,a+xwidth-3,b+ywidth);
         line(a+xwidth-4,b+1,a+xwidth-4,b+ywidth)
      end
   end
end;


procedure tunnel(kind:byte);
var a,b:integer;

begin
   a:=getx;
   b:=gety;
   case kind of
      1: begin
         straight(1,8);
         setcolor(15);
         line(a+5,b+5,a+xwidth,b+5);
         line(a+5,b+10,a+xwidth,b+10);
         line(a+10,b+4,a+xwidth,b+4);
         line(a+10,b+11,a+xwidth,b+11);
         putpixel(a+8,b+6,7);
         putpixel(a+8,b+9,7);
         putpixel(a+7,b+7,7);
         putpixel(a+7,b+8,7);
         putpixel(a+11,b+6,7);
         putpixel(a+11,b+9,7);
         putpixel(a+10,b+7,7);
         putpixel(a+10,b+8,7);
         putpixel(a+14,b+6,7);
         putpixel(a+14,b+9,7);
         putpixel(a+13,b+7,7);
         putpixel(a+13,b+8,7)
      end;
      2: begin
         straight(1,8);
         setcolor(15);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         line(a+1,b+4,a+xwidth,b+4);
         line(a+1,b+11,a+xwidth,b+11);
         setcolor(7);
         line(a+2,b+6,a+2,b+9);
         line(a+5,b+6,a+5,b+9);
         line(a+10,b+6,a+10,b+9);
         line(a+13,b+6,a+13,b+9)
      end;
      3: begin
         straight(1,8);
         setcolor(15);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         line(a+1,b+4,a+xwidth,b+4);
         line(a+1,b+11,a+xwidth,b+11);
         setcolor(7);
         line(a+2,b+6,a+2,b+9);
         line(a+5,b+6,a+5,b+9);
         line(a+10,b+6,a+10,b+9);
         line(a+13,b+6,a+13,b+9);
         putpixel(a+7,b+7,6);
         putpixel(a+7,b+8,6);
         putpixel(a+8,b+7,6);
         putpixel(a+8,b+8,6);
         setcolor(6);
         line(a+7,b+6,a+8,b+6);
         line(a+7,b+9,a+8,b+9)
      end;
      4: begin
         straight(1,8);
         setcolor(15);
         line(a+1,b+5,a+xwidth-4,b+5);
         line(a+1,b+10,a+xwidth-4,b+10);
         line(a+1,b+4,a+xwidth-9,b+4);
         line(a+1,b+11,a+xwidth-9,b+11);
         putpixel(a+7,b+6,7);
         putpixel(a+7,b+9,7);
         putpixel(a+8,b+7,7);
         putpixel(a+8,b+8,7);
         putpixel(a+4,b+6,7);
         putpixel(a+4,b+9,7);
         putpixel(a+5,b+7,7);
         putpixel(a+5,b+8,7);
         putpixel(a+1,b+6,7);
         putpixel(a+1,b+9,7);
         putpixel(a+2,b+7,7);
         putpixel(a+2,b+8,7)
      end;
      5: begin
         straight(2,8);
         setcolor(15);
         line(a+5,b+1,a+5,b+10);
         line(a+10,b+1,a+10,b+10);
         line(a+4,b+1,a+4,b+5);
         line(a+11,b+1,a+11,b+5);
         putpixel(a+6,b+7,7);
         putpixel(a+9,b+7,7);
         putpixel(a+7,b+8,7);
         putpixel(a+8,b+8,7);
         putpixel(a+6,b+4,7);
         putpixel(a+9,b+4,7);
         putpixel(a+7,b+5,7);
         putpixel(a+8,b+5,7);
         putpixel(a+6,b+1,7);
         putpixel(a+9,b+1,7);
         putpixel(a+7,b+2,7);
         putpixel(a+8,b+2,7)
      end;
      6: begin
         straight(2,8);
         setcolor(15);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         line(a+4,b+1,a+4,b+ywidth);
         line(a+11,b+1,a+11,b+ywidth);
         setcolor(7);
         line(a+6,b+2,a+9,b+2);
         line(a+6,b+5,a+9,b+5);
         line(a+6,b+10,a+9,b+10);
         line(a+6,b+13,a+9,b+13)
      end;
      7: begin
         straight(2,8);
         setcolor(15);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         line(a+4,b+1,a+4,b+ywidth);
         line(a+11,b+1,a+11,b+ywidth);
         setcolor(7);
         line(a+6,b+2,a+9,b+2);
         line(a+6,b+5,a+9,b+5);
         line(a+6,b+10,a+9,b+10);
         line(a+6,b+13,a+9,b+13);
         putpixel(a+7,b+7,6);
         putpixel(a+7,b+8,6);
         putpixel(a+8,b+7,6);
         putpixel(a+8,b+8,6);
         setcolor(6);
         line(a+6,b+7,a+6,b+8);
         line(a+9,b+7,a+9,b+8)
      end;
      8: begin
         straight(2,8);
         setcolor(15);
         line(a+5,b+5,a+5,b+ywidth);
         line(a+10,b+5,a+10,b+ywidth);
         line(a+4,b+10,a+4,b+ywidth);
         line(a+11,b+10,a+11,b+ywidth);
         putpixel(a+6,b+8,7);
         putpixel(a+9,b+8,7);
         putpixel(a+7,b+7,7);
         putpixel(a+8,b+7,7);
         putpixel(a+6,b+11,7);
         putpixel(a+9,b+11,7);
         putpixel(a+7,b+10,7);
         putpixel(a+8,b+10,7);
         putpixel(a+6,b+14,7);
         putpixel(a+9,b+14,7);
         putpixel(a+7,b+13,7);
         putpixel(a+8,b+13,7)
      end;
      9: begin
         straight(1,0);
         setcolor(4);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(6);
         line(a+1,b+4,a+xwidth,b+4);
         line(a+1,b+11,a+xwidth,b+11)
      end;
      10: begin
         straight(2,0);
         setcolor(4);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(6);
         line(a+4,b+1,a+4,b+ywidth);
         line(a+11,b+1,a+11,b+ywidth)
      end
   end
end;


procedure ramp(kind:byte);
var a,b:integer;

begin
   a:=getx;
   b:=gety;
   case kind of
      1: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+4,b+4,a+xwidth,b+4);
         line(a+8,b+3,a+xwidth,b+3);
         line(a+4,b+11,a+xwidth,b+11);
         line(a+8,b+12,a+xwidth,b+12)
      end;
      2: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+4,b+4,a+7,b+4);
         line(a+4,b+11,a+7,b+11)
      end;
      3: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+4,b+4,a+7,b+4);
         line(a+4,b+11,a+7,b+11);
         setcolor(9);
         line(a+8,b+5,a+10,b+5);
         line(a+8,b+10,a+10,b+10);
         line(a+10,b+4,a+12,b+4);
         line(a+10,b+11,a+12,b+11);
         line(a+12,b+3,a+xwidth,b+3);
         line(a+12,b+12,a+xwidth,b+12)
      end;
      4: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+1,b+4,a+xwidth,b+4);
         line(a+1,b+11,a+xwidth,b+11);
         line(a+1,b+3,a+xwidth,b+3);
         line(a+1,b+12,a+xwidth,b+12)
      end;
      5: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+1,b+4,a+xwidth,b+4);
         line(a+1,b+11,a+xwidth,b+11);
         PutPixel(a+1,b+3,15);
         PutPixel(a+xwidth,b+3,15);
         PutPixel(a+1,b+12,15);
         PutPixel(a+xwidth,b+12,15);
         PutPixel(a+5,b+3,15);
         PutPixel(a+xwidth-4,b+3,15);
         PutPixel(a+5,b+12,15);
         PutPixel(a+xwidth-4,b+12,15)
      end;
      6: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+1,b+4,a+xwidth,b+4);
         line(a+1,b+11,a+xwidth,b+11);
         PutPixel(a+1,b+3,15);
         PutPixel(a+xwidth,b+3,15);
         PutPixel(a+1,b+12,15);
         PutPixel(a+xwidth,b+12,15)
      end;
      7: begin
         straight(2,8);
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+1,b+4,a+xwidth,b+4);
         line(a+1,b+11,a+xwidth,b+11);
         PutPixel(a+1,b+3,15);
         PutPixel(a+xwidth,b+3,15);
         PutPixel(a+1,b+12,15);
         PutPixel(a+xwidth,b+12,15)
      end;
      8: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+11,b+4,a+1,b+4);
         line(a+7,b+3,a+1,b+3);
         line(a+11,b+11,a+1,b+11);
         line(a+7,b+12,a+1,b+12)
      end;
      9: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+11,b+4,a+8,b+4);
         line(a+11,b+11,a+8,b+11)
      end;
      10: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+10,a+xwidth,b+10);
         setcolor(15);
         line(a+8,b+4,a+11,b+4);
         line(a+8,b+11,a+11,b+11);
         setcolor(9);
         line(a+7,b+5,a+5,b+5);
         line(a+7,b+10,a+5,b+10);
         line(a+5,b+4,a+3,b+4);
         line(a+5,b+11,a+3,b+11);
         line(a+3,b+3,a+1,b+3);
         line(a+3,b+12,a+1,b+12)
      end;
      11: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+11,a+4,b+1);
         line(a+3,b+7,a+3,b+1);
         line(a+11,b+11,a+11,b+1);
         line(a+12,b+7,a+12,b+1)
      end;
      12: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+11,a+4,b+8);
         line(a+11,b+11,a+11,b+8)
      end;
      13: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+8,a+4,b+11);
         line(a+11,b+8,a+11,b+11);
         setcolor(9);
         line(a+5,b+7,a+5,b+5);
         line(a+10,b+7,a+10,b+5);
         line(a+4,b+5,a+4,b+3);
         line(a+11,b+5,a+11,b+3);
         line(a+3,b+3,a+3,b+1);
         line(a+12,b+3,a+12,b+1)
      end;
      14: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+1,a+4,b+ywidth);
         line(a+11,b+1,a+11,b+ywidth);
         line(a+3,b+1,a+3,b+ywidth);
         line(a+12,b+1,a+12,b+ywidth)
      end;
      15: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+1,a+4,b+ywidth);
         line(a+11,b+1,a+11,b+ywidth);
         PutPixel(a+3,b+1,15);
         PutPixel(a+3,b+ywidth,15);
         PutPixel(a+12,b+1,15);
         PutPixel(a+12,b+ywidth,15);
         PutPixel(a+3,b+5,15);
         PutPixel(a+3,b+ywidth-4,15);
         PutPixel(a+12,b+5,15);
         PutPixel(a+12,b+ywidth-4,15)
      end;
      16: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+1,a+4,b+ywidth);
         line(a+11,b+1,a+11,b+ywidth);
         PutPixel(a+3,b+1,15);
         PutPixel(a+3,b+ywidth,15);
         PutPixel(a+12,b+1,15);
         PutPixel(a+12,b+ywidth,15)
      end;
      17: begin
         straight(1,8);
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+1,a+4,b+ywidth);
         line(a+11,b+1,a+11,b+ywidth);
         PutPixel(a+3,b+1,15);
         PutPixel(a+3,b+ywidth,15);
         PutPixel(a+12,b+1,15);
         PutPixel(a+12,b+ywidth,15)
      end;
      18: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+4,a+4,b+ywidth);
         line(a+3,b+8,a+3,b+ywidth);
         line(a+11,b+4,a+11,b+ywidth);
         line(a+12,b+8,a+12,b+ywidth)
      end;
      19: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+4,a+4,b+7);
         line(a+11,b+4,a+11,b+7)
      end;
      20: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+10,b+1,a+10,b+ywidth);
         setcolor(15);
         line(a+4,b+4,a+4,b+7);
         line(a+11,b+4,a+11,b+7);
         setcolor(9);
         line(a+5,b+8,a+5,b+10);
         line(a+10,b+8,a+10,b+10);
         line(a+4,b+10,a+4,b+12);
         line(a+11,b+10,a+11,b+12);
         line(a+3,b+12,a+3,b+ywidth);
         line(a+12,b+12,a+12,b+ywidth)
      end
   end
end;


procedure inclined(kind:byte);
var a,b:word;

begin
   a:=getx;
   b:=gety;
   case kind of
      1: begin
         straight(1,8);
         setcolor(12);
         line(a+xwidth div 3,b+5,a+xwidth,b+5);
         line(a+xwidth div 2+1,b+6,a+xwidth,b+6)
      end;
      2: begin
         straight(1,8);
         setcolor(12);
         line(a+1,b+5,a+xwidth,b+5);
         line(a+1,b+6,a+xwidth,b+6)
      end;
      3: begin
         straight(1,8);
         setcolor(12);
         line(a+1,b+5,a+xwidth-xwidth div 3+1,b+5);
         line(a+1,b+6,a+xwidth div 2,b+6)
      end;
      4: begin
         straight(1,8);
         setcolor(12);
         line(a+xwidth div 3,b+10,a+xwidth,b+10);
         line(a+xwidth div 2+1,b+9,a+xwidth,b+9)
      end;
      5: begin
         straight(1,8);
         setcolor(12);
         line(a+1,b+10,a+xwidth,b+10);
         line(a+1,b+9,a+xwidth,b+9)
      end;
      6: begin
         straight(1,8);
         setcolor(12);
         line(a+1,b+10,a+xwidth-xwidth div 3+1,b+10);
         line(a+1,b+9,a+xwidth div 2,b+9)
      end;
      7: begin
         straight(2,8);
         setcolor(12);
         line(a+5,b+ywidth div 3,a+5,b+ywidth);
         line(a+6,b+ywidth div 2+1,a+6,b+ywidth)
      end;
      8: begin
         straight(2,8);
         setcolor(12);
         line(a+5,b+1,a+5,b+ywidth);
         line(a+6,b+1,a+6,b+ywidth)
      end;
      9: begin
         straight(2,8);
         setcolor(12);
         line(a+5,b+1,a+5,b+ywidth-ywidth div 3+1);
         line(a+6,b+1,a+6,b+ywidth div 2)
      end;
      10: begin
         straight(2,8);
         setcolor(12);
         line(a+10,b+ywidth div 3,a+10,b+ywidth);
         line(a+9,b+ywidth div 2+1,a+9,b+ywidth)
      end;
      11: begin
         straight(2,8);
         setcolor(12);
         line(a+10,b+1,a+10,b+ywidth);
         line(a+9,b+1,a+9,b+ywidth)
      end;
      12: begin
         straight(2,8);
         setcolor(12);
         line(a+10,b+1,a+10,b+ywidth-ywidth div 3+1);
         line(a+9,b+1,a+9,b+ywidth div 2)
      end
   end
end;


procedure small_curve(quadrant,color:word);
var a,b:word;

begin
   a:=getx;
   b:=gety;
   setcolor(color);
   case quadrant of
      1: begin
         arc(a+2,b+ywidth-1,10,80,xwidth div 2);
         arc(a+1,b+ywidth,0,90,xwidth div 2+1);
         arc(a+1,b+ywidth,0,90,xwidth div 2);
         arc(a+1,b+ywidth,0,90,xwidth div 2-1);
         arc(a+1,b+ywidth,0,90,xwidth div 2-2);
         putpixel(a+5,b+9,color);
         putpixel(a+6,b+10,color)
      end;
      2: begin
         arc(a+xwidth-1,b+ywidth-1,90,170,xwidth div 2);
         arc(a+xwidth,b+ywidth,90,180,xwidth div 2+1);
         arc(a+xwidth,b+ywidth,90,180,xwidth div 2);
         arc(a+xwidth,b+ywidth,90,180,xwidth div 2-1);
         arc(a+xwidth,b+ywidth,90,180,xwidth div 2-2);
         putpixel(a+xwidth-4,b+9,color);
         putpixel(a+xwidth-5,b+10,color)
      end;
      3: begin
         arc(a+xwidth-1,b+2,190,260,xwidth div 2);
         arc(a+xwidth,b+1,180,270,xwidth div 2+1);
         arc(a+xwidth,b+1,180,270,xwidth div 2);
         arc(a+xwidth,b+1,180,270,xwidth div 2-1);
         arc(a+xwidth,b+1,180,270,xwidth div 2-2);
         putpixel(a+xwidth-4,b+ywidth-8,color);
         putpixel(a+xwidth-5,b+ywidth-9,color)
      end;
      4: begin
         arc(a+2,b+2,280,352,xwidth div 2);
         arc(a+1,b+1,270,360,xwidth div 2+1);
         arc(a+1,b+1,270,360,xwidth div 2);
         arc(a+1,b+1,270,360,xwidth div 2-1);
         arc(a+1,b+1,270,360,xwidth div 2-2);
         putpixel(a+5,b+ywidth-8,color);
         putpixel(a+6,b+ywidth-9,color)
      end
   end
end;


procedure big_curve(combquadrant,color,rand:word);
var a,b,mx,my,r:word;

begin                                        (*   6  5  2  1  *)
   a:=getx;                                  (*   7  8  3  4  *)
   b:=gety;                                  (*  10  9 14 13  *)
   setcolor(color);                          (*  11 12 15 16  *)
   r:=3*ywidth div 2+3;
   case combquadrant of
      1: begin
         mx:=a-xwidth-1;
         my:=b+2*ywidth+2;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,40,50,r+1);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,40,50,r+1)
            end
         end;
         arc(mx,my,40,50,r);
         putpixel(a+1,b+ywidth-1,color);
         putpixel(a+1,b+ywidth,color);
         putpixel(a+2,b+ywidth,color)
      end;
      2: begin
         mx:=a;
         my:=b+2*ywidth+2;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,54,89,r+1);
               arc(mx,my,53,89,r-4);
               putpixel(a+14,b+10,7);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,54,89,r+1);
               putpixel(a+14,b+10,12)
            end
         end
         else begin
            putpixel(a+xwidth-2,b+ywidth,15);
            putpixel(a+xwidth-4,b+ywidth-1,15);
            putpixel(a+xwidth-6,b+ywidth-2,15);
            putpixel(a+xwidth-8,b+ywidth-3,15);
            putpixel(a+xwidth-10,b+ywidth-4,12);
            putpixel(a+xwidth-12,b+ywidth-4,12);
            putpixel(a+xwidth-3,b+ywidth-1,12);
            putpixel(a+xwidth-5,b+ywidth-2,12);
            putpixel(a+xwidth-7,b+ywidth-3,12);
            putpixel(a+xwidth-9,b+ywidth-3,12);
            putpixel(a+xwidth-11,b+ywidth-4,15);
         end;
         arc(mx,my,53,89,r);
         setcolor(color);
         arc(mx,my,52,89,r-1);
         arc(mx,my,50,89,r-2);
         arc(mx,my,49,89,r-3);
         putpixel(a+8,b+9,color);
         putpixel(a+10,b+11,color);
         putpixel(a+12,b+11,color);
         putpixel(a+13,b+13,color)
      end;
      3: begin
         case rand of
            0: begin
               putpixel(a+xwidth,b+1,12);
               arc(a+xwidth-5,b+6,0,90,3);
            end;
            1: begin
               putpixel(a+xwidth,b+1,7);
               setcolor(7);
               arc(a+xwidth-5,b+6,0,90,3);
            end;
            2: begin
               putpixel(a+xwidth,b+1,8);
               setcolor(12);
               arc(a+xwidth-5,b+6,0,90,3);
            end;
         end;
      end;
      4: begin
         mx:=a-xwidth-1;
         my:=b+ywidth+1;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,1,36,r+1);
               arc(mx,my,1,37,r-4);
               putpixel(a+5,b+1,7);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,1,36,r+1);
               putpixel(a+5,b+1,12)
            end
         end
         else begin
            putpixel(a+1,b+3,15);
            putpixel(a+2,b+5,15);
            putpixel(a+3,b+7,15);
            putpixel(a+4,b+9,15);
            putpixel(a+5,b+11,12);
            putpixel(a+5,b+13,12);
            putpixel(a+2,b+4,12);
            putpixel(a+3,b+6,12);
            putpixel(a+4,b+8,12);
            putpixel(a+4,b+10,12);
            putpixel(a+5,b+12,15);
         end;
         arc(mx,my,1,37,r);
         setcolor(color);
         arc(mx,my,1,38,r-1);
         arc(mx,my,1,40,r-2);
         arc(mx,my,1,41,r-3);
         putpixel(a+2,b+2,color);
         putpixel(a+4,b+3,color);
         putpixel(a+4,b+5,color);
         putpixel(a+6,b+7,color)
      end;
      5: begin
         mx:=a+xwidth+1;
         my:=b+2*ywidth+2;
         putpixel(a+xwidth,b+6,color);
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,91,124,r+1);
               arc(mx,my,91,124,r-4);
               putpixel(a+xwidth,b+10,7);
               putpixel(a+1,b+10,7);
               putpixel(a+xwidth,b+5,7);
               putpixel(a+xwidth,b+6,8);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,91,124,r+1);
               putpixel(a+1,b+10,12);
               putpixel(a+xwidth,b+5,12);
               putpixel(a+xwidth,b+6,12)
            end
         end
         else begin
            putpixel(a+3,b+ywidth,15);
            putpixel(a+5,b+ywidth-1,15);
            putpixel(a+7,b+ywidth-2,15);
            putpixel(a+9,b+ywidth-3,15);
            putpixel(a+11,b+ywidth-4,12);
            putpixel(a+13,b+ywidth-4,12);
            putpixel(a+4,b+ywidth-1,12);
            putpixel(a+6,b+ywidth-2,12);
            putpixel(a+8,b+ywidth-3,12);
            putpixel(a+10,b+ywidth-3,12);
            putpixel(a+12,b+ywidth-4,15);
         end;
         arc(mx,my,91,125,r);
         setcolor(color);
         arc(mx,my,91,128,r-1);
         arc(mx,my,91,129,r-2);
         arc(mx,my,91,131,r-3);
         putpixel(a+7,b+9,color);
         putpixel(a+5,b+11,color);
         putpixel(a+3,b+11,color);
         putpixel(a+2,b+13,color);
         putpixel(a+xwidth,b+7,color);
         putpixel(a+xwidth,b+8,color);
         putpixel(a+xwidth,b+9,color)
      end;
      6: begin
         mx:=a+2*xwidth+2;
         my:=b+2*ywidth+2;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,129,138,r+1);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,129,138,r+1)
            end
         end;
         arc(mx,my,130,138,r);
         setcolor(color);
         putpixel(a+xwidth,b+ywidth-1,color);
         putpixel(a+xwidth-1,b+ywidth,color);
         putpixel(a+xwidth,b+ywidth,color)
      end;
      7: begin
         mx:=a+2*xwidth+2;
         my:=b+ywidth+1;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,144,177,r+1);
               arc(mx,my,143,177,r-4);
               putpixel(a+10,b+1,7);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,144,177,r+1);
               putpixel(a+10,b+1,12)
            end
         end
         else begin
            putpixel(a+xwidth,b+3,15);
            putpixel(a+xwidth-1,b+5,15);
            putpixel(a+xwidth-2,b+7,15);
            putpixel(a+xwidth-3,b+9,15);
            putpixel(a+xwidth-4,b+11,12);
            putpixel(a+xwidth-4,b+13,12);
            putpixel(a+xwidth-1,b+4,12);
            putpixel(a+xwidth-2,b+6,12);
            putpixel(a+xwidth-3,b+8,12);
            putpixel(a+xwidth-3,b+10,12);
            putpixel(a+xwidth-4,b+12,15);
         end;
         arc(mx,my,142,177,r);
         setcolor(color);
         arc(mx,my,141,177,r-1);
         arc(mx,my,140,177,r-2);
         arc(mx,my,138,177,r-3);
         putpixel(a+13,b+2,color);
         putpixel(a+11,b+3,color);
         putpixel(a+11,b+5,color);
         putpixel(a+9,b+7,color)
      end;
      8: begin
         case rand of
            0: begin
               putpixel(a+1,b+1,12);
               arc(a+6,b+6,90,180,3);
            end;
            1: begin
               putpixel(a+1,b+1,7);
               setcolor(7);
               arc(a+6,b+6,90,180,3);
            end;
            2: begin
               putpixel(a+1,b+1,8);
               setcolor(12);
               arc(a+6,b+6,90,180,3);
            end;
         end;
      end;
      9: begin
         case rand of
            0: begin
               putpixel(a+1,b+ywidth,12);
               arc(a+6,b+ywidth-5,180,270,3);
            end;
            1: begin
               putpixel(a+1,b+ywidth,7);
               setcolor(7);
               arc(a+6,b+ywidth-5,180,270,3);
            end;
            2: begin
               putpixel(a+1,b+ywidth,8);
               setcolor(12);
               arc(a+6,b+ywidth-5,180,270,3);
            end;
         end;
      end;
      10: begin
         mx:=a+2*xwidth+2;
         my:=b;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,181,216,r+1);
               arc(mx,my,181,217,r-4);
               putpixel(a+10,b+ywidth,7);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,181,216,r+1);
               putpixel(a+10,b+ywidth,12)
            end
         end
         else begin
            putpixel(a+xwidth,b+ywidth-2,15);
            putpixel(a+xwidth-1,b+ywidth-4,15);
            putpixel(a+xwidth-2,b+ywidth-6,15);
            putpixel(a+xwidth-3,b+ywidth-8,15);
            putpixel(a+xwidth-4,b+ywidth-10,12);
            putpixel(a+xwidth-4,b+ywidth-12,12);
            putpixel(a+xwidth-1,b+ywidth-3,12);
            putpixel(a+xwidth-2,b+ywidth-5,12);
            putpixel(a+xwidth-3,b+ywidth-7,12);
            putpixel(a+xwidth-3,b+ywidth-9,12);
            putpixel(a+xwidth-4,b+ywidth-11,15);
         end;
         arc(mx,my,181,217,r);
         setcolor(color);
         arc(mx,my,181,219,r-1);
         arc(mx,my,181,220,r-2);
         arc(mx,my,181,222,r-3);
         putpixel(a+13,b+13,color);
         putpixel(a+11,b+12,color);
         putpixel(a+11,b+10,color);
         putpixel(a+9,b+8,color)
      end;
      11: begin
         mx:=a+2*xwidth+2;
         my:=b-ywidth-1;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,220,230,r+1);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,220,230,r+1)
            end
         end;
         arc(mx,my,221,230,r);
         setcolor(color);
         putpixel(a+xwidth-1,b+1,color);
         putpixel(a+xwidth,b+1,color);
         putpixel(a+xwidth,b+2,color)
      end;
      12: begin
         mx:=a+xwidth+1;
         my:=b-ywidth-1;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,234,269,r+1);
               arc(mx,my,233,269,r-4);
               putpixel(a+1,b+5,7);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,234,269,r+1);
               putpixel(a+1,b+5,12)
            end
         end
         else begin
            putpixel(a+3,b+1,15);
            putpixel(a+5,b+2,15);
            putpixel(a+7,b+3,15);
            putpixel(a+9,b+4,15);
            putpixel(a+11,b+5,12);
            putpixel(a+13,b+5,12);
            putpixel(a+4,b+2,12);
            putpixel(a+6,b+3,12);
            putpixel(a+8,b+4,12);
            putpixel(a+10,b+4,12);
            putpixel(a+12,b+5,15);
         end;
         arc(mx,my,234,269,r);
         setcolor(color);
         arc(mx,my,232,269,r-1);
         arc(mx,my,230,269,r-2);
         arc(mx,my,229,269,r-3);
         putpixel(a+7,b+6,color);
         putpixel(a+5,b+4,color);
         putpixel(a+3,b+4,color);
         putpixel(a+2,b+2,color)
      end;
      13: begin
         mx:=a-xwidth-1;
         my:=b;
         putpixel(a+9,b+1,color);
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,326,359,r+1);
               arc(mx,my,326,359,r-4);
               putpixel(a+5,b+ywidth,7);
               putpixel(a+5,b+1,7);
               putpixel(a+9,b+1,8);
               putpixel(a+10,b+1,7);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,326,359,r+1);
               putpixel(a+5,b+ywidth,12);
               putpixel(a+9,b+1,12);
               putpixel(a+10,b+1,12)
            end
         end
         else begin
            putpixel(a+1,b+ywidth-2,15);
            putpixel(a+2,b+ywidth-4,15);
            putpixel(a+3,b+ywidth-6,15);
            putpixel(a+4,b+ywidth-8,15);
            putpixel(a+5,b+ywidth-10,12);
            putpixel(a+5,b+ywidth-12,12);
            putpixel(a+2,b+ywidth-3,12);
            putpixel(a+3,b+ywidth-5,12);
            putpixel(a+4,b+ywidth-7,12);
            putpixel(a+4,b+ywidth-9,12);
            putpixel(a+5,b+ywidth-11,15);
         end;
         arc(mx,my,325,359,r);
         setcolor(color);
         arc(mx,my,322,359,r-1);
         arc(mx,my,321,359,r-2);
         arc(mx,my,319,359,r-3);
         putpixel(a+2,b+13,color);
         putpixel(a+4,b+12,color);
         putpixel(a+4,b+10,color);
         putpixel(a+6,b+8,color);
         putpixel(a+6,b+1,color);
         putpixel(a+7,b+1,color);
         putpixel(a+8,b+1,color)
      end;
      14: begin
         case rand of
            0: begin
               putpixel(a+xwidth,b+ywidth,12);
               arc(a+xwidth-5,b+ywidth-5,270,360,3);
            end;
            1: begin
               putpixel(a+xwidth,b+ywidth,7);
               setcolor(7);
               arc(a+xwidth-5,b+ywidth-5,270,360,3);
            end;
            2: begin
               putpixel(a+xwidth,b+ywidth,8);
               setcolor(12);
               arc(a+xwidth-5,b+ywidth-5,270,360,3);
            end;
         end;
      end;
      15: begin
         mx:=a;
         my:=b-ywidth-1;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,273,306,r+1);
               arc(mx,my,273,307,r-4);
               putpixel(a+xwidth,b+5,7);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,273,306,r+1);
               putpixel(a+xwidth,b+5,12)
            end
         end
         else begin
            putpixel(a+xwidth-2,b+1,15);
            putpixel(a+xwidth-4,b+2,15);
            putpixel(a+xwidth-6,b+3,15);
            putpixel(a+xwidth-8,b+4,15);
            putpixel(a+xwidth-10,b+5,12);
            putpixel(a+xwidth-12,b+5,12);
            putpixel(a+xwidth-3,b+2,12);
            putpixel(a+xwidth-5,b+3,12);
            putpixel(a+xwidth-7,b+4,12);
            putpixel(a+xwidth-9,b+4,12);
            putpixel(a+xwidth-11,b+5,15);
         end;
         arc(mx,my,273,308,r);
         setcolor(color);
         arc(mx,my,273,309,r-1);
         arc(mx,my,273,310,r-2);
         arc(mx,my,273,312,r-3);
         putpixel(a+8,b+6,color);
         putpixel(a+10,b+4,color);
         putpixel(a+12,b+4,color);
         putpixel(a+13,b+2,color)
      end;
      16: begin
         mx:=a-xwidth-1;
         my:=b-ywidth-1;
         if rand>0
         then begin
            if rand=1
            then begin
               setcolor(7);
               arc(mx,my,312,321,r+1);
               setcolor(color)
            end
            else begin
               setcolor(12);
               arc(mx,my,312,321,r+1)
            end
         end;
         arc(mx,my,312,320,r);
         setcolor(color);
         putpixel(a+1,b+1,color);
         putpixel(a+2,b+1,color);
         putpixel(a+1,b+2,color)
      end
   end
end;


procedure s_big_curve(kind:word);
var x,y:word;

begin       
   x:=getx;
   y:=gety;
   case kind of
      1: begin
         big_curve(6,8,0);
         straight(1,8)
      end;
      2: begin
         big_curve(2,8,0);
         straight(1,8);
      end;
      3: begin
         big_curve(10,8,0);
         setcolor(8);
         line(x+xwidth div 4-1,y+ywidth+1-ywidth div 4,
              x+xwidth div 4+2,y+ywidth+1-ywidth div 4);
         arc(x+6,y+ywidth-5,180,270,3);
      end;
      4: begin
         big_curve(14,8,0);
         setcolor(8);
         line(x+xwidth+1-xwidth div 4-2,y+ywidth+1-ywidth div 4,
              x+xwidth+2-xwidth div 4,y+ywidth+1-ywidth div 4)
      end;
      5: begin
         big_curve(6,8,0);
         straight(2,8)
      end;
      6: begin
         big_curve(2,8,0);
         setcolor(8);
         line(x+xwidth+1-xwidth div 4,y+ywidth div 4-1,
              x+xwidth+1-xwidth div 4,y+ywidth div 4+2);
         arc(x+xwidth-5,y+6,0,90,3);
      end;
      7: begin
         big_curve(10,8,0);
         straight(2,8)
      end;
      8: begin
         big_curve(14,8,0);
         setcolor(8);
         line(x+xwidth+1-xwidth div 4,y+ywidth+1-ywidth div 4-2,
              x+xwidth+1-xwidth div 4,y+ywidth+2-ywidth div 4)
      end;
      9: begin
         big_curve(5,8,0);
         straight(1,8)
      end;
      10: begin
         big_curve(1,8,0);
         straight(1,8)
      end;
      11: begin
         big_curve(9,8,0);
         setcolor(8);
         line(x+xwidth div 4-1,y+ywidth+1-ywidth div 4,
              x+xwidth div 4+2,y+ywidth+1-ywidth div 4)
      end;
      12: begin
         big_curve(13,8,0);
         setcolor(8);
         line(x+xwidth+1-xwidth div 4-2,y+ywidth+1-ywidth div 4,
              x+xwidth+2-xwidth div 4,y+ywidth+1-ywidth div 4);
         arc(x+xwidth-5,y+ywidth-5,270,360,3);
      end;
      13: begin
         big_curve(5,8,0);
         setcolor(8);
         line(x+xwidth div 4,y+ywidth div 4-1,
              x+xwidth div 4,y+ywidth div 4+2);
         arc(x+6,y+6,90,180,3);
      end;
      14: begin
         big_curve(1,8,0);
         straight(2,8)
      end;
      15: begin
         big_curve(9,8,0);
         setcolor(8);
         line(x+xwidth div 4,y+ywidth+1-ywidth div 4-2,
              x+xwidth div 4,y+ywidth+2-ywidth div 4)
      end;
      16: begin
         big_curve(13,8,0);
         straight(2,8)
      end;
      17: begin
         big_curve(7,8,0);
         setcolor(8);
         line(x+xwidth div 4-1,y+ywidth div 4,
              x+xwidth div 4+2,y+ywidth div 4);
         arc(x+6,y+6,90,180,3);
      end;
      18: begin
         big_curve(3,8,0);
         setcolor(8);
         line(x+xwidth+1-xwidth div 4-2,y+ywidth div 4,
              x+xwidth+2-xwidth div 4,y+ywidth div 4);
      end;
      19: begin
         big_curve(11,8,0);
         straight(1,8)
      end;
      20: begin
         big_curve(15,8,0);
         straight(1,8)
      end;
      21: begin
         big_curve(7,8,0);
         straight(2,8)
      end;
      22: begin
         big_curve(3,8,0);
         setcolor(8);
         line(x+xwidth+1-xwidth div 4,y+ywidth div 4-1,
              x+xwidth+1-xwidth div 4,y+ywidth div 4+2);
      end;
      23: begin
         big_curve(11,8,0);
         straight(2,8)
      end;
      24: begin
         big_curve(15,8,0);
         setcolor(8);
         line(x+xwidth+1-xwidth div 4,y+ywidth+1-ywidth div 4-2,
              x+xwidth+1-xwidth div 4,y+ywidth+2-ywidth div 4);
         arc(x+xwidth-5,y+ywidth-5,270,360,3);
      end;
      25: begin
         big_curve(8,8,0);
         setcolor(8);
         line(x+xwidth div 4-1,y+ywidth div 4,
              x+xwidth div 4+2,y+ywidth div 4)
      end;
      26: begin
         big_curve(4,8,0);
         setcolor(8);
         line(x+xwidth+1-xwidth div 4-2,y+ywidth div 4,
              x+xwidth+2-xwidth div 4,y+ywidth div 4);
         arc(x+xwidth-5,y+6,0,90,3);
      end;
      27: begin
         big_curve(12,8,0);
         straight(1,8)
      end;
      28: begin
         big_curve(16,8,0);
         straight(1,8)
      end;
      29: begin
         big_curve(8,8,0);
         setcolor(8);
         line(x+xwidth div 4,y+ywidth div 4-1,
              x+xwidth div 4,y+ywidth div 4+2)
      end;
      30: begin
         big_curve(4,8,0);
         straight(2,8)
      end;
      31: begin
         big_curve(12,8,0);
         setcolor(8);
         line(x+xwidth div 4,y+ywidth+1-ywidth div 4-2,
              x+xwidth div 4,y+ywidth+2-ywidth div 4);
         arc(x+6,y+ywidth-5,180,270,3);
      end;
      32: begin
         big_curve(16,8,0);
         straight(2,8)
      end;
   end;
end;

procedure chick(kind:byte);    (*   1    2    3    4  *)
var a,b:integer;               (*   == ==      #  #   *)
                               (* ==     ==  #      # *)
begin
   a:=getx;
   b:=gety;
   setcolor(8);
   case kind of
      1: begin
         arc(a+xwidth+1,b+2*ywidth-2,91,132,3*ywidth div 2-1);
         arc(a+xwidth+1,b+2*ywidth-2,91,134,3*ywidth div 2-2);
         arc(a+xwidth+1,b+2*ywidth-2,91,135,3*ywidth div 2-3);
         arc(a+xwidth+1,b+2*ywidth-2,91,135,3*ywidth div 2-4);
         line(a+1,b+ywidth,a+3,b+ywidth-2);
         putpixel(a+1,b+ywidth-3,8);
         putpixel(a+2,b+ywidth-4,8);
         putpixel(a+4,b+ywidth,8);
         putpixel(a+5,b+ywidth-1,8);
         putpixel(a+4,b+ywidth-4,8);
         putpixel(a+8,b+ywidth-4,8);
         putpixel(a+6,b+ywidth-3,8);
         putpixel(a+xwidth,b+6,8);
         putpixel(a+xwidth,b+7,8);
         putpixel(a+xwidth,b+8,8);
         putpixel(a+xwidth,b+9,8)
      end;
      2: begin
         putpixel(a+xwidth,b+ywidth-1,8);
         putpixel(a+xwidth-1,b+ywidth,8);
         putpixel(a+xwidth,b+ywidth,8);
         line(a+xwidth-5,b+6,a+xwidth-3,b+6);
         line(a+4,b+9,a+6,b+9);
         line(a+xwidth-5,b+6,a+6,b+9);
      end;
      3: begin
         arc(a,b-ywidth+3,274,316,3*ywidth div 2-1);
         arc(a,b-ywidth+3,274,318,3*ywidth div 2-2);
         arc(a,b-ywidth+3,274,319,3*ywidth div 2-3);
         arc(a,b-ywidth+3,274,319,3*ywidth div 2-4);
         line(a+xwidth,b+1,a+xwidth-2,b+3);
         putpixel(a+xwidth-3,b+1,8);
         putpixel(a+xwidth-4,b+2,8);
         putpixel(a+xwidth,b+4,8);
         putpixel(a+xwidth-1,b+5,8);
         putpixel(a+xwidth-3,b+5,8);
         putpixel(a+xwidth-7,b+5,8);
         putpixel(a+xwidth-5,b+4,8)
      end;
      4: begin
         putpixel(a+1,b+1,8);
         putpixel(a+2,b+1,8);
         putpixel(a+1,b+2,8);
         line(a+xwidth-5,b+6,a+xwidth-3,b+6);
         line(a+4,b+9,a+6,b+9);
         line(a+xwidth-5,b+6,a+6,b+9);
      end;
      5: begin
         putpixel(a+1,b+ywidth-1,8);
         putpixel(a+1,b+ywidth,8);
         putpixel(a+2,b+ywidth,8);
         line(a+xwidth-5,b+9,a+xwidth-3,b+9);
         line(a+4,b+6,a+6,b+6);
         line(a+xwidth-5,b+9,a+6,b+6);
      end;
      6: begin
         arc(a,b+2*ywidth-2,45,89,3*ywidth div 2-1);
         arc(a,b+2*ywidth-2,43,89,3*ywidth div 2-2);
         arc(a,b+2*ywidth-2,42,89,3*ywidth div 2-3);
         arc(a,b+2*ywidth-2,42,89,3*ywidth div 2-4);
         line(a+xwidth,b+ywidth,a+xwidth-2,b+ywidth-2);
         putpixel(a+xwidth,b+ywidth-3,8);
         putpixel(a+xwidth-1,b+ywidth-4,8);
         putpixel(a+xwidth-3,b+ywidth,8);
         putpixel(a+xwidth-4,b+ywidth-1,8);
         putpixel(a+xwidth-3,b+ywidth-4,8);
         putpixel(a+xwidth-7,b+ywidth-4,8);
         putpixel(a+xwidth-5,b+ywidth-3,8)
      end;
      7: begin
         putpixel(a+xwidth-1,b+1,8);
         putpixel(a+xwidth,b+1,8);
         putpixel(a+xwidth,b+2,8);
         line(a+xwidth-5,b+9,a+xwidth-3,b+9);
         line(a+4,b+6,a+6,b+6);
         line(a+xwidth-5,b+9,a+6,b+6);
      end;
      8: begin
         arc(a+xwidth+1,b-ywidth+3,224,269,3*ywidth div 2-1);
         arc(a+xwidth+1,b-ywidth+3,222,269,3*ywidth div 2-2);
         arc(a+xwidth+1,b-ywidth+3,221,269,3*ywidth div 2-3);
         arc(a+xwidth+1,b-ywidth+3,221,269,3*ywidth div 2-4);
         line(a+1,b+1,a+3,b+3);
         putpixel(a+4,b+1,8);
         putpixel(a+5,b+2,8);
         putpixel(a+1,b+4,8);
         putpixel(a+2,b+5,8);
         putpixel(a+4,b+5,8);
         putpixel(a+8,b+5,8);
         putpixel(a+6,b+4,8)
      end;
      9: begin
         arc(a-xwidth+3,b,318,359,3*ywidth div 2-4);
         arc(a-xwidth+3,b,315,359,3*ywidth div 2-3);
         arc(a-xwidth+3,b,315,359,3*ywidth div 2-2);
         arc(a-xwidth+3,b,318,359,3*ywidth div 2-1);
         line(a+1,b+ywidth,a+3,b+ywidth-2);
         putpixel(a+5,b+ywidth-3,8);
         putpixel(a+5,b+ywidth-7,8);
         putpixel(a+4,b+ywidth-5,8);
         putpixel(a+2,b+ywidth-4,8);
         putpixel(a+1,b+ywidth-3,8);
         putpixel(a+4,b+ywidth,8);
         putpixel(a+5,b+ywidth-1,8);
         putpixel(a+6,b+1,8);
         putpixel(a+7,b+1,8);
         putpixel(a+8,b+1,8);
         putpixel(a+9,b+1,8)
      end;
      10: begin
         putpixel(a+xwidth,b+ywidth-1,8);
         putpixel(a+xwidth-1,b+ywidth,8);
         putpixel(a+xwidth,b+ywidth,8);
         line(a+xwidth-5,b+4,a+xwidth-5,b+6);
         line(a+6,b+ywidth-3,a+6,b+ywidth-5);
         line(a+xwidth-5,b+6,a+6,b+ywidth-5);
      end;
      11: begin
         arc(a+2*xwidth-2,b+ywidth+1,134,176,3*ywidth div 2-4);
         arc(a+2*xwidth-2,b+ywidth+1,131,176,3*ywidth div 2-3);
         arc(a+2*xwidth-2,b+ywidth+1,131,176,3*ywidth div 2-2);
         arc(a+2*xwidth-2,b+ywidth+1,134,176,3*ywidth div 2-1);
         line(a+xwidth,b+1,a+xwidth-2,b+3);
         putpixel(a+xwidth-3,b+1,8);
         putpixel(a+xwidth-4,b+2,8);
         putpixel(a+xwidth,b+4,8);
         putpixel(a+xwidth-1,b+5,8);
         putpixel(a+xwidth-4,b+4,8);
         putpixel(a+xwidth-3,b+6,8);
         putpixel(a+xwidth-4,b+8,8)
      end;
      12: begin
         putpixel(a+1,b+2,8);
         putpixel(a+2,b+1,8);
         putpixel(a+1,b+1,8);
         line(a+xwidth-5,b+4,a+xwidth-5,b+6);
         line(a+6,b+ywidth-3,a+6,b+ywidth-5);
         line(a+xwidth-5,b+6,a+6,b+ywidth-5);
      end;
      13: begin
         putpixel(a+1,b+ywidth-1,8);
         putpixel(a+1,b+ywidth,8);
         putpixel(a+2,b+ywidth,8);
         line(a+6,b+4,a+6,b+6);
         line(a+xwidth-5,b+ywidth-3,a+xwidth-5,b+ywidth-5);
         line(a+6,b+6,a+xwidth-5,b+ywidth-5);
      end;
      14: begin
         arc(a+2*xwidth-2,b,181,228,3*ywidth div 2-4);
         arc(a+2*xwidth-2,b,181,228,3*ywidth div 2-3);
         arc(a+2*xwidth-2,b,181,228,3*ywidth div 2-2);
         arc(a+2*xwidth-2,b,181,228,3*ywidth div 2-1);
         line(a+xwidth,b+ywidth,a+xwidth-2,b+ywidth-2);
         putpixel(a+xwidth-4,b+ywidth-3,8);
         putpixel(a+xwidth-4,b+ywidth-7,8);
         putpixel(a+xwidth-3,b+ywidth-5,8);
         putpixel(a+xwidth-1,b+ywidth-4,8);
         putpixel(a+xwidth,b+ywidth-3,8);
         putpixel(a+xwidth-3,b+ywidth,8);
         putpixel(a+xwidth-4,b+ywidth-1,8)
      end;
      15: begin
         putpixel(a+xwidth-1,b+1,8);
         putpixel(a+xwidth,b+1,8);
         putpixel(a+xwidth,b+2,8);
         line(a+6,b+4,a+6,b+6);
         line(a+xwidth-5,b+ywidth-3,a+xwidth-5,b+ywidth-5);
         line(a+6,b+6,a+xwidth-5,b+ywidth-5);
      end;
      16: begin
         arc(a-xwidth+3,b+ywidth+1,1,48,3*ywidth div 2-4);
         arc(a-xwidth+3,b+ywidth+1,1,48,3*ywidth div 2-3);
         arc(a-xwidth+3,b+ywidth+1,1,48,3*ywidth div 2-2);
         arc(a-xwidth+3,b+ywidth+1,1,48,3*ywidth div 2-1);
         line(a+1,b+1,a+3,b+3);
         putpixel(a+4,b+1,8);
         putpixel(a+5,b+2,8);
         putpixel(a+1,b+4,8);
         putpixel(a+2,b+5,8);
         putpixel(a+5,b+4,8);
         putpixel(a+4,b+6,8);
         putpixel(a+5,b+8,8)
      end
   end
end;


procedure split(kind:byte);
var x,y:integer;

begin
   x:=getx;
   y:=gety;
   case kind of
      1: begin
         away_street(1);
         away_street(3);
         setcolor(7);
         line(x+xwidth-4,y+7,x+xwidth,y+6);
         line(x+xwidth-4,y+8,x+xwidth-2,y+8);
         putpixel(x+xwidth-1,y+9,7);
         putpixel(x+xwidth,y+9,7);
         putpixel(x+xwidth-1,y+7,10);
         putpixel(x+xwidth,y+7,10);
         putpixel(x+xwidth-1,y+8,10);
         putpixel(x+xwidth,y+8,10)
      end;
      2: begin
         away_street(9);
         away_street(10);
         setcolor(7);
         line(x+1,y+6,x+xwidth,y+6);
         line(x+1,y+9,x+xwidth,y+9);
         setcolor(10);
         line(x+1,y+7,x+xwidth,y+7);
         line(x+1,y+8,x+xwidth,y+8)
      end;
      3: begin
         away_street(2);
         away_street(4);
         setcolor(7);
         line(x+1,y+6,x+5,y+7);
         line(x+3,y+8,x+5,y+8);
         putpixel(x+2,y+9,7);
         putpixel(x+1,y+9,7);
         putpixel(x+2,y+7,10);
         putpixel(x+1,y+7,10);
         putpixel(x+2,y+8,10);
         putpixel(x+1,y+8,10)
      end;
      4: begin
         away_street(5);
         away_street(7);
         setcolor(7);
         line(x+7,y+5,x+6,y+1);
         line(x+8,y+5,x+9,y+1);
         putpixel(x+7,y+1,10);
         putpixel(x+8,y+1,10);
         putpixel(x+7,y+2,10);
         putpixel(x+8,y+2,10)
      end;
      5: begin
         away_street(11);
         away_street(12);
         setcolor(7);
         line(x+6,y+1,x+6,y+ywidth);
         line(x+9,y+1,x+9,y+ywidth);
         setcolor(10);
         line(x+7,y+1,x+7,y+ywidth);
         line(x+8,y+1,x+8,y+ywidth)
      end;
      6: begin
         away_street(6);
         away_street(8);
         setcolor(7);
         line(x+7,y+ywidth-4,x+7,y+ywidth-2);
         line(x+8,y+ywidth-4,x+8,y+ywidth-2);
         putpixel(x+6,y+ywidth-1,7);
         putpixel(x+6,y+ywidth,7);
         putpixel(x+9,y+ywidth-1,7);
         putpixel(x+9,y+ywidth,7);
         putpixel(x+7,y+ywidth,10);
         putpixel(x+8,y+ywidth,10);
         putpixel(x+7,y+ywidth-1,10);
         putpixel(x+8,y+ywidth-1,10)
      end;
      7: begin
         straight(1,8);
         setcolor(15);
         line(x+5,y+8,x+5,y+9);
         line(x+10,y+6,x+10,y+7)
      end;
      8: begin
         straight(2,8);
         setcolor(15);
         line(x+6,y+5,x+7,y+5);
         line(x+8,y+10,x+9,y+10)
      end
   end
end;


procedure screw(combquadrant,height:byte;right_sense:boolean);
var a,b:integer;

begin
   a:=getx;
   b:=gety;
   if height=4
   then begin
      case right_sense of
         true: begin
            if (combquadrant=1) or (combquadrant=3)
            then begin
               straight(1,8);
               setcolor(7);
               line(a+1,b+5,a+xwidth,b+5);
               line(a+1,b+ywidth-4,a+xwidth,b+ywidth-4)
            end
            else begin
               straight(2,8);
               setcolor(7);
               line(a+5,b+1,a+5,b+ywidth);
               line(a+xwidth-4,b+1,a+xwidth-4,b+ywidth)
            end
         end;
         false: begin
            if (combquadrant=2) or (combquadrant=4)
            then begin
               straight(1,8);
               setcolor(7);
               line(a+1,b+5,a+xwidth,b+5);
               line(a+1,b+ywidth-4,a+xwidth,b+ywidth-4)
            end
            else begin
               straight(2,8);
               setcolor(7);
               line(a+5,b+1,a+5,b+ywidth);
               line(a+xwidth-4,b+1,a+xwidth-4,b+ywidth)
            end
         end
      end
   end;
   case combquadrant of
      1: begin
         small_curve(1,8);
         setcolor(7);
         arc(a+2,b+ywidth-1,0,90,xwidth div 2+1);
         putpixel(a+1,b+5,7);
         putpixel(a+xwidth-4,b+ywidth,7);
         line(a+1,b+ywidth-4,a+3,b+ywidth-4);
         line(a+5,b+ywidth-2,a+5,b+ywidth);
         putpixel(a+4,b+ywidth-3,7);
         case height of
            2: begin
               if right_sense
               then begin
                  putpixel(a+6,b+ywidth-4,7);
                  putpixel(a+6,b+ywidth-5,7);
                  putpixel(a+5,b+ywidth-4,7)
               end
               else begin
                  putpixel(a+5,b+ywidth-5,7);
                  putpixel(a+6,b+ywidth-5,7);
                  putpixel(a+5,b+ywidth-4,7)
               end
            end;
            3: begin
               if right_sense
               then begin
                  putpixel(a+5,b+ywidth-5,7);
                  putpixel(a+5,b+ywidth-6,7);
                  putpixel(a+4,b+ywidth-5,7);
                  putpixel(a+7,b+ywidth-3,7);
                  putpixel(a+7,b+ywidth-4,7);
                  putpixel(a+6,b+ywidth-3,7)
               end
               else begin
                  putpixel(a+4,b+ywidth-6,7);
                  putpixel(a+5,b+ywidth-6,7);
                  putpixel(a+4,b+ywidth-5,7);
                  putpixel(a+6,b+ywidth-4,7);
                  putpixel(a+7,b+ywidth-4,7);
                  putpixel(a+6,b+ywidth-3,7)
               end
            end
         end
      end;
      2: begin
         small_curve(2,8);
         setcolor(7);
         arc(a+xwidth-1,b+ywidth-1,85,185,xwidth div 2+1);
         line(a+xwidth-2,b+ywidth-4,a+xwidth,b+ywidth-4);
         line(a+xwidth-4,b+ywidth-2,a+xwidth-4,b+ywidth);
         putpixel(a+xwidth-3,b+ywidth-3,7);
         case height of
            2: begin
               if right_sense
               then begin
                  putpixel(a+xwidth-4,b+ywidth-4,7);
                  putpixel(a+xwidth-4,b+ywidth-5,7);
                  putpixel(a+xwidth-5,b+ywidth-5,7)
               end
               else begin
                  putpixel(a+xwidth-4,b+ywidth-4,7);
                  putpixel(a+xwidth-5,b+ywidth-4,7);
                  putpixel(a+xwidth-5,b+ywidth-5,7)
               end
            end;
            3: begin
               if right_sense
               then begin
                  putpixel(a+xwidth-3,b+ywidth-5,7);
                  putpixel(a+xwidth-3,b+ywidth-6,7);
                  putpixel(a+xwidth-4,b+ywidth-6,7);
                  putpixel(a+xwidth-5,b+ywidth-3,7);
                  putpixel(a+xwidth-5,b+ywidth-4,7);
                  putpixel(a+xwidth-6,b+ywidth-4,7)
               end
               else begin
                  putpixel(a+xwidth-3,b+ywidth-5,7);
                  putpixel(a+xwidth-4,b+ywidth-5,7);
                  putpixel(a+xwidth-4,b+ywidth-6,7);
                  putpixel(a+xwidth-5,b+ywidth-3,7);
                  putpixel(a+xwidth-6,b+ywidth-3,7);
                  putpixel(a+xwidth-6,b+ywidth-4,7)
               end
            end
         end
      end;
      3: begin
         small_curve(3,8);
         setcolor(7);
         arc(a+xwidth-1,b+2,170,280,xwidth div 2+1);
         line(a+xwidth-4,b+1,a+xwidth-4,b+3);
         line(a+xwidth-2,b+5,a+xwidth,b+5);
         putpixel(a+xwidth-3,b+4,7);
         case height of
            2: begin
               if right_sense
               then begin
                  putpixel(a+xwidth-5,b+5,7);
                  putpixel(a+xwidth-4,b+5,7);
                  putpixel(a+xwidth-5,b+6,7)
               end
               else begin
                  putpixel(a+xwidth-4,b+6,7);
                  putpixel(a+xwidth-4,b+5,7);
                  putpixel(a+xwidth-5,b+6,7)
               end
            end;
            3: begin
               if right_sense
               then begin
                  putpixel(a+xwidth-4,b+6,7);
                  putpixel(a+xwidth-3,b+6,7);
                  putpixel(a+xwidth-4,b+7,7);
                  putpixel(a+xwidth-6,b+4,7);
                  putpixel(a+xwidth-5,b+4,7);
                  putpixel(a+xwidth-6,b+5,7)
               end
               else begin
                  putpixel(a+xwidth-3,b+7,7);
                  putpixel(a+xwidth-3,b+6,7);
                  putpixel(a+xwidth-4,b+7,7);
                  putpixel(a+xwidth-5,b+5,7);
                  putpixel(a+xwidth-5,b+4,7);
                  putpixel(a+xwidth-6,b+5,7)
               end
            end
         end
      end;
      4: begin
         small_curve(4,8);
         setcolor(7);
         arc(a+2,b+2,265,365,xwidth div 2+1);
         line(a+1,b+5,a+3,b+5);
         line(a+5,b+1,a+5,b+3);
         putpixel(a+4,b+4,7);
         case height of
            2: begin
               if right_sense
               then begin
                  putpixel(a+5,b+5,7);
                  putpixel(a+5,b+6,7);
                  putpixel(a+6,b+6,7)
               end
               else begin
                  putpixel(a+5,b+5,7);
                  putpixel(a+6,b+5,7);
                  putpixel(a+6,b+6,7)
               end
            end;
            3: begin
               if right_sense
               then begin
                  putpixel(a+6,b+4,7);
                  putpixel(a+6,b+5,7);
                  putpixel(a+7,b+5,7);
                  putpixel(a+4,b+6,7);
                  putpixel(a+4,b+7,7);
                  putpixel(a+5,b+7,7)
               end
               else begin
                  putpixel(a+4,b+6,7);
                  putpixel(a+5,b+6,7);
                  putpixel(a+5,b+7,7);
                  putpixel(a+6,b+4,7);
                  putpixel(a+7,b+4,7);
                  putpixel(a+7,b+5,7)
               end
            end
         end
      end
   end;
   if height=1
   then begin
      case right_sense of
         true: begin
            if (combquadrant=2) or (combquadrant=4)
            then begin
               straight(1,8);
               setcolor(7);
               line(a+1,b+5,a+xwidth,b+5);
               line(a+1,b+ywidth-4,a+xwidth,b+ywidth-4)
            end
            else begin
               straight(2,8);
               setcolor(7);
               line(a+5,b+1,a+5,b+ywidth);
               line(a+xwidth-4,b+1,a+xwidth-4,b+ywidth)
            end
         end;
         false: begin
            if (combquadrant=1) or (combquadrant=3)
            then begin
               straight(1,8);
               setcolor(7);
               line(a+1,b+5,a+xwidth,b+5);
               line(a+1,b+ywidth-4,a+xwidth,b+ywidth-4)
            end
            else begin
               straight(2,8);
               setcolor(7);
               line(a+5,b+1,a+5,b+ywidth);
               line(a+xwidth-4,b+1,a+xwidth-4,b+ywidth)
            end
         end
      end
   end
end;


procedure loops(kind:byte);
var a,b:integer;

begin
   a:=getx;
   b:=gety;
   case kind of
      1: begin
         away_street(1);
         setcolor(7);
         line(a+xwidth,b+6,a+xwidth-6,b+ywidth-5);
         line(a+xwidth,b+7,a+xwidth-6,b+ywidth-4);
         line(a+xwidth,b+8,a+xwidth-6,b+ywidth-3);
         line(a+xwidth,b+9,a+xwidth-6,b+ywidth-2);
         line(a+xwidth,b+10,a+xwidth-6,b+ywidth-1);
         setcolor(8);
         line(a+xwidth-4,b+ywidth-1,a+xwidth,b+ywidth-1);
         line(a+xwidth-2,b+ywidth-2,a+xwidth,b+ywidth-2);
         putpixel(a+xwidth,b+ywidth-3,8)
      end;
      2: begin
         away_street(4);
         setcolor(7);
         line(a+1,b+ywidth-5,a+7,b+6);
         line(a+1,b+ywidth-6,a+7,b+5);
         line(a+1,b+ywidth-7,a+7,b+4);
         line(a+1,b+ywidth-8,a+7,b+3);
         line(a+1,b+ywidth-9,a+7,b+2);
         setcolor(8);
         line(a+6,b+2,a+1,b+2);
         line(a+4,b+3,a+1,b+3);
         putpixel(a+1,b+4,8);
         putpixel(a+2,b+4,8)
      end;
      3: begin
         away_street(5);
         setcolor(7);
         line(a+6,b+1,a+9,b+7);
         line(a+7,b+1,a+10,b+7);
         line(a+8,b+1,a+11,b+7);
         line(a+9,b+1,a+12,b+7);
         line(a+10,b+1,a+13,b+7);
         setcolor(8);
         line(a+xwidth-1,b+1,a+xwidth-1,b+5);
         line(a+xwidth-2,b+1,a+xwidth-2,b+3);
         putpixel(a+xwidth-3,b+1,8)
      end;
      4: begin
         away_street(8);
         setcolor(7);
         line(a+xwidth-5,b+ywidth,a+xwidth-8,b+ywidth-6);
         line(a+xwidth-6,b+ywidth,a+xwidth-9,b+ywidth-6);
         line(a+xwidth-7,b+ywidth,a+xwidth-10,b+ywidth-6);
         line(a+xwidth-8,b+ywidth,a+xwidth-11,b+ywidth-6);
         line(a+xwidth-9,b+ywidth,a+xwidth-12,b+ywidth-6);
         setcolor(8);
         line(a+2,b+ywidth,a+2,b+ywidth-5);
         line(a+3,b+ywidth,a+3,b+ywidth-3);
         putpixel(a+4,b+ywidth,8);
         putpixel(a+4,b+ywidth-1,8)
      end;
      5: begin
         straight(1,8);
         setcolor(7);
         line(a+2,b+ywidth-4,a+xwidth,b+ywidth-4);
         line(a+3,b+ywidth-3,a+xwidth,b+ywidth-3);
         line(a+6,b+ywidth-5,a+xwidth,b+ywidth-10);
         line(a+7,b+ywidth-5,a+xwidth,b+ywidth-9);
         line(a+8,b+ywidth-5,a+xwidth,b+ywidth-8);
         line(a+9,b+ywidth-5,a+xwidth,b+ywidth-7);
         line(a+10,b+ywidth-5,a+xwidth,b+ywidth-6);
         line(a+11,b+ywidth-5,a+xwidth,b+ywidth-5);
         setcolor(4);
         line(a+xwidth-6,b+6,a+xwidth,b+7)
      end;
      6: begin
         straight(1,8);
         setcolor(7);
         line(a+1,b+5,a+xwidth-1,b+5);
         line(a+1,b+4,a+xwidth-2,b+4);
         line(a+1,b+11,a+xwidth-5,b+6);
         line(a+1,b+10,a+xwidth-5,b+6);
         line(a+1,b+9,a+xwidth-5,b+6);
         line(a+1,b+8,a+xwidth-5,b+6);
         line(a+1,b+7,a+xwidth-5,b+6);
         line(a+1,b+6,a+xwidth-5,b+6);
         setcolor(4);
         line(a+1,b+8,a+7,b+9)
      end;
      7: begin
         straight(2,8);
         setcolor(7);
         line(a+xwidth-4,b+ywidth-1,a+xwidth-4,b+1);
         line(a+xwidth-3,b+ywidth-2,a+xwidth-3,b+1);
         line(a+xwidth-5,b+ywidth-5,a+xwidth-10,b+1);
         line(a+xwidth-5,b+ywidth-6,a+xwidth-9,b+1);
         line(a+xwidth-5,b+ywidth-7,a+xwidth-8,b+1);
         line(a+xwidth-5,b+ywidth-8,a+xwidth-7,b+1);
         line(a+xwidth-5,b+ywidth-9,a+xwidth-6,b+1);
         line(a+xwidth-5,b+ywidth-10,a+xwidth-5,b+1);
         setcolor(4);
         line(a+6,b+7,a+7,b+1)
      end;
      8: begin
         straight(2,8);
         setcolor(7);
         line(a+5,b+ywidth,a+5,b+2);
         line(a+4,b+ywidth,a+4,b+3);
         line(a+6,b+6,a+11,b+ywidth);
         line(a+6,b+7,a+10,b+ywidth);
         line(a+6,b+8,a+9,b+ywidth);
         line(a+6,b+9,a+8,b+ywidth);
         line(a+6,b+10,a+7,b+ywidth);
         line(a+6,b+11,a+6,b+ywidth);
         setcolor(4);
         line(a+8,b+ywidth,a+9,b+ywidth-6)
      end
   end
end;


procedure scenery(kind:byte);
var a,b:integer;

begin
   a:=getx;
   b:=gety;
   case kind of
      0: begin
         setcolor(4);
         line(a+7,b+5,a+7,b+ywidth-4);
         line(a+xwidth-6,b+5,a+xwidth-6,b+ywidth-4);
         putpixel(a+8,b+ywidth-6,8);
         putpixel(a+xwidth-7,b+ywidth-6,8);
         putpixel(a+6,b+6,8);
         putpixel(a+xwidth-5,b+6,8);
         putpixel(a+6,b+ywidth-4,8);
         putpixel(a+xwidth-5,b+ywidth-4,8);
         putpixel(a+6,b+ywidth-5,8);
         putpixel(a+xwidth-5,b+ywidth-5,8);
      end;
      1: begin
         setcolor(2);
         line(a+5,b+ywidth-4,a+7,b+5);
         line(a+xwidth-4,b+ywidth-4,a+xwidth-6,b+5);
         setcolor(10);
         line(a+6,b+ywidth-4,a+7,b+7);
         line(a+xwidth-5,b+ywidth-4,a+xwidth-6,b+7);
         line(a+4,b+ywidth-4,a+7,b+3);
         line(a+xwidth-3,b+ywidth-4,a+xwidth-6,b+3);
         line(a+5,b+ywidth-4,a+xwidth-4,b+ywidth-4);
         putpixel(a+7,b+ywidth-5,2);
         putpixel(a+xwidth-6,b+ywidth-5,2);
         putpixel(a+7,b+ywidth-3,6);
         putpixel(a+8,b+ywidth-3,6);
         putpixel(a+7,b+ywidth-2,6);
         putpixel(a+8,b+ywidth-2,6)
      end;
      2: begin
         setcolor(6);
         line(a+7,b+ywidth-2,a+7,b+3);
         line(a+xwidth-6,b+ywidth-2,a+xwidth-6,b+3);
         line(a+5,b+ywidth-5,a+xwidth-4,b+ywidth-5);
         line(a+5,b+ywidth-6,a+xwidth-4,b+ywidth-6);
         line(a+5,b+ywidth-7,a+5,b+ywidth-8);
         line(a+xwidth-4,b+ywidth-7,a+xwidth-4,b+ywidth-9)
      end;
      3: begin
         setcolor(6);
         line(a+8,b+ywidth-2,a+8,b+ywidth-4);
         line(a+7,b+ywidth-4,a+7,b+4);
         setcolor(2);
         line(a+5,b+6,a+7,b+4);
         line(a+xwidth-3,b+5,a+xwidth-6,b+3);
         setcolor(10);
         line(a+4,b+5,a+7,b+3);
         line(a+xwidth-4,b+6,a+xwidth-6,b+4)
      end;
      4: begin
         setcolor(7);
         line(a+5,b+ywidth-2,a+5,b+3);
         line(a+xwidth-4,b+ywidth-2,a+xwidth-4,b+3);
         line(a+6,b+ywidth-2,a+xwidth-5,b+ywidth-2);
         line(a+6,b+3,a+xwidth-5,b+3);
         line(a+6,b+7,a+xwidth-5,b+7);
         line(a+6,b+ywidth-6,a+xwidth-5,b+ywidth-6)
      end;
      5: begin
         setcolor(7);
         rectangle(a+4,b+4,a+xwidth-3,b+ywidth-3);
         rectangle(a+5,b+5,a+xwidth-4,b+ywidth-4);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,7);
         putpixel(a+xwidth-6,b+7,7);
         putpixel(a+7,b+ywidth-6,7);
         putpixel(a+xwidth-6,b+ywidth-6,7);
         putpixel(a+7,b+ywidth-3,0);
         putpixel(a+xwidth-6,b+ywidth-3,0)
      end;
      6: begin
         setcolor(7);
         rectangle(a+4,b+4,a+xwidth-3,b+ywidth-3);
         rectangle(a+5,b+5,a+xwidth-4,b+ywidth-4);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,7);
         putpixel(a+xwidth-6,b+7,7);
         putpixel(a+7,b+ywidth-6,7);
         putpixel(a+xwidth-6,b+ywidth-6,7);
         putpixel(a+4,b+7,0);
         putpixel(a+4,b+ywidth-6,0)
      end;
      7: begin
         setcolor(7);
         rectangle(a+4,b+4,a+xwidth-3,b+ywidth-3);
         rectangle(a+5,b+5,a+xwidth-4,b+ywidth-4);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,7);
         putpixel(a+xwidth-6,b+7,7);
         putpixel(a+7,b+ywidth-6,7);
         putpixel(a+xwidth-6,b+ywidth-6,7);
         putpixel(a+7,b+4,0);
         putpixel(a+xwidth-6,b+4,0)
      end;
      8: begin
         setcolor(7);
         rectangle(a+4,b+4,a+xwidth-3,b+ywidth-3);
         rectangle(a+5,b+5,a+xwidth-4,b+ywidth-4);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,7);
         putpixel(a+xwidth-6,b+7,7);
         putpixel(a+7,b+ywidth-6,7);
         putpixel(a+xwidth-6,b+ywidth-6,7);
         putpixel(a+xwidth-3,b+7,0);
         putpixel(a+xwidth-3,b+ywidth-6,0)
      end;
      9: begin
         setcolor(12);
         rectangle(a+4,b+4,a+xwidth-3,b+ywidth-3);
         rectangle(a+5,b+5,a+xwidth-4,b+ywidth-4);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,12);
         putpixel(a+xwidth-6,b+7,12);
         putpixel(a+7,b+ywidth-6,12);
         putpixel(a+xwidth-6,b+ywidth-6,12);
         putpixel(a+7,b+ywidth-3,15);
         putpixel(a+xwidth-6,b+ywidth-3,15)
      end;
      10: begin
         setcolor(12);
         rectangle(a+4,b+4,a+xwidth-3,b+ywidth-3);
         rectangle(a+5,b+5,a+xwidth-4,b+ywidth-4);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,12);
         putpixel(a+xwidth-6,b+7,12);
         putpixel(a+7,b+ywidth-6,12);
         putpixel(a+xwidth-6,b+ywidth-6,12);
         putpixel(a+4,b+7,15);
         putpixel(a+4,b+ywidth-6,15)
      end;
      11: begin
         setcolor(12);
         rectangle(a+4,b+4,a+xwidth-3,b+ywidth-3);
         rectangle(a+5,b+5,a+xwidth-4,b+ywidth-4);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,12);
         putpixel(a+xwidth-6,b+7,12);
         putpixel(a+7,b+ywidth-6,12);
         putpixel(a+xwidth-6,b+ywidth-6,12);
         putpixel(a+7,b+4,15);
         putpixel(a+xwidth-6,b+4,15)
      end;
      12: begin
         setcolor(12);
         rectangle(a+4,b+4,a+xwidth-3,b+ywidth-3);
         rectangle(a+5,b+5,a+xwidth-4,b+ywidth-4);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,12);
         putpixel(a+xwidth-6,b+7,12);
         putpixel(a+7,b+ywidth-6,12);
         putpixel(a+xwidth-6,b+ywidth-6,12);
         putpixel(a+xwidth-3,b+7,15);
         putpixel(a+xwidth-3,b+ywidth-6,15)
      end;
      13: begin
         setcolor(7);
         rectangle(a+4,b+4,a+xwidth-3,b+8);
         rectangle(a+5,b+5,a+xwidth-4,b+7);
         line(a+6,b+6,a+xwidth-5,b+6);
         rectangle(a+4,b+ywidth-4,a+6,b+ywidth-3)
      end;
      14: begin
         setcolor(7);
         rectangle(a+xwidth-3,b+4,a+xwidth-7,b+ywidth-3);
         rectangle(a+xwidth-4,b+5,a+xwidth-6,b+ywidth-4);
         line(a+xwidth-5,b+6,a+xwidth-5,b+ywidth-5);
         rectangle(a+4,b+4,a+5,b+6)
      end;
      15: begin
         setcolor(7);
         rectangle(a+4,b+ywidth-3,a+xwidth-3,b+ywidth-7);
         rectangle(a+5,b+ywidth-4,a+xwidth-4,b+ywidth-6);
         line(a+6,b+ywidth-5,a+xwidth-5,b+ywidth-5);
         rectangle(a+xwidth-3,b+5,a+xwidth-5,b+4)
      end;
      16: begin
         setcolor(7);
         rectangle(a+4,b+4,a+8,b+ywidth-3);
         rectangle(a+5,b+5,a+7,b+ywidth-4);
         line(a+6,b+6,a+6,b+ywidth-5);
         rectangle(a+xwidth-3,b+ywidth-3,a+xwidth-4,b+ywidth-5)
      end;
      17: begin
         setcolor(6);
         arc(a+xwidth-6,b+7,0,90,3);
         arc(a+7,b+7,90,180,3);
         arc(a+7,b+ywidth-6,180,270,3);
         arc(a+xwidth-6,b+ywidth-6,270,360,3);
         arc(a+xwidth-6,b+7,0,90,2);
         arc(a+7,b+7,90,180,2);
         arc(a+7,b+ywidth-6,180,270,2);
         arc(a+xwidth-6,b+ywidth-6,270,360,2);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,6);
         putpixel(a+xwidth-6,b+7,6);
         putpixel(a+7,b+ywidth-6,6);
         putpixel(a+xwidth-6,b+ywidth-6,6);
         setcolor(7);
         line(a+5,b+ywidth-5,a+xwidth-4,b+ywidth-3);
         line(a+5,b+ywidth-3,a+xwidth-4,b+ywidth-5)
      end;
      18: begin
         setcolor(6);
         arc(a+xwidth-6,b+7,0,90,3);
         arc(a+7,b+7,90,180,3);
         arc(a+7,b+ywidth-6,180,270,3);
         arc(a+xwidth-6,b+ywidth-6,270,360,3);
         arc(a+xwidth-6,b+7,0,90,2);
         arc(a+7,b+7,90,180,2);
         arc(a+7,b+ywidth-6,180,270,2);
         arc(a+xwidth-6,b+ywidth-6,270,360,2);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,6);
         putpixel(a+xwidth-6,b+7,6);
         putpixel(a+7,b+ywidth-6,6);
         putpixel(a+xwidth-6,b+ywidth-6,6);
         setcolor(7);
         line(a+4,b+5,a+4,b+6);
         line(a+6,b+5,a+6,b+6);
         line(a+4,b+ywidth-4,a+4,b+ywidth-5);
         line(a+6,b+ywidth-4,a+6,b+ywidth-5);
         putpixel(a+5,b+7,7);
         putpixel(a+5,b+ywidth-6,7)
      end;
      19: begin
         setcolor(6);
         arc(a+xwidth-6,b+7,0,90,3);
         arc(a+7,b+7,90,180,3);
         arc(a+7,b+ywidth-6,180,270,3);
         arc(a+xwidth-6,b+ywidth-6,270,360,3);
         arc(a+xwidth-6,b+7,0,90,2);
         arc(a+7,b+7,90,180,2);
         arc(a+7,b+ywidth-6,180,270,2);
         arc(a+xwidth-6,b+ywidth-6,270,360,2);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,6);
         putpixel(a+xwidth-6,b+7,6);
         putpixel(a+7,b+ywidth-6,6);
         putpixel(a+xwidth-6,b+ywidth-6,6);
         setcolor(7);
         line(a+5,b+6,a+xwidth-4,b+4);
         line(a+5,b+4,a+xwidth-4,b+6)
      end;
      20: begin
         setcolor(6);
         arc(a+xwidth-6,b+7,0,90,3);
         arc(a+7,b+7,90,180,3);
         arc(a+7,b+ywidth-6,180,270,3);
         arc(a+xwidth-6,b+ywidth-6,270,360,3);
         arc(a+xwidth-6,b+7,0,90,2);
         arc(a+7,b+7,90,180,2);
         arc(a+7,b+ywidth-6,180,270,2);
         arc(a+xwidth-6,b+ywidth-6,270,360,2);
         rectangle(a+6,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+7,6);
         putpixel(a+xwidth-6,b+7,6);
         putpixel(a+7,b+ywidth-6,6);
         putpixel(a+xwidth-6,b+ywidth-6,6);
         setcolor(7);
         line(a+xwidth-3,b+5,a+xwidth-3,b+6);
         line(a+xwidth-5,b+5,a+xwidth-5,b+6);
         line(a+xwidth-3,b+ywidth-4,a+xwidth-3,b+ywidth-5);
         line(a+xwidth-5,b+ywidth-4,a+xwidth-5,b+ywidth-5);
         putpixel(a+xwidth-4,b+7,7);
         putpixel(a+xwidth-4,b+ywidth-6,7)
      end;
      21: begin
         setcolor(7);
         line(a+6,b+ywidth-3,a+6,b+6);
         line(a+xwidth-5,b+ywidth-3,a+xwidth-5,b+6);
         line(a+7,b+ywidth-3,a+7,b+4);
         line(a+xwidth-6,b+ywidth-3,a+xwidth-6,b+4);
         putpixel(a+7,b+7,15);
         putpixel(a+xwidth-6,b+7,15);
         putpixel(a+7,b+ywidth-6,15);
         putpixel(a+xwidth-6,b+ywidth-6,15)
      end;
      22: begin
         setcolor(7);
         line(a+4,b+6,a+xwidth-5,b+6);
         line(a+4,b+7,a+xwidth-3,b+7);
         line(a+4,b+ywidth-5,a+xwidth-5,b+ywidth-5);
         line(a+4,b+ywidth-6,a+xwidth-3,b+ywidth-6);
         putpixel(a+7,b+7,15);
         putpixel(a+xwidth-6,b+7,15);
         putpixel(a+7,b+ywidth-6,15);
         putpixel(a+xwidth-6,b+ywidth-6,15)
      end;
      23: begin
         setcolor(7);
         line(a+6,b+4,a+6,b+ywidth-5);
         line(a+xwidth-5,b+4,a+xwidth-5,b+ywidth-5);
         line(a+7,b+4,a+7,b+ywidth-3);
         line(a+xwidth-6,b+4,a+xwidth-6,b+ywidth-3);
         putpixel(a+7,b+7,15);
         putpixel(a+xwidth-6,b+7,15);
         putpixel(a+7,b+ywidth-6,15);
         putpixel(a+xwidth-6,b+ywidth-6,15)
      end;
      24: begin
         setcolor(7);
         line(a+xwidth-3,b+6,a+6,b+6);
         line(a+xwidth-3,b+7,a+4,b+7);
         line(a+xwidth-3,b+ywidth-5,a+6,b+ywidth-5);
         line(a+xwidth-3,b+ywidth-6,a+4,b+ywidth-6);
         putpixel(a+7,b+7,15);
         putpixel(a+xwidth-6,b+7,15);
         putpixel(a+7,b+ywidth-6,15);
         putpixel(a+xwidth-6,b+ywidth-6,15)
      end;
      25: begin
         setcolor(6);
         rectangle(a+4,b+4,a+xwidth-3,b+8);
         rectangle(a+5,b+5,a+xwidth-4,b+7);
         line(a+6,b+6,a+xwidth-5,b+6);
         putpixel(a+xwidth-6,b+ywidth-4,15);
         putpixel(a+xwidth-6,b+ywidth-3,15)
      end;
      26: begin
         setcolor(6);
         rectangle(a+xwidth-3,b+4,a+xwidth-7,b+ywidth-3);
         rectangle(a+xwidth-4,b+5,a+xwidth-6,b+ywidth-4);
         line(a+xwidth-5,b+6,a+xwidth-5,b+ywidth-5);
         putpixel(a+5,b+xwidth-6,15);
         putpixel(a+4,b+xwidth-6,15)
      end;
      27: begin
         setcolor(6);
         rectangle(a+4,b+ywidth-3,a+xwidth-3,b+ywidth-7);
         rectangle(a+5,b+ywidth-4,a+xwidth-4,b+ywidth-6);
         line(a+6,b+ywidth-5,a+xwidth-5,b+ywidth-5);
         putpixel(a+7,b+5,15);
         putpixel(a+7,b+4,15)
      end;
      28: begin
         setcolor(6);
         rectangle(a+4,b+4,a+8,b+ywidth-3);
         rectangle(a+5,b+5,a+7,b+ywidth-4);
         line(a+6,b+6,a+6,b+ywidth-5);
         putpixel(a+xwidth-4,b+7,15);
         putpixel(a+xwidth-3,b+7,15)
      end
   end
end;


procedure finish(kind,color:byte);
var a,b,ac:integer;

begin
   a:=getx;
   b:=gety;
   if color=15
   then
      ac:=7
   else
      ac:=15;
   case kind of
      1: begin
         straight(1,color);
         setcolor(ac);
         line(a+xwidth-4,b+7,a+xwidth-1,b+7);
         putpixel(a+xwidth-3,b+6,ac);
         putpixel(a+xwidth-3,b+8,ac);
         line(a+7,b+4,a+7,b+ywidth-3);
         line(a+8,b+4,a+8,b+ywidth-3)
      end;
      2: begin
         straight(1,color);
         setcolor(ac);
         line(a+2,b+ywidth-6,a+5,b+ywidth-6);
         putpixel(a+4,b+ywidth-5,ac);
         putpixel(a+4,b+ywidth-7,ac);
         line(a+7,b+4,a+7,b+ywidth-3);
         line(a+8,b+4,a+8,b+ywidth-3)
      end;
      3: begin
         straight(2,color);
         setcolor(ac);
         line(a+7,b+2,a+7,b+5);
         putpixel(a+6,b+4,ac);
         putpixel(a+8,b+4,ac);
         line(a+4,b+7,a+xwidth-3,b+7);
         line(a+4,b+8,a+xwidth-3,b+8)
      end;
      4: begin
         straight(2,color);
         setcolor(ac);
         line(a+xwidth-6,b+ywidth-1,a+xwidth-6,b+ywidth-4);
         putpixel(a+xwidth-5,b+ywidth-3,ac);
         putpixel(a+xwidth-7,b+ywidth-3,ac);
         line(a+4,b+7,a+xwidth-3,b+7);
         line(a+4,b+8,a+xwidth-3,b+8)
      end
   end
end;


procedure draw_track_elem(mode,i,j:byte);   (* i-te Spalte, j-te Zeile *)
var a,b,c,x,y,wert,vw:integer;                (* mode 0 : streckenmodus  *)
    sv:string;                                (*      1 : auswahlmodus   *)
                                              (*      2 : fokusfeldmodus *)
                                                   (* i : element *)
                                                   (* j : vorgnger *)
begin
   c:=getcolor;
   x:=GetX;
   y:=GetY;
   SetTextJustify(LeftText, TopText);
   a:=x;
   b:=y;
   case mode of
      0: begin
         wert:=ord(trackfield[1,900+i-j*30]);
         case wert of
            255: begin
               if i>1
               then
                  vw:=ord(trackfield[1,900+i-1-j*30])
            end;
            254: begin
               if j>1
               then
                  vw:=ord(trackfield[1,900+i-(j-1)*30])
            end;
            253: begin
               if (j>1) and (i>1)
               then
                  vw:=ord(trackfield[1,900+i-1-(j-1)*30])
            end
         end
      end;
      1: begin
         wert:=i;
         case wert of
            255: begin
               if ti>1
               then
                  vw:=tsf[tsf_nr,ti-1,tj];
            end;
            254: begin
               if tj>1
               then
                  vw:=tsf[tsf_nr,ti,tj-1];
            end;
            253: begin
               if (tj>1) and (ti>1)
               then
                  vw:=tsf[tsf_nr,ti-1,tj-1];
            end
         end
      end;
      2: begin
         wert:=i;
         if ((multifield) AND (not autoset) AND (markfunct=0))
         then
            case wert of
               255: begin
                  if ti>1
                  then
                     vw:=tsf[tsf_nr,tsf_pos[tsf_nr].i-1,tsf_pos[tsf_nr].j];
               end;
               254: begin
                  if tj>1
                  then
                     vw:=tsf[tsf_nr,tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j-1];
               end;
               253: begin
                  if (tj>1) and (ti>1)
                  then
                     vw:=tsf[tsf_nr,tsf_pos[tsf_nr].i-1,tsf_pos[tsf_nr].j-1];
               end
            end
         else if (wert>=253) or (wert<=255)
         then
            vw:=0;
      end;
   end;
   case wert of
      5: straight(1,8);
      4: straight(2,8);
      74: begin
         straight(1,8);
         straight(2,8)
      end;
      6: small_curve(2,8);
      7: small_curve(1,8);
      8: small_curve(3,8);
      9: small_curve(4,8);
      76: begin
         straight(1,8);
         small_curve(2,8)
      end;
      82: begin
         straight(1,8);
         small_curve(1,8)
      end;
      80: begin
         straight(1,8);
         small_curve(3,8)
      end;
      78: begin
         straight(1,8);
         small_curve(4,8)
      end;
      79: begin
         straight(2,8);
         small_curve(2,8)
      end;
      75: begin
         straight(2,8);
         small_curve(1,8);
      end;
      77: begin
         straight(2,8);
         small_curve(3,8)
      end;
      81: begin
         straight(2,8);
         small_curve(4,8)
      end;
      10: begin
         big_curve(6,8,0)
      end;
      11: begin
         big_curve(2,8,0)
      end;
      12: begin
         big_curve(10,8,0)
      end;
      13: begin
         big_curve(14,8,0)
      end;
      15: begin
         straight(1,6)
      end;
      14: begin
         straight(2,6)
      end;
      125: begin
         straight(1,6);
         straight(2,6)
      end;
      16: small_curve(2,6);
      17: small_curve(1,6);
      18: small_curve(3,6);
      19: small_curve(4,6);
      127: begin
         straight(1,6);
         small_curve(2,6)
      end;
      133: begin
         straight(1,6);
         small_curve(1,6)
      end;
      131: begin
         straight(1,6);
         small_curve(3,6)
      end;
      129: begin
         straight(1,6);
         small_curve(4,6)
      end;
      130: begin
         straight(2,6);
         small_curve(2,6)
      end;
      126: begin
         straight(2,6);
         small_curve(1,6)
      end;
      128: begin
         straight(2,6);
         small_curve(3,6)
      end;
      132: begin
         straight(2,6);
         small_curve(4,6)
      end;
      20: begin
         big_curve(6,6,0)
      end;
      21: begin
         big_curve(2,6,0)
      end;
      22: begin
         big_curve(10,6,0)
      end;
      23: begin
         big_curve(14,6,0)
      end;
      25: begin
         straight(1,15)
      end;
      24: begin
         straight(2,15)
      end;
      138: begin
         straight(1,15);
         straight(2,15)
      end;
      26: small_curve(2,15);
      27: small_curve(1,15);
      28: small_curve(3,15);
      29: small_curve(4,15);
      140: begin
         straight(1,15);
         small_curve(2,15)
      end;
      146: begin
         straight(1,15);
         small_curve(1,15)
      end;
      144: begin
         straight(1,15);
         small_curve(3,15)
      end;
      142: begin
         straight(1,15);
         small_curve(4,15)
      end;
      143: begin
         straight(2,15);
         small_curve(2,15)
      end;
      139: begin
         straight(2,15);
         small_curve(1,15)
      end;
      141: begin
         straight(2,15);
         small_curve(3,15)
      end;
      145: begin
         straight(2,15);
         small_curve(4,15)
      end;
      30: begin
         big_curve(6,15,0)
      end;
      31: begin
         big_curve(2,15,0)
      end;
      32: begin
         big_curve(10,15,0)
      end;
      33: begin
         big_curve(14,15,0)
      end;
      88: s_big_curve(1);
      94: s_big_curve(2);
      92: s_big_curve(3);
      90: s_big_curve(4);
      91: s_big_curve(5);
      87: s_big_curve(6);
      89: s_big_curve(7);
      93: s_big_curve(8);
      41: inclined(1);
      50: inclined(2);
      47: inclined(3);
      45: inclined(4);
      51: inclined(5);
      43: inclined(6);
      46: inclined(7);
      48: inclined(8);
      40: inclined(9);
      42: inclined(10);
      49: inclined(11);
      44: inclined(12);
      52: big_curve(6,8,2);
      53: big_curve(2,8,2);
      54: big_curve(10,8,2);
      55: big_curve(14,8,2);
      105: big_curve(6,8,1);
      106: big_curve(2,8,1);
      107: big_curve(10,8,1);
      108: big_curve(14,7,1);
      95: ramp(1);
      36: ramp(2);
      56: ramp(3);
      100: ramp(4);
      35: ramp(5);
      104: ramp(6);
      102: ramp(7);
      96: ramp(8);
      37: ramp(9);
      57: ramp(10);
      97: ramp(11);
      38: ramp(12);
      58: ramp(13);
      99: ramp(14);
      34: ramp(15);
      103: ramp(16);
      101: ramp(17);
      98: ramp(18);
      39: ramp(19);
      59: ramp(20);
      73: tunnel(1);
      69: tunnel(2);
      84: tunnel(3);
      72: tunnel(4);
      70: tunnel(5);
      68: tunnel(6);
      83: tunnel(7);
      71: tunnel(8);
      67: tunnel(9);
      66: tunnel(10);
      112: split(1);
      110: split(2);
      114: split(3);
      111: split(4);
      109: split(5);
      113: split(6);
      116: split(7);
      115: split(8);
      153: scenery(1);
      152: scenery(2);
      151: scenery(3);
      154: scenery(4);
      163: scenery(5);
      166: scenery(6);
      164: scenery(7);
      165: scenery(8);
      159: scenery(9);
      162: scenery(10);
      160: scenery(11);
      161: scenery(12);
      155: scenery(13);
      158: scenery(14);
      156: scenery(15);
      157: scenery(16);
      167: scenery(17);
      170: scenery(18);
      168: scenery(19);
      169: scenery(20);
      174: scenery(21);
      172: scenery(22);
      173: scenery(23);
      171: scenery(24);
      175: scenery(25);
      178: scenery(26);
      176: scenery(27);
      177: scenery(28);
      61: chick(2);
      63: chick(6);
      60: chick(10);
      62: chick(14);
      65: loops(1);
      64: loops(4);
      86: loops(5);
      85: loops(8);
      119: screw(2,3,false);
      121: screw(2,2,true);
      123: screw(2,4,true);
      117: screw(2,1,false);
      120: screw(2,4,false);
      122: screw(2,1,true);
      124: screw(2,3,true);
      118: screw(2,2,false);
      150: finish(1,15);
      149: finish(2,15);
      148: finish(3,15);
      147: finish(4,15);
      137: finish(1,6);
      136: finish(2,6);
      135: finish(3,6);
      134: finish(4,6);
      181: finish(1,8);
      180: finish(2,8);
      179: finish(3,8);
      1: finish(4,8);
      2: scenery(0);
      255: begin
         if (i>1) or (mode>0)
         then begin
            case vw of
               10: big_curve(5,8,0);
               11: big_curve(1,8,0);
               12: big_curve(9,8,0);
               13: big_curve(13,8,0);
               20: big_curve(5,6,0);
               21: big_curve(1,6,0);
               22: big_curve(9,6,0);
               23: big_curve(13,6,0);
               30: big_curve(5,15,0);
               31: big_curve(1,15,0);
               32: big_curve(9,15,0);
               33: big_curve(13,15,0);
               52: big_curve(5,8,2);
               53: big_curve(1,8,2);
               54: big_curve(9,8,2);
               55: big_curve(13,8,2);
               105: big_curve(5,8,1);
               106: big_curve(1,8,1);
               107: big_curve(9,8,1);
               108: big_curve(13,8,1);
               88: s_big_curve(9);
               94: s_big_curve(10);
               92: s_big_curve(11);
               90: s_big_curve(12);
               91: s_big_curve(13);
               87: s_big_curve(14);
               89: s_big_curve(15);
               93: s_big_curve(16);
               61: chick(1);
               63: chick(5);
               60: chick(9);
               62: chick(13);
               65: loops(2);
               86: loops(6);
               119: screw(1,4,false);
               121: screw(1,1,true);
               123: screw(1,3,true);
               117: screw(1,2,false);
               120: screw(1,1,false);
               122: screw(1,4,true);
               124: screw(1,2,true);
               118: screw(1,3,false);
               else begin
                  settextstyle(0,0,1);
                  setcolor(0);
                  outtextxy(x+sx,y+sy,'2')
               end
            end
         end
         else begin
            settextstyle(0,0,1);
            setcolor(0);
            outtextxy(x+sx,y+sy,'2')
         end
      end;
      254: begin
         if (j>1) or (mode>0)
         then begin
            case vw of
               10: big_curve(7,8,0);
               11: big_curve(3,8,0);
               12: big_curve(11,8,0);
               13: big_curve(15,8,0);
               20: big_curve(7,6,0);
               21: big_curve(3,6,0);
               22: big_curve(11,6,0);
               23: big_curve(15,6,0);
               30: big_curve(7,15,0);
               31: big_curve(3,15,0);
               32: big_curve(11,15,0);
               33: big_curve(15,15,0);
               52: big_curve(7,8,2);
               53: big_curve(3,8,2);
               54: big_curve(11,8,2);
               55: big_curve(15,8,2);
               105: big_curve(7,8,1);
               106: big_curve(3,8,1);
               107: big_curve(11,8,1);
               108: big_curve(15,8,1);
               88: s_big_curve(17);
               94: s_big_curve(18);
               92: s_big_curve(19);
               90: s_big_curve(20);
               91: s_big_curve(21);
               87: s_big_curve(22);
               89: s_big_curve(23);
               93: s_big_curve(24);
               61: chick(3);
               63: chick(7);
               60: chick(11);
               62: chick(15);
               64: loops(3);
               85: loops(7);
               119: screw(3,2,false);
               121: screw(3,3,true);
               123: screw(3,1,true);
               117: screw(3,4,false);
               120: screw(3,3,false);
               122: screw(3,2,true);
               124: screw(3,4,true);
               118: screw(3,1,false);
               else begin
                  settextstyle(0,0,1);
                  setcolor(0);
                  outtextxy(x+sx,y+sy,'3')
               end
            end
         end
         else begin
            settextstyle(0,0,1);
            setcolor(0);
            outtextxy(x+sx,y+sy,'3')
         end
      end;
      253: begin
         if ((j>1) and (i>1)) or (mode>0)
         then begin
            case vw of
               10: big_curve(8,8,0);
               11: big_curve(4,8,0);
               12: big_curve(12,8,0);
               13: big_curve(16,8,0);
               20: big_curve(8,6,0);
               21: big_curve(4,6,0);
               22: big_curve(12,6,0);
               23: big_curve(16,6,0);
               30: big_curve(8,15,0);
               31: big_curve(4,15,0);
               32: big_curve(12,15,0);
               33: big_curve(16,15,0);
               52: big_curve(8,8,2);
               53: big_curve(4,8,2);
               54: big_curve(12,8,2);
               55: big_curve(16,8,2);
               105: big_curve(8,8,1);
               106: big_curve(4,8,1);
               107: big_curve(12,8,1);
               108: big_curve(16,8,1);
               88: s_big_curve(25);
               94: s_big_curve(26);
               92: s_big_curve(27);
               90: s_big_curve(28);
               91: s_big_curve(29);
               87: s_big_curve(30);
               89: s_big_curve(31);
               93: s_big_curve(32);
               61: chick(4);
               63: chick(8);
               60: chick(12);
               62: chick(16);
               119: screw(4,1,false);
               121: screw(4,4,true);
               123: screw(4,2,true);
               117: screw(4,3,false);
               120: screw(4,2,false);
               122: screw(4,3,true);
               124: screw(4,1,true);
               118: screw(4,4,false);
               else begin
                  settextstyle(0,0,1);
                  setcolor(0);
                  outtextxy(x+sx,y+sy,'4')
               end
            end
         end
         else begin
            settextstyle(0,0,1);
            setcolor(0);
            outtextxy(x+sx,y+sy,'4')
         end
      end;
      else begin
         if (mode=0) and (ord(trackfield[1,900+i-j*30])>0)
         then begin
            setcolor(7);
            a:=a+xwidth div 2;
            b:=b+ywidth div 2;
            arc(a,b,90,180,3);
            arc(a+1,b,0,90,3);
            arc(a,b+1,180,270,3);
            arc(a+1,b+1,270,360,3)
         end
      end
   end;
(*
str(ord(trackfield[1,900+i-j*30]),sv);
SetTextStyle(2, HorizDir, 4);
outtext(sv);
*)
(*
   draw_field_elem(257);
*)
   setcolor(c)
end;


procedure draw_field_elem(nr:integer);
var sv:string;

begin
   xpos:=GetX;
   ypos:=GetY;
   setcolor(16);
   case nr of
      0..18: landscape(nr,xpos,ypos);
      256: begin
         setcolor(15);
         rectangle(xpos,ypos,xpos+xwidth+1,ypos+ywidth+1)
      end;
      257: begin
         rectangle(xpos,ypos,xpos+xwidth+1,ypos+ywidth+1)
      end;
      258: begin
         if marked
         then begin
            if markfunct=0
            then begin
               setcolor(15);
               rectangle(xpos,ypos,xpos+xwidth+1,ypos+ywidth+1);
               setcolor(11);
               rectangle(l_border+((markxmin-1)*(xwidth+1)),
                 u_border+((markymin-1)*(ywidth+1)),
                 l_border+((markxmax)*(xwidth+1)),
                 u_border+((markymax)*(ywidth+1)))
            end
            else begin
               setcolor(7);
               rectangle(l_border+((ci-1)*(xwidth+1)),
                 u_border+((cj-1)*(ywidth+1)),
                 l_border+((ci+markxmax-markxmin)*(xwidth+1)),
                 u_border+((cj+markymax-markymin)*(ywidth+1)));
               if markfunct>0
               then begin
                setcolor(11);
                i:=l_border+((markxmin-1)*(xwidth+1));
                j:=u_border+((markymin-1)*(ywidth+1));
                line(i,j,i+3,j);
                line(i,j,i,j+mj);
                for ii:=markxmin+1 to markxmax
                do begin
                   i:=i+xwidth+1;
                   line(i-3,j,i+3,j)
                end;
                i:=l_border+((markxmax)*(xwidth+1));
                line(i,j,i-3,j);
                line(i,j,i,j+mj);
                for jj:=markymin+1 to markymax
                do begin
                   j:=j+ywidth+1;
                   line(i,j-mj,i,j+mj)
                end;
                j:=u_border+((markymax)*(ywidth+1));
                line(i,j,i-3,j);
                line(i,j,i,j-mj);
                for ii:=markxmax downto markxmin+1
                do begin
                   i:=i-xwidth-1;
                   line(i+3,j,i-3,j)
                end;
                i:=l_border+((markxmin-1)*(xwidth+1));
                line(i,j,i+3,j);
                line(i,j,i,j-mj);
                for jj:=markymax downto markymin+1
                do begin
                   j:=j-ywidth-1;
                   line(i,j+mj,i,j-mj)
                end
               end
            end
         end
      end;
      259: begin
         if marked
         then begin
            if markfunct=0
            then begin
               rectangle(xpos,ypos,xpos+xwidth+1,ypos+ywidth+1);
               rectangle(l_border+((markxmin-1)*(xwidth+1)),
                 u_border+((markymin-1)*(ywidth+1)),
                 l_border+((markxmax)*(xwidth+1)),
                 u_border+((markymax)*(ywidth+1)))
            end
            else begin
               if markfunct=99
               then
                  rectangle(l_border+((markxmin-1)*(xwidth+1)),
                    u_border+((markymin-1)*(ywidth+1)),
                    l_border+((markxmax)*(xwidth+1)),
                    u_border+((markymax)*(ywidth+1)));
               rectangle(l_border+((ci-1)*(xwidth+1)),
                 u_border+((cj-1)*(ywidth+1)),
                 l_border+((ci+markxmax-markxmin)*(xwidth+1)),
                 u_border+((cj+markymax-markymin)*(ywidth+1)))
            end
         end
      end;
      260: begin
         setlinestyle(SOLIDLN,1,1);
         setcolor(0);
         for i:=0 to 30 do
            line(l_border+i*(xwidth+1),u_border,
                 l_border+i*(xwidth+1),u_border+30*(ywidth+1));
         for j:=0 to 30 do
            line(l_border,u_border+j*(ywidth+1),
                 l_border+30*(ywidth+1),u_border+j*(ywidth+1));
         if markfunct<>0
         then begin
            MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
            draw_field_elem(258);
         end
         else begin
            MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
            draw_field_elem(256);
            if marked
            then
               draw_field_elem(258);
         end;
      end
      else begin
         setcolor(6);
         setfillstyle(1,6);
         squadrangle_1(xpos,ypos);
         SetTextJustify(LeftText, TopText);
         settextstyle(2,0,2);
         setcolor(0);
         str(nr,sv);
         outtextxy(xpos+3,ypos+5,sv)
      end
   end
end;


procedure draw_select_field;
var x,y:integer;

begin
   SetColor(16);
   setfillstyle(1,0);
   bar(lsf_l_border-1,tu_border-1,639,tu_border+6*(ywidth+1)+1);
   if trackmode
   then begin
      for ti:=1 to 6 do begin
         for tj:=1 to 6 do begin
            MoveTo(ssf_l_border+ti*(xwidth+1),tu_border+(tj-1)*(ywidth+1));
            draw_field_elem(0);
            draw_track_elem(1,tsf[tsf_nr,ti,tj],0)
         end
      end
   end
   else begin
      SetTextStyle(2, HorizDir, 4);
      SetTextJustify(CenterText, CenterText);
      MoveTo(lsf_pos[ 0].x,lsf_pos[ 0].y);
      draw_field_elem(0);
      Make_Label('0');
      if hill_mode then begin
         MoveTo(lsf_pos[13].x,lsf_pos[13].y);
         draw_field_elem(13);
         Make_Label('7');
         MoveTo(lsf_pos[ 9].x,lsf_pos[ 9].y);
         draw_field_elem(9);
         Make_Label('8');
         MoveTo(lsf_pos[12].x,lsf_pos[12].y);
         draw_field_elem(12);
         Make_Label('9');
         MoveTo(lsf_pos[10].x,lsf_pos[10].y);
         draw_field_elem(10);
         Make_Label('4');
         MoveTo(lsf_pos[ 6].x,lsf_pos[ 6].y);
         draw_field_elem(6);
         Make_Label('5');
         MoveTo(lsf_pos[ 8].x,lsf_pos[ 8].y);
         draw_field_elem(8);
         Make_Label('6');
         MoveTo(lsf_pos[14].x,lsf_pos[14].y);
         draw_field_elem(14);
         Make_Label('1');
         MoveTo(lsf_pos[ 7].x,lsf_pos[ 7].y);
         draw_field_elem(7);
         Make_Label('2');
         MoveTo(lsf_pos[11].x,lsf_pos[11].y);
         draw_field_elem(11);
         Make_Label('3');
         MoveTo(lsf_pos[17].x,lsf_pos[17].y);
         draw_field_elem(17);
         Write_Ctrl('7');
         MoveTo(lsf_pos[16].x,lsf_pos[16].y);
         draw_field_elem(16);
         Write_Ctrl('9');
         MoveTo(lsf_pos[18].x,lsf_pos[18].y);
         draw_field_elem(18);
         Write_Ctrl('1');
         MoveTo(lsf_pos[15].x,lsf_pos[15].y);
         draw_field_elem(15);
         Write_Ctrl('3')
      end
      else begin
         MoveTo(lsf_pos[ 3].x,lsf_pos[ 3].y);
         draw_field_elem(3);
         Make_Label('7');
         MoveTo(lsf_pos[ 2].x,lsf_pos[ 2].y);
         draw_field_elem(2);
         Make_Label('9');
         MoveTo(lsf_pos[ 1].x,lsf_pos[ 1].y);
         draw_field_elem(1);
         Make_Label('5');
         MoveTo(lsf_pos[ 4].x,lsf_pos[ 4].y);
         draw_field_elem(4);
         Make_Label('1');
         MoveTo(lsf_pos[ 5].x,lsf_pos[ 5].y);
         draw_field_elem(5);
         Make_Label('3')
      end
   end;
end;


procedure draw_sel_el;

begin
 if markfunct<1
 then begin
  if trackmode then begin
     MoveTo(sel_l,sel_u);
     draw_field_elem(0);
     draw_track_elem(2,tsf[tsf_nr,tsf_pos[tsf_nr].i,tsf_pos[tsf_nr].j],0);
     setfillstyle(SOLIDFILL,2);
     xpos:=multi_l;
     ypos:=multi_u;
(*     if (egamode=1)
     then begin
        bar(xpos+3,ypos+2,xpos+4,ypos+3);
        if (multifield) AND (not autoset) AND (markfunct=0)
        then
           setfillstyle(SOLIDFILL,8);
        bar(xpos+10,ypos+2,xpos+11,ypos+3);
        bar(xpos+3,ypos+8,xpos+4,ypos+9);
        bar(xpos+10,ypos+8,xpos+11,ypos+9);
     end
     else begin
        bar(xpos+3,ypos+3,xpos+4,ypos+4);
        if (multifield) AND (not autoset) AND (markfunct=0)
        then
           setfillstyle(SOLIDFILL,8);
        bar(xpos+11,ypos+3,xpos+12,ypos+4);
        bar(xpos+3,ypos+11,xpos+4,ypos+12);
        bar(xpos+11,ypos+11,xpos+12,ypos+12);
     end;
*)     MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)))
  end
  else begin
   setcolor(16);
   rectangle(selX-1,selY-1,selX+xwidth+2,selY+ywidth+2);
   selx:=lsf_pos[elem_nr].x;
   sely:=lsf_pos[elem_nr].y;
   SetColor(15);
   rectangle(selX-1,selY-1,selX+xwidth+2,selY+ywidth+2);
   MoveTo(sel_l,sel_u);
   draw_field_elem(elem_nr);
   MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)))
  end
 end
 else begin
      setfillstyle(1,0);
      setcolor(0);
      xpos:=sel_l;
      ypos:=sel_u;
      squadrangle_1(xpos,ypos);
      setcolor(11);
      moveto(xpos,ypos-1);
      if (egamode=1)
      then begin
         case markfunct of
            1,2: begin
               setfillstyle(1,11);
               bar(xpos+3,ypos+2,xpos+4,ypos+3);
               bar(xpos+10,ypos+2,xpos+11,ypos+3);
               bar(xpos+3,ypos+8,xpos+4,ypos+9);
               bar(xpos+10,ypos+8,xpos+11,ypos+9);
            end
         end;
         if xmirr
         then begin
            setcolor(15);
            line(xpos+1,ypos+5,xpos+13,ypos+5);
            line(xpos+1,ypos+6,xpos+13,ypos+6)
         end;
         if ymirr
         then begin
            setcolor(7);
            line(xpos+8,ypos+1,xpos+8,ypos+10);
            setcolor(15);
            line(xpos+7,ypos+1,xpos+7,ypos+10);
            setcolor(7);
            line(xpos+6,ypos+1,xpos+6,ypos+10)
         end;
      end
      else begin
         case markfunct of
            1,2: begin
               setfillstyle(1,11);
               bar(xpos+3,ypos+3,xpos+4,ypos+4);
               bar(xpos+11,ypos+3,xpos+12,ypos+4);
               bar(xpos+3,ypos+11,xpos+4,ypos+12);
               bar(xpos+11,ypos+11,xpos+12,ypos+12);
            end
         end;
         if xmirr
         then begin
            setcolor(15);
            line(xpos+1,ypos+7,xpos+14,ypos+7);
            line(xpos+1,ypos+8,xpos+14,ypos+8)
         end;
         if ymirr
         then begin
            setcolor(15);
            line(xpos+8,ypos+1,xpos+8,ypos+14);
            line(xpos+7,ypos+1,xpos+7,ypos+14)
         end;
      end;
      MoveTo(l_border+((ci-1)*(xwidth+1)),u_border+((cj-1)*(ywidth+1)));
      xpos:=l_border+((ci-1)*(xwidth+1));
      ypos:=u_border+((cj-1)*(ywidth+1))
 end
end;


procedure draw_edit_menu;
var altx,alty:integer;

begin
   altx:=getx;
   alty:=gety;
   SetColor(16);
   setfillstyle(1,0);
   bar(takt_l,takt_u2,sel_l-7,479);
   SetColor(5);
   SetTextStyle(2, HorizDir, 4);
   SetTextJustify(LeftText, TopText);
   if markfunct<1
   then begin
    if trackmode
    then begin
       MoveTo(ssf_l_border+tsf_pos[tsf_nr].i*(xwidth+1),
              tu_border+(tsf_pos[tsf_nr].j-1)*(ywidth+1));
       draw_field_elem(256);
       setcolor(5);
       MoveTo(takt_l,takt_u1);
       OutText(ted1);
       MoveTo(takt_l,takt_u1+takt_yplus*1);
       OutText(ted2);
       MoveTo(takt_l,takt_u1+takt_yplus*2);
       OutText(ted3);
       MoveTo(sel_l,sel_u);
       SetColor(15);
       rectangle(GetX-6,GetY-6,GetX+xwidth+7,GetY+ywidth+7);
       SetColor(7);
       rectangle(GetX-4,GetY-4,GetX+xwidth+5,GetY+ywidth+5);
       SetColor(8);
       rectangle(GetX-2,GetY-2,GetX+xwidth+3,GetY+ywidth+3);
    end
    else begin
       MoveTo(takt_l,takt_u1);
       OutText(ed1);
       MoveTo(takt_l,takt_u1+takt_yplus*1);
       OutText(ed2);
       MoveTo(takt_l,takt_u1+takt_yplus*2);
       OutText(ed3);
       MoveTo(sel_l,sel_u);
       SetColor(15);
       rectangle(GetX-6,GetY-6,GetX+xwidth+7,GetY+ywidth+7);
       SetColor(7);
       rectangle(GetX-4,GetY-4,GetX+xwidth+5,GetY+ywidth+5);
       SetColor(8);
       rectangle(GetX-2,GetY-2,GetX+xwidth+3,GetY+ywidth+3);
       selx:=lsf_pos[0].x;
       sely:=lsf_pos[0].y;
    end;
    write_status
   end
   else begin
      if (terrmark) and (trackmark)
      then begin
       MoveTo(takt_l,takt_u2);
       OutText(ed1);
       MoveTo(takt_l,takt_u2+takt_yplus*1);
       OutText(ted2);
       MoveTo(takt_l,takt_u2+takt_yplus*2);
       OutText(ed2);
       MoveTo(takt_l,takt_u2+takt_yplus*3);
       OutText(ed3);
      end
      else if (not terrmark) and (trackmark)
      then begin
       MoveTo(takt_l,takt_u2);
       OutText(ed1);
       MoveTo(takt_l,takt_u2+takt_yplus*1);
       OutText(ted2);
       setcolor(8);
       MoveTo(takt_l,takt_u2+takt_yplus*2);
       OutText(ed2);
       setcolor(5);
       MoveTo(takt_l,takt_u2+takt_yplus*3);
       OutText(ed3);
      end
      else if (terrmark) and (not trackmark)
      then begin
       MoveTo(takt_l,takt_u2);
       OutText(ed1);
       setcolor(8);
       MoveTo(takt_l,takt_u2+takt_yplus*1);
       OutText(ted2);
       setcolor(5);
       MoveTo(takt_l,takt_u2+takt_yplus*2);
       OutText(ed2);
       MoveTo(takt_l,takt_u2+takt_yplus*3);
       OutText(ed3);
      end;
       write_status;
       MoveTo(sel_l,sel_u);
       SetColor(15);
       rectangle(GetX-6,GetY-6,GetX+xwidth+7,GetY+ywidth+7);
       SetColor(7);
       rectangle(GetX-4,GetY-4,GetX+xwidth+5,GetY+ywidth+5);
       SetColor(8);
       rectangle(GetX-2,GetY-2,GetX+xwidth+3,GetY+ywidth+3);
   end;
   moveto(altx,alty)
end;


procedure draw_menu_line(xpos,ypos:integer;keytext,dots,functtext:string;
  active:boolean);
const x_d=91;
      x_f=97;

begin
   SetTextStyle(2, HorizDir, 4);
   SetTextJustify(LeftText, TopText);
   if active
   then
      setcolor(2)
   else
      setcolor(8);
   OutTextXY(xpos,ypos,keytext);
   if active
   then
      setcolor(5)
   else
      setcolor(8);
   OutTextXY(xpos+x_f,ypos,functtext);
   SetTextStyle(2, HorizDir, 2);
   SetTextJustify(RightText, TopText);
   if active
   then
      setcolor(7)
   else
      setcolor(8);
   OutTextXY(xpos+x_d,ypos+1,dots)
end;


procedure draw_smenu_line(xpos,ypos,x_dots:integer;keytext,dots,functtext:
  string;active:boolean);

begin
   ypos:=ypos-1-egamode*2;
   SetTextStyle(2, HorizDir, 4);
   SetTextJustify(LeftText, TopText);
   if active
   then
      setcolor(2)
   else
      setcolor(8);
   OutTextXY(xpos,ypos,keytext);
   if active
   then
      setcolor(5)
   else
      setcolor(8);
   OutTextXY(xpos+x_dots+6,ypos,functtext);
   SetTextStyle(2, HorizDir, 2);
   SetTextJustify(RightText, TopText);
   if active
   then
      setcolor(7)
   else
      setcolor(8);
   OutTextXY(xpos+x_dots,ypos+1,dots)
end;


procedure draw_full_key_menu;
const x_base=9;
      x_plus=310;
      x_d=91;
      x_f=97;
var x_pos,y_pos,x_dots,x_funct,c,oldx,oldy:integer;
    active:boolean;

begin
   oldx:=GetX;
   oldy:=GetY;
   c:=getcolor;
   x_dots:=x_base+x_d;
   x_funct:=x_base+x_f;
   x_pos:=x_base;
   y_pos:=fkm_ybase;
   SetTextStyle(2, HorizDir, 6);
   SetTextJustify(CenterText, TopText);
   SetColor(9);
   OutTextXY(319,10,me);
   if markfunct=0
   then begin
    draw_menu_line(x_pos,y_pos,'< C_Left >','    ',e1,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< C_Right >','   ',e2,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< C_Up >','      ',e3,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< C_Down >','    ',e4,true);
    y_pos:=y_pos+fkm_yplus;
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< Pg_Up >','     ',e5,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< Pg_Down >','   ',e6,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< End >','       ',e7,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< Home >','      ',e8,true);
   end
   else begin
    draw_menu_line(x_pos,y_pos,'< C_Left >','    ',em1,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< C_Right >','   ',em2,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< C_Left >','    ',em3,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< C_Right >','   ',em4,true);
    y_pos:=y_pos+fkm_yplus;
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< Pg_Up >','     ',em5,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< Pg_Down >','   ',em6,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< End >','       ',em7,true);
    y_pos:=y_pos+fkm_yplus;
    draw_menu_line(x_pos,y_pos,'< Home >','      ',em8,true)
   end;
   y_pos:=y_pos+fkm_yplus;
   y_pos:=y_pos+fkm_yplus;
   if markfunct>0
   then
      draw_menu_line(x_pos,y_pos,'< Space >','     ',em9,true)
   else
      draw_menu_line(x_pos,y_pos,'< Space >','     ',e9,true);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< F1 >','','',true);
   y_pos:=y_pos+fkm_yplus;
   setcolor(7);
   SetTextStyle(2, HorizDir, 4);
   SetTextJustify(LeftText, TopText);
   OutTextXY(x_pos+20,y_pos-5,'.');
   OutTextXY(x_pos+20,y_pos,'.');
   if markfunct>0
   then
      draw_menu_line(x_pos,y_pos,'','         ',em10,true)
   else
      draw_menu_line(x_pos,y_pos,'','         ',e10,true);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< F10 >','','',true);
   y_pos:=y_pos+fkm_yplus;
   y_pos:=y_pos+fkm_yplus;
   active:=true;
   if markfunct<>0
   then
      active:=false;
   draw_menu_line(x_pos,y_pos,'< Tab >','       ',e11,active);
   active:=true;
   x_pos:=x_base+x_plus;
   y_pos:=fkm_ybase;
   if trackmode
   then begin
      if markfunct>0
      then
         active:=false;
      draw_menu_line(x_pos,y_pos,'< 4 >','         ',en4,active);
      y_pos:=y_pos+fkm_yplus;
      draw_menu_line(x_pos,y_pos,'< 6 >','         ',en6,active);
      y_pos:=y_pos+fkm_yplus;
      draw_menu_line(x_pos,y_pos,'< 8 >','         ',en8,active);
      y_pos:=y_pos+fkm_yplus;
      setcolor(2);
      if markfunct>0
      then
         setcolor(8);
      SetTextStyle(2, HorizDir, 4);
      SetTextJustify(LeftText, TopText);
      OutTextXY(x_pos,y_pos,'< 2 >');
      OutTextXY(x_pos+42,y_pos,'< 5 >');
      setcolor(7);
      if markfunct>0
      then
         setcolor(8);
      SetTextStyle(2, HorizDir, 4);
      SetTextJustify(RightText, TopText);
      OutTextXY(x_pos+40,y_pos,',');
      draw_menu_line(x_pos,y_pos,'','  ',en2,active);
      y_pos:=y_pos+fkm_yplus;
      y_pos:=y_pos+fkm_yplus;
      draw_menu_line(x_pos,y_pos,'< 9 >','         ',en9,active);
      y_pos:=y_pos+fkm_yplus;
      draw_menu_line(x_pos,y_pos,'< 3 >','         ',en3,active);
      y_pos:=y_pos+fkm_yplus;
      draw_menu_line(x_pos,y_pos,'< 1 >','         ',en1,active);
      y_pos:=y_pos+fkm_yplus;
      draw_menu_line(x_pos,y_pos,'< 7 >','         ',en7,active)
   end
   else begin
      active:=true;
      setcolor(2);
      if markfunct>0
      then begin
         SetColor(8);
         active:=false
      end;
      SetTextStyle(2, HorizDir, 4);
      SetTextJustify(LeftText, TopText);
      OutTextXY(x_pos,y_pos,'< 0 >');
      OutTextXY(x_pos+49,y_pos,'< 9 >');
      setcolor(7);
      if markfunct>0
      then
         setcolor(8);
      SetTextJustify(RightText, TopText);
      OutTextXY(x_pos+39,y_pos-1,'.');
      OutTextXY(x_pos+44,y_pos-1,'.');
      draw_menu_line(x_pos,y_pos,'',' ',en0,active)
   end;
   x_pos:=x_base+x_plus;
   y_pos:=fkm_ybase+10*fkm_yplus;
   if markfunct<=0
   then begin
      if (prefetched)
      then
         draw_menu_line(x_pos,y_pos,'< Enter >','     ',e12b,true)
      else
         draw_menu_line(x_pos,y_pos,'< Enter >','     ',e12a,true)
   end
   else
      draw_menu_line(x_pos,y_pos,'< Enter >','     ',em12,true);
   y_pos:=y_pos+fkm_yplus;
   if markfunct<=0
   then
      draw_menu_line(x_pos,y_pos,'< BckSpc. >','   ',e13,true)
   else begin
      if (lneumarkpos)
      then
         draw_menu_line(x_pos,y_pos,'< BckSpc. >','   ',em13,true)
      else
         draw_menu_line(x_pos,y_pos,'< BckSpc. >','   ',em13,false)
   end;
   y_pos:=y_pos+fkm_yplus;
   if markfunct<=0
   then
      draw_menu_line(x_pos,y_pos,'< Ins >','       ',e14,true)
   else begin
      if (sneumarkpos)
      then
         draw_menu_line(x_pos,y_pos,'< Ins >','       ',em14,true)
      else
         draw_menu_line(x_pos,y_pos,'< Ins >','       ',em14,false)
   end;
   active:=true;
   if markfunct>0
   then
      active:=false;
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< Del >','       ',e15,active);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< x >','         ',e16,active);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< X >','         ',e16b,active);
   x_pos:=x_base;
   y_pos:=fkm_ybase+17*fkm_yplus;
   active:=true;
   if markfunct<>0
   then
      active:=false;
   draw_menu_line(x_pos,y_pos,'< Alt-F5 >','    ',e17,active);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< Alt-F6 >','    ',e18,active);
   y_pos:=y_pos+fkm_yplus;
   active:=false;
   if markfunct<>0
   then
      active:=true;
   draw_menu_line(x_pos,y_pos,'< Alt-F7 >','    ',e19b,active);
   y_pos:=y_pos+fkm_yplus;
   active:=true;
   if not marked
   then
      active:=false;
   draw_menu_line(x_pos,y_pos,'< Alt-F8 >','    ',e19,active);
   y_pos:=y_pos+fkm_yplus;
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< '+comp_char+' >','         ',e24,true);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< '+swap_char+' >','         ',e25,true);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< D >','         ',e27,true);
   y_pos:=y_pos+fkm_yplus;
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< Alt-F2 >','    ',e26,true);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< - >','         ',e30,true);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< + >','         ',e31,true);
   x_pos:=x_base+x_plus;
   y_pos:=fkm_ybase+17*fkm_yplus;
   active:=true;
   if not ((marked) and (markfunct=0))
   then
      active:=false;
   draw_menu_line(x_pos,y_pos,'< Ctrl-S >','    ',e20,active);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< Ctrl-C >','    ',e21,(markfunct=0));
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< Ctrl-X >','    ',e22,(markfunct=0));
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< Alt-X >','     ',e22sh,(markfunct=0));
   y_pos:=y_pos+fkm_yplus;
   y_pos:=y_pos+fkm_yplus;
   active:=true;
   if not (markfunct>0)
   then
      active:=false;
   draw_menu_line(x_pos,y_pos,'< '+mirr_char+' >','         ',e23a,active);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< '+mirr_shift_char+' >','         ',e23b,active);
   y_pos:=y_pos+fkm_yplus;
   y_pos:=y_pos+fkm_yplus;
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< Esc >','       ',e91,true);
   y_pos:=y_pos+fkm_yplus;
   draw_menu_line(x_pos,y_pos,'< Q >','         ',e92,true);
   SetColor(5);
   SetTextStyle(5, HorizDir, 0);
   SetTextJustify(CenterText, TopText);
   OutTextXY(319,fh_u,i3);
   readkey;
   if keypressed
   then
      readkey;
   setcolor(c);
   MoveTo(oldx,oldy)
end;


procedure draw_short_key_menu;
const x_d=79;
      x_f=85;
var x_pos,y_pos,c,oldx,oldy:integer;
    active:boolean;

begin
   oldx:=GetX;
   oldy:=GetY;
   c:=getcolor;
   setcolor(1);
   rectangle(l_border+(xwidth+1)*31-1,skm_ybase,
     639,skm_ybase+skm_yplus*25);
   setfillstyle(1,0);
   x_pos:=skm_xbase;
   y_pos:=skm_ybase+1;
   clear_field(x_pos+55,y_pos,638,y_pos+12);
   if markfunct>0
   then
      draw_smenu_line(x_pos,y_pos,49,'<Space>','',esm9,true)
   else
      draw_smenu_line(x_pos,y_pos,49,'<Space>','',es9,true);
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,55,'<F1>','','',true);
   y_pos:=y_pos+skm_yplus;
   setcolor(7);
   SetTextStyle(2, HorizDir, 4);
   SetTextJustify(LeftText, TopText);
   OutTextXY(x_pos+14,y_pos-5,'.');
   OutTextXY(x_pos+14,y_pos,'.');
   clear_field(x_pos+49,y_pos,638,y_pos+12);
   if markfunct>0
   then
      draw_smenu_line(x_pos,y_pos,49,'','   ',esm10,true)
   else
      draw_smenu_line(x_pos,y_pos,49,'','   ',es10,true);
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,55,'<F10>','','',true);
   y_pos:=y_pos+skm_yplus;
   setcolor(1);
   line(skm_xbase-3,y_pos-1,638,y_pos-1);
   active:=true;
   if markfunct<>0
   then
      active:=false;
   draw_smenu_line(x_pos,y_pos,37,'<Tab>','',es11,active);
   y_pos:=y_pos+skm_yplus;
   setcolor(1);
   line(skm_xbase-3,y_pos-1,638,y_pos-1);
   active:=true;
   clear_field(x_pos+55,y_pos,638,y_pos+12);
   if markfunct<=0
   then begin
      if (prefetched)
      then
         draw_smenu_line(x_pos,y_pos,55,'<Enter>',' ',es12b,true)
      else
         draw_smenu_line(x_pos,y_pos,55,'<Enter>',' ',es12a,true)
   end
   else
      draw_smenu_line(x_pos,y_pos,55,'<Enter>',' ',esm12,true);
   y_pos:=y_pos+skm_yplus;
   clear_field(x_pos+55,y_pos,638,y_pos+12);
   if markfunct<=0
   then
      draw_smenu_line(x_pos,y_pos,55,'<B.Spc.>',' ',es13,true)
   else begin
      if (lneumarkpos)
      then
         draw_smenu_line(x_pos,y_pos,55,'<B.Spc.>',' ',esm13,true)
      else
         draw_smenu_line(x_pos,y_pos,55,'<B.Spc.>',' ',esm13,false)
   end;
   y_pos:=y_pos+skm_yplus;
   clear_field(x_pos+55,y_pos,638,y_pos+12);
   if markfunct<=0
   then
      draw_smenu_line(x_pos,y_pos,55,'<Ins>','   ',es14,true)
   else begin
      if (sneumarkpos)
      then
         draw_smenu_line(x_pos,y_pos,55,'<Ins>','   ',esm14,true)
      else
         draw_smenu_line(x_pos,y_pos,55,'<Ins>','   ',esm14,false)
   end;
   active:=true;
   if markfunct>0
   then
      active:=false;
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,55,'<Del>','   ',es15,active);
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,55,'<x>/<X>',' ',es16,active);
   y_pos:=y_pos+skm_yplus;
   setcolor(1);
   line(skm_xbase-3,y_pos-1,638,y_pos-1);
   active:=true;
   if markfunct<>0
   then
      active:=false;
   draw_smenu_line(x_pos,y_pos,55,'<Alt-F5>','',es17,active);
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,55,'<Alt-F6>','',es18,active);
   y_pos:=y_pos+skm_yplus;
   active:=false;
   if markfunct<>0
   then
      active:=true;
   draw_smenu_line(x_pos,y_pos,55,'<Alt-F7>','',es19b,active);
   y_pos:=y_pos+skm_yplus;
   active:=true;
   if not marked
   then
      active:=false;
   draw_smenu_line(x_pos,y_pos,55,'<Alt-F8>','',es19,active);
   y_pos:=y_pos+skm_yplus;
   setcolor(1);
   line(skm_xbase-3,y_pos-1,638,y_pos-1);
   active:=true;
   if not ((marked) and (markfunct=0))
   then
      active:=false;
   draw_smenu_line(x_pos,y_pos,55,'<Ctrl-S>','',es20,active);
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,55,'<Ctrl-C>','',es21,(markfunct=0));
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,55,'<Ctrl-X>','',es22,(markfunct=0));
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,55,'<Alt-X>',' ',es22sh,(markfunct=0));
   y_pos:=y_pos+skm_yplus;
   setcolor(1);
   line(skm_xbase-3,y_pos-1,638,y_pos-1);
   active:=true;
   if not (markfunct>0)
   then
      active:=false;
   draw_smenu_line(x_pos,y_pos,23,'<'+mirr_char+'>','',es23,active);
   y_pos:=y_pos+skm_yplus;
   setcolor(1);
   line(skm_xbase-3,y_pos-1,638,y_pos-1);
   draw_smenu_line(x_pos,y_pos,23,'<'+comp_char+'>','',es24,true);
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,23,'<'+swap_char+'>','',es25,true);
   y_pos:=y_pos+skm_yplus;
   setcolor(1);
   line(skm_xbase-3,y_pos-1,638,y_pos-1);
   draw_smenu_line(x_pos,y_pos,61,'<Alt-F2>',' ',es26,true);
   y_pos:=y_pos+skm_yplus;
   setcolor(1);
   line(skm_xbase-3,y_pos-1,638,y_pos-1);
   draw_smenu_line(x_pos,y_pos,61,'<Alt-F1>',' ',es90,true);
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,61,'<Esc>','    ',es91,true);
   y_pos:=y_pos+skm_yplus;
   draw_smenu_line(x_pos,y_pos,61,'<Q>','      ',es92,true);
   setcolor(c);
   MoveTo(oldx,oldy)
end;


procedure write_status;
var x,y,c:integer;

begin
   x:=getx;
   y:=gety;
   c:=getcolor;
   SetTextStyle(2, HorizDir, 4);
   SetTextJustify(LeftText, TopText);
   if (autoset) and (markfunct<1)
   then
      setcolor(14)
   else
      setcolor(8);
   outtextxy(autoset_l,takt_u1,edstat11);
   outtextxy(autoset_l,takt_u1+takt_yplus*1,edstat12);
   outtextxy(autoset_l,takt_u1+takt_yplus*2,edstat13);
   if (trackcomp)
   then
      setcolor(14)
   else
      setcolor(8);
   settextjustify(centertext,toptext);
   outtextxy(vmstat_l,vmstat_u,edstat2);
   moveto(x,y);
   setcolor(c)
end;


procedure Make_Label(s:string);

begin
   SetColor(c_text_graph);
   OutTextXY(GetX+7,GetY+laby,'<'+s+'>')
end;


procedure Write_Ctrl(z:char);

begin
   SetColor(c_text_graph);
   OutTextXY(GetX-8,GetY+laby,'<');
   OutTextXY(GetX-3,GetY+laby,'C');
   OutTextXY(GetX+1,GetY+laby,'t');
   OutTextXY(GetX+6,GetY+laby,'r');
   OutTextXY(GetX+9,GetY+laby,'l');
   OutTextXY(GetX+13,GetY+laby,'-');
   OutTextXY(GetX+18,GetY+laby,z);
   OutTextXY(GetX+23,GetY+laby,'>');
end;




begin
end.
