# Restunts - The Stunts reverse engineering project

https://wiki.stunts.hu/wiki/Restunts

Main repository: https://github.com/4d-stunts/restunts

## Repository contents:
	docs
		Various technical docs related to (re)stunts itself.

	src\execombiner
		Tool which combines the original game and video drivers into a single
		debugable executable.

	src\idc
		Script for IdaPro to generate .asm-files from an ida project.

	src\restunts
		Project directory containing disassembly, ported c and makefiles to
		produce various executables based on the (re)stunts code.

	stunts
		Stunts 1.1 the game.

	tools
		Contains binaries, libraries, headers with a full toolchain for
		building restunts on Windows. The toolchain is based on TASM, TLINK,
		Turbo Debugger, Borland C++, DOSBox, and various other tools.


### Contents of src\restunts:
	src\restunts\game_mod3.idb
		The analysis database for IDAPro.

	src\restunts\asm
		Contains patched, compilable disassembly generated by the script for
		IdaPro. This code is patched to work with our ported c code.
		Note 2025-02-03: the asm is not in sync with IDA any more, since some
		variable names were modified by the script src\restunts\annotate-vars.sh

	src\restunts\asmorig
		Contains the same files as src\restunts\asm, but unpatched and does not
		use any of the ported c code.

	src\restunts\c
		Contains c functions ported from the disassembly.

	src\restunts\dos
		Makefile to build restunts for DOS.

	src\restunts\repldump
		Tool based on the original game code, loads replays and dumps the game
		state contents at each frame in a file for further analysis.


## How to build

### On Windows
	1) Double click tools\mount_stunts_to_s.bat (only needed once per reboot)
	2) Start cmd.exe and enter the following commands:
		S:
		cd \src\restunts
		setpath
		make

### On Linux
	0) You might want to set `git config --worktree core.autocrlf=false` before
	   you make any change, lest git meddles with the DOS newlines
	1) Install Wine
	2) Mount the restunts dir as drive S using winecfg
	3) In the Linux console type `wineconsole cmd`
	4) In the resulting Wine console type (mind the inverted slashes and the lack of tab completion):
	```
	s:
	cd src\restunts
	setpath
	```

### On both platforms

If everything went fine, there should be a new s:\stunts\restunts.exe which can
be run in DOSBox. Note that the drive letter S: is hardcoded many places in the
makefiles, and is also mounted inside DOSBox as a fixed point of reference.

The makefile supports the following targets:

	make <OPTIONS> restunts
		The default restunts target builds an executable based on ported C code
		and patched disassembly.

	make <OPTIONS> restunts-original
		Builds an executable based on unpatched disassembly with the original
		codepaths intact. Does not use any of the ported C code.

	make <OPTIONS> repldump
		Builds the replay dump tool using ported C code and patched
		disassembly.

	make <OPTIONS> repldump-original
		Builds the replay dump tool without ported C code.


## Build options

### Assembler selection

Restunts builds per default with TASM32 for Windows, but it can be changed to using
the a 16-bit TASMX by using option `ASSEMBLER=tasmbox` before the target name (or
`ASSEMBLER=tasmx` if one really likes seeing pop-up windows).

E.g. to build restunts with TASMX, type

	make ASSEMBLER=tasmbox restunts 

Building with TASMX is much slower since DOSBox is involved, but it allows to include 
debugging symbols (s. below)

### Linker selection

Restunts links per default with TLINK using dosbox but that can changed to using
the native WLINK executable by using option `LINKER=wlink` before the target name

E.g. to build Restunts with wlink, type

	make LINKER=wlink restunts 

Note that `WLINK` is experimental, and it does not allow to include debug symbols. Its
use can slightly speed up the build process since it avoids calling DOSBox.

### Debugging symbols

The executable can be built with debug symbols by means of the `CONFIG=debug`
option. Note that this requires using TASMX as assembler and TLINK as linker
(TLINK is currently the default but this might change in future)

E.g. to build Restunts with debug symbols, type

	make ASSEMBLER=tasmbox LINKER=tlink CONFIG=debug restunts 


## The toolchain

The toolchain has evolved over the years and it can now (2025) use either
Borland tools or alternative ones. For various reasons, the build process can
uses both 16 and 32-bit tools. In order to compile on modern 64 bit systems,
the 16-bit apps run via DOSBox. A couple of batch files (in
`tools\bin\*box.bat`) take care of starting DOSBox in headless mode to prevent
pop-ups, and copy the output into the Windows console.

### Tools used
Assemblers:
	- TASMX (16-bit, from Borland Turbo Assembler 4.0)
	- TASM32 (32-bit)

Linkers:
	- TLINK (16-bit)
	- WLINK (32-bit, experimental)

Other:
	- Borland C++ 5.2 (Win32)
	- GNU Make 4.4.1 (Win32) - from the Chocolatey Windows Packages

## Analysis in IDA and the development cycle

Analysis happens continously in IDA 6.1 (Win32). Using a custom script in IDA,
the entire disassembly is exported to compilable .asm and .inc files in
src\restunts\asm. This allows using latest analysis results in the build
process. As code is ported manually to C, the custom script is updated and kept
in sync, such that it generates patched assembly code calling into the ported C
functions.

The custom script also runs a second pass, where it exports a separate set of
.asm files to src\restunts\asmorig. These files are unpatched and produce code
that behaves 100% identically to the original game.

When doing analysis and (re)naming variables and functions, it is important to
always check the ported C code if there are any references to the previous
symbol names. All symbol references in the C code need to be kept in sync with
the analysis manually. Obviously, the linker will complain about missing
symbols in case a symbol was renamed in IDA, but not in the C files.


## Debugging restunts.exe

Restunts can be debugged with Turbo Debugger inside DOSBox. In orger to do
that, the target program must be built with debug symbols, which is possible by
setting the option `CONFIG=debug` when calling make (see paragraph “Debugging
symbols” above).

The DOSBox debugging environment is an extension of the build environment
described above:

	1) Double click tools\mount_stunts_to_s.bat (only needed once per reboot)
	2) Start DOSBox and enter the following commands:
		mount S S:
		S:
		cd tools
		setpath.bat
		cd \stunts
		td restunts.exe

Turbo Debugger is preconfigured to automatically find and show the source code.
Setting breakpoints, stepping etc works. The TD configuration file is stored in
stunts\tdconfig.td.

## Notes about the toolchain

### Notes regarding the linker

WLINK from the Open Watcom C/C++ compiler suite was originally chosen because
it supports detailed control on how to order segment classes in the final
executable image.

Our requirement is to put the original code and data first in the file, exactly
as in the original game, only patching up function calls and data access.
TLINK and OPTLINK were tested in the early days, but after having difficulties
with segment ordering and subsequent crashes, the project settled on WLINK.

The problems with TLINK were revisited and fixed years later, after an urgent
need to get debug information for the restunts executable. As WLINK is not able
to use the debug information format created by BCC/TASM, it became necessary to
replace either of them. After the initial attempts of using TLINK were
successful, no further investigation were made into replacing TASM.  It should
be noted that MASM seems a promising TASM replacement candidate: the syntax is
close to TASM, and it produces CodeView debug format usable by WLINK.


### Notes regarding 16-bit tasmx, tlink and DOSBox

The choice of reverting to TLINK was not easy either. Only the 16-bit version
of TLINK can produce 16-bit executables such as restunts.exe, and it can only
use object files produced by the 16-bit TASM. In order to use 16-bit tools on a
64-bit Windows host, they need to be emulated. And so DOSBox became
incorporated in the build process. Another problem is the regular 16-bit
tasm.exe exceeds the available 640k of memory when compiling the largest
restunts source files. This was overcome by using the DPMI-enabled tasmx.exe
instead.


### Notes regarding the CRT (libc)

When linking with cm.lib from Borland C++ 5.1, TLINK is not able to produce an
executable. To get around this, the tlib tool was used to extract object files
from cm.lib, and now restunts links with these instead.

When the project used WLINK, it was able to link with cm.lib from Borland C++
5.1, but was not able to link correctly with cm.lib from Borland C++ 3.1.
Before upgrading to Borland C++ 5.1, the makefile would link to single obj
files from Borland 3.1's CRT.

The linker can complain about weird missing symbols f.ex at first time use of
some compiler feature or CRT function. This can be fixed by extracting the
object file from cm.lib, and adding it to the makefile.

cm.lib is the medium model libc from Borland C++ 5.2. tlib.exe is a 16-bit
Borland utility for manipulating lib files and has to be run via DOSBox.

Using a binary file viewer with cm.lib it's possible to locate missing CRT
symbol names and work out/guess the object file name by looking at strings in
the binary data before it.

To extract the object file
	1) Double click tools\mount_stunts_to_s.bat (only needed once per reboot)
	2) Start DOSBox and initialize the restunts development environment:
		mount S S:
		S:
		cd tools
		setpath.bat
		cd \tools\lib
	3) Run tlib to extract the object file, some examples:
		tlib cm.lib * GETVECT
		tlib cm.lib * LABS
		tlib cm.lib * STRCPY
		tlib cm.lib * MEMCPY
		tlib cm.lib * FMEMCPY
		tlib cm.lib * H_LDIV
		tlib cm.lib * F_LXMUL
		tlib cm.lib * F_SCOPY
		tlib cm.lib * H_LRSH
		tlib cm.lib * H_PADD
		tlib cm.lib * H_PINA
		tlib cm.lib * H_PADA
		tlib cm.lib * N_PCMP
		tlib cm.lib * F_PCMP
		tlib cm.lib * H_LURSH
		tlib cm.lib * H_PSBP
		tlib cm.lib * H_LLSH
	4) Add new CRT object files in dos\makefile - at the end of the line
	   starting with CTARGETS =


## Porting a function from ASM to C

1. Open src\idc\anders.idc in a text editor and locate the PortFuncName()
   function. The IDA script needs to be aware of all the functions that have
   been ported in order to generate asm that does not conflict with the ported
   code. Add a line in PortFuncName() for the function you've chosen.

2. Run anders.idc from within IDA to regenerate the asm files (or skip step 1+2
   and rename the respective extrn, public and function manually in the .inc
   and asm files)

3. Add a function stub to one of the existing .c files in src\restunts\c
3.1 If you want to add a new .c-file to the project, you need to
	- add a target for it in c\makefile
	- add a reference to the obj in RESTUNTS_OBJFILES in dos\makefile

4. Add an extrn for the c-function in asm\custom.inc

5. Start make to see if it compiles + links

6. Port to c!
