/*
Copyright (C) 2013 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <time.h>
#include <SDL.h>
#include "cstr.h"
#include "crs_sdl.h"
#include "draw.h"


/*ctext[10]*/
void clocktext(char *ctext,int sec)
{int c;
c=sec/3600;
sprintf(ctext,"%2d",c); if(c<10){ctext[0]='0';}
c=(sec%3600)/60;
sprintf(&ctext[3],"%2d",c); if(c<10){ctext[3]='0';}
c=sec%60;
sprintf(&ctext[6],"%2d",c); if(c<10){ctext[6]='0';}
ctext[2]=ctext[5]=':';
}


char rtlet(int i,char sl)
{switch(i){
  case 1: if(sl=='a'){return 'a';}else{return '1';}
  case 2: if(sl=='a'){return 'b';}else{return '2';}
  case 3: if(sl=='a'){return 'c';}else{return '3';}
  case 4: if(sl=='a'){return 'd';}else{return '4';}
  case 5: if(sl=='a'){return 'e';}else{return '5';}
  case 6: if(sl=='a'){return 'f';}else{return '6';}
  case 7: if(sl=='a'){return 'g';}else{return '7';}
  case 8: if(sl=='a'){return 'h';}else{return '8';}
  default: return '0';
}
}


void mvtext(pcmove *mv,char *s){
  int i1,i2,j1,j2,n1,n2;
  n1=mv->start[0];
  n2=mv->dest[0];
  i1=(n1-1)/8+1; j1=(n1-1)%8+1;
  i2=(n2-1)/8+1; j2=(n2-1)%8+1;
  s[0]=rtlet(j1,'a');
  s[1]=rtlet(i1,'1');
  s[2]=rtlet(j2,'a');
  s[3]=rtlet(i2,'1');
  s[4]='\0';
}


int main()
{int i,j,skill,firstmove,wsk=2,bsk=2,
     clws=35,clbs=0,clwp=10,clbp=15, /*colours*/
     clk,timw,timb; /*clock*/
board bd;
char sel,col='w',slcol[10],imove[10],timtxt[10];

initgraph(640,480,0);
inrnd();

initscr();start_color();
init_pair(1,COLOR_WHITE,COLOR_BLUE);
init_pair(2,COLOR_WHITE,COLOR_BLACK);
init_pair(3,COLOR_BLUE,COLOR_GREEN);
init_pair(4,COLOR_YELLOW,COLOR_BLACK);
init_pair(5,COLOR_CYAN,COLOR_BLACK);
init_pair(6,COLOR_BLACK,COLOR_GREEN);
init_pair(7,COLOR_WHITE,COLOR_RED);
init_pair(8,COLOR_RED,COLOR_BLACK);
init_pair(9,COLOR_BLACK,COLOR_CYAN);
init_pair(10,COLOR_GREEN,COLOR_BLACK);
bkgd(COLOR_PAIR(2));curs_set(1);
/*initializat ecran grafic*/


MENU1:

erase(); attron(1);
move(2,4); printw(" xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx ");
move(3,4); printw("     MPChess 1.2.2 - Copyright 2013 Matei Petrescu      ");
move(4,4); printw("  Available under GNU GPL license, version 3 or later,  ");
move(5,4); printw("            see file 'COPYING' for details              ");
move(6,4); printw(" xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx ");

attron(2); refresh();


move(9,10); attron(COLOR_PAIR(4));printw(" 1."); attron(COLOR_PAIR(2));
            printw(" Start playing");
move(10,10); attron(COLOR_PAIR(4));printw(" 2."); attron(COLOR_PAIR(2));
             printw(" Watch computer play with itself");
move(11,10); attron(COLOR_PAIR(4));printw(" 3."); attron(COLOR_PAIR(2));
             printw(" Change colours");
move(12,10); attron(COLOR_PAIR(4));printw(" 4."); attron(COLOR_PAIR(2));
             printw(" Quit");
move(14,14);attron(COLOR_PAIR(1)); printw(" press a key (1...4) "); attron(COLOR_PAIR(2));

move(0,0); sel=getch_graph(); move(0,0); printw("     ");


switch(sel){
  case '1':
    skill=2;
    move(16,14); printw("Difficulty level (1...4): "); scanw("%d",&skill);
    if(skill<1){skill=1;}
    if(skill>4){skill=4;}
    skill+=2; /*search 'skill' moves ahead*/

    move(17,14); printw("Your colour (w/b): "); scanw("%s",slcol);
    if((slcol[0]=='w')||(slcol[0]=='W')){col='w';}else{col='b';}
    break;

  case '2':
    move(16,14); printw("White level (1...4): "); scanw("%d",&wsk);
    if(wsk<1){wsk=1;}
    if(wsk>4){wsk=4;}
    wsk+=2; /*search 'skill' moves ahead*/

    move(17,14); printw("Black level (1...4): "); scanw("%d",&bsk);
    if(bsk<1){bsk=1;}
    if(bsk>4){bsk=4;}
    bsk+=2; /*search 'skill' moves ahead*/

    skill=wsk;
    col='w';
    break;

  case '3':
    erase();
    for(i=0;i<=10;i++){
      drectangle(130+40*i,400,160+40*i,430,i);
      sprintf(slcol,"%d",i);
      dtext(slcol,130+40*i,430,20,10);
    }
    for(i=1;i<=6;i++){
      for(j=1;j<=5;j++){
        drectangle(50+80*i,140+40*j,80+80*i,170+40*j,(i-1)*5+j+10);
        sprintf(slcol,"%d",(i-1)*5+j+10);
        dtext(slcol,26+80*i,140+40*j,20,10);
      }
    }
    move(17,14); printw("White square colour (0...40): "); scanw("%d",&clws);
    if(clws<0){clws=0;} if(clws>40){clws=40;}
    move(18,14); printw("Black square colour (0...40): "); scanw("%d",&clbs);
    if(clbs<0){clbs=0;} if(clbs>40){clbs=40;}
    move(19,14); printw("White peace colour (0...40): "); scanw("%d",&clwp);
    if(clwp<0){clwp=0;} if(clwp>40){clwp=40;}
    move(20,14); printw("Black peace colour (0...40): "); scanw("%d",&clbp);
    if(clbp<0){clbp=0;} if(clbp>40){clbp=40;}
    goto MENU1;

  case '4': goto ENDGAME;

  default: goto MENU1;
}

erase(); refresh();

setboard(&bd); firstmove=1; timw=timb=0;

while(1){

  switch(sel){
    case '1':
      move(14,5); printw("Level: %d",skill-2);
      break;
    case '2':
      move(12,5); printw("White level: %d",wsk-2);
      move(14,5); printw("Black level: %d",bsk-2);
      move(10,5); attron(1); printw(" ESC "); attron(2); printw(" to exit");
  }

  dboard(&bd,col,clws,clbs,clwp,clbp);
  if(((col=='w')||((col=='b')&&(firstmove==0)))&&(sel=='1')){
  /*your move*/

  clk=SDL_GetTicks();

  move(20,5); printw("Move: "); scanw("%s",imove);
  move(20,5); printw("              ");
  if(!strcmp(imove,"exit")){erase(); refresh(); goto MENU1;}

  while(ismvchk(&bd,imove)){
    move(21,5); printw("Move not possible (check)");
    move(20,5); printw("Move: "); scanw("%s",imove);
    move(20,5); printw("                  ");
  }

  j=0;
  while(!(j=txmove(&bd,imove))){
    move(21,5); printw("Move not possible        ");
    move(20,5); printw("Move: "); scanw("%s",imove);
    move(20,5); printw("                   ");
  }
  move(21,5); printw("                          ");

  /*show clock*/
  switch(bd.turn){
    case 'b': timw+=(SDL_GetTicks()-clk);
              clocktext(timtxt,timw/1000);
              move(4,4); attron(2); printw(" %s ",timtxt); attron(2);
              break;
    case 'w': timb+=(SDL_GetTicks()-clk);
              clocktext(timtxt,timb/1000);
              move(4,14); attron(10); printw(" %s ",timtxt); attron(2);
              break;
    default: break;
  }

  dboard(&bd,col,clws,clbs,clwp,clbp);

  if(ismate(&bd)){
    move(20,5);
    if(ischeck(&bd)){
      printw("Checkmate - you win.");
    }else{
      printw("Stalemate - nobody wins.");
    }
    refresh(); break;
  }
  /*your move ^*/
  }

  /*computer move*/
  clk=SDL_GetTicks();

  findgmv2(&bd,bd.turn,skill,8*tcval('k'));
  mkmove(&bd,&(bd.mv[(bd.nmoves)+1]));

  /*show clock*/
  switch(bd.turn){
    case 'b': timw+=(SDL_GetTicks()-clk);
              clocktext(timtxt,timw/1000);
              move(4,4); attron(2); printw(" %s ",timtxt); attron(2);
              break;
    case 'w': timb+=(SDL_GetTicks()-clk);
              clocktext(timtxt,timb/1000);
              move(4,14); attron(10); printw(" %s ",timtxt); attron(2);
              break;
    default: break;
  }

  dboard(&bd,col,clws,clbs,clwp,clbp);

  while(SDL_PollEvent(&eventglob)){
    switch(eventglob.type){
      case SDL_KEYDOWN:
        switch(eventglob.key.keysym.sym){
          case SDLK_ESCAPE: goto MENU1;
          default: break;
        }
      default: break;
    }
  }

  mvtext(&(bd.mv[(bd.nmoves)+1]),imove);
  attron(4); move(17,5); printw("My move: %s",imove); attron(2);
  refresh();

  if(ismate(&bd)){
    move(20,5);
    if(ischeck(&bd)){
      printw("Checkmate - computer wins.");
    }else{
      printw("Stalemate - nobody wins.");
    }
    refresh(); break;
  }
  firstmove=0;

  if(sel=='2'){if(skill==wsk){skill=bsk;}else{skill=wsk;}} /*if computer plays with itself*/
  /*computer move ^*/

}

move(0,0); col=getch_graph(); goto MENU1;

ENDGAME:

freegraph();
return 0;}
