/*
Copyright (C) 2013 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


/*draws 1 piece*/
void dpiece(int i,int j,piece *pc,int clwp,int clbp,int ox,int oy,int ds)
{static int crd1[50]={0,-6,18,0,0,6,-6,6,0,6,3,0,0,6,-12,0,0,-6,3,0,0,-6,-6,-6,18,0}, /*pawn*/
            crd2[50]={0,-6,18,0,0,6,-4,0,4,8,0,16,-3,-3,0,3,-9,0,-6,-6,0,-6,9,0,0,-3,-9,-9,18,0}, /*horse*/
            crd3[50]={0,-6,18,0,0,6,-6,6,0,3,6,6,-3,3,-5,-5,-3,3,5,5,-3,3,-9,-9,6,-6,0,-3,-6,-6,18,0}, /*bishop*/
            crd4[50]={0,-6,18,0,0,6,-3,0,0,15,3,0,0,9,-4,0,0,-3,-3,0,0,3,-4,0,0,-3,-3,0,0,3,-4,0,0,-9,3,0,0,-15,-3,0,18,0}, /*tower*/
            crd5[50]={0,-6,18,0,0,6,-6,12,3,0,3,12,-6,-6,-3,6,-3,-6,-6,6,3,-12,3,0,-6,-12,18,0}, /*queen*/
            crd6[50]={0,-6,18,0,0,6,-6,12,6,0,0,6,-6,0,0,6,-6,0,0,-6,-6,0,0,-6,6,0,-6,-12,18,0}; /*quing*/

int *crd,n,k,clr;

if((pc->col)=='w'){clr=clwp;}else{clr=clbp;} /*colour of piece*/

switch(pc->tc){
  case 'p': crd=crd1; n=12; break; /*pawn*/
  case 'n': crd=crd2; n=14; break; /*rabbit*/
  case 'b': crd=crd3; n=15; break; /*priest*/
  case 'r': crd=crd4; n=20; break; /*castle*/
  case 'q': crd=crd5; n=13; break; /*kueen*/
  case 'k': crd=crd6; n=14; break; /*king*/
  case '0': return; /*nothing*/
  default: crd=crd6; n=14; break; /*test*/
}

dpoint(ox-ds+10+i*ds,oy-ds+10+j*ds,clr);
for(k=0;k<=n;k++){dline(crd[2*k],crd[2*k+1],clr);}
dpoint(ox-ds+11+i*ds,oy-ds+10+j*ds,clr);
for(k=0;k<=n;k++){dline(crd[2*k],crd[2*k+1],clr);}
dpoint(ox-ds+10+i*ds,oy-ds+11+j*ds,clr);
for(k=0;k<=n;k++){dline(crd[2*k],crd[2*k+1],clr);}
dpoint(ox-ds+11+i*ds,oy-ds+11+j*ds,clr);
for(k=0;k<=n;k++){dline(crd[2*k],crd[2*k+1],clr);}

}


/*draws board and pieces; if col=='b', draw upside down*/
void dboard(board *bd,char col,int clws,int clbs,int clwp,int clbp)
{int i,j,cbb=clbs,cbw=clws, /*board colours*/
     ox=280,oy=120,ds=40; /*board position and size*/

for(i=0;i<=7;i++){
  for(j=0;j<=7;j++){
    if((i+j)%2){drectangle(ox+ds*i,oy+ds*j,ox+ds+ds*i,oy+ds+ds*j,cbw);}else{
      drectangle(ox+ds*i,oy+ds*j,ox+ds+ds*i,oy+ds+ds*j,cbb);}
  }
}
dpoint(ox,oy,1);dline(8*ds,0,1);dline(0,8*ds,1);dline(-8*ds,0,1);dline(0,-8*ds,1);
dpoint(ox-1,oy-1,9);dline((8*ds+2),0,9);dline(0,(8*ds+2),9);dline(-(8*ds+2),0,9);dline(0,-(8*ds+2),9);
dpoint(ox-2,oy-2,1);dline((8*ds+4),0,1);dline(0,(8*ds+4),1);dline(-(8*ds+4),0,1);dline(0,-(8*ds+4),1);
/*board drawn*/

for(i=1;i<=8;i++){
  for(j=1;j<=8;j++){
    if(col!='b'){
      dpiece(i,j,&(bd->pc[(j-1)*8+i]),clwp,clbp,ox,oy,ds);
    }else{
      dpiece(i,j,&(bd->pc[(9-j-1)*8+9-i]),clwp,clbp,ox,oy,ds);
    }
  }
} /*drawn pieces*/

if(col!='b'){
dtext("a   b   c   d   e   f   g   h",ox+15,oy-25,20,9);
dtext("1",ox-17,oy+10,20,9);
dtext("2",ox-17,oy+10+ds,20,9);
dtext("3",ox-17,oy+10+2*ds,20,9);
dtext("4",ox-17,oy+10+3*ds,20,9);
dtext("5",ox-17,oy+10+4*ds,20,9);
dtext("6",ox-17,oy+10+5*ds,20,9);
dtext("7",ox-17,oy+10+6*ds,20,9);
dtext("8",ox-17,oy+10+7*ds,20,9);
}else{
dtext("h   g   f   e   d   c   b   a",ox+15,oy-25,20,9);
dtext("8",ox-17,oy+10,20,9);
dtext("7",ox-17,oy+10+ds,20,9);
dtext("6",ox-17,oy+10+2*ds,20,9);
dtext("5",ox-17,oy+10+3*ds,20,9);
dtext("4",ox-17,oy+10+4*ds,20,9);
dtext("3",ox-17,oy+10+5*ds,20,9);
dtext("2",ox-17,oy+10+6*ds,20,9);
dtext("1",ox-17,oy+10+7*ds,20,9);
}

refresh();
}
