#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ROWS 3000
#define LEN 200

void read1(FILE *f,char *s){
  int i=0;
  s[i]=getc(f);
  while((s[i]!=' ')&&(!feof(f))){i++; s[i]=getc(f);}
  s[i]='\0';
}

void read2(FILE *f,char *s){
  int i=0;
  s[i]=getc(f);
  while(s[i]==' '){s[i]=getc(f);}
  while((s[i]!='\r')&&(s[i]!='\n')&&(!feof(f))){i++; s[i]=getc(f);}
  s[i]='\0';
}

void eslsh(char *s){
  int i=0,p=0;
  while(s[i]){
    if(s[i]=='/'){p=i+1;}
    i++;
    s[i-p]=s[i];
  }
}

int main(int argc,char *argv[]){
  int i,j,rows1,rows2,fd,path; /*path==1:compare full path*/
  char s[30],
       **md51,**name1,**md52,**name2;
  FILE *f;

path=0;

if(argc!=3){
  if(argc==4){
    strcpy(s,argv[3]);
    if((s[0]!='/')||(s[1]!='\0')){
      printf("Try 'md5test %s %s /'\r\n",argv[1],argv[2]); exit(1);
    }else{
      path=1;
    }
  }else{
    printf("Try 'md5test file1 file2'\r\n"); exit(1);
  }
}

if(!(md51=(char **)malloc(ROWS*sizeof(char *)))){printf("Out of memory\n"); exit(1);}
for(i=0;i<ROWS;i++){
  if(!(md51[i]=(char *)malloc(LEN*sizeof(char)))){printf("Out of memory\n"); exit(1);}
}
if(!(name1=(char **)malloc(ROWS*sizeof(char *)))){printf("Out of memory\n"); exit(1);}
for(i=0;i<ROWS;i++){
  if(!(name1[i]=(char *)malloc(LEN*sizeof(char)))){printf("Out of memory\n"); exit(1);}
}
if(!(md52=(char **)malloc(ROWS*sizeof(char *)))){printf("Out of memory\n"); exit(1);}
for(i=0;i<ROWS;i++){
  if(!(md52[i]=(char *)malloc(LEN*sizeof(char)))){printf("Out of memory\n"); exit(1);}
}
if(!(name2=(char **)malloc(ROWS*sizeof(char *)))){printf("Out of memory\n"); exit(1);}
for(i=0;i<ROWS;i++){
  if(!(name2[i]=(char *)malloc(LEN*sizeof(char)))){printf("Out of memory\n"); exit(1);}
}


strcpy(s,argv[1]);
if(!(f=fopen(s,"r"))){printf("Could not open file '%s'\n",s); exit(1);}
rows1=0;
while(!feof(f)){
  read1(f,md51[rows1]);
  if(!feof(f)){read2(f,name1[rows1]); if(path==0){eslsh(name1[rows1]);} rows1++;}
}
fclose(f);

strcpy(s,argv[2]);
if(!(f=fopen(s,"r"))){printf("Could not open file '%s'\n",s); exit(1);}
rows2=0;
while(!feof(f)){
  read1(f,md52[rows2]);
  if(!feof(f)){read2(f,name2[rows2]); if(path==0){eslsh(name2[rows2]);} rows2++;}
}
fclose(f);

printf("\r\n");

for(i=0;i<rows1;i++){
  fd=0;
  for(j=0;j<rows2;j++){
    if(strcmp(name1[i],name2[j])==0){fd=1; break;}
  }
  if(fd==0){
    printf("'%s' - only in the 1st file\n",name1[i]);
  }
}

printf("\r\n");

for(i=0;i<rows2;i++){
  fd=0;
  for(j=0;j<rows1;j++){
    if(strcmp(name2[i],name1[j])==0){fd=1; break;}
  }
  if(fd==0){
    printf("'%s' - only in the 2nd file\n",name2[i]);
  }
}

printf("\r\n");

for(i=0;i<rows1;i++){
  for(j=0;j<rows2;j++){
    if((strcmp(name1[i],name2[j])==0)&&(strcmp(md51[i],md52[j])!=0)){
      printf("Error: '%s' different!\n",name1[i]);
      break;
    }
  }
}

printf("\r\n");

for(i=0;i<ROWS;i++){free(md51[i]); free(md52[i]); free(name1[i]); free(name2[i]);}
free(md51); free(md52); free(name1); free(name2);

return 0;}
