/*generate file itemlist*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LITEMS 256 /*max. nr. of vword items in list*/
#define INSTR "\"monster_" /*start of string to be replaced*/
#define REPSTR "\"light\"" /*with this string*/

typedef unsigned char vword [64]; /*now vword c means unsigned char c[64]*/

int GILEN,GRLEN; /*length of INSTR and REPSTR above*/
unsigned char *CGLOBc;


/*read complete INSTR, i - current position, n - size of CGLOBc*/
int readinstr(int i,int n,unsigned char *s){
  int j,a;
j=0; a='\0'; s[j]=CGLOBc[i];
while((a!='\"')&&(i<n)&&(j<64)){i++; j++; a=CGLOBc[i]; s[j]=a;}
s[j+1]='\0';
if(s[j]!='\"'){return 0;}else{return 1;}
}


/*i - current position, j - size of INSTR, n - size of file*/
int checkinstr(int i,int j,int n){
  int k;
if(n<(i+j)){return 0;}
for(k=0;k<j;k++){
  if(CGLOBc[i+k]!=INSTR[k]){return 0;}
}
return 1;
}


int main(int argc,char *argv[]){
  int i,j,k,n,sem,tlen[LITEMS],nit[LITEMS]; /*n - size of input file*/
  vword *finstr; /*strings in file starting with INSTR*/
  FILE *fi;

if(argc<2){
  printf("Input file not declared\n"); exit(1);
}else{
  if(argc>2){
    printf("Too many parameters\n"); exit(1);
  }
}

/*check file size*/
if(!(fi=fopen(argv[1],"r"))){printf("Could not open file '%s'\n",argv[1]); exit(1);}
n=0;
while(!feof(fi)){getc(fi); n++;}
rewind(fi); n--;

printf("File '%s' - size %d B\n",argv[1],n);

if(!(CGLOBc=(unsigned char *)malloc(n*sizeof(char)))){printf("Out of memory\n"); exit(1);}
/*read file*/
for(i=0;i<n;i++){CGLOBc[i]=getc(fi);}
fclose(fi);

GILEN=0; /*det. length of INSTR*/
while(INSTR[GILEN]!='\0'){GILEN++;}

GRLEN=0; /*det. length of REPSTR*/
while(REPSTR[GRLEN]!='\0'){GRLEN++;}

if(!(finstr=(vword *)malloc(LITEMS*sizeof(vword)))){printf("Out of memory\n"); exit(1);}

j=0;
for(i=0;i<n;i++){
  if(checkinstr(i,GILEN,n)){
    readinstr(i,n,finstr[j]);
    nit[j]=1;
    tlen[j]=strlen((char *)finstr[j])-GRLEN;
    sem=1;
    for(k=0;k<j;k++){
      if(!strcmp((char *)finstr[k],(char *)finstr[j])){
        sem=0; nit[k]++;
      }
    }
    if(sem==1){j++;}
    if(j>=LITEMS){printf("Error: j > %d\n",LITEMS); exit(1);}
  }
}

if(!(fi=fopen("itemlist","w"))){printf("Could not open file 'itemlist'\n"); exit(1);}
fprintf(fi,"Map %s\r\n",argv[1]);
fprintf(fi,"----\r\nIf you change \"light\" with \"item_health\", \"monster_dog\" or something else,\r\n");
fprintf(fi,"make sure to keep the exact same number of characters\r\nbetween the vertical lines:\r\n----\r\n");
for(i=0;i<j;i++){
  k=0; putc('|',fi);
  while(finstr[i][k]!='\0'){
    putc(finstr[i][k],fi); k++;
  }
  fprintf(fi,"| |");

  for(k=0;k<GRLEN;k++){putc(REPSTR[k],fi);}
  for(k=0;k<tlen[i];k++){putc(' ',fi);}
  fprintf(fi,"| x%d\r\n",nit[i]);
}
fclose(fi);

free(finstr); free(CGLOBc);

printf("-----------------------\nFile 'itemlist' created\n-----------------------\n");

return 0;
}
