/*
Copyright (C) 2025 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>

int main(int argc,char *argv[]){
  int i,
      nv,nt, /*nr. of vertices, nr. of triangles*/
      tr1,tr2,tr3;
  float xv,yv,zv,xmin,dx;
  char *ft;
  FILE *f1,*f2;

if(argc<3){printf("Files not specified\r\n"); exit(1);}
if(argc>3){printf("Too many parameters\r\n"); exit(1);}

if(!(f1=fopen(argv[1],"r"))){printf("Could not open '%s'\r\n",argv[1]); exit(1);}
if(!(f2=fopen(argv[2],"w"))){printf("Could not open '%s'\r\n",argv[2]); exit(1);}

if(!(ft=(char *)malloc(10*sizeof(char)))){printf("Insufficient memory\r\n"); exit(1);}

fscanf(f1,"%d %d",&nv,&nt);
fprintf(f2,"%d %d\r\n",nv,nt);

printf("Xmin: "); scanf("%f",&xmin);
printf("deltaX: "); scanf("%f",&dx);

for(i=0;i<nv;i++){
  fscanf(f1,"%f %f %f",&xv,&yv,&zv);
  if(xv<=xmin){xv-=dx;}
  fprintf(f2,"%1.4f %1.4f %1.4f\r\n",xv,yv,zv);
}

for(i=0;i<nt;i++){
  fscanf(f1,"%s %d %d %d",ft,&tr1,&tr2,&tr3);
  fprintf(f2,"%s %d %d %d\r\n",ft,tr1,tr2,tr3);
}

free(ft);
fclose(f2); fclose(f1);
return 0;
}
