/*
Copyright (C) 2007-2024 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <SDL.h>
#include "../graphics/graphics.h"


int main(int argc,char *argv[]){
  unsigned int screenwidth=800,screenheight=600,fov=90;
  int quit=0,cftx=0,cfty=0,cftz=0,cfrx=0,cfry=0,cfrz=0,t0frame,ntri,
    i,w,nmod,nob, /*word, nr. of models and objects*/
    bred=0,bgreen=0,bblue=0;
  float vtrans,vrot,rotmax,transmax,
    transx=0,transy=0,transz=0,rotx=0,roty=0,rotz=0,
    timp,fps=0,tframe=0.5,xan,zmin,zfog,zmax,
    x,y,z,tt, /*object position and rotation*/
    amb=0.5,hd=0.3,dir=0.2,dx=0.0,dy=0.5,dz=0.5,len,
    fred=1.0,fgreen=1.0,fblue=1.0,
    *rot; /*pointer to rotation matrix of camera*/
  char name1[32],name2[32],name3[32],name4[32];
  SDL_Event event;

if(argc<2){printf("Track file not declared\r\n"); exit(1);}
if(argc>3){printf("Too many input files\r\n"); exit(1);}

readtok(argv[1],"objtypes:objects:background:clfactors:ambient:headlight:directional:lightdir");

w=1;

while(w){

w=tkgetword();

switch(w){
  case 1:
    nmod=tkgetint();
    for(i=0;i<nmod;i++){
      tkgetstring(name1); tkgetstring(name2); tkgetstring(name3); tkgetstring(name4);
      rdmod3d3f(name1,name2,name4); /*returns i, which is already known*/
    }
    break; /*however, in file with track, first model is 1*/

  case 2:
    nob=tkgetint();
    for(i=0;i<nob;i++){
      w=tkgetint();
      addobj3d(w-1); /*returns i, which is already known*/
      x=tkgetfloat()-5; y=tkgetfloat(); z=tkgetfloat()-10;
      tkgetfloat(); tkgetfloat(); tt=tkgetfloat();
      tkgetint(); tkgetint();
      transobj3d(i,x,y,z);
      rotXobj3d(i,tt);
    }
    break;

  case 3: bred=tkgetint(); bgreen=tkgetint(); bblue=tkgetint(); break;

  case 4: fred=tkgetfloat(); fgreen=tkgetfloat(); fblue=tkgetfloat(); break;

  case 5: amb=tkgetfloat(); break;

  case 6: hd=tkgetfloat(); break;

  case 7: dir=tkgetfloat(); break;

  case 8: dx=tkgetfloat(); dy=tkgetfloat(); dz=tkgetfloat(); break;

  default: break;
}
}

freetok();

readtok("config","screen");
tkgetword();
screenwidth=tkgetint(); screenheight=tkgetint(); fov=tkgetfloat();
freetok();

zmax=2048.0;
zfog=0.5*zmax;
zmin=0.0001*zmax;

vrot=1.5;
vtrans=0.05*zmax;
rotmax=0.1*vrot;
transmax=0.1*vtrans;

initgraph(screenwidth,screenheight,0,"3Dview");
setbgcolor(128,192,255);
initgraph3d(fov,zmin,zmax);

setbgcolor(bred,bgreen,bblue);
clfactors(fred,fgreen,fblue);

len=1.0/sqrt(dx*dx+dy*dy+dz*dz);
dx*=len; dy*=len; dz*=len; /*normalized light direction*/

setlight3d(amb,hd,dir,dx,dy,dz);

/*timp=clock();*/
timp=0.001*SDL_GetTicks(); /*pornit cronometru*/

xan=0;
quit=0;

while(!quit){

/*t0frame=clock();*/
t0frame=SDL_GetTicks();
xan++;

  transx=cftx*tframe*vtrans;
if(transx<(-transmax)){transx=-transmax;} if(transx>transmax){transx=transmax;}
  transy=cfty*tframe*vtrans;
if(transy<(-transmax)){transy=-transmax;} if(transy>transmax){transy=transmax;}
  transz=cftz*tframe*vtrans;
if(transz<(-transmax)){transz=-transmax;} if(transz>transmax){transz=transmax;}
  rotx=cfrx*tframe*vrot;
if(rotx<(-rotmax)){rotx=-rotmax;} if(rotx>rotmax){rotx=rotmax;}
  roty=cfry*tframe*vrot;
if(roty<(-rotmax)){roty=-rotmax;} if(roty>rotmax){roty=rotmax;}
  rotz=cfrz*tframe*vrot;
if(rotz<(-rotmax)){rotz=-rotmax;} if(rotz>rotmax){rotz=rotmax;}

  rot=getcamrot();

  x=transx*rot[0]+transy*rot[1]+transz*rot[2];
  y=transx*rot[3]+transy*rot[4]+transz*rot[5];
  z=transx*rot[6]+transy*rot[7]+transz*rot[8];
  transcam(x,y,z);
  /*if(rotx){rotABcam(rot[0],rot[3],rot[6],rotx);}*/
  if(rotx)(rotXcam(rotx));
  if(roty){rotABcam(rot[1],rot[4],rot[7],roty);}
  if(rotz){rotABcam(rot[2],rot[5],rot[8],rotz);}

ntri=drawobj3all(); drawfog3d(zfog,zmax);

setcolor(0,0,0); setpos(0,screenheight-40);
printw("%d triangles, %3.2f f/s ",ntri,fps);
setpos(0,screenheight-18);
printw("keys: arrows, 'a', 'z', 's', 'x', 'm', 'n'");

display();

while(SDL_PollEvent(&event)){
switch(event.type){

  case SDL_KEYDOWN:
    switch(event.key.keysym.sym){
      case SDLK_a: cftz=1;break;
      case SDLK_z: cftz=-1;break;
      case SDLK_LEFT: cfrx=1;break;
      case SDLK_RIGHT: cfrx=-1;break;
      case SDLK_UP: cfry=1;break;
      case SDLK_DOWN: cfry=-1;break;
      /*case SDLK_s: cfrz=-1;break;
      case SDLK_d: cfrz=1;break;*/

      case SDLK_s: cftx=1;break;
      case SDLK_x: cftx=-1;break;
      case SDLK_n: cfty=-1;break;
      case SDLK_m: cfty=1;break;

      case SDLK_ESCAPE: goto FRAMERATE;

      default: break;
  } break;

  case SDL_KEYUP:
    switch(event.key.keysym.sym){
      case SDLK_a: cftz=0;break;
      case SDLK_z: cftz=0;break;
      case SDLK_LEFT: cfrx=0;break;
      case SDLK_RIGHT: cfrx=0;break;
      case SDLK_UP: cfry=0;break;
      case SDLK_DOWN: cfry=0;break;
      /*case SDLK_s: cfrz=0;break;
      case SDLK_d: cfrz=0;break;*/

      case SDLK_s: cftx=0;break;
      case SDLK_x: cftx=0;break;
      case SDLK_n: cfty=0;break;
      case SDLK_m: cfty=0;break;

      default: break;
  } break;

case SDL_QUIT: goto FRAMERATE;
}
}
pause(2);
tframe=0.001*(float)(SDL_GetTicks()-t0frame);
fps=xan/(0.001*(float)SDL_GetTicks()-timp);
/*tframe=(float)(clock()-t0frame)/CLOCKS_PER_SEC;
fps=xan/((float)(clock()-timp)/CLOCKS_PER_SEC);*/
}


FRAMERATE: printf("%1.3f fps\r\n",fps);

closegraph3d();
closegraph();

return 0;
}
