/*
Copyright (C) 2024 Victor Matei Petrescu
Help given by Cas

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "convreadf.h"

#define MAXEL 4096
#define PI 3.1415926536

typedef struct _trackobj{
 float x;
 float y;
 float z; /*centre*/
 float rot;
 int kind;
} trackobj;


void casfn(char *trackfile,trackobj *aob,int *nob){
  int i,j,k,n,aobs=0,cc[256][8],w; /*cc[i]={t,w,h,r,t,w,h,r};w-word number*/
  unsigned char t[31][31],l[31][31];
  FILE *f;

if(!(f=fopen(trackfile,"r"))){printf("Could not open '%s'\r\n",trackfile); exit(1);}
for(j=30;j>=1;j--){
  for(i=1;i<=30;i++){
    t[i][j]=getc(f);
  }
}

getc(f);
for(j=1;j<=30;j++){
  for(i=1;i<=30;i++){
    l[i][j]=getc(f);
 }
}
fclose(f);

for(i=0;i<256;i++){for(j=0;j<8;j++){cc[i][j]=0;}}
readtok("src/stxlist","n:t:r:wr:hr:whr");
w=1;
while(w){
  w=tkgetword();
  switch(w){
    case 1: n=tkgetint();
      if((tkgetword())!=2){printf("'t' expected\r\n"); exit(1);}
      cc[n][0]=tkgetint();
      switch(tkgetword()){
        case 3: cc[n][3]=tkgetint(); break;
        case 4: cc[n][3]=tkgetint(); cc[n][1]=1; break;
        case 5: cc[n][3]=tkgetint(); cc[n][2]=1; break;
        case 6: cc[n][3]=tkgetint(); cc[n][1]=cc[n][2]=1; break;
        default: printf("Some error\r\n"); exit(1);
      }
      break;
     case 2: cc[n][4]=tkgetint();
      switch(tkgetword()){
        case 3: cc[n][7]=tkgetint(); break;
        case 4: cc[n][7]=tkgetint(); cc[n][5]=1; break;
        case 5: cc[n][7]=tkgetint(); cc[n][6]=1; break;
        case 6: cc[n][7]=tkgetint(); cc[n][5]=cc[n][6]=1; break;
        default: printf("Some error\r\n"); exit(1);
      }
      break;
    default: break;
  }
}
freetok();

n=0; /*start calculating coordinates*/

for(j=1;j<=30;j++){
  for(i=1;i<=30;i++){
    if(l[i][j]){
     aob[aobs].x = 2*(i-1);
     aob[aobs].y = 2*(30-j);
     aob[aobs].z = 0;
     aob[aobs].rot = 0;
    }

    switch(l[i][j]){
     case 1:
      aob[aobs].kind = 82; break;
     case 2:
     case 3:
     case 4:
     case 5:
      aob[aobs].kind = 81;
      if(l[i][j] % 2){
       aob[aobs].rot = l[i][j]*0.5*PI+PI;
      }else{
       aob[aobs].rot = (l[i][j]-2)*0.5*PI;
      }
      break;
     case 6:
      aob[aobs].kind = 80;
      aob[aobs].z = .88;
      break;
     case 7:
     case 8:
     case 9:
     case 10:
      aob[aobs].kind = 76;
      if(l[i][j] % 2){
       aob[aobs].rot = (l[i][j]+1)*0.5*PI;
      }else{
       aob[aobs].rot = (l[i][j]-1)*0.5*PI+PI;
      }
      break;
     case 11:
     case 12:
     case 13:
     case 14:
      aob[aobs].kind = 75;
      if(l[i][j] % 2){
       aob[aobs].rot = (l[i][j]+1)*0.5*PI;
      }else{
       aob[aobs].rot = (l[i][j]-1)*0.5*PI+PI;
      }
      break;
     case 15:
     case 16:
     case 17:
     case 18:
      aob[aobs].kind = 74;
      if(l[i][j] % 2){
       aob[aobs].rot = (l[i][j]+1)*0.5*PI;
      }else{
       aob[aobs].rot = (l[i][j]-1)*0.5*PI+PI;
      }
      break;
      default: break;
    }

    if(fabs(aob[aobs].rot) < 0.0001){aob[aobs].rot = 0.0;}

    (aob[aobs].z)-=0.002;
    aobs++;
  }
}

for(j=1;j<=30;j++){
 for(i=1;i<=30;i++){
  for(k=0;k<2;k++){
    if(cc[t[i][j]][k*4]){
      aob[aobs].kind = cc[t[i][j]][0+k*4];
      aob[aobs].x = 2*(i-1);
      aob[aobs].y = 2*(30-j);
      aob[aobs].x += cc[t[i][j]][1+k*4];
      aob[aobs].y -= cc[t[i][j]][2+k*4];
      aob[aobs].rot=0.5*PI*cc[t[i][j]][3+k*4];

      switch(l[i][j]){
       case 6: aob[aobs].z = 0.88; break;
       case 7:
        switch(t[i][j]){
         case 4: aob[aobs].kind = 89; aob[aobs].rot = 0; break;
         case 14: aob[aobs].kind = 133; aob[aobs].rot = 0; break;
         case 24: aob[aobs].kind = 134; aob[aobs].rot = 0; break;
         case 59: aob[aobs].kind = 118; break;
         case 39: aob[aobs].kind = 119; break;
         case 98: aob[aobs].kind = 120; break;
         default: break;
        }
        break;
       case 8:
        switch(t[i][j]){
         case 5: aob[aobs].kind = 89; aob[aobs].rot = 0.5*PI; break;
         case 15: aob[aobs].kind = 133; aob[aobs].rot = 0.5*PI; break;
         case 25: aob[aobs].kind = 134; aob[aobs].rot = 0.5*PI; break;
         case 56: aob[aobs].kind = 118; break;
         case 36: aob[aobs].kind = 119; break;
         case 95: aob[aobs].kind = 120; break;
         default: break;
        }
        break;
       case 9:
        switch(t[i][j]){
         case 4: aob[aobs].kind = 89; aob[aobs].rot = PI; break;
         case 14: aob[aobs].kind = 133; aob[aobs].rot = PI; break;
         case 24: aob[aobs].kind = 134; aob[aobs].rot = PI; break;
         case 58: aob[aobs].kind = 118; break;
         case 38: aob[aobs].kind = 119; break;
         case 97: aob[aobs].kind = 120; break;
         default: break;
        }
        break;
       case 10:
        switch(t[i][j]){
         case 5: aob[aobs].kind = 89; aob[aobs].rot = -0.5*PI; break;
         case 15: aob[aobs].kind = 133; aob[aobs].rot = -0.5*PI; break;
         case 25: aob[aobs].kind = 134; aob[aobs].rot = -0.5*PI; break;
         case 57: aob[aobs].kind = 118; break;
         case 37: aob[aobs].kind = 119; break;
         case 96: aob[aobs].kind = 120; break;
         default: break;
        }
        break;
        default: break;
      }

      if(fabs(aob[aobs].rot) < 0.0001){aob[aobs].rot = 0.0;}

      aobs++;
    }
  }
 }
}
(*nob)=aobs;
}


int iang(float fang){return ((int)((2.0*(fang+2.0*PI)+0.1)/PI))%4;}


int main(int argc,char *argv[]){
  int i,n,*t,ti,nob,syz,nw;
  float *x,*y,*z,*tt,scale=16.0,
    dx,dy,dz,xi,yi,zi,tti,fy,fz,ftt;
  char c;
  trackobj *aob;
  FILE *fm,*f;

if(argc!=3){
  printf("Wrong number of parameters\r\nExample: %s input.trk output\r\n",argv[0]);
  exit(1);
}

if(!(aob=(trackobj *)malloc(2048*sizeof(trackobj)))){printf("Out of memory\r\n"); exit(1);}
if(!(t=(int *)malloc(MAXEL*sizeof(int)))){printf("Out of memory\r\n"); exit(1);}
if(!(x=(float *)malloc(MAXEL*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(y=(float *)malloc(MAXEL*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(z=(float *)malloc(MAXEL*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(tt=(float *)malloc(MAXEL*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}

dx=-20.0; dy=-100.0; dz=-100.0;

casfn(argv[1],aob,&nob); /*read track file*/

n=0;

for(i=0;i<nob;i++){
ti=aob[i].kind;
yi=scale*aob[i].x;
zi=scale*aob[i].y;
xi=scale*aob[i].z;
tti=aob[i].rot;

if(ti==118){ti=66;}
if(ti==119){ti=66;}
if(ti==120){ti=66;} /*ramps*/
/*if(t==118){t=61;}
if(t==119){t=86;}
if(t==120){t=95;}*/ /*ramps*/
if(ti==121){ti=21;}
if(ti==122){ti=29;}
if(ti==123){ti=25;}
if(ti==124){ti=21;}
if(ti==125){ti=29;}
if(ti==126){ti=25;}
if(ti==127){ti=11;}
if(ti==128){ti=11;}
if(ti==129){ti=16;}
if(ti==130){ti=17;}
if(ti==131){ti=16;}
if(ti==132){ti=17;}
if(ti==133){ti=89;}
if(ti==134){ti=89;} /*road*/

/*21, 6    '121 - Dirt road
29, 6    '122 - Dirt closed corner
25, 6    '123 - Dirt large corner
21, 9    '124 - Icy road
29, 9    '125 - Icy closed corner
25, 9    '126 - Icy large corner
11, 6    '127 - Dirt crossroad
11, 9    '128 - Icy crossroad
16, 6    '129 - Dirt split 1
17, 6    '130 - Dirt split 2
16, 9    '131 - Icy split 1
17, 9    '132 - Icy split 2
89, 6    '133 - Dirt hill ramp
89, 9    '134 - Icy hill ramp*/

if(ti>0){
  if(n==0){
    t[n]=ti; x[n]=xi; y[n]=yi; z[n]=zi; tt[n]=tti; n++;
  }else{
    if((ti!=t[n-1])||((fabs(xi-x[n-1])+fabs(yi-y[n-1])+fabs(zi-z[n-1])+fabs(tti-tt[n-1]))>0.0001)){
      t[n]=ti; x[n]=xi; y[n]=yi; z[n]=zi; tt[n]=tti; n++;
    }
  }
  if(ti==8){
    switch(iang(tti)){
      case 0: syz=0; fy=1.0; fz=1.0; ftt=0.0; break;
      case 1: syz=1; fy=-1.0; fz=1.0; ftt=0.5*PI; break;
      case 2: syz=0; fy=-1.0; fz=-1.0; ftt=PI; break;
      case 3: syz=1; fy=1.0; fz=-1.0; ftt=1.5*PI; break;
      default: printf("Some error\r\n"); break;
    }
    printf("Rotated %1.2f degrees\r\n",90.0*iang(tti));
  }
} /*eliminated repetitions*/
}

for(i=0;i<n;i++){
  if(syz){tti=y[i]; y[i]=z[i]; z[i]=tti;}
  y[i]*=fy; z[i]*=fz; tt[i]+=ftt;
  if(t[i]==8){
    dx=-x[i]-2.0; dy=-y[i]-1.5; dz=-z[i]+20.0;
  }
}

if(!(f=fopen(argv[2],"w"))){printf("Could not open '%s'\r\n",argv[2]); exit(1);}
fprintf(f,"ambient 0.5\nheadlight 0.3\ndirectional 0.5\nlightdir -1.0 0.4 0.6\nbackground 140 180 210\nclfactors 1.0 1.0 1.0\n");
if(!(fm=fopen("src/modlist","r"))){printf("Could not open 'modlist'\r\n"); exit(1);}
while(!feof(fm)){
  c=getc(fm);
  if(!feof(fm)){putc(c,f);}
}
fclose(fm);

nw=0;
for(i=0;i<n;i++){if(t[i]==99){nw++;}}
n+=nw; /*+win2*/

fprintf(f,"objects %d\n",n+1);
n-=nw;

fprintf(f,"118 %1.3f %1.3f %1.3f 0 0 %1.3f 1 0\n",dx-0.05,480*fy+dy,480*fz+dz,0.0);
for(i=0;i<n;i++){
  fprintf(f,"%d %1.3f %1.3f %1.3f 0 0 %1.3f 1 0\n",t[i],x[i]+dx,y[i]+dy,z[i]+dz,tt[i]);
  if(t[i]==99){
    fprintf(f,"%d %1.3f %1.3f %1.3f 0 0 %1.3f 3 0\n",119,x[i]+dx+11.25,y[i]+dy,z[i]+dz,tt[i]); /*+win2*/
  }
}
fclose(f);

free(aob); free(t); free(x); free(y); free(z); free(tt);

return 0;
}
