#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "readfile.h"


typedef struct _mod3d{
  int nv; /*nr. of vertices*/
  int nt; /*nr. of triangles*/
  float x[1024];
  float y[1024];
  float z[1024]; /*coordinates of vertices*/
  int v[1024]; /*v[i*3+j] - vertex j of triangle i*/
  int r[1024];
  int g[1024];
  int b[1024]; /*colours of triangles*/
} mod3d;


void readmod(const char *nf,mod3d *mod){
  int i,j;
readtok(nf,"f");
mod->nv=tkgetint(); mod->nt=tkgetint();
for(i=0;i<(mod->nv);i++){
  mod->x[i]=tkgetfloat();
  mod->y[i]=tkgetfloat();
  mod->z[i]=tkgetfloat();
}

for(i=0;i<(mod->nt);i++){
  tkgetword();
  for(j=0;j<3;j++){
    mod->v[i*3+j]=tkgetint()-1; /*first vertex is 0*/
  }
}
freetok();
}


/*convert line into 3D model*/
void lnmod(mod3d *mod,float x0,float y0,float z0,float x1,float y1,float z1,float th){
  int i;
  float x[256],y[256],z[256],ix,iy,iz,jx,jy,jz,kx,ky,kz,len,lenz;

readmod("cube",mod);

kx=x1-x0; ky=y1-y0; kz=z1-z0;
lenz=sqrt(kx*kx+ky*ky+kz*kz);
kx/=lenz; ky/=lenz; kz/=lenz;

/*tilted or vertical?*/
len=sqrt(ky*ky+kz*kz); /*(horizontal length)/(length)*/
if(len<1e-5){ /*vertical*/
  jx=0; jy=0; jz=-1;
}
else{ /*tilted*/
  jx=0; jy=kz; jz=-ky;
  len=sqrt(jx*jx+jy*jy+jz*jz);
  jx/=len; jy/=len; jz/=len;
}

  ix=jy*kz-jz*ky;
  iy=jz*kx-jx*kz;
  iz=jx*ky-jy*kx; /*calculated local system*/

for(i=0;i<(mod->nv);i++){x[i]=th*(mod->x[i]); y[i]=th*(mod->y[i]); z[i]=lenz*(mod->z[i]);}

for(i=0;i<(mod->nv);i++){
  mod->x[i]=x0+ix*x[i]+jx*y[i]+kx*z[i];
  mod->y[i]=y0+iy*x[i]+jy*y[i]+ky*z[i];
  mod->z[i]=z0+iz*x[i]+jz*y[i]+kz*z[i];
}
}


/*returns number in base 10 from digit in base 16*/
int hexd(char c){
  if((c>='A')&&(c<='F')){return c-'A'+10;}else{return c-'0';}
}


int main(int argc,char *argv[]){
  int i,j,w,nsh,csh,npol,ntp,
      v0,v1;
    /*nsh - number of shapes, csh - current shape, npol - number of polygons in a shape,
    ntp - number of triangles in a polygon, v0 and v1 - vertices of a line*/
  unsigned char r[256],g[256],b[256];
  char s[16],nmfgeo[32],nmfcol[32];
  mod3d mod,linemod;
  float scale=32.0;
  FILE *f;

if(argc<2){printf("Input file not declared.\r\n"); exit(1);}
if(argc>2){printf("To many arguments.\r\n"); exit(1);}

scale=1.0/scale;

if(!(f=fopen("defmat","r"))){printf("Could not open 'defmat'."); exit(1);}
for(i=0;i<129;i++){
  fscanf(f,"%s",s);
  r[i]=hexd(s[0])*16+hexd(s[1]);
  g[i]=hexd(s[2])*16+hexd(s[3]);
  b[i]=hexd(s[4])*16+hexd(s[5]);
}
fclose(f); /*colours, file 'defmat'*/

readtok(argv[1],"shapes:shape:vertices:primitives:type:material:vert");

w=tkgetword();
if(w!=1){printf("Number of shapes must be declared first.\r\n"); exit(1);}
nsh=tkgetint();

for(csh=0;csh<nsh;csh++){
  w=tkgetword();
  if(w!=2){
    printf("Word 'shape' expected.\r\nFound ");
    printtok(); printf(".\r\n"); exit(1);
  }

  if((tkgetint())!=(csh+1)){
    printf("Wrong shape number.\r\nFound ");
    printtok(); printf(".\r\n"); exit(1);
  }

  tkgetstring(s); sprintf(nmfgeo,"%s.geo",s); sprintf(nmfcol,"%s.col",s);
  /*names of output files*/

  w=tkgetword();
  if(w!=3){printf("Word 'vertices' expected.\r\nFound ");
    printtok(); printf(".\r\n"); exit(1);
  }

  mod.nv=tkgetint();
  for(i=0;i<(mod.nv);i++){
    mod.y[i]=scale*tkgetfloat(); mod.x[i]=scale*tkgetfloat(); mod.z[i]=scale*tkgetfloat();
  }

  w=tkgetword();
  if(w!=4){printf("Word 'primitives' expected.\r\nFound ");
    printtok(); printf(".\r\n"); exit(1);
  }

  npol=tkgetint();
  mod.nt=0;

  for(i=0;i<npol;i++){
    w=tkgetword();
    if(w!=5){printf("Word 'type' expected.\r\nFound ");
      printtok(); printf(".\r\n"); exit(1);
    }
    ntp=tkgetint()-2;

    w=tkgetword();
    if(w!=6){printf("Word 'material' expected.\r\nFound ");
      printtok(); printf(".\r\n"); exit(1);
    }
    w=tkgetint()-1;
    mod.r[mod.nt]=r[w+1]; mod.g[mod.nt]=g[w+1]; mod.b[mod.nt]=b[w+1];

    w=tkgetword();
    if(w!=7){printf("Word 'vert' expected.\r\nFound ");
      printtok(); printf(".\r\n"); exit(1);
    }

    if(ntp>0){
      mod.v[(mod.nt)*3]=tkgetint();
      mod.v[(mod.nt)*3+1]=tkgetint();
      mod.v[(mod.nt)*3+2]=tkgetint();

      for(j=1;j<ntp;j++){
        mod.v[((mod.nt)+j)*3]=mod.v[(mod.nt)*3];
        mod.v[((mod.nt)+j)*3+1]=mod.v[((mod.nt)+j-1)*3+2];
        mod.v[((mod.nt)+j)*3+2]=tkgetint();
        mod.r[mod.nt+j]=mod.r[mod.nt+j-1];
        mod.g[mod.nt+j]=mod.g[mod.nt+j-1];
        mod.b[mod.nt+j]=mod.b[mod.nt+j-1];
      }
      mod.nt+=ntp;
    }else{ /*convert line into 3D model*/
      v0=tkgetint(); v1=tkgetint();
      lnmod(&linemod,mod.x[v0],mod.y[v0],mod.z[v0],mod.x[v1],mod.y[v1],mod.z[v1],scale*4.0);

      for(j=0;j<(linemod.nv);j++){
        mod.x[mod.nv+j]=linemod.x[j];
        mod.y[mod.nv+j]=linemod.y[j];
        mod.z[mod.nv+j]=linemod.z[j];
      }

      for(j=0;j<(linemod.nt);j++){
        mod.v[((mod.nt)+j)*3]=mod.nv+linemod.v[j*3];
        mod.v[((mod.nt)+j)*3+1]=mod.nv+linemod.v[j*3+1];
        mod.v[((mod.nt)+j)*3+2]=mod.nv+linemod.v[j*3+2];
        if(j>0){
          mod.r[mod.nt+j]=mod.r[mod.nt+j-1];
          mod.g[mod.nt+j]=mod.g[mod.nt+j-1];
          mod.b[mod.nt+j]=mod.b[mod.nt+j-1];
        }
      }
      mod.nv+=linemod.nv; mod.nt+=linemod.nt;
    }
  }

  if(!(f=fopen(nmfgeo,"w"))){printf("Could not open '%s'.\r\n",nmfgeo); exit(1);}
  fprintf(f,"%d %d\r\n",mod.nv,mod.nt);
  for(i=0;i<(mod.nv);i++){
    fprintf(f,"%1.3f %1.3f %1.3f\r\n",mod.x[i],mod.y[i],mod.z[i]);
  }
  for(i=0;i<(mod.nt);i++){
    fprintf(f,"f %d %d %d\r\n",mod.v[i*3]+1,mod.v[i*3+1]+1,mod.v[i*3+2]+1);
  }
  fclose(f);

  if(!(f=fopen(nmfcol,"w"))){printf("Could not open '%s'.\r\n",nmfcol); exit(1);}
  fprintf(f,"%d\r\n",mod.nt);
  for(i=0;i<(mod.nt);i++){
    fprintf(f,"%d %d %d %d %d\r\n",i+1,i+1,mod.r[i],mod.g[i],mod.b[i]);
  }
  fclose(f);
}

freetok();

return 0;
}
