/*
Copyright (C) 2017 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

/*initialize random numbers*/
void inrnd(){
  int i,t,r;
t=time(NULL); if(t<0){t=-t;} t=t%16384;
for(i=1;i<=t;i++){
  r=rand();
}
}

float frand1(){
  int a;
  float b;
a=rand();
a=a%100;
b=-1.0+0.02*a;
return b;
}


int main(){
  int i,j,m,n;
  float *x,*y,pi=3.1415927f,tt,rf,rd;
  FILE *f;

inrnd();

printf("m: "); scanf("%d",&m);
printf("n: "); scanf("%d",&n);

if(!(x=(float *)malloc(m*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(y=(float *)malloc(m*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}

printf("rf: "); scanf("%f",&rf);
for(i=0;i<m;i++){
  printf("x[%d]: ",i); scanf("%f",&x[i]);
  printf("y[%d]: ",i); scanf("%f",&y[i]);
}


if(!(f=fopen("tree.geo","w"))){printf("Could not open 'tree.geo'\r\n"); exit(1);}
fprintf(f,"%d %d\r\n",n*m,2*n*(m-1));
for(j=0;j<n;j++){
  tt=2.0*j*pi/n;
  for(i=0;i<m;i++){
    rd=1.0+rf*frand1();
    fprintf(f,"%f %f %f\r\n",x[i],rd*y[i]*cos(tt),rd*y[i]*sin(tt));
  }
}
for(j=0;j<(n-1);j++){
  for(i=1;i<m;i++){
    fprintf(f,"f %d %d %d\r\n",j*m+i,j*m+(i+1),(j+1)*m+(i+1));
    fprintf(f,"f %d %d %d\r\n",j*m+i,(j+1)*m+i,(j+1)*m+(i+1));
  }
}
for(i=1;i<m;i++){
  fprintf(f,"f %d %d %d\r\n",j*m+i,j*m+(i+1),i+1);
  fprintf(f,"f %d %d %d\r\n",j*m+i,i,i+1);
}
fclose(f);

if(!(f=fopen("tree.col","w"))){printf("Could not open 'tree.col'\r\n"); exit(1);}
fprintf(f,"%d\r\n",n*(m-1));
for(j=0;j<n;j++){
  fprintf(f,"%d %d 100 50 0\r\n",j*(m-1)*2+1,j*(m-1)*2+2);
  for(i=2;i<m;i++){
    fprintf(f,"%d %d 40 180 30\r\n",j*(m-1)*2+i*2-1,j*(m-1)*2+i*2);
  }
}
fclose(f);

if(!(f=fopen("tree.cld","w"))){printf("Could not open 'tree.cld'\r\n"); exit(1);}
fprintf(f,"1\r\n");
fprintf(f,"%d %d i %1.2f %1.2f %1.2f\r\n",1,2*n*(m-1),(x[1]+x[2])/2,0.0,0.0);
fclose(f);
return 0;
}
